/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.pardini.ButtonConfiguracao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SteppedComboBox;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ConfiguradorProtocoloHPardini
extends AbstractConfiguradorProtocolo {
    public static final String TAG_NAO_ENVIAR_OBS_REQUISICAO = "naoEnviarObsRequisicao";
    public static final String TAG_ADICIONAL_LOTE = "adicionalLote";
    public static final String TAG_CODIGO_LOTE = "codigoLote";
    public static final String TAG_SENHA_WEB = "senhaWeb";
    public static final String TAG_ENVIAR_ETIQUETA_HP_DIRECT = "enviarEtiquetaHpDirect";
    public static final String TAG_ENVIAR_UTILIZANDO_WEBSERVICE = "enviarLoteWebservice";
    public static final String TAG_ATUALIZACAO_AUTOMATICA_LISTA_EXAMES = "atualizacaoAutomaticaListaExames";
    public static final String TAG_TIPO_IMPRESSAO = "tipoImpressao";
    public static final String TAG_MODELO = "modelo";
    public static final String TAG_MODELO_GRAFICO = "modeloGrafico";
    public static final String TAG_MODELO_TERMICO = "modeloTermico";
    public static final String TAG_HPARDINI = "hpardini";
    public static final String TAG_CODIGO_PROTOCOLO = "codigoProtocolo";
    public static final String TAG_IGNORAR_UNIDADE_PRODUTIVA = "ignorarUnidadeProdutiva";
    public static final String TAG_UNIDADE_PRODUTIVA = "unidadeProdutiva";
    public static final String TAG_ENVIAR_DADOS_MEDICO = "enviarDadosMedico";
    public static final String TAG_IMPORTAR_RESULTADO_PDF = "importarResultadoPdf";
    public static final String TAG_ENVIAR_REQUISICAO_WEBSERVICE = "envioAutomatico";
    public TTextField textAdicionalLote = new TTextField();
    private TTextField textSenha = new TTextField(8, 1);
    public JCheckBox checkNaoEnviarObs = new JCheckBox("N\u00e3o enviar observa\u00e7\u00e3o da requisi\u00e7\u00e3o");
    public JCheckBox checkEnviarEtiquetaHpDirect = new JCheckBox("Enviar etiqueta HP Direct");
    public JCheckBox checkEnviarWebServiceRequisicao = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    public JCheckBox checkAtuAutoListaExames = new JCheckBox("Atualizar automaticamente lista de exames");
    public JCheckBox checkEnviarLoteWebservice = new JCheckBox("Enviar lote utilizando webservice");
    public JCheckBox checkIgnorarUnidadeProdutiva = new JCheckBox("Ignorar Unidade Produtiva");
    public JCheckBox checkEnviarDadosMedico = new JCheckBox("Enviar os dados do m\u00e9dico");
    public JCheckBox checkImportarResultadoPdf = new JCheckBox("Importar resultados no formato PDF");
    private JComboBox comboUnidadeProdutiva = new SteppedComboBox((Object[])UnidadesProdutivas.values());
    public TTextField textContador = new TTextField(10, 1);
    private JButton buttonZeraSequencia = new JButton("Zerar sequ\u00eancia");
    private ButtonConfiguracao buttonConfigurarLayout = new ButtonConfiguracao(this, "Configurar layout", ButtonConfiguracao.TiposImpressao.GRAFICA, ButtonConfiguracao.TiposImpressao.TERMICA);

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloHPardini((Frame)pai, "Laborat\u00f3rio H. Pardini", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloHPardini((Dialog)pai, "Laborat\u00f3rio H. Pardini", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloHPardini(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    public ConfiguradorProtocoloHPardini(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.iniciar();
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<hpardini>");
        bui.append(StringUtil.getTag(TAG_CODIGO_LOTE, this.textLote.getText()));
        bui.append(StringUtil.getTag(TAG_CODIGO_PROTOCOLO, this.textCodigo.getText()));
        bui.append(StringUtil.getTag(TAG_SENHA_WEB, this.textSenha.getText()));
        bui.append(StringUtil.getTag(TAG_ADICIONAL_LOTE, this.textAdicionalLote.getText()));
        bui.append(StringUtil.getTag(TAG_NAO_ENVIAR_OBS_REQUISICAO, this.checkNaoEnviarObs.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_ETIQUETA_HP_DIRECT, this.checkEnviarEtiquetaHpDirect.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_REQUISICAO_WEBSERVICE, this.checkEnviarWebServiceRequisicao.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ATUALIZACAO_AUTOMATICA_LISTA_EXAMES, this.checkAtuAutoListaExames.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_UTILIZANDO_WEBSERVICE, this.checkEnviarLoteWebservice.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_IGNORAR_UNIDADE_PRODUTIVA, this.checkIgnorarUnidadeProdutiva.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_ENVIAR_DADOS_MEDICO, this.checkEnviarDadosMedico.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_IMPORTAR_RESULTADO_PDF, this.checkImportarResultadoPdf.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TAG_UNIDADE_PRODUTIVA, String.valueOf(((UnidadesProdutivas)((Object)this.comboUnidadeProdutiva.getSelectedItem())).getCodigo())));
        bui.append(StringUtil.getTag(TAG_TIPO_IMPRESSAO, this.buttonConfigurarLayout.getTipoImpressaoSelecionado() != null ? this.buttonConfigurarLayout.getTipoImpressaoSelecionado().getCodigo() : ""));
        bui.append("<").append(TAG_MODELO).append(">");
        bui.append(StringUtil.getTag(TAG_MODELO_GRAFICO, this.buttonConfigurarLayout.getModeloGrafico()));
        bui.append(StringUtil.getTag(TAG_MODELO_TERMICO, this.buttonConfigurarLayout.getModeloTermico()));
        bui.append("</").append(TAG_MODELO).append(">");
        return bui.append("</hpardini>").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, TAG_HPARDINI);
            this.textLote.setText(StringUtil.getValor(xml, TAG_CODIGO_LOTE));
            this.textCodigo.setText(StringUtil.getValor(xml, TAG_CODIGO_PROTOCOLO));
            this.textSenha.setText(StringUtil.getValor(xml, TAG_SENHA_WEB));
            this.textAdicionalLote.setText(StringUtil.getValor(xml, TAG_ADICIONAL_LOTE));
            this.checkNaoEnviarObs.setSelected(StringUtil.getBoolean(xml, TAG_NAO_ENVIAR_OBS_REQUISICAO));
            this.checkEnviarEtiquetaHpDirect.setSelected(StringUtil.getBoolean(xml, TAG_ENVIAR_ETIQUETA_HP_DIRECT));
            this.checkEnviarWebServiceRequisicao.setSelected(StringUtil.getBoolean(xml, TAG_ENVIAR_REQUISICAO_WEBSERVICE));
            this.checkAtuAutoListaExames.setSelected(StringUtil.getBoolean(xml, TAG_ATUALIZACAO_AUTOMATICA_LISTA_EXAMES));
            this.checkEnviarLoteWebservice.setSelected(StringUtil.getBoolean(xml, TAG_ENVIAR_UTILIZANDO_WEBSERVICE));
            this.checkEnviarDadosMedico.setSelected(StringUtil.getBoolean(xml, TAG_ENVIAR_DADOS_MEDICO));
            this.checkImportarResultadoPdf.setSelected(StringUtil.getBoolean(xml, TAG_IMPORTAR_RESULTADO_PDF));
            if (xml.contains(TAG_IGNORAR_UNIDADE_PRODUTIVA)) {
                this.checkIgnorarUnidadeProdutiva.setSelected(StringUtil.getBoolean(xml, TAG_IGNORAR_UNIDADE_PRODUTIVA));
            } else {
                this.checkIgnorarUnidadeProdutiva.setSelected(true);
            }
            String codigoUnidadeProdutiva = StringUtil.getValor(xml, TAG_UNIDADE_PRODUTIVA);
            if (!Funcoes.textoVazio(codigoUnidadeProdutiva)) {
                for (int i = 0; i < this.comboUnidadeProdutiva.getItemCount(); ++i) {
                    UnidadesProdutivas unidadeProdutiva = (UnidadesProdutivas)((Object)this.comboUnidadeProdutiva.getItemAt(i));
                    if (unidadeProdutiva.getCodigo() != Integer.parseInt(codigoUnidadeProdutiva)) continue;
                    this.comboUnidadeProdutiva.setSelectedIndex(i);
                    break;
                }
            }
            this.buttonConfigurarLayout.setXmlConfiguracao(xml);
            this.buttonConfigurarLayout.setTipoImpressaoSelecionado(this.getTipoImpressao(StringUtil.getValor(xml, TAG_TIPO_IMPRESSAO)));
            this.gerenciarPainelEtiqueta();
        }
    }

    private ButtonConfiguracao.TiposImpressao getTipoImpressao(String valor) {
        for (ButtonConfiguracao.TiposImpressao tiposImpressao : ButtonConfiguracao.TiposImpressao.values()) {
            if (!tiposImpressao.getCodigo().equalsIgnoreCase(valor)) continue;
            return tiposImpressao;
        }
        return ButtonConfiguracao.TiposImpressao.GRAFICA;
    }

    public void iniciar() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        JPanel jPanelProtocolo = new JPanel();
        jPanelProtocolo.setLayout(new GridBagLayout());
        jPanelProtocolo.setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        JPanel jPanelHpDirect = new JPanel();
        jPanelHpDirect.setLayout(new GridBagLayout());
        jPanelHpDirect.setBorder(BorderFactory.createTitledBorder("Etiqueta HP Direct"));
        JPanel jPanelAtuAutomatica = new JPanel();
        jPanelAtuAutomatica.setLayout(new GridBagLayout());
        jPanelAtuAutomatica.setBorder(BorderFactory.createTitledBorder("Atualiza\u00e7\u00e3o Autom\u00e1tica"));
        GridBagConstraints consCentral = new GridBagConstraints();
        consCentral.fill = 2;
        consCentral.insets = new Insets(0, 0, 0, 0);
        consCentral.gridx = 0;
        consCentral.gridy = 0;
        GridBagConstraints consAtuAuto = new GridBagConstraints();
        consAtuAuto.fill = 2;
        consAtuAuto.insets = new Insets(1, 1, 1, 1);
        consAtuAuto.gridx = 0;
        consAtuAuto.gridy = 0;
        consAtuAuto.weightx = 0.5;
        consAtuAuto.weighty = 0.5;
        consAtuAuto.gridwidth = 1;
        consAtuAuto.gridheight = 1;
        GridBagConstraints consHp = new GridBagConstraints();
        consHp.fill = 2;
        consHp.insets = new Insets(1, 1, 1, 1);
        consHp.gridx = 0;
        consHp.gridy = 0;
        consHp.weightx = 0.5;
        consHp.weighty = 0.5;
        consHp.gridwidth = 1;
        consHp.gridheight = 1;
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        jPanelProtocolo.add((Component)ComponenteFactory.novoJLabel("Lote atual:", new Dimension(85, 20)), cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(new Dimension(100, 20));
        this.textLote.setMinimumSize(new Dimension(100, 20));
        this.textLote.setText("0");
        jPanelProtocolo.add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        jPanelProtocolo.add((Component)ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(850, 20)), cons);
        cons.gridx = 1;
        this.textCodigo.setPreferredSize(new Dimension(100, 20));
        this.textCodigo.setMinimumSize(new Dimension(100, 20));
        jPanelProtocolo.add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        cons.gridy = 2;
        jPanelProtocolo.add((Component)ComponenteFactory.novoJLabel("Senha:", new Dimension(850, 20)), cons);
        cons.gridx = 1;
        this.textSenha.setPreferredSize(new Dimension(100, 20));
        this.textSenha.setMinimumSize(new Dimension(100, 20));
        jPanelProtocolo.add((Component)this.textSenha, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        jPanelProtocolo.add((Component)ComponenteFactory.novoJLabel("Adicional lote:", new Dimension(850, 20)), cons);
        cons.gridx = 1;
        this.textAdicionalLote.setPreferredSize(new Dimension(100, 20));
        this.textAdicionalLote.setMinimumSize(new Dimension(100, 20));
        jPanelProtocolo.add((Component)this.textAdicionalLote, cons);
        cons.gridx = 0;
        cons.gridy = 4;
        jPanelProtocolo.add((Component)ComponenteFactory.novoJLabel("Unidade Produtiva:", new Dimension(850, 20)), cons);
        cons.gridx = 1;
        this.comboUnidadeProdutiva.setPreferredSize(new Dimension(100, 20));
        this.comboUnidadeProdutiva.setMinimumSize(new Dimension(100, 20));
        jPanelProtocolo.add((Component)this.comboUnidadeProdutiva, cons);
        cons.gridx = 0;
        cons.gridy = 5;
        jPanelProtocolo.add((Component)this.checkIgnorarUnidadeProdutiva, cons);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 2;
        jPanelProtocolo.add((Component)this.checkNaoEnviarObs, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 2;
        jPanelProtocolo.add((Component)this.checkEnviarLoteWebservice, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 2;
        jPanelProtocolo.add((Component)this.checkEnviarWebServiceRequisicao, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 2;
        jPanelProtocolo.add((Component)this.checkEnviarDadosMedico, cons);
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 2;
        jPanelProtocolo.add((Component)this.checkImportarResultadoPdf, cons);
        this.checkEnviarWebServiceRequisicao.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConfiguradorProtocoloHPardini.this.gerenciarPainelEtiqueta();
                if (!ConfiguradorProtocoloHPardini.this.checkEnviarLoteWebservice.isSelected()) {
                    ConfiguradorProtocoloHPardini.this.checkEnviarLoteWebservice.setSelected(true);
                }
                if (ConfiguradorProtocoloHPardini.this.checkEnviarEtiquetaHpDirect.isSelected() && ConfiguradorProtocoloHPardini.this.checkEnviarLoteWebservice.isSelected()) {
                    ConfiguradorProtocoloHPardini.this.checkEnviarEtiquetaHpDirect.setSelected(false);
                }
            }
        });
        this.checkEnviarLoteWebservice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ConfiguradorProtocoloHPardini.this.checkEnviarLoteWebservice.isSelected() && ConfiguradorProtocoloHPardini.this.checkEnviarWebServiceRequisicao.isSelected()) {
                    ConfiguradorProtocoloHPardini.this.checkEnviarWebServiceRequisicao.setSelected(false);
                }
                if (ConfiguradorProtocoloHPardini.this.checkEnviarEtiquetaHpDirect.isSelected() && ConfiguradorProtocoloHPardini.this.checkEnviarLoteWebservice.isSelected()) {
                    ConfiguradorProtocoloHPardini.this.checkEnviarEtiquetaHpDirect.setSelected(false);
                }
            }
        });
        this.checkEnviarEtiquetaHpDirect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloHPardini.this.buttonConfigurarLayout.getTipoImpressaoSelecionado() == null) {
                    ConfiguradorProtocoloHPardini.this.buttonConfigurarLayout.setTipoImpressaoSelecionado(ButtonConfiguracao.TiposImpressao.GRAFICA);
                }
                if (ConfiguradorProtocoloHPardini.this.checkEnviarEtiquetaHpDirect.isSelected() && ConfiguradorProtocoloHPardini.this.checkEnviarLoteWebservice.isSelected()) {
                    ConfiguradorProtocoloHPardini.this.checkEnviarLoteWebservice.setSelected(false);
                    ConfiguradorProtocoloHPardini.this.checkEnviarWebServiceRequisicao.setSelected(false);
                }
            }
        });
        this.checkEnviarEtiquetaHpDirect.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ConfiguradorProtocoloHPardini.this.gerenciarPainelEtiqueta();
            }
        });
        this.getPanelCentral().add((Component)jPanelProtocolo, consCentral);
        consHp.gridwidth = 2;
        jPanelHpDirect.add((Component)this.checkEnviarEtiquetaHpDirect, consHp);
        consHp.gridwidth = 1;
        ++consHp.gridy;
        jPanelHpDirect.add((Component)ComponenteFactory.novoJLabel("Contador:", new Dimension(85, 20)), consHp);
        ++consHp.gridx;
        this.textContador.setEditable(false);
        this.textContador.setPreferredSize(new Dimension(100, 20));
        this.textContador.setMinimumSize(new Dimension(100, 20));
        jPanelHpDirect.add((Component)this.textContador, consHp);
        consHp.gridx = 0;
        ++consHp.gridy;
        jPanelHpDirect.add((Component)this.buttonZeraSequencia, consHp);
        ++consHp.gridx;
        jPanelHpDirect.add((Component)this.buttonConfigurarLayout, consHp);
        ++consCentral.gridy;
        this.getPanelCentral().add((Component)jPanelHpDirect, consCentral);
        jPanelAtuAutomatica.add((Component)this.checkAtuAutoListaExames, consAtuAuto);
        ++consCentral.gridy;
        this.getPanelCentral().add((Component)jPanelAtuAutomatica, consCentral);
        this.buttonZeraSequencia.addActionListener(this);
        this.buttonConfigurarLayout.addActionListener(this);
        this.buttonZeraSequencia.setMnemonic('Z');
        this.buttonConfigurarLayout.setMnemonic('L');
        this.mostraValorContador();
        this.pack();
        this.setResizable(false);
        this.setSize(new Dimension(340, 505));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textLote);
    }

    private void gerenciarPainelEtiqueta() {
        if (this.isCheckEnviarEtiquetaHpDirect()) {
            this.buttonConfigurarLayout.setEnabled(true);
            if (this.getValorSequencia() > 0) {
                this.buttonZeraSequencia.setEnabled(true);
            } else {
                this.buttonZeraSequencia.setEnabled(false);
            }
            this.mostraValorContador();
        } else {
            this.buttonConfigurarLayout.setEnabled(false);
            this.buttonZeraSequencia.setEnabled(false);
        }
    }

    private void mostraValorContador() {
        try {
            StringBuffer sqlVerificaSequencia = new StringBuffer();
            sqlVerificaSequencia.append("select 0 FROM pg_class where relname = 'labexterno_");
            sqlVerificaSequencia.append(Variaveis.filialPadrao).append("_");
            sqlVerificaSequencia.append(this.codigoLabExterno);
            sqlVerificaSequencia.append("_sequence';");
            ResultSet result = Conexao.executeQuery(Conexao.getStatement(), sqlVerificaSequencia.toString());
            if (result.next()) {
                sqlVerificaSequencia.setLength(0);
                sqlVerificaSequencia.append("SELECT last_value from labexterno_");
                sqlVerificaSequencia.append(Variaveis.filialPadrao).append("_");
                sqlVerificaSequencia.append(this.codigoLabExterno);
                sqlVerificaSequencia.append("_sequence;");
                ResultSet resultSet = Conexao.executeQuery(Conexao.getStatement(), sqlVerificaSequencia.toString());
                if (resultSet.next()) {
                    this.textContador.setText(resultSet.getString("last_value"));
                }
            } else {
                this.textContador.setText("0");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "", e.getStackTrace());
        }
    }

    @Override
    public String getAdicionalLote() {
        return this.textAdicionalLote.getText();
    }

    public boolean isCheckEnviarEtiquetaHpDirect() {
        return this.checkEnviarEtiquetaHpDirect.isSelected();
    }

    @Override
    public boolean isNaoEnviarObsRequisicao() {
        return this.checkNaoEnviarObs.isSelected();
    }

    public boolean isEnviarDadosMedico() {
        return this.checkEnviarDadosMedico.isSelected();
    }

    public boolean isImportarResultadoPdf() {
        return this.checkImportarResultadoPdf.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonZeraSequencia)) {
            this.zerarSequencia();
            this.gerenciarPainelEtiqueta();
        } else if (e.getSource().equals(this.buttonOK)) {
            if (this.checkEnviarEtiquetaHpDirect.isSelected() && this.checkEnviarLoteWebservice.isSelected()) {
                Funcoes.mensagem(this, "As op\u00e7\u00f5es [Enviar lote utilizando webservice] e [Enviar etiqueta HP Direct] est\u00e3o selecionadas.\n Apenas uma deve estar marcada.", 2);
                return;
            }
            if (this.isCheckEnviarEtiquetaHpDirect()) {
                try {
                    this.alterarCriarSequencia(false);
                }
                catch (Exception ex) {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {}
                }
            }
        } else if (e.getSource().equals(this.buttonCancelar) && this.checkEnviarEtiquetaHpDirect.isSelected() && this.checkEnviarLoteWebservice.isSelected()) {
            Funcoes.mensagem(this, "As op\u00e7\u00f5es [Enviar lote utilizando webservice] e [Enviar etiqueta HP Direct] est\u00e3o selecionadas.\n Apenas uma deve estar marcada.", 2);
            return;
        }
        super.actionPerformed(e);
    }

    private void zerarSequencia() {
        try {
            int zerar = Funcoes.mensagem(this, "A sequ\u00eancia ser\u00e1 zerada.\nA opera\u00e7\u00e3o n\u00e3o poder\u00e1 ser desfeita.\nDeseja continuar?", 4);
            if (zerar == 0) {
                this.alterarCriarSequencia(true);
            }
        }
        catch (Exception ex) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar sequencia.", ex.getStackTrace());
        }
    }

    private boolean possuiSequencia() {
        try {
            StringBuffer sqlVerificaSequencia = new StringBuffer();
            sqlVerificaSequencia.append("select 0 FROM pg_class where relname = 'labexterno_");
            sqlVerificaSequencia.append(Variaveis.filialPadrao).append("_");
            sqlVerificaSequencia.append(this.codigoLabExterno);
            sqlVerificaSequencia.append("_sequence';");
            ResultSet result = Conexao.executeQuery(Conexao.getStatement(), sqlVerificaSequencia.toString());
            return result.next();
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar sequencia.", e.getStackTrace());
            return false;
        }
    }

    protected void alterarCriarSequencia(boolean zerarSequencia) throws SQLException {
        StringBuffer sqlVerificaSequencia = new StringBuffer();
        boolean possuiSequencia = this.possuiSequencia();
        if (possuiSequencia && zerarSequencia) {
            sqlVerificaSequencia.setLength(0);
            sqlVerificaSequencia.append("select setval('labexterno_");
            sqlVerificaSequencia.append(Variaveis.filialPadrao).append("_");
            sqlVerificaSequencia.append(this.codigoLabExterno);
            sqlVerificaSequencia.append("_sequence', 0);");
            Conexao.execute(Variaveis.filialPadrao, Conexao.getStatement(), sqlVerificaSequencia.toString());
            Conexao.arquivaSQL();
        } else if (!possuiSequencia) {
            sqlVerificaSequencia.setLength(0);
            sqlVerificaSequencia.append("CREATE SEQUENCE labexterno_");
            sqlVerificaSequencia.append(Variaveis.filialPadrao).append("_");
            sqlVerificaSequencia.append(this.codigoLabExterno);
            sqlVerificaSequencia.append("_sequence  INCREMENT 1 MINVALUE 0 START 0;");
            sqlVerificaSequencia.append("ALTER TABLE labexterno_");
            sqlVerificaSequencia.append(Variaveis.filialPadrao).append("_");
            sqlVerificaSequencia.append(this.codigoLabExterno);
            sqlVerificaSequencia.append("_sequence OWNER TO thread;");
            Conexao.execute(Variaveis.filialPadrao, Conexao.getStatement(), sqlVerificaSequencia.toString());
            Conexao.arquivaSQL();
        }
        this.mostraValorContador();
    }

    private int getValorSequencia() {
        if (this.possuiSequencia()) {
            try {
                StringBuffer sqlVerificaSequencia = new StringBuffer();
                sqlVerificaSequencia.append("SELECT last_value from labexterno_");
                sqlVerificaSequencia.append(Variaveis.filialPadrao).append("_");
                sqlVerificaSequencia.append(this.codigoLabExterno);
                sqlVerificaSequencia.append("_sequence;");
                ResultSet result = Conexao.executeQuery(Conexao.getStatement(), sqlVerificaSequencia.toString());
                if (result.next()) {
                    return result.getInt("last_value");
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel consultar sequencia.", e.getStackTrace());
            }
        }
        return 0;
    }

    public static enum UnidadesProdutivas {
        UNID_MG("Unid. de Minas Gerais", 1),
        UNID_SP("Unid. de S\u00e3o Paulo", 13);

        private int codigo = -1;
        private String descricao = null;

        private UnidadesProdutivas(String descricao, int codigo) {
            this.descricao = descricao;
            this.codigo = codigo;
        }

        public String toString() {
            return this.codigo + " - " + this.descricao;
        }

        public static UnidadesProdutivas get(Integer codigo) {
            if (codigo == null) {
                return null;
            }
            UnidadesProdutivas[] todos = UnidadesProdutivas.values();
            for (int i = 0; i < todos.length; ++i) {
                UnidadesProdutivas aux = todos[i];
                if (aux.codigo != codigo) continue;
                return aux;
            }
            return null;
        }

        public int getCodigo() {
            return this.codigo;
        }

        public String getDescricao() {
            return this.descricao;
        }
    }
}

