/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.pardini.ExameHPardini;
import jalis.laboratorio.util.parsers.pardini.MatRealHPardini;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorHPardini
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String MATERIAL = "material";
    private static final String DESC_MAT = "descricaoMaterial";
    private static final String CONSERVANTE = "conservante";
    private static final String SELECIONADO = "selecionado";
    private static final String MATERIAL_ESPEC_CONFIGURACAO = "materialUsuario";
    private static final String OBJ_EXAME_HPARDINI = "objExameHPardini";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "material");
    private ModeloResultSet modMatCheck = new ModeloResultSet(new String[]{"Descri\u00e7\u00e3o", "descricaoMaterial", "Conservante", "conservante", "Sel", "selecionado"}){

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            super.setValueAt(aValue, rowIndex, columnIndex);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    };
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, new int[0]);
    private JTable tableMat = new JTable(this.modMatCheck);
    private JCheckBox checkUtilizarMaterialRequisicao = ComponenteFactory.novoJCheckBox("Utilizar material informado na requisi\u00e7\u00e3o", 'U', this);
    private JTextField textMaterial = new JTextField();
    private JLabel labelMaterial = ComponenteFactory.novoJLabel(" Material: ", 'M', new Dimension(70, 22), this.textMaterial);
    private JButton buttonAdicionarMaterial = ComponenteFactory.novoJButton("Adicionar", 'A', this, null, null, false);
    private JPanel panelMaterial = new JPanel();
    private JPanel panelMateriaisReais;
    private JLabel labelObrigatorio = new JLabel("Obrigat\u00f3rio: ");
    private JLabel labelGrupo = new JLabel("Grupo: ");
    private JLabel labelGrupoInfo = new JLabel();
    private JTextArea txtAreaInfo = new JTextArea();
    private JScrollPane scrollInfo = new JScrollPane(this.txtAreaInfo);
    private JTextField textLocalizar = new JTextField();
    private String xmlSelecionado = "";
    private String codigoExameLabExterno = "";
    private ExameHPardini registroSelecionado = null;
    private JCheckBox checkExigirCondicaoAmostra = ComponenteFactory.novoJCheckBox("Exigir condi\u00e7\u00e3o da amostra", 'E', this);
    private JCheckBox checkImportarResultadoPDF = new JCheckBox("Importar resultado no formato PDF");
    private Object[] itensNumeroAmostra = new Object[]{"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
    private JLabel labelNumeroAmostra = new JLabel("N\u00ba da amostra:");
    private JComboBox<Object> comboNumeroAmostra = new JComboBox<Object>(this.itensNumeroAmostra);
    private JPanel panelInformacoes = null;

    public static ConfiguradorHPardini novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorHPardini((Frame)pai, codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorHPardini((Dialog)pai, codigoLabExterno);
        }
        return null;
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null) {
            ExameHPardini ehp = ExameHPardini.novaInstancia(xml);
            return ehp.getDescricaoExame();
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameHPardini ehp = ExameHPardini.novaInstancia(xml);
            return ehp.getMnemonicoMaterial() + "|" + ehp.getMnemonicoExame() + "|1";
        }
        return "";
    }

    public ConfiguradorHPardini(Frame pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Lab. H. Pardini", codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorHPardini(Dialog pai, String codigoLabExterno) {
        super(pai, "Configura\u00e7\u00e3o para exames do Lab. H. Pardini", codigoLabExterno);
        this.iniciar();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.atualizarInformacoesExame((ExameHPardini)reg.getValor(OBJ_EXAME_HPARDINI));
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.checkUtilizarMaterialRequisicao) {
            this.habilitarCamposMaterial(!this.checkUtilizarMaterialRequisicao.isSelected());
            if (this.checkUtilizarMaterialRequisicao.isSelected()) {
                this.textMaterial.setText("");
            }
        } else if (o == this.buttonAdicionarMaterial) {
            ModeloResultSet mod = this.modMatCheck;
            Registro regSelecionado = mod.getRegistro(mod.getIndice(SELECIONADO, Boolean.TRUE));
            if (regSelecionado != null) {
                regSelecionado.substituirValor(SELECIONADO, Boolean.FALSE);
            }
            mod.addRegistro(Registro.novoRegistro(new Object[]{DESC_MAT, this.textMaterial.getText(), SELECIONADO, Boolean.TRUE, MATERIAL_ESPEC_CONFIGURACAO, Boolean.TRUE}));
            this.atualizarXMLSelecionado();
            this.atualizarTabelaMateriais(mod);
            this.atualizarPanelMateriais();
            this.textMaterial.setText("");
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public boolean exigeAltura() {
        return this.contemInfoComp("Altura");
    }

    @Override
    public boolean exigePeso() {
        return this.contemInfoComp("Peso");
    }

    @Override
    public boolean exigeTempoDiurese() {
        return this.contemInfoComp("TempoDiurese");
    }

    @Override
    public boolean exigeCondicaoAmostra() {
        return this.checkExigirCondicaoAmostra.isSelected();
    }

    @Override
    public boolean exigeVolumeDiurese() {
        return this.contemInfoComp("VolumeDiurese");
    }

    @Override
    public boolean acaoOk() {
        ExameHPardini exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        if (this.tableMat.getModel() == this.modMatCheck && !this.checkUtilizarMaterialRequisicao.isSelected() && !this.modMatCheck.contemValor(SELECIONADO, Boolean.TRUE) && this.modMatCheck.getRowCount() > 0) {
            Funcoes.mensagem(this, "Nenhum material foi selecionado", 1);
            return false;
        }
        this.atualizarXMLSelecionado();
        return true;
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameHPardini.isXmlValido(xml)) {
            Registro reg;
            int i;
            this.xmlSelecionado = xml;
            ExameHPardini ehp = ExameHPardini.novaInstancia(xml);
            for (i = 0; i < this.tableExa.getRowCount(); ++i) {
                reg = this.modExa.getRegistro(i);
                if (reg == null || !ehp.equals(reg.getValor(OBJ_EXAME_HPARDINI))) continue;
                this.registroSelecionado = (ExameHPardini)reg.getValor(OBJ_EXAME_HPARDINI);
                this.registroSelecionado.setSelecionado(true);
                this.registroSelecionado.setConservanteSelecionado(ehp.getConservanteSelecionado());
                this.registroSelecionado.setMaterialSelecionado(ehp.getMaterialSelecinado());
                this.registroSelecionado.setUtilizarMatRequisicao(ehp.utilizarMatRequisicao());
                this.checkExigirCondicaoAmostra.setSelected(ehp.isCondicaoSelecionada());
                this.comboNumeroAmostra.setSelectedItem(ehp.getNumeroAmostra());
                this.checkImportarResultadoPDF.setSelected(ehp.isFormatoPDF());
                reg.substituirValor(OBJ_EXAME_HPARDINI, ehp);
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
            if (this.tableMat.getModel() == this.modMatCheck) {
                if (ehp.utilizarMatRequisicao()) {
                    this.checkUtilizarMaterialRequisicao.setSelected(true);
                    this.habilitarCamposMaterial(false);
                } else {
                    if (!ehp.materialEspecConfiguracao()) {
                        for (i = 0; i < this.modMatCheck.getRowCount(); ++i) {
                            reg = this.modMatCheck.getRegistro(i);
                            if ((!reg.contemValor(DESC_MAT, Funcoes.textoVazio(ehp.getMaterialSelecinado()) ? "" : ehp.getMaterialSelecinado()) || !reg.contemValor(CONSERVANTE, Funcoes.textoVazio(ehp.getConservanteSelecionado()) ? "" : ehp.getConservanteSelecionado())) && (!reg.contemValor(DESC_MAT, Funcoes.textoVazio(ehp.getMaterialSelecinado()) ? "" : ehp.getMaterialSelecinado()) || reg.getValor(CONSERVANTE) != null || !Funcoes.textoVazio(ehp.getConservanteSelecionado()))) continue;
                            reg.setValor(SELECIONADO, Boolean.TRUE);
                            break;
                        }
                    }
                    this.modMatCheck.fireTableDataChanged();
                    this.atualizarPanelMateriais();
                }
            }
        }
    }

    private void atualizarXMLSelecionado() {
        ExameHPardini exa = this.getExameSelecionado();
        if (exa != null) {
            exa.setUtilizarMatRequisicao(this.checkUtilizarMaterialRequisicao.isSelected());
            exa.setCondicaoSelecionada(this.checkExigirCondicaoAmostra.isSelected());
            Registro reg = this.modMatCheck.getRegistro(this.modMatCheck.getIndice(SELECIONADO, Boolean.TRUE));
            if (reg != null) {
                exa.setMaterialEspecConfig(reg.getBoolean(MATERIAL_ESPEC_CONFIGURACAO));
                exa.setMaterialSelecionado(reg.getString(DESC_MAT));
                exa.setConservanteSelecionado(reg.getString(CONSERVANTE));
            }
            exa.setCodLabExterno(this.getCodigoLabExterno());
            exa.setNumeroAmostra(this.comboNumeroAmostra.getSelectedItem().toString());
            exa.setFormatoPDF(this.checkImportarResultadoPDF.isSelected());
            this.xmlSelecionado = exa.getXMLExame();
            this.codigoExameLabExterno = exa.getMnemonicoMaterial() + "|" + exa.getMnemonicoExame() + "|1";
        }
    }

    private boolean contemInfoComp(String valor) {
        ExameHPardini exa = this.getExameSelecionado();
        if (exa != null) {
            return exa.contemInfoComp(valor);
        }
        return false;
    }

    private String getInformacoes() {
        StringBuilder ret;
        ArrayList<String> itens = new ArrayList<String>();
        ExameHPardini exa = this.getExameSelecionado();
        if (exa != null) {
            for (String infComp : exa.getInformacoesComplementares()) {
                if (exa.contemInfoComp("Peso") && infComp.equalsIgnoreCase("Peso")) {
                    itens.add("Peso");
                    continue;
                }
                if (exa.contemInfoComp("Altura") && infComp.equalsIgnoreCase("Altura")) {
                    itens.add("Altura");
                    continue;
                }
                if (exa.contemInfoComp("VolumeDiurese") && infComp.equalsIgnoreCase("VolumeDiurese")) {
                    itens.add("Volume de Diurese");
                    continue;
                }
                if (exa.contemInfoComp("TempoDiurese") && infComp.equalsIgnoreCase("TempoDiurese")) {
                    itens.add("Tempo de Diurese");
                    continue;
                }
                if (exa.contemInfoComp("LinfocitosAbsoluto") && infComp.equalsIgnoreCase("LinfocitosAbsoluto")) {
                    itens.add("Linf\u00f3citos Absolutos");
                    continue;
                }
                if (exa.contemInfoComp("PesoAmostra") && infComp.equalsIgnoreCase("PesoAmostra")) {
                    itens.add("Peso da amostra");
                    continue;
                }
                if (exa.contemInfoComp("TempoAmostra") && infComp.equalsIgnoreCase("TempoAmostra")) {
                    itens.add("Tempo da amostra");
                    continue;
                }
                itens.add(infComp);
            }
        }
        if (!Funcoes.textoVazio((ret = new StringBuilder(StringUtil.implode(itens, ",\n"))).toString()) && ret.indexOf(",") > -1) {
            ret = ret.reverse().replace(ret.indexOf(","), ret.indexOf(",") + 1, "e ").reverse();
        }
        return ret.toString();
    }

    private ExameHPardini getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameHPardini)reg.getValor(OBJ_EXAME_HPARDINI);
        }
        return null;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        renderer.setAlinhamentoColuna(2, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void carregarExames() {
        for (ExameHPardini exame : ExameHPardini.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getMnemonicoExame());
            reg.setValor(DESC_EXA, exame.getDescricaoExame());
            reg.setValor(MATERIAL, exame.getMnemonicoMaterial());
            reg.setValor(OBJ_EXAME_HPARDINI, exame);
            this.modExa.addRegistro(reg);
        }
    }

    private void atualizarInformacoesExame(ExameHPardini exa) {
        Registro registro;
        String informacoes = this.getInformacoes();
        this.txtAreaInfo.setText(informacoes);
        this.txtAreaInfo.setSelectionStart(0);
        this.txtAreaInfo.setSelectionEnd(0);
        this.labelGrupoInfo.setText(exa.getGrupoAmostra());
        this.labelGrupo.setVisible(this.labelGrupoInfo.getText().length() > 0);
        this.labelObrigatorio.setVisible(this.txtAreaInfo.getText().length() > 0);
        this.scrollInfo.setVisible(this.txtAreaInfo.getText().trim().length() > 0);
        this.panelInformacoes.setVisible(this.labelGrupo.isVisible() || this.labelObrigatorio.isVisible());
        ModeloResultSet mod = this.modMatCheck;
        boolean teste = false;
        mod.limpar();
        for (MatRealHPardini mat : exa.getMateriaisReais()) {
            if (mat.getConservantes().size() == 0) {
                Registro reg = new Registro();
                reg.setValor(DESC_MAT, mat.getDescricaoMatReal());
                reg.setValor(SELECIONADO, exa.isSelecionado() && mat.getDescricaoMatReal().equals(exa.getMaterialSelecinado()));
                mod.addRegistro(reg);
                continue;
            }
            for (String conservante : mat.getConservantes()) {
                Registro reg = new Registro();
                reg.setValor(DESC_MAT, mat.getDescricaoMatReal());
                reg.setValor(CONSERVANTE, conservante);
                reg.setValor(SELECIONADO, exa.isSelecionado() && conservante.equals(exa.getConservanteSelecionado()) && mat.getDescricaoMatReal().equals(exa.getMaterialSelecinado()));
                mod.addRegistro(reg);
            }
        }
        if (!Funcoes.textoVazio(exa.getMaterialSelecinado()) && exa.materialEspecConfiguracao() && (registro = mod.getRegistro(mod.getIndice(DESC_MAT, exa.getMnemonicoMaterial()))) == null) {
            mod.addRegistro(Registro.novoRegistro(new Object[]{DESC_MAT, exa.getMaterialSelecinado(), SELECIONADO, Boolean.TRUE, MATERIAL_ESPEC_CONFIGURACAO, Boolean.TRUE}));
        }
        if (mod.getRowCount() == 1) {
            registro = mod.getRegistro(0);
            registro.substituirValor(SELECIONADO, Boolean.TRUE);
        }
        this.atualizarTabelaMateriais(mod);
        this.atualizarPanelMateriais();
    }

    private void atualizarTabelaMateriais(ModeloResultSet modelo) {
        this.tableMat.setModel(modelo);
        modelo.fireTableStructureChanged();
        if (modelo == this.modMatCheck) {
            TableColumn col = this.tableMat.getColumnModel().getColumn(2);
            col.setMinWidth(20);
            col.setMaxWidth(20);
        }
        modelo.fireTableDataChanged();
    }

    private void atualizarPanelMateriais() {
        ExameHPardini ehp = this.getExameSelecionado();
        if (ehp != null) {
            if (ehp.getMnemonicoMaterial().equals("DIV")) {
                ModeloResultSet mod = (ModeloResultSet)this.tableMat.getModel();
                if (!this.panelMaterial.isVisible()) {
                    this.habilitarCamposMaterial(true);
                }
                this.panelMaterial.setVisible(true);
            } else {
                this.panelMaterial.setVisible(false);
            }
            this.panelMateriaisReais.revalidate();
            this.panelMateriaisReais.repaint();
        }
    }

    private void habilitarCamposMaterial(boolean habilitar) {
        this.labelMaterial.setEnabled(habilitar);
        this.textMaterial.setEnabled(habilitar);
    }

    private void iniciar() {
        this.modMatCheck.setColunaEditavel(SELECIONADO);
        this.modMatCheck.setColunaValorUnico(SELECIONADO, Boolean.TRUE, Boolean.FALSE);
        this.labelObrigatorio.setVisible(false);
        this.labelGrupo.setVisible(false);
        this.txtAreaInfo.setFont(new Font("Arial", 0, 12));
        this.txtAreaInfo.setEditable(false);
        this.txtAreaInfo.setPreferredSize(new Dimension(545, 250));
        this.txtAreaInfo.setRows(2);
        this.txtAreaInfo.setFocusable(true);
        this.labelGrupoInfo.setFont(new Font("Arial", 0, 12));
        this.comboNumeroAmostra.setPreferredSize(new Dimension(55, 20));
        this.modMatCheck.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                Registro reg;
                int coluna = e.getColumn();
                if (coluna == 2 && (reg = ConfiguradorHPardini.this.modMatCheck.getRegistro(e.getFirstRow())).getBoolean(ConfiguradorHPardini.SELECIONADO)) {
                    ExameHPardini novoRegistroSelecionado = ConfiguradorHPardini.this.getExameSelecionado();
                    if (ConfiguradorHPardini.this.registroSelecionado != null) {
                        ConfiguradorHPardini.this.registroSelecionado.setSelecionado(false);
                    }
                    ConfiguradorHPardini.this.registroSelecionado = novoRegistroSelecionado;
                    novoRegistroSelecionado.setSelecionado(true);
                    novoRegistroSelecionado.setMaterialEspecConfig(false);
                    novoRegistroSelecionado.setConservanteSelecionado(reg.getValor(ConfiguradorHPardini.CONSERVANTE) == null ? null : reg.getValor(ConfiguradorHPardini.CONSERVANTE).toString());
                    novoRegistroSelecionado.setMaterialSelecionado(reg.getValor(ConfiguradorHPardini.DESC_MAT) == null ? null : reg.getValor(ConfiguradorHPardini.DESC_MAT).toString());
                }
            }
        });
        this.tableMat.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                Registro reg;
                if (ConfiguradorHPardini.this.tableMat.getModel() == ConfiguradorHPardini.this.modMatCheck && ConfiguradorHPardini.this.tableMat.getSelectedRow() >= 0 && e.getKeyCode() == 127 && (reg = ConfiguradorHPardini.this.modMatCheck.getRegistro(ConfiguradorHPardini.this.tableMat.getSelectedRow())).getBoolean(ConfiguradorHPardini.MATERIAL_ESPEC_CONFIGURACAO)) {
                    ConfiguradorHPardini.this.modMatCheck.removerRegistro(reg);
                    ConfiguradorHPardini.this.modMatCheck.fireTableDataChanged();
                    ConfiguradorHPardini.this.atualizarPanelMateriais();
                }
            }
        });
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        JScrollPane scrollMat = new JScrollPane(this.tableMat);
        scrollMat.setPreferredSize(new Dimension(650, 100));
        this.scrollInfo = new JScrollPane(this.txtAreaInfo);
        this.scrollInfo.setAutoscrolls(false);
        JPanel panelObrigatorio = ComponenteFactory.novoJPanelFlowLayout(0, this.labelObrigatorio, this.scrollInfo);
        JPanel panelGrupo = ComponenteFactory.novoJPanelFlowLayout(0, this.labelGrupo, this.labelGrupoInfo);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.panelMateriaisReais = ComponenteFactory.novoJPanelBorderLayout("Materiais Reais", (Component)scrollMat, (Component)this.panelMaterial, null, null, null);
        this.panelInformacoes = ComponenteFactory.novoJPanelBorderLayout("Informa\u00e7\u00f5es", null, (Component)panelGrupo, (Component)panelObrigatorio, null, null);
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout(this.panelMateriaisReais, this.panelInformacoes, null, null, null), "Center");
        this.getPanelBotoesEsquerda().add(this.labelNumeroAmostra);
        this.getPanelBotoesEsquerda().add(this.comboNumeroAmostra);
        this.getPanelBotoesEsquerda().add(this.checkExigirCondicaoAmostra);
        this.getPanelBotoesEsquerda().add(this.checkImportarResultadoPDF);
        this.panelInformacoes.setVisible(false);
        this.configurarTabelas();
        this.montarPanelMaterial();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private void montarPanelMaterial() {
        ScreenUtil.addDocumentListener(this.textMaterial.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorHPardini.this.buttonAdicionarMaterial.setEnabled(ConfiguradorHPardini.this.textMaterial.getText().trim().length() > 0);
            }
        });
        this.panelMaterial.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints(0, 0, 3, 1, 0.5, 0.5, 10, 1, new Insets(0, 1, 0, 1), 0, 0);
        this.panelMaterial.add((Component)this.checkUtilizarMaterialRequisicao, cons);
        cons.weightx = 0.0;
        cons.gridy = 1;
        cons.gridwidth = 1;
        cons.insets = new Insets(0, 1, 1, 1);
        this.textMaterial.setPreferredSize(new Dimension(10, 22));
        this.panelMaterial.add((Component)this.labelMaterial, cons);
        cons.weightx = 0.5;
        cons.gridx = 1;
        this.panelMaterial.add((Component)this.textMaterial, cons);
        cons.weightx = 0.0;
        cons.gridx = 2;
        cons.insets = new Insets(0, 0, 1, 1);
        this.buttonAdicionarMaterial.setMargin(new Insets(1, 3, 1, 3));
        this.buttonAdicionarMaterial.setPreferredSize(new Dimension(this.buttonAdicionarMaterial.getPreferredSize().width, 22));
        this.panelMaterial.add((Component)this.buttonAdicionarMaterial, cons);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorHPardini.this.modExa.filtrar(ConfiguradorHPardini.DESC_EXA, ConfiguradorHPardini.this.textLocalizar.getText());
                if (ConfiguradorHPardini.this.modExa.getRowCount() > 0) {
                    ConfiguradorHPardini.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorHPardini.this.tableExa.hasFocus() && (row = ConfiguradorHPardini.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorHPardini.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorHPardini.this.tableExa.scrollRectToVisible(ConfiguradorHPardini.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorHPardini.this.tableExa.hasFocus() && (row = ConfiguradorHPardini.this.tableExa.getSelectedRow()) < ConfiguradorHPardini.this.tableExa.getRowCount() - 1) {
                    ConfiguradorHPardini.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorHPardini.this.tableExa.scrollRectToVisible(ConfiguradorHPardini.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }
}

