/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.pardini;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorProtocoloHPardini;
import jalis.relatorio.Editor;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.impressao.termica.EditorTermica;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

class ButtonConfiguracao
extends JButton {
    private TiposImpressao[] tiposImpressao = null;
    private TiposImpressao tipoImpressaoSelecionado = TiposImpressao.GRAFICA;
    private JPopupMenu menu = new JPopupMenu();
    private JMenu menuTipo = new JMenu("Tipo de impress\u00e3o");
    private JCheckBoxMenuItem itemTipoGrafica = new JCheckBoxMenuItem(TiposImpressao.GRAFICA.getDescricao(), TiposImpressao.GRAFICA.getImagem());
    private JCheckBoxMenuItem itemTipoDireta = new JCheckBoxMenuItem(TiposImpressao.DIRETA.getDescricao(), TiposImpressao.DIRETA.getImagem());
    private JCheckBoxMenuItem itemTipoTermica = new JCheckBoxMenuItem(TiposImpressao.TERMICA.getDescricao(), TiposImpressao.TERMICA.getImagem());
    private JMenuItem itemNovoAlterar = new JMenuItem("Novo/Alterar");
    private ConfiguradorProtocoloHPardini configuradorProtocoloHPardini;
    private String xmlConfiguracao = "";
    private String xmlConfiguracaoModeloGraficoTemp = "";
    private String xmlConfiguracaoModeloTermicoTemp = "";

    public ButtonConfiguracao(ConfiguradorProtocoloHPardini configuradorProtocoloHPardini, String descricao, TiposImpressao ... tipoImpressao) {
        super(descricao);
        this.configuradorProtocoloHPardini = configuradorProtocoloHPardini;
        int altura = this.getHeight();
        this.setPreferredSize(new Dimension(170, 25));
        this.setMinimumSize(new Dimension(170, 25));
        this.setMaximumSize(new Dimension(170, 25));
        this.tiposImpressao = tipoImpressao;
        this.setHorizontalTextPosition(4);
        this.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
        this.setHorizontalAlignment(2);
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TiposImpressao.GRAFICA) > -1) {
            this.menuTipo.add(this.itemTipoGrafica);
        }
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TiposImpressao.DIRETA) > -1) {
            this.menuTipo.add(this.itemTipoDireta);
        }
        if (Arrays.binarySearch((Object[])this.tiposImpressao, (Object)TiposImpressao.TERMICA) > -1) {
            this.menuTipo.add(this.itemTipoTermica);
        }
        if (this.menuTipo.getPopupMenu().getComponentCount() > 0) {
            this.menu.add(this.menuTipo);
        }
        this.menu.add(this.itemNovoAlterar);
        this.itemNovoAlterar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.xmlConfiguracao = ButtonConfiguracao.this.configurarModelo(ButtonConfiguracao.this);
                ButtonConfiguracao.this.setXmlConfiguracao(ButtonConfiguracao.this.xmlConfiguracao);
            }
        });
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.menu.show(ButtonConfiguracao.this, 0, ButtonConfiguracao.this.getHeight());
            }
        });
        this.itemTipoGrafica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, true);
            }
        });
        this.itemTipoDireta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.setTipoImpressaoSelecionado(TiposImpressao.DIRETA, true);
            }
        });
        this.itemTipoTermica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ButtonConfiguracao.this.setTipoImpressaoSelecionado(TiposImpressao.TERMICA, true);
            }
        });
    }

    private String configurarModelo(ButtonConfiguracao buttonConfiguracao) {
        TiposImpressao tipoImpressao = buttonConfiguracao.getTipoImpressaoSelecionado();
        if (tipoImpressao == null) {
            return "";
        }
        StringBuilder xml = new StringBuilder();
        xml.append(buttonConfiguracao.getXmlConfiguracao());
        String configurando = "";
        if (tipoImpressao.equals((Object)TiposImpressao.GRAFICA)) {
            Editor editor = new Editor(Laboratorio.getInstancia(), "Configurando etiqueta HP Direct", true);
            editor.setCamposDoBanco(Impressao.CAMPOS_ETIQUETA_HP_DIRECT);
            this.xmlConfiguracaoModeloGraficoTemp = StringUtil.getValor(this.xmlConfiguracao, "modeloGrafico");
            if (!Funcoes.textoVazio(this.xmlConfiguracaoModeloGraficoTemp)) {
                editor.setAtributos(this.xmlConfiguracaoModeloGraficoTemp);
            }
            editor.setVisible(true);
            configurando = editor.ok() ? editor.getAtributos() : this.xmlConfiguracaoModeloGraficoTemp;
            if (xml.indexOf("<modeloGrafico>") == -1) {
                xml.append("<modeloGrafico></modeloGrafico>");
            }
            StringUtil.setValor(xml, "modeloGrafico", configurando);
        } else if (tipoImpressao.equals((Object)TiposImpressao.TERMICA)) {
            EditorTermica editorTermica = new EditorTermica(Laboratorio.getInstancia(), "Configurando etiqueta HP Direct", true);
            this.xmlConfiguracaoModeloTermicoTemp = StringUtil.getValor(this.xmlConfiguracao, "modeloTermico");
            editorTermica.setDocumento(this.xmlConfiguracaoModeloTermicoTemp);
            editorTermica.setCamposBanco(Impressao.CAMPOS_ETIQUETA_HP_DIRECT);
            editorTermica.setVisible(true);
            configurando = editorTermica.ok() ? editorTermica.getDocumento() : this.xmlConfiguracaoModeloTermicoTemp;
            if (xml.indexOf("<modeloTermico>") == -1) {
                xml.append("<modeloTermico></modeloTermico>");
            }
            StringUtil.setValor(xml, "modeloTermico", configurando);
        }
        return xml.toString();
    }

    public void setTipoImpressaoSelecionado(TiposImpressao tipo, boolean perguntarAlteracao) {
        if (perguntarAlteracao && this.tipoImpressaoSelecionado != tipo) {
            int resp = Funcoes.mensagem(this.getTopLevelAncestor(), "Alterar o tipo de impress\u00e3o remover\u00e1 as configura\u00e7\u00f5es atuais.\nDeseja alterar?", 4);
            if (resp == 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.xmlConfiguracao);
                StringUtil.setValor(builder, "modeloTermico", "");
                StringUtil.setValor(builder, "modeloGrafico", "");
                this.xmlConfiguracao = builder.toString();
            } else {
                if (tipo == TiposImpressao.GRAFICA) {
                    this.itemTipoGrafica.setSelected(false);
                } else if (tipo == TiposImpressao.DIRETA) {
                    this.itemTipoDireta.setSelected(false);
                } else if (tipo == TiposImpressao.TERMICA) {
                    this.itemTipoTermica.setSelected(false);
                } else {
                    this.itemTipoGrafica.setSelected(true);
                    this.setIcon(TiposImpressao.GRAFICA.getImagem());
                }
                return;
            }
        }
        this.tipoImpressaoSelecionado = tipo;
        if (this.tipoImpressaoSelecionado.getImagem() != null) {
            this.setIcon(this.tipoImpressaoSelecionado.getImagem());
        }
        this.itemTipoGrafica.setSelected(false);
        this.itemTipoDireta.setSelected(false);
        this.itemTipoTermica.setSelected(false);
        if (tipo == TiposImpressao.GRAFICA) {
            this.itemTipoGrafica.setSelected(true);
        } else if (tipo == TiposImpressao.DIRETA) {
            this.itemTipoDireta.setSelected(true);
        } else if (tipo == TiposImpressao.TERMICA) {
            this.itemTipoTermica.setSelected(true);
        } else {
            this.itemTipoGrafica.setSelected(true);
            this.setIcon(TiposImpressao.GRAFICA.getImagem());
        }
        this.montaHint();
    }

    public TiposImpressao getTipoImpressaoSelecionado() {
        return this.tipoImpressaoSelecionado;
    }

    public void setTipoImpressaoSelecionado(TiposImpressao tipoImpressaoSelecionado) {
        this.tipoImpressaoSelecionado = tipoImpressaoSelecionado;
        this.tipoImpressaoSelecionado = tipoImpressaoSelecionado;
        if (tipoImpressaoSelecionado != null && tipoImpressaoSelecionado.getImagem() != null) {
            this.setIcon(tipoImpressaoSelecionado.getImagem());
        }
        this.itemTipoGrafica.setSelected(false);
        this.itemTipoDireta.setSelected(false);
        this.itemTipoTermica.setSelected(false);
        if (this.tipoImpressaoSelecionado == TiposImpressao.GRAFICA) {
            this.itemTipoGrafica.setSelected(true);
        } else if (this.tipoImpressaoSelecionado == TiposImpressao.DIRETA) {
            this.itemTipoDireta.setSelected(true);
        } else if (this.tipoImpressaoSelecionado == TiposImpressao.TERMICA) {
            this.itemTipoTermica.setSelected(true);
        } else {
            this.itemTipoGrafica.setSelected(true);
            this.setIcon(TiposImpressao.GRAFICA.getImagem());
        }
        this.montaHint();
    }

    public void setXmlConfiguracao(String xml) {
        this.xmlConfiguracao = xml;
        this.montaHint();
    }

    public String getXmlConfiguracao() {
        return this.xmlConfiguracao;
    }

    public String getModeloGrafico() {
        StringBuffer retorno = new StringBuffer();
        retorno.append(StringUtil.getValor(this.xmlConfiguracao, "modeloGrafico"));
        return retorno.toString();
    }

    public String getModeloTermico() {
        StringBuffer retorno = new StringBuffer();
        retorno.append(StringUtil.getValor(this.xmlConfiguracao, "modeloTermico"));
        return retorno.toString();
    }

    private void montaHint() {
        StringBuilder buf = new StringBuilder();
        buf.append("<html>Tipo de impress\u00e3o: <b>").append(this.tipoImpressaoSelecionado != null ? this.tipoImpressaoSelecionado.getDescricao() : "").append("</b>");
        if (Funcoes.textoVazio(this.xmlConfiguracao)) {
            buf.append("<br>").append("Sem modelo definido");
        }
        buf.append("</html>");
        this.setToolTipText(buf.toString());
    }

    public void limpar() {
        this.setTipoImpressaoSelecionado(TiposImpressao.GRAFICA, false);
        this.setXmlConfiguracao("");
    }

    static enum TiposImpressao {
        GRAFICA("C", "Impress\u00e3o Gr\u00e1fica", ImagemUtils.carregaImagemJalis("impressaografica.gif")),
        DIRETA("D", "Impress\u00e3o Direta", ImagemUtils.carregaImagemJalis("impressaodireta.gif")),
        TERMICA("T", "Impress\u00e3o T\u00e9rmica", ImagemUtils.carregaImagemJalis("impressaotermica.gif"));

        private String descricao;
        private String codigo;
        private ImageIcon imagem;

        private TiposImpressao(String codigo, String descricao, ImageIcon imagem) {
            this.codigo = codigo;
            this.descricao = descricao;
            this.imagem = imagem;
        }

        public String getDescricao() {
            return this.descricao;
        }

        public String getCodigo() {
            return this.codigo;
        }

        public ImageIcon getImagem() {
            return this.imagem;
        }

        public String toString() {
            return this.descricao;
        }
    }
}

