/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws.resultado;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardiniImpl;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ParserResultadoMercolab {
    public static final String ELEMENTO_RESULTADOS = "Resultados";
    public static final String ELEMENTO_PROTOCOLO = "Protocolo";
    public static final String ELEMENTO_COD_LAB = "CodLab";
    public static final String ELEMENTO_CONTROLE_DE_LOTE = "ControleDeLote";
    public static final String ELEMENTO_EMISSOR = "Emissor";
    public static final String ELEMENTO_DATA_EMISSAO = "DataEmissao";
    public static final String ELEMENTO_HORA_EMISSAO = "HoraEmissao";
    public static final String ELEMENTO_PERIODO = "Periodo";
    public static final String ELEMENTO_DATA_INICIAL = "DataInicial";
    public static final String ELEMENTO_DATA_FINAL = "DataFinal";
    public static final String ELEMENTO_HORA_INICIAL = "HoraInicial";
    public static final String ELEMENTO_HORA_FINAL = "HoraFinal";
    public static final String ELEMENTO_PEDIDO = "Pedido";
    public static final String ELEMENTO_COD_PED_APOIO = "CodPedApoio";
    public static final String ELEMENTO_COD_PED_LAB = "CodPedLab";
    public static final String ELEMENTO_NOME = "Nome";
    public static final String ELEMENTO_SUPER_EXAME = "SuperExame";
    public static final String ELEMENTO_MATERIAL_NOME = "MaterialNome";
    public static final String ELEMENTO_EXAME_NOME = "ExameNome";
    public static final String ELEMENTO_COD_EXM_APOIO = "CodExmApoio";
    public static final String ELEMENTO_COD_EXM_LAB = "CodExmLab";
    public static final String ELEMENTO_CODIGO_FORMATO = "CodigoFormato";
    public static final String ELEMENTO_EXAME = "Exame";
    public static final String ATRIBUTO_ID_EXAME = "idExame";
    public static final String ELEMENTO_METODO = "Metodo";
    public static final String ELEMENTO_INTERPRETACAO = "Interpretacao";
    public static final String ELEMENTO_OBSERVACAO = "Observacao";
    public static final String ELEMENTO_NOTA = "Nota";
    public static final String ELEMENTO_COMENTARIO_DO_PATOLOGISTA = "ComentarioDoPatologista";
    public static final String ELEMENTO_CONDICAO_DA_AMOSTRA = "CondicaoDaAmostra";
    public static final String ELEMENTO_ESTIMULO = "Estimulo";
    public static final String ELEMENTO_INF_ADICIONAL = "InfAdicional";
    public static final String ATRIBUTO_ID_INF_ADICIONAL = "idInfAdicional";
    public static final String ELEMENTO_DESCRICAO = "Descricao";
    public static final String ELEMENTO_VALOR = "Valor";
    public static final String ATRIBUTO_NOME = "Nome";
    public static final String ATRIBUTO_CASAS_DECIMAIS = "CasasDecimais";
    public static final String ATRIBUTO_TAMANHO_MAXIMO = "TamanhoMaximo";
    public static final String ATRIBUTO_TIPO = "Tipo";
    public static final String VALOR_ALFANUMERICO = "alfanumerico";
    public static final String VALOR_DECIMAL = "decimal";
    public static final String ATRIBUTO_ID_VALOR = "idValor";
    public static final String ELEMENTO_UNIDADE = "Unidade";
    public static final String ELEMENTO_ITEM_DE_EXAME = "ItemDeExame";
    public static final String ATRIBUTO_ID_ITEM_DE_EXAME = "idItemDeExame";
    public static final String ATRIBUTO_ID_IDEXAME = "idExame";
    public static final String ELEMENTO_RESULTADO = "Resultado";
    public static final String ATRIBUTO_ID_RESULTADO = "idResultado";
    public static final String ELEMENTO_CONTEUDO = "Conteudo";
    public static final String ELEMENTO_UNIDADE_DE_MEDIDA = "UnidadeDeMedida";
    public static final String ELEMENTO_VALOR_DE_REFERENCIA = "ValorDeReferencia";
    public static final String ELEMENTO_VALOR_REFERENCIA_BLOCO_TEXTO = "ValorReferenciaBlocoTexto";
    public static final String ELEMENTO_GRAFICO = "Grafico";
    public static final String ELEMENTO_TABELA = "Tabela";
    public static final String ELEMENTO_LINHA = "Linha";
    public static final String ATRIBUTO_ID_LINHA = "idLinha";
    public static final String ELEMENTO_PARAMETRO1 = "Parametro1";
    public static final String ELEMENTO_PARAMETRO2 = "Parametro2";
    public static final String ELEMENTO_UNIDADE_DO_PARAMETRO1 = "UnidadeDoParametro1";
    public static final String ELEMENTO_UNIDADE_DO_PARAMETRO2 = "UnidadeDoParametro2";
    public static final String ELEMENTO_CATEGORIA1 = "Categoria1";
    public static final String ELEMENTO_CATEGORIA2 = "Categoria2";
    public static final String ELEMENTO_CATEGORIA3 = "Categoria3";
    public static final String ELEMENTO_VALOR1 = "Valor1";
    public static final String ELEMENTO_VALOR2 = "Valor2";
    public static final String ELEMENTO_UNIDADE_DO_VALOR = "UnidadeDoValor";
    public static final String ELEMENTO_UNIDADE_PRODUTIVA = "UnidadeProdutiva";
    public static final String ELEMENTO_FORMATOS = "Formatos";
    public static final String ELEMENTO_FORMATO = "Formato";
    protected HashMap<String, String> atrsID = new HashMap();

    protected ParserResultadoMercolab() {
        this.atrsID.put(ELEMENTO_EXAME, "idExame");
        this.atrsID.put(ELEMENTO_INF_ADICIONAL, ATRIBUTO_ID_INF_ADICIONAL);
        this.atrsID.put(ELEMENTO_VALOR, ATRIBUTO_ID_VALOR);
        this.atrsID.put(ELEMENTO_ITEM_DE_EXAME, ATRIBUTO_ID_ITEM_DE_EXAME);
        this.atrsID.put(ELEMENTO_RESULTADO, ATRIBUTO_ID_RESULTADO);
        this.atrsID.put(ELEMENTO_LINHA, ATRIBUTO_ID_LINHA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document analisarXML(File arquivo, ErrorHandler error) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo, error);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document analisarXML(InputStream stream, ErrorHandler error) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(stream, error);
            return doc;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            return doc;
        }
    }

    public static ElementoHPardini analisarXMLHPardini(File arquivoXML) throws ParserResultadoHPardiniException {
        ParserResultadoMercolab parser = new ParserResultadoMercolab();
        return parser.analisar(ParserResultadoMercolab.analisarXML(arquivoXML, ParserResultadoMercolab.getErrorHandler()));
    }

    public static ElementoHPardini analisarXMLHPardini(InputStream inputXML) throws ParserResultadoHPardiniException {
        ParserResultadoMercolab parser = new ParserResultadoMercolab();
        return parser.analisar(ParserResultadoMercolab.analisarXML(inputXML, ParserResultadoMercolab.getErrorHandler()));
    }

    protected ElementoHPardini analisar(Document doc) throws ParserResultadoHPardiniException {
        ElementoHPardiniImpl resultado = null;
        if (doc != null) {
            Element raiz = doc.getDocumentElement();
            resultado = new ElementoHPardiniImpl(null, raiz.getNodeName());
            this.carregarAtributosEFilhos(resultado, raiz, XMLUtil.getElementosFilhos(raiz));
        }
        return resultado;
    }

    private void carregarAtributosEFilhos(ElementoHPardiniImpl elePai, Element pai, List<Element> filhos) {
        String atrID;
        String nome = pai.getNodeName();
        Map<String, String> atrs = XMLUtil.getAtributosDoElemento(pai);
        if (this.atrsID.containsKey(nome) && atrs.containsKey(atrID = this.atrsID.get(nome))) {
            elePai.setAtributoID(atrID, atrs.get(atrID));
            atrs.remove(atrID);
        }
        for (String atr : atrs.keySet()) {
            elePai.setAtributo(atr, atrs.get(atr));
        }
        for (Element ele : filhos) {
            ElementoHPardiniImpl filho = this.addFilho(elePai, ele);
            this.carregarAtributosEFilhos(filho, ele, XMLUtil.getElementosFilhos(ele));
        }
    }

    private ElementoHPardiniImpl addFilho(ElementoHPardiniImpl eleHP, Element filho) {
        ElementoHPardiniImpl eleFilho = null;
        eleFilho = XMLUtil.contemElementosFilhos(filho) ? new ElementoHPardiniImpl(eleHP, filho.getNodeName()) : new ElementoHPardiniImpl(eleHP, filho.getNodeName(), filho.getTextContent());
        eleHP.addFilho(eleFilho);
        return eleFilho;
    }

    protected static ErrorHandler getErrorHandler() {
        return new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                Funcoes.mensagem(null, "O XML especificado est\u00e1 incorreto:\n" + exception.getMessage(), 1);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                Funcoes.mensagem(null, "O XML especificado est\u00e1 incorreto:\n" + exception.getMessage(), 1);
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }
        };
    }
}

