/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws.resultado;

import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class InformaPeriodoImportacaoMercolabWS
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Importa\u00e7\u00e3o via Weservice";
    private JLabel labelDataInicial = new JLabel("Data Inicial:");
    private JLabel labelDataFinal = new JLabel("Data Final:");
    private JLabel labelHoraInicial = new JLabel("Hora Inicial:");
    private JLabel labelHoraFinal = new JLabel("Hora Final:");
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private int codigoLabExterno;
    private boolean isOk = false;

    public static InformaPeriodoImportacaoMercolabWS novaInstancia(Object pai, int codLabExterno) {
        return pai instanceof Dialog ? new InformaPeriodoImportacaoMercolabWS((Dialog)pai, codLabExterno) : new InformaPeriodoImportacaoMercolabWS((Frame)pai, codLabExterno);
    }

    private InformaPeriodoImportacaoMercolabWS(Dialog pai, int codigoLabExterno) {
        super(pai, TITULO);
        this.codigoLabExterno = codigoLabExterno;
        this.construirTela();
    }

    private InformaPeriodoImportacaoMercolabWS(Frame pai, int codigoLabExterno) {
        super(pai, TITULO);
        this.codigoLabExterno = codigoLabExterno;
        this.construirTela();
    }

    private void construirTela() {
        this.setSize(new Dimension(250, 190));
        this.setResizable(false);
        this.setModal(true);
        this.definirTamanhoComponentes();
        this.buttonOK.setText("Importar");
        this.buttonOK.setToolTipText("Informar per\u00edodo inicial e final para habilitar");
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        JPanel panelInicial = this.posicionarComponentes();
        panel.add((Component)panelInicial, "Center");
        this.setPeriodo();
        this.buttonOK.setEnabled(false);
        this.adicionarListener();
        ScreenUtil.centralizar(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (Funcoes.textoVazio(InformaPeriodoImportacaoMercolabWS.this.textDataInicial)) {
                    InformaPeriodoImportacaoMercolabWS.this.textDataInicial.requestFocus();
                } else {
                    InformaPeriodoImportacaoMercolabWS.this.textDataFinal.requestFocus();
                }
            }
        });
    }

    private void setPeriodo() {
        this.textDataInicial.setText(Funcoes.formataData("dd/MM/yyyy", new Date()));
        this.textHoraInicial.setText("00:00");
    }

    private void adicionarListener() {
        this.textDataFinal.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }
        });
        this.textDataInicial.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }
        });
        this.textHoraInicial.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }
        });
        this.textHoraFinal.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InformaPeriodoImportacaoMercolabWS.this.buttonOK.setEnabled(InformaPeriodoImportacaoMercolabWS.this.todosPreenchidos());
            }
        });
        this.textDataInicial.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(InformaPeriodoImportacaoMercolabWS.this.textDataInicial, InformaPeriodoImportacaoMercolabWS.this.buttonDataInicial, InformaPeriodoImportacaoMercolabWS.this.getPanelCentral(), true);
                }
            }
        });
        this.textDataFinal.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 113) {
                    Funcoes.mostraData(InformaPeriodoImportacaoMercolabWS.this.textDataFinal, InformaPeriodoImportacaoMercolabWS.this.buttonDataFinal, InformaPeriodoImportacaoMercolabWS.this.getPanelCentral(), true);
                }
            }
        });
    }

    private void definirTamanhoComponentes() {
        int alturaPadrao = 20;
        int larguraText = 100;
        int larguraButton = 20;
        this.textDataInicial.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataInicial.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraInicial.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraInicial.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraFinal.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraFinal.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.buttonDataInicial.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataInicial.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
    }

    private JPanel posicionarComponentes() {
        JPanel panelInicial = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.insets = new Insets(1, 1, 0, 0);
        c1.fill = 1;
        c1.anchor = 16;
        ++c1.gridx;
        panelInicial.add((Component)this.labelDataInicial, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 3;
        panelInicial.add((Component)this.labelHoraInicial, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.textDataInicial, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonDataInicial, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 2;
        panelInicial.add((Component)this.textHoraInicial, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.labelDataFinal, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 3;
        panelInicial.add((Component)this.labelHoraFinal, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panelInicial.add((Component)this.textDataFinal, c1);
        ++c1.gridx;
        panelInicial.add((Component)this.buttonDataFinal, c1);
        c1.insets = new Insets(0, 10, 0, 0);
        c1.gridx += 2;
        panelInicial.add((Component)this.textHoraFinal, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        c1.gridx = 0;
        ++c1.gridy;
        return panelInicial;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
        } else if (e.getSource() == this.buttonOK) {
            if (this.preenchimentoValido()) {
                this.isOk = true;
                this.setVisible(false);
            }
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean preenchimentoValido() {
        int intervalo = Funcoes.diasPorPeriodo(this.textDataInicial.getText(), this.textDataFinal.getText());
        if (intervalo < 0) {
            Funcoes.mensagem(this, "A data final n\u00e3o pode ser menor que a data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return false;
        }
        if (intervalo > 6) {
            Funcoes.mensagem(this, "O per\u00edodo informado excede a quantidade m\u00e1xima de dias\npermitidos para a importa\u00e7\u00e3o de resultados (7 dias).\"", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return false;
        }
        return true;
    }

    public boolean isOk() {
        return this.isOk;
    }

    private boolean todosPreenchidos() {
        return !Funcoes.textoVazio(this.textDataFinal) && !Funcoes.textoVazio(this.textDataInicial) && !Funcoes.textoVazio(this.textHoraFinal) && !Funcoes.textoVazio(this.textHoraInicial);
    }

    public Date getDataInicial() {
        return this.textDataInicial.getData();
    }

    public Date getDataFinal() {
        return this.textDataFinal.getData();
    }

    public String getHoraInicial() {
        return this.textHoraInicial.getText();
    }

    public String getHoraFinal() {
        return this.textHoraFinal.getText();
    }
}

