/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws.resultado;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.util.StringUtil;
import java.util.LinkedHashMap;

public class CamposImportacaoMercolab
implements CamposImportacao {
    public static final String LINHA_CODIGO_EXAME = "codigoExame";
    public static final String LINHA_DESCRICAO_EXAME = "descricaoExame";
    public static final String LINHA_DESCRICAO_MATERIAL = "descricaoMaterial";
    public static final String LINHA_METODO = "metodo";
    public static final String LINHA_NOTA = "nota";
    public static final String LINHA_COD_FORMATO = "codigoFormato";
    public static final String LINHA_ID_CAMPO = "idCampo";
    public static final String LINHA_NOME_CAMPO = "nomeCampo";
    public static final String LINHA_NOME_FORMATO = "nomeFormato";
    public static final String LINHA_UN_MEDIDA = "unidadeMedida";
    public static final String LINHA_VALOR_REF = "valorReferencia";
    LinkedHashMap<String, String> linhas = new LinkedHashMap();
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CamposImportacaoMercolab() {
    }

    public CamposImportacaoMercolab(String xml, String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, String versao, Integer codigoMaterialPai) {
        String[] formatos;
        this.codigoExamePai = codigoExamePai;
        this.codigoExame = codigoExameLabApoio;
        this.versao = versao;
        this.codigoMaterialPai = codigoMaterialPai;
        this.linhas.put("", "Nenhum");
        this.linhas.put(LINHA_CODIGO_EXAME, StringUtil.getValor(xml, LINHA_CODIGO_EXAME));
        this.linhas.put(LINHA_DESCRICAO_EXAME, StringUtil.getValor(xml, LINHA_DESCRICAO_EXAME));
        this.linhas.put(LINHA_DESCRICAO_MATERIAL, StringUtil.getValor(xml, LINHA_DESCRICAO_MATERIAL));
        this.linhas.put(LINHA_METODO, StringUtil.getValor(xml, LINHA_METODO));
        this.linhas.put(LINHA_NOTA, StringUtil.getValor(xml, LINHA_NOTA));
        this.linhas.put(LINHA_COD_FORMATO, versao);
        for (String formato : formatos = StringUtil.getValores(xml, "formato")) {
            String[] campos;
            String codFormatoXML = StringUtil.getValor(formato, LINHA_COD_FORMATO);
            if (!versao.equals(codFormatoXML)) continue;
            this.linhas.put(LINHA_NOME_FORMATO, StringUtil.getValor(formato, LINHA_NOME_FORMATO));
            for (String campo : campos = StringUtil.getValores(formato, "campo")) {
                String idCampo = StringUtil.getValor(campo, LINHA_ID_CAMPO);
                this.linhas.put(StringUtil.getValor(campo, LINHA_ID_CAMPO), StringUtil.getValor(campo, LINHA_NOME_CAMPO));
                this.linhas.put("unidadeMedida_" + idCampo, StringUtil.getValor(campo, LINHA_UN_MEDIDA));
                this.linhas.put("valorReferencia_" + idCampo, StringUtil.getValor(campo, LINHA_VALOR_REF));
            }
        }
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }

    public String toString() {
        return this.getVersao();
    }
}

