/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws.dto;

import jalis.laboratorio.util.parsers.mercolabws.dto.CamposExameMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.DadosAdicionaisMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.FormatosMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.MaterialMercolabDTO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ExameMercolabDTO {
    private String codigoExame;
    private String descricaoExame;
    private List<MaterialMercolabDTO> materialMercolab = new ArrayList<MaterialMercolabDTO>();
    private List<DadosAdicionaisMercolabDTO> dadosAdicionaisMercolab = new ArrayList<DadosAdicionaisMercolabDTO>();
    private boolean isExameAntigo;
    private String xmlExameAntigo;
    private boolean formatoPDF;
    public static final String TAG_CAMPO = "campo";
    public static final String TAG_ID_CAMPO = "idCampo";
    public static final String TAG_NOME_CAMPO = "nomeCampo";
    public static final String TAG_UNIDADE_MEDIDA = "unidadeMedida";
    public static final String TAG_VALOR_REFERENCIA = "valorReferencia";
    public static final String TAG_METODOLOGIA = "metodologia";

    public MaterialMercolabDTO getMaterialSelecionado(List<MaterialMercolabDTO> materiais, String materialSelecionado) {
        MaterialMercolabDTO materialDto = new MaterialMercolabDTO();
        for (MaterialMercolabDTO material : materiais) {
            if (!material.getDescricaoMaterial().equalsIgnoreCase(materialSelecionado)) continue;
            return material;
        }
        return materialDto;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getDescricaoExame() {
        return this.descricaoExame;
    }

    public void setDescricaoExame(String descricaoExame) {
        this.descricaoExame = descricaoExame;
    }

    public List<MaterialMercolabDTO> getMaterialMercolab() {
        return this.materialMercolab;
    }

    public void setMaterialMercolab(List<MaterialMercolabDTO> materialMercolab) {
        this.materialMercolab = materialMercolab;
    }

    public void setDadosAdicionaisMercolab(List<DadosAdicionaisMercolabDTO> dadosAdicionaisMercolab) {
        this.dadosAdicionaisMercolab = dadosAdicionaisMercolab;
    }

    public List<DadosAdicionaisMercolabDTO> getDadosAdicionaisMercolab() {
        return this.dadosAdicionaisMercolab;
    }

    public boolean isExameAntigo() {
        return this.isExameAntigo;
    }

    public void setExameAntigo(boolean isExameAntigo) {
        this.isExameAntigo = isExameAntigo;
    }

    public String getXmlExameAntigo() {
        return this.xmlExameAntigo;
    }

    public void setXmlExameAntigo(String xmlExameAntigo) {
        this.xmlExameAntigo = xmlExameAntigo;
    }

    public boolean isFormatoPDF() {
        return this.formatoPDF;
    }

    public void setFormatoPDF(boolean formatoPDF) {
        this.formatoPDF = formatoPDF;
    }

    public static boolean isXmlValido(String xmlExame) {
        String formatos;
        String materiais = StringUtil.getValor(xmlExame, "materiais");
        return materiais != null && materiais.trim().length() > 0 && (formatos = StringUtil.getValor(materiais, "formatos")) != null && formatos.trim().length() > 0;
    }

    public static ExameMercolabDTO criaObjetoExame(String xmlExameMercolab) {
        ExameMercolabDTO exameDTO = new ExameMercolabDTO();
        if (xmlExameMercolab != null) {
            exameDTO.setCodigoExame(StringUtil.getValor(xmlExameMercolab, "codigoExame"));
            exameDTO.setDescricaoExame(StringUtil.getValor(xmlExameMercolab, "descricaoExame"));
            String[] materiais = StringUtil.getValores(xmlExameMercolab, "material");
            ArrayList<MaterialMercolabDTO> materiaisDto = new ArrayList<MaterialMercolabDTO>();
            for (int i = 0; i < materiais.length; ++i) {
                MaterialMercolabDTO materialDto = new MaterialMercolabDTO();
                String material = materiais[i];
                materialDto.setDescricaoMaterial(StringUtil.getValor(material, "descricaoMaterial"));
                materialDto.setMetodo(StringUtil.getValor(material, "metodo"));
                String[] formatos = StringUtil.getValores(material, "formato");
                ArrayList<FormatosMercolabDTO> formatosDto = new ArrayList<FormatosMercolabDTO>();
                for (int j = 0; j < formatos.length; ++j) {
                    FormatosMercolabDTO formatoDto = new FormatosMercolabDTO();
                    String formato = formatos[j];
                    formatoDto.setCodigoFormato(StringUtil.getValor(formato, "codigoFormato"));
                    formatoDto.setNomeFormato(StringUtil.getValor(formato, "nomeFormato"));
                    String[] campos = StringUtil.getValores(formato, TAG_CAMPO);
                    ArrayList<CamposExameMercolabDTO> camposDto = new ArrayList<CamposExameMercolabDTO>();
                    for (int k = 0; k < campos.length; ++k) {
                        CamposExameMercolabDTO campoDto = new CamposExameMercolabDTO();
                        String campo = campos[k];
                        campoDto.setIdCampo(StringUtil.getValor(campo, TAG_ID_CAMPO));
                        campoDto.setNomeCampo(StringUtil.getValor(campo, TAG_NOME_CAMPO));
                        campoDto.setUnidadeMedida(StringUtil.getValor(campo, TAG_UNIDADE_MEDIDA));
                        campoDto.setValorReferencia(StringUtil.getValor(campo, TAG_VALOR_REFERENCIA));
                        campoDto.setObrigatorio(StringUtil.getValor(campo, "obrigatorio"));
                        camposDto.add(campoDto);
                    }
                    formatoDto.setCamposExameMercolab(camposDto);
                    formatosDto.add(formatoDto);
                }
                materialDto.setFormatosMercolab(formatosDto);
                materiaisDto.add(materialDto);
            }
            exameDTO.setMaterialMercolab(materiaisDto);
            ArrayList<DadosAdicionaisMercolabDTO> dadosAdicionaisDto = new ArrayList<DadosAdicionaisMercolabDTO>();
            String[] dadosAdicionais = StringUtil.getValores(xmlExameMercolab, "dadosAdicionais");
            for (int i = 0; i < dadosAdicionais.length; ++i) {
                String dadoAdicional = dadosAdicionais[i];
                DadosAdicionaisMercolabDTO dadosDto = new DadosAdicionaisMercolabDTO();
                dadosDto.setCodigoExame(StringUtil.getValor(xmlExameMercolab, "codigoExame"));
                dadosDto.setInformacao(StringUtil.getValor(dadoAdicional, "informacao"));
                dadosDto.setRespostas(StringUtil.getValor(dadoAdicional, "respostas"));
                dadosAdicionaisDto.add(dadosDto);
            }
            if (!dadosAdicionaisDto.isEmpty()) {
                exameDTO.setDadosAdicionaisMercolab(dadosAdicionaisDto);
            }
            boolean importaPdf = !Funcoes.textoVazio(StringUtil.getValor(xmlExameMercolab, "formato_pdf")) && StringUtil.getValor(xmlExameMercolab, "formato_pdf").equals("SIM");
            exameDTO.setFormatoPDF(importaPdf);
        }
        return exameDTO;
    }
}

