/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.mercolabws.ExameImportacaoMercolabWSDTO;
import jalis.laboratorio.util.parsers.mercolabws.ExameMercolab;
import jalis.laboratorio.util.parsers.mercolabws.dto.CamposExameMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.DadosAdicionaisMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.ExameMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.FormatosMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.MaterialMercolabDTO;
import jalis.util.Funcoes;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JProgressBar;

public class ParserImportacaoMercolabWS {
    private static String ABRIR_TAG_MERCOLAB = "<mercolab>";
    private static String FECHAR_TAG_MERCOLAB = "</mercolab>";
    private static String ABRIR_TAG_EXAME = "<exame>";
    private static String FECHAR_TAG_EXAME = "</exame>";
    private static String ABRIR_TAG_CODIGO_EXAME = "<codigoExame>";
    private static String FECHAR_TAG_CODIGO_EXAME = "</codigoExame>";
    private static String ABRIR_TAG_DESCRICAO_EXAME = "<descricaoExame>";
    private static String FECHAR_TAG_DESCRICAO_EXAME = "</descricaoExame>";
    private static String ABRIR_TAG_MATERIAIS = "<materiais>";
    private static String FECHAR_TAG_MATERIAIS = "</materiais>";
    private static String ABRIR_TAG_MATERIAL = "<material>";
    private static String FECHAR_TAG_MATERIAL = "</material>";
    private static String ABRIR_TAG_DESCRICAO_MATERIAL = "<descricaoMaterial>";
    private static String FECHAR_TAG_DESCRICAO_MATERIAL = "</descricaoMaterial>";
    private static String ABRIR_TAG_METODO = "<metodo>";
    private static String FECHAR_TAG_METODO = "</metodo>";
    private static String ABRIR_TAG_NOTA = "<nota>";
    private static String FECHAR_TAG_NOTA = "</nota>";
    private static String ABRIR_TAG_FORMATOS = "<formatos>";
    private static String FECHAR_TAG_FORMATOS = "</formatos>";
    private static String ABRIR_TAG_FORMATO = "<formato>";
    private static String FECHAR_TAG_FORMATO = "</formato>";
    private static String ABRIR_TAG_CODIGO_FORMATO = "<codigoFormato>";
    private static String FECHAR_TAG_CODIGO_FORMATO = "</codigoFormato>";
    private static String ABRIR_TAG_NOME_FORMATO = "<nomeFormato>";
    private static String FECHAR_TAG_NOME_FORMATO = "</nomeFormato>";
    private static String ABRIR_TAG_DADOS_ADICIONAIS = "<dadosAdicionais>";
    private static String FECHAR_TAG_DADOS_ADICIONAIS = "</dadosAdicionais>";
    private static String ABRIR_TAG_ADICIONAL = "<adcional>";
    private static String FECHAR_TAG_ADICIONAL = "</adcional>";
    private static String ABRIR_TAG_INFORMACAO = "<informacao>";
    private static String FECHAR_TAG_INFORMACAO = "</informacao>";
    private static String ABRIR_TAG_RESPOSTAS = "<respostas>";
    private static String FECHAR_TAG_RESPOSTAS = "</respostas>";
    private static String ABRIR_TAG_OPCOES = "<opcoes>";
    private static String FECHAR_TAG_OPCOES = "</opcoes>";
    private static String ABRIR_TAG_RESULTADO = "<resultado>";
    private static String FECHAR_TAG_RESULTADO = "</resultado>";
    private static String ABRIR_TAG_CAMPOS = "<campos>";
    private static String FECHAR_TAG_CAMPOS = "</campos>";
    private static String ABRIR_TAG_CAMPO = "<campo>";
    private static String FECHAR_TAG_CAMPO = "</campo>";
    private static String ABRIR_TAG_ID_CAMPO = "<idCampo>";
    private static String FECHAR_TAG_ID_CAMPO = "</idCampo>";
    private static String ABRIR_TAG_NOME_CAMPO = "<nomeCampo>";
    private static String FECHAR_TAG_NOME_CAMPO = "</nomeCampo>";
    private static String ABRIR_TAG_UNIDADE_MEDIDA = "<unidadeMedida>";
    private static String FECHAR_TAG_UNIDADE_MEDIDA = "</unidadeMedida>";
    private static String ABRIR_TAG_VALOR_REFERENCIA = "<valorReferencia>";
    private static String FECHAR_TAG_VALOR_REFERENCIA = "</valorReferencia>";
    private static String ABRIR_TAG_CAMPO_OBRIGATORIO = "<obrigatorio>";
    private static String FECHAR_TAG_CAMPO_OBRIGATORIO = "</obrigatorio>";
    public static final String TAG_DADOS_ADICIONAIS = "dadosAdicionais";
    public static final String TAG_DADO_ADICIONAL = "dadoAdicional";
    public static final String TAG_DADO = "dado";
    public static final String TAG_ALTURA = "Altura";
    public static final String TAG_PESO = "Peso";
    public static final String TAG_VOLUME = "Volume";
    public static final String TAG_SELECIONADO = "selecionado";
    public static final String TAG_CONFIRMAR = "confirmar";

    public List<ExameMercolabDTO> importarExames(List<ExameImportacaoMercolabWSDTO> examesMercolab, List<DadosAdicionaisMercolabDTO> dadosAdicionaisMercolab, JProgressBar progress) {
        String codExame = "";
        StringBuilder material = new StringBuilder();
        String descMaterial = "";
        HashMap<String, List> mapExamesMercolab = new HashMap<String, List>();
        for (ExameImportacaoMercolabWSDTO exameImportacao : examesMercolab) {
            if (mapExamesMercolab.containsKey(exameImportacao.getCodExameUnimed())) {
                ((List)mapExamesMercolab.get(exameImportacao.getCodExameUnimed())).add(exameImportacao);
                continue;
            }
            ArrayList<ExameImportacaoMercolabWSDTO> exame = new ArrayList<ExameImportacaoMercolabWSDTO>();
            exame.add(exameImportacao);
            mapExamesMercolab.put(exameImportacao.getCodExameUnimed(), exame);
        }
        ArrayList<ExameMercolabDTO> examesMercolabDto = new ArrayList<ExameMercolabDTO>();
        mapExamesMercolab.forEach((key, value) -> {
            ExameMercolabDTO exame = new ExameMercolabDTO();
            exame.setCodigoExame((String)key);
            exame.setDescricaoExame(((ExameImportacaoMercolabWSDTO)value.get(0)).getNomeExame());
            for (ExameImportacaoMercolabWSDTO exameImportacaoDto : value) {
                Optional<CamposExameMercolabDTO> opcionalCampo;
                Optional<FormatosMercolabDTO> opcionalFormato;
                FormatosMercolabDTO formatoMercolab;
                MaterialMercolabDTO materialMercolab;
                Optional<MaterialMercolabDTO> opcionalMaterial = exame.getMaterialMercolab().stream().filter(a -> a.getDescricaoMaterial().equalsIgnoreCase(exameImportacaoDto.getMaterial())).findAny();
                MaterialMercolabDTO materialMercolabDTO = materialMercolab = opcionalMaterial.isPresent() ? opcionalMaterial.get() : new MaterialMercolabDTO();
                if (!opcionalMaterial.isPresent()) {
                    materialMercolab.setDescricaoMaterial(exameImportacaoDto.getMaterial());
                    materialMercolab.setMetodo(exameImportacaoDto.getMetodo());
                    exame.getMaterialMercolab().add(materialMercolab);
                }
                FormatosMercolabDTO formatosMercolabDTO = formatoMercolab = (opcionalFormato = materialMercolab.getFormatosMercolab().stream().filter(a -> a.getCodigoFormato().equalsIgnoreCase(exameImportacaoDto.getVersaoMascara().toString())).findAny()).isPresent() ? opcionalFormato.get() : new FormatosMercolabDTO();
                if (!opcionalFormato.isPresent()) {
                    formatoMercolab.setCodigoFormato(exameImportacaoDto.getVersaoMascara().toString());
                    formatoMercolab.setNomeFormato(exameImportacaoDto.getNomeMascara());
                    materialMercolab.getFormatosMercolab().add(formatoMercolab);
                }
                if ((opcionalCampo = formatoMercolab.getCamposExameMercolab().stream().filter(a -> a.getIdCampo().equalsIgnoreCase(exameImportacaoDto.getIdCampo())).findAny()).isPresent()) continue;
                CamposExameMercolabDTO campoMercolab = new CamposExameMercolabDTO();
                campoMercolab.setIdCampo(exameImportacaoDto.getIdCampo());
                campoMercolab.setNomeCampo(exameImportacaoDto.getNomeCampo());
                campoMercolab.setUnidadeMedida(exameImportacaoDto.getUnidadeMedida());
                campoMercolab.setValorReferencia(exameImportacaoDto.getValorReferencia());
                campoMercolab.setObrigatorio(exameImportacaoDto.getObrigatorio());
                formatoMercolab.getCamposExameMercolab().add(campoMercolab);
            }
            List dadosAdicionais = dadosAdicionaisMercolab.stream().filter(a -> a.getCodigoExame() != null && a.getCodigoExame().equals(exame.getCodigoExame())).collect(Collectors.toList());
            if (dadosAdicionais != null && !dadosAdicionais.isEmpty()) {
                for (DadosAdicionaisMercolabDTO dados : dadosAdicionais) {
                    exame.getDadosAdicionaisMercolab().add(dados);
                }
            }
            examesMercolabDto.add(exame);
        });
        return examesMercolabDto;
    }

    public String getXmlExame(ExameMercolab exameMercolab) {
        ExameMercolabDTO exameDto = new ExameMercolabDTO();
        exameDto.setCodigoExame(exameMercolab.getCodigoExame());
        exameDto.setDescricaoExame(exameMercolab.getDescricaoExame());
        exameDto.setDadosAdicionaisMercolab(exameMercolab.getDadosAdicionais());
        ArrayList<MaterialMercolabDTO> materiais = new ArrayList<MaterialMercolabDTO>();
        materiais.add(exameMercolab.getMaterialMercolab());
        exameDto.setMaterialMercolab(materiais);
        exameDto.setFormatoPDF(exameMercolab.isFormatoPdf());
        return this.getXmlExameMercolab(exameDto);
    }

    protected String getXmlExameMercolab(ExameMercolabDTO exameMercolabDto) {
        StringBuilder xmlExame = new StringBuilder(ABRIR_TAG_MERCOLAB);
        xmlExame.append(ABRIR_TAG_EXAME);
        xmlExame.append(ABRIR_TAG_CODIGO_EXAME);
        xmlExame.append(exameMercolabDto.getCodigoExame());
        xmlExame.append(FECHAR_TAG_CODIGO_EXAME);
        xmlExame.append(ABRIR_TAG_DESCRICAO_EXAME);
        xmlExame.append(exameMercolabDto.getDescricaoExame());
        xmlExame.append(FECHAR_TAG_DESCRICAO_EXAME);
        xmlExame.append(ABRIR_TAG_MATERIAIS);
        for (MaterialMercolabDTO materialMercolab : exameMercolabDto.getMaterialMercolab()) {
            xmlExame.append(this.escreveMateriais(materialMercolab));
        }
        xmlExame.append(FECHAR_TAG_MATERIAIS);
        if (!exameMercolabDto.getDadosAdicionaisMercolab().isEmpty()) {
            xmlExame.append(ABRIR_TAG_DADOS_ADICIONAIS);
            for (DadosAdicionaisMercolabDTO dados : exameMercolabDto.getDadosAdicionaisMercolab()) {
                xmlExame.append(this.escreverDadosAdicionais(dados));
            }
            xmlExame.append(FECHAR_TAG_DADOS_ADICIONAIS);
        }
        xmlExame.append(FECHAR_TAG_EXAME);
        xmlExame.append("\n<formato_pdf>").append(exameMercolabDto.isFormatoPDF() ? "SIM" : "NAO").append("</formato_pdf>");
        xmlExame.append(FECHAR_TAG_MERCOLAB);
        return xmlExame.toString();
    }

    private String escreveMateriais(MaterialMercolabDTO materialMercolab) {
        StringBuilder materiais = new StringBuilder(ABRIR_TAG_MATERIAL);
        materiais.append(ABRIR_TAG_DESCRICAO_MATERIAL);
        materiais.append(materialMercolab.getDescricaoMaterial());
        materiais.append(FECHAR_TAG_DESCRICAO_MATERIAL);
        materiais.append(ABRIR_TAG_METODO);
        materiais.append(materialMercolab.getMetodo());
        materiais.append(FECHAR_TAG_METODO);
        materiais.append(ABRIR_TAG_FORMATOS);
        for (FormatosMercolabDTO formatosMercolab : materialMercolab.getFormatosMercolab()) {
            materiais.append(this.escreverFormatos(formatosMercolab));
        }
        materiais.append(FECHAR_TAG_FORMATOS);
        materiais.append(FECHAR_TAG_MATERIAL);
        return materiais.toString();
    }

    private String escreverFormatos(FormatosMercolabDTO formatosMercolab) {
        StringBuilder formatos = new StringBuilder(ABRIR_TAG_FORMATO);
        formatos.append(ABRIR_TAG_CODIGO_FORMATO);
        formatos.append(formatosMercolab.getCodigoFormato());
        formatos.append(FECHAR_TAG_CODIGO_FORMATO);
        formatos.append(ABRIR_TAG_NOME_FORMATO);
        formatos.append(formatosMercolab.getNomeFormato());
        formatos.append(FECHAR_TAG_NOME_FORMATO);
        formatos.append(ABRIR_TAG_RESULTADO);
        formatos.append(ABRIR_TAG_CAMPOS);
        for (CamposExameMercolabDTO camposExameMercolab : formatosMercolab.getCamposExameMercolab()) {
            formatos.append(this.escreverCampos(camposExameMercolab));
        }
        formatos.append(FECHAR_TAG_CAMPOS);
        formatos.append(FECHAR_TAG_RESULTADO);
        formatos.append(FECHAR_TAG_FORMATO);
        return formatos.toString();
    }

    private String escreverCampos(CamposExameMercolabDTO camposExame) {
        StringBuilder campos = new StringBuilder(ABRIR_TAG_CAMPO);
        campos.append(ABRIR_TAG_ID_CAMPO);
        campos.append(camposExame.getIdCampo());
        campos.append(FECHAR_TAG_ID_CAMPO);
        campos.append(ABRIR_TAG_NOME_CAMPO);
        campos.append(camposExame.getNomeCampo());
        campos.append(FECHAR_TAG_NOME_CAMPO);
        campos.append(ABRIR_TAG_UNIDADE_MEDIDA);
        campos.append(camposExame.getUnidadeMedida());
        campos.append(FECHAR_TAG_UNIDADE_MEDIDA);
        campos.append(ABRIR_TAG_VALOR_REFERENCIA);
        campos.append(camposExame.getValorReferencia());
        campos.append(FECHAR_TAG_VALOR_REFERENCIA);
        campos.append(ABRIR_TAG_CAMPO_OBRIGATORIO);
        campos.append(camposExame.getObrigatorio());
        campos.append(FECHAR_TAG_CAMPO_OBRIGATORIO);
        campos.append(FECHAR_TAG_CAMPO);
        return campos.toString();
    }

    private String escreverDadosAdicionais(DadosAdicionaisMercolabDTO dadosAdicional) {
        StringBuilder dadoAdicional = new StringBuilder(ABRIR_TAG_ADICIONAL);
        dadoAdicional.append(ABRIR_TAG_INFORMACAO);
        dadoAdicional.append(dadosAdicional.getInformacao());
        dadoAdicional.append(FECHAR_TAG_INFORMACAO);
        dadoAdicional.append(ABRIR_TAG_RESPOSTAS);
        String[] opcoes = dadosAdicional.getRespostas().split(";");
        if (!Funcoes.textoVazio(dadosAdicional.getRespostas()) && opcoes.length > 0) {
            for (int i = 0; i < opcoes.length; ++i) {
                dadoAdicional.append(opcoes[i]);
            }
        } else {
            dadoAdicional.append(ABRIR_TAG_OPCOES);
            dadoAdicional.append(FECHAR_TAG_OPCOES);
        }
        dadoAdicional.append(FECHAR_TAG_RESPOSTAS);
        dadoAdicional.append(FECHAR_TAG_ADICIONAL);
        return dadoAdicional.toString();
    }

    public List<ExameMercolabDTO> loadExamesMercolab(Statement st, int codigoLabExterno) throws SQLException {
        ArrayList<ExameMercolabDTO> exames = new ArrayList<ExameMercolabDTO>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, lae_codigo, eml_codexame, eml_descricaoexame, eml_xml ");
        sql.append(" from examesmercolab ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameMercolabDTO e = ExameMercolabDTO.criaObjetoExame(rs.getString("eml_xml"));
            e.setXmlExameAntigo(rs.getString("eml_xml"));
            exames.add(e);
        }
        return exames;
    }
}

