/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.mercolabws.ImportacaoResultadoMercolabDao;
import jalis.laboratorio.util.parsers.mercolabws.dto.ExameMercolabDTO;
import jalis.model.vo.consultas.ConfiguracaoExameMercolabVO;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JFileChooser;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPMessage;

public class ImportacaoResultadoMercolabService {
    private ImportacaoResultadoMercolabDao dao;
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;
    private List<String> examesMercolabConfigurados = new ArrayList<String>();

    public ImportacaoResultadoMercolabService() {
        this.dao = new ImportacaoResultadoMercolabDao();
    }

    public void salvarResultadoPDF(ConfiguracaoExameMercolabVO configExameMercolab, String resultadoPDFEmBase64, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica) throws SQLException {
        if (!Funcoes.textoVazio(resultadoPDFEmBase64)) {
            this.dao.salvarResultadoPDF(configExameMercolab, resultadoPDFEmBase64);
            this.dao.atualizarExameRequisicao(configExameMercolab, conferirAutomatico, codigoUsuarioConferenciaAutomatica);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void buscaDadosConferenciaAutomatica(String codigoLabExterno) {
        Statement st;
        block4: {
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImportacaoResultadoDB (56)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public String requisitarResultadosWebServiceMercolab(LaboratorioExterno labExterno, String xmlConsultaResultados) {
        String resposta = "";
        try {
            byte[] bytesXml = xmlConsultaResultados.getBytes();
            String hostWebService = StringUtil.getValor(labExterno.configuracao, "enderecoWebService");
            URL url = new URL(hostWebService);
            SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
            SOAPMessage message = MessageFactory.newInstance().createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(bytesXml));
            SOAPMessage response = soapConnection.call(message, (Object)url);
            if (null != response) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                response.writeTo((OutputStream)out);
                resposta = new String(out.toByteArray(), "UTF-8");
                out.close();
            }
            resposta = StringUtil.xmlToTexto(resposta);
        }
        catch (Exception e) {
            resposta = "Falha ao consultar resultados no WebService Mercolab - " + e.getCause();
        }
        return resposta;
    }

    public String importarResultadoPDFWebServiceEmBase64(LaboratorioExterno labExterno, String xmlConsultaResultadoPDF) {
        String retornoResultadoPDF = "";
        if (!Funcoes.textoVazio(xmlConsultaResultadoPDF)) {
            try {
                byte[] bytesXml = xmlConsultaResultadoPDF.getBytes();
                String hostWebService = StringUtil.getValor(labExterno.configuracao, "enderecoWebService");
                URL url = new URL(hostWebService);
                SOAPConnection soapConnection = SOAPConnectionFactory.newInstance().createConnection();
                SOAPMessage message = MessageFactory.newInstance().createMessage(new MimeHeaders(), (InputStream)new ByteArrayInputStream(bytesXml));
                SOAPMessage response = soapConnection.call(message, (Object)url);
                if (null != response) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    response.writeTo((OutputStream)out);
                    String resposta = new String(out.toByteArray(), "UTF-8");
                    out.close();
                    retornoResultadoPDF = StringUtil.xmlToTexto(resposta);
                }
            }
            catch (Exception e) {
                retornoResultadoPDF = "Comunica\u00e7\u00e3o com WebService Mercolab - " + e.getCause() + " - " + e.getMessage();
                return retornoResultadoPDF;
            }
        }
        return retornoResultadoPDF;
    }

    public ExameDesmembrado getExameDesmembrado(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        ExameDesmembrado exmDesm = null;
        try {
            exmDesm = this.dao.pesquisarExameDesmembradoNoLote(filial, reqCodigo, laeCodigo, exaFilho, mcoFilho);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 261");
        }
        return exmDesm;
    }

    public List<ConfiguracaoExameMercolabVO> getExamesDesmembradosPDF(Registro reg) throws SQLException {
        return this.dao.pesquisarExamesDesmembradosNoLote(reg);
    }

    public String getSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws Exception {
        return this.dao.pesquisarSituacaoExame(codFilial, codLabExterno, multiguias, codExame, codMaterial);
    }

    public String salvarXmlResultadoNoPcLocal(String descricaoLabExterno, String xmlResultado) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Salvar");
            chooser.setApproveButtonText("Salvar");
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("XML (*.xml)", "xml"));
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd HH-mm-ssSSS");
            String nomeArquivo = sf.format(new Date());
            if (!Funcoes.diretorioExiste(System.getProperty("user.home") + "/resultados" + descricaoLabExterno)) {
                new File(System.getProperty("user.home") + "/resultados" + descricaoLabExterno).mkdirs();
            }
            File arquivo = new File(System.getProperty("user.home").toString() + "/resultados" + descricaoLabExterno + "/" + nomeArquivo + ".xml");
            chooser.setSelectedFile(arquivo);
            StringUtil.escreverArquivoTexto(chooser.getSelectedFile().getPath(), xmlResultado);
        }
        catch (Exception e) {
            return "\nFalha ao salvar resultado no diretorio local - " + e.getMessage();
        }
        return "";
    }

    public Registro localizarExameRequisicao(String filial, String requisicao, String exame, String material, String codigoLabexterno) throws SQLException {
        return this.dao.pesquisarExameRequisicao(filial, requisicao, exame, material, codigoLabexterno);
    }

    public ExameMercolabDTO getXmlExameLabExterno(String codFilial, String codExameLabExterno, String codigoLabExterno) {
        ExameMercolabDTO dto = new ExameMercolabDTO();
        String xmlExameLabExterno = this.dao.pesquisarXmlExameLabExterno(codFilial, codExameLabExterno, codigoLabExterno);
        return ExameMercolabDTO.criaObjetoExame(xmlExameLabExterno);
    }
}

