/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.model.vo.consultas.ConfiguracaoExameMercolabVO;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ImportacaoResultadoMercolabDao {
    private static final String ASPA = "'";
    private static final String VIRGULA = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salvarResultadoPDF(ConfiguracaoExameMercolabVO configExameMercolab, String resultadoPDF) throws SQLException {
        Statement st = Conexao.getStatement();
        try {
            String resultado = StringUtil.textoDBEscape(resultadoPDF);
            StringBuilder sql = new StringBuilder();
            String condicaoWhere = this.getCondicaoWhere(configExameMercolab);
            sql.append(" select 1 as resultado from examerequisicaoresultado");
            sql.append(condicaoWhere);
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            sql.delete(0, sql.length());
            if (rs.next()) {
                sql.append(" update examerequisicaoresultado set");
                sql.append(" ert_resultadopdf = ").append(resultado);
                sql.append(condicaoWhere);
            } else {
                sql.append(" insert into examerequisicaoresultado (fil_codigo, exa_codigo, mco_codigo, req_codigo, ert_resultadopdf) ");
                sql.append(" values (");
                sql.append(configExameMercolab.getCodigoFilial()).append(VIRGULA);
                sql.append(ASPA.concat(configExameMercolab.getCodigoExame()).concat(ASPA)).append(VIRGULA);
                sql.append(configExameMercolab.getCodigoMaterial()).append(VIRGULA);
                sql.append(configExameMercolab.getCodigoRequisicao()).append(VIRGULA);
                sql.append(resultado).append(" );");
            }
            Conexao.executeUpdate(configExameMercolab.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private String getCondicaoWhere(ConfiguracaoExameMercolabVO configExameMercolab) {
        StringBuilder where = new StringBuilder(" where ");
        where.append(" fil_codigo = ").append(configExameMercolab.getCodigoFilial());
        where.append(" and req_codigo = ").append(configExameMercolab.getCodigoRequisicao());
        where.append(" and exa_codigo = '").append(configExameMercolab.getCodigoExame()).append(ASPA);
        where.append(" and mco_codigo = ").append(configExameMercolab.getCodigoMaterial());
        return where.toString();
    }

    public void atualizarExameRequisicao(ConfiguracaoExameMercolabVO configExameMercolab, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica) throws SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" update examerequisicao set exr_resultadoempdf = true, ");
        if (!conferirAutomatico && Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" exr_situacao = '").append("L").append("', ");
        }
        sql.append(" exr_datadigita = current_timestamp, ");
        sql.append(" usr_coddigitador = '").append(Variaveis.login).append(ASPA);
        if (conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" ,exr_situacao = '").append("C").append("', ");
            sql.append(" exr_dataassina = current_timestamp, ");
            sql.append(" usr_codassina = '").append(codigoUsuarioConferenciaAutomatica).append(ASPA);
        }
        sql.append(this.getCondicaoWhere(configExameMercolab));
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(configExameMercolab.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
    }

    public List<ConfiguracaoExameMercolabVO> pesquisarExamesFormatoPDFPorData(String dataInicial, String dataFinal, String horaInicial, String horaFinal) throws SQLException {
        ArrayList<ConfiguracaoExameMercolabVO> exames = new ArrayList<ConfiguracaoExameMercolabVO>();
        Statement st = Conexao.getStatement();
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" ler.fil_codigo, ler.req_codigo, emcle.ele_xmllabexterno, leer.exa_codigo, leer.mco_codigo, ler.leq_codigoreqapoio ");
        sql.append(" from loteexterno le");
        sql.append(" join loteexternorequisicao ler on le.fil_codigo = ler.fil_kodigo and le.lex_codigo = ler.lex_codigo and le.lae_codigo = ler.lae_codigo ");
        sql.append(" join loteexternoexamerequisicao leer on ler.fil_kodigo = leer.fil_kodigo and ler.lex_codigo = leer.lex_codigo and ler.lae_codigo = leer.lae_codigo and ler.req_codigo = leer.req_codigo ");
        sql.append(" join labexterno lae on le.fil_codigo = lae.fil_codigo and le.lae_codigo = lae.lae_codigo ");
        sql.append(" join examerequisicao er on leer.fil_kodigo = er.fil_codigo and leer.req_codigo = er.req_codigo and leer.exa_codigo = er.exa_codigo and leer.mco_codigo = er.mco_codigo ");
        sql.append(" left join examematcoletalabexterno emcle on leer.fil_codigo = emcle.fil_codigo and leer.exa_codigo = emcle.exa_codigo and leer.mco_codigo = emcle.mco_codigo and leer.lae_codigo = emcle.lae_codigo ");
        sql.append(" where ");
        sql.append(" le.lex_datahora >= '").append(Funcoes.formataData("yyyy-MM-dd", dataInicial)).append(" ").append(horaInicial).append(ASPA);
        sql.append(" and le.lex_datahora <= ' ").append(Funcoes.formataData("yyyy-MM-dd", dataFinal)).append(" ").append(horaFinal).append(ASPA);
        sql.append(" and er.exr_situacao = '").append("").append(ASPA);
        sql.append(" and (emcle.ele_xmllabexterno ilike '%<formato_pdf>SIM</formato_pdf>%' or lae.lae_configuracao ilike '%<importarResultadoPdf>true</importarResultadoPdf>%') ");
        try {
            ResultSet rs = ConexaoTemporaria.executeQuery(st, sql);
            while (rs.next()) {
                ConfiguracaoExameMercolabVO exame = new ConfiguracaoExameMercolabVO();
                exame.setCodigoFilial(rs.getString("fil_codigo"));
                exame.setCodigoRequisicao(rs.getString("req_codigo"));
                exame.setCodigoExame(rs.getString("exa_codigo"));
                exame.setCodigoMaterial(rs.getString("mco_codigo"));
                exame.setConfigExameMercolab(rs.getString("ele_xmllabexterno"));
                exame.setCodPedApoio(rs.getString("leq_codigoreqapoio"));
                exames.add(exame);
            }
        }
        catch (Exception e) {
            try {
                ConexaoTemporaria.anulaSQL();
                throw e;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
        }
        Conexao.fecharStatement(st);
        return exames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfiguracaoExameMercolabVO> pesquisarExamesDesmembradosNoLote(Registro reg) throws SQLException {
        ArrayList<ConfiguracaoExameMercolabVO> desmembrados = new ArrayList<ConfiguracaoExameMercolabVO>();
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" ldesm.fil_kodigo, ldesm.req_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo, ler.leq_codigoreqapoio,  exlabext.ele_xmllabexterno ");
        sql.append(" from loteexternoexamerequisicaodesm ldesm ");
        sql.append(" left join loteexternoexamerequisicao leer ");
        sql.append(" on ldesm.fil_kodigo = leer.fil_kodigo ");
        sql.append(" and ldesm.fil_codigo = leer.fil_codigo ");
        sql.append(" and ldesm .lex_codigo = leer.lex_codigo ");
        sql.append(" and ldesm.req_codigo = leer.req_codigo ");
        sql.append(" and ldesm.exa_codigo = leer.exa_codigo ");
        sql.append(" and ldesm.mco_codigo = leer.mco_codigo ");
        sql.append(" left join loteexternorequisicao ler ");
        sql.append(" on leer.fil_kodigo = ler.fil_kodigo ");
        sql.append(" and leer.fil_codigo = ler.fil_codigo ");
        sql.append(" and leer .lex_codigo = ler.lex_codigo ");
        sql.append(" and leer.req_codigo = ler.req_codigo ");
        sql.append(" left join examematcoletalabexterno exlabext ");
        sql.append(" on ldesm.fil_kodigo = exlabext.fil_codigo ");
        sql.append(" and ldesm.exa_kodigo = exlabext.exa_codigo ");
        sql.append(" and ldesm.mco_kodigo  = exlabext.mco_codigo ");
        sql.append(" and ldesm.lae_codigo = exlabext.lae_codigo ");
        sql.append(" where ldesm.fil_kodigo = ").append(reg.getInt("fil_codigo"));
        sql.append(" and ldesm.req_codigo = ").append(reg.getInt("req_codigo"));
        sql.append(" and ldesm.exa_codigo = ").append(StringUtil.textoDBEscape(reg.getString("examePai")));
        sql.append(" and ldesm.mco_codigo = ").append(reg.getInt("mco_codigo"));
        sql.append(" and ldesm.lae_codigo = ").append(reg.getInt("lae_codigo"));
        sql.append(" and leer.ler_datahoraestorno  is null and leer.usr_codestorno is null ");
        sql.append(" and ler.leq_dataestorno is null and ler.usr_codestorno  is null ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                ConfiguracaoExameMercolabVO confExame = new ConfiguracaoExameMercolabVO();
                confExame.setCodigoExame(rs.getString("exa_kodigo"));
                confExame.setCodigoFilial(rs.getString("fil_kodigo"));
                confExame.setCodigoMaterial(rs.getString("mco_kodigo"));
                confExame.setCodigoRequisicao(rs.getString("req_codigo"));
                confExame.setCodPedApoio(rs.getString("leq_codigoreqapoio"));
                confExame.setConfigExameMercolab(rs.getString("ele_xmllabexterno"));
                desmembrados.add(confExame);
            }
        }
        catch (Throwable throwable) {
            Conexao.fecharStatement(st);
            throw throwable;
        }
        Conexao.fecharStatement(st);
        return desmembrados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameDesmembrado pesquisarExameDesmembradoNoLote(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) throws SQLException {
        Statement st;
        block2: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block2;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ,a.mco_codigo ,p.ele_xmllabexterno, pai.ele_xmllabexterno as xmllabexternopai ");
                buf.append(" from loteexternoexamerequisicaodesm a ");
                buf.append(" left join examematcoletalabexterno p on a.fil_kodigo = p.fil_codigo and a.exa_kodigo = p.exa_codigo and a.mco_kodigo = p.mco_codigo and a.lae_codigo = p.lae_codigo ");
                buf.append(" left join examematcoletalabexterno pai on a.fil_kodigo = pai.fil_codigo and a.exa_codigo = pai.exa_codigo and a.mco_codigo = pai.mco_codigo and a.lae_codigo = pai.lae_codigo ");
                buf.append(" where a.fil_kodigo = ").append(filial);
                buf.append(" and a.req_codigo  = ").append(reqCodigo);
                buf.append(" and a.exa_kodigo = ").append(StringUtil.textoDBEscape(exaFilho));
                buf.append(" and a.mco_kodigo = ").append(mcoFilho);
                buf.append(" and a.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block2;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"), res.getString("xmllabexternopai"));
                ex.addFilho(new Exame(exaFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pesquisarSituacaoExame(String codFilial, String codLabExterno, Integer[] multiguias, String codExame, String codMaterial) throws Exception {
        String situacao = "";
        StringBuilder sql = new StringBuilder();
        Statement st = Conexao.getStatement();
        ResultSet rs = null;
        try {
            String[] examePai = new String[3];
            if (multiguias.length > 1) {
                sql.delete(0, sql.length());
                sql.append(" select req_codigo, exa_codigo, mco_codigo from loteexternoexamerequisicaodesm ");
                sql.append(" where fil_kodigo = ").append(codFilial);
                sql.append(" and lae_codigo = ").append(codLabExterno);
                sql.append(" and exa_kodigo = ").append(StringUtil.textoDBEscape(codExame));
                sql.append(" and mco_kodigo = ").append(codMaterial);
                sql.append("and req_codigo in ( ");
                for (Integer guia : multiguias) {
                    sql.append(guia).append(VIRGULA);
                }
                sql.replace(sql.length() - 1, sql.length(), "");
                sql.append(")");
                rs = Conexao.executeQuery(st, sql);
                while (rs.next()) {
                    examePai[0] = rs.getString("req_codigo");
                    examePai[1] = rs.getString("exa_codigo");
                    examePai[2] = rs.getString("mco_codigo");
                }
            }
            String codExa = codExame;
            String codMat = codMaterial;
            if (!Funcoes.textoVazio(examePai[0])) {
                codExa = examePai[1];
                codMat = examePai[2];
            }
            sql.delete(0, sql.length());
            sql = new StringBuilder(" select distinct(exr_situacao) as exr_situacao from examerequisicao ");
            sql.append(" where exr_excluido = false ");
            sql.append(" and fil_codigo = ").append(codFilial);
            sql.append(" and exa_codigo = ").append(StringUtil.textoDBEscape(codExa));
            sql.append(" and mco_codigo = ").append(codMat);
            if (multiguias.length == 1) {
                sql.append(" and req_codigo = ").append(multiguias[0]);
            } else {
                sql.append(" and req_codigo in ( ");
                for (Integer guia : multiguias) {
                    sql.append(guia).append(VIRGULA);
                }
                sql.replace(sql.length() - 1, sql.length(), "");
                sql.append(")");
            }
            rs = Conexao.executeQuery(st, sql);
            situacao = rs.next() ? rs.getString("exr_situacao") : "";
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return situacao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Registro pesquisarExameRequisicao(String fil, String req, String exa, String mco, String codigoLabExterno) {
        Statement st;
        block4: {
            Registro registro;
            StringBuilder sql = new StringBuilder("select \n");
            sql.append(" a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo, a.req_idade, a.req_anomes, \n");
            sql.append(" b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, coalesce(g.met_codigo, e.met_codigo) as met_codigo, \n");
            sql.append(" c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
            sql.append(" d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, b.exr_resposta, \n");
            sql.append(" a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao, le.lae_configuracao, le.lae_codigo \n");
            sql.append(" from requisicao a \n");
            sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
            sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
            sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
            sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
            sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
            sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
            sql.append(" left join labexterno le on g.fil_codigo = le.fil_codigo and g.lae_codigo = le.lae_codigo ");
            sql.append(" where \n");
            sql.append(" a.fil_codigo = ").append(fil).append(" and \n");
            sql.append(" a.req_codigo = ").append(req).append(" and \n");
            sql.append(" b.exa_codigo = '").append(exa).append("' and \n");
            sql.append(" b.mco_codigo = ").append(mco).append(" and \n");
            sql.append(" f.lae_codigo = ").append(codigoLabExterno);
            sql.append(" and a.req_excluida = false and b.exr_excluido = false \n");
            st = Conexao.getStatement();
            try {
                ResultSet res;
                if (st == null || !(res = Conexao.executeQuery(st, sql.toString())).next()) break block4;
                Registro reg = new Registro(res);
                reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(fil, res.getString("con_codigo"), res.getString("des_codigo")));
                reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(fil, reg.getString("codigo-layout")));
                Registro formatacao = new Registro();
                formatacao.setValor("formato", reg.getValor("exr_resultado"));
                formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                reg.setValor("formatacao", formatacao);
                registro = reg;
            }
            catch (Exception e) {
                try {
                    this.anularSQL();
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return registro;
        }
        Conexao.fecharStatement(st);
        return new Registro();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String pesquisarXmlExameLabExterno(String codFilial, String codExameLabExterno, String codigoLabExterno) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select eml_xml from examesmercolab where fil_codigo = ").append(codFilial);
        sql.append(" and eml_codexame = ").append(StringUtil.textoDBEscape(codExameLabExterno));
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        Statement st = Conexao.getStatement();
        String xmlLabExterno = "";
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            xmlLabExterno = rs.next() ? rs.getString("eml_xml") : "";
        }
        catch (Exception e) {
            String string;
            try {
                string = xmlLabExterno;
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
            return string;
        }
        Conexao.fecharStatement(st);
        return xmlLabExterno;
    }

    private void anularSQL() {
        try {
            Conexao.anulaSQL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

