/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.AbstractIntegracaoProtocolo;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.mercolabws.ImportacaoResultadoMercolabService;
import jalis.laboratorio.util.parsers.mercolabws.dto.CamposExameMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.ExameMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.FormatosMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.MaterialMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.resultado.InformaPeriodoImportacaoMercolabWS;
import jalis.laboratorio.util.parsers.mercolabws.resultado.ParserResultadoMercolab;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.model.bean.cadastro.exame.ExameLayoutMetodoBean;
import jalis.model.vo.cadastro.LayoutVO;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.model.vo.cadastro.exame.ExameVO;
import jalis.model.vo.cadastro.exame.LabExternoVO;
import jalis.model.vo.cadastro.exame.MaterialColetaVO;
import jalis.model.vo.cadastro.exame.MetodologiaVO;
import jalis.model.vo.consultas.ConfiguracaoExameMercolabVO;
import jalis.service.cadastro.FilialService;
import jalis.service.cadastro.exame.ExameLayoutMetodoService;
import jalis.service.triagem.LoteExternoExameRequisicaoService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLStringBuilder;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;

public class ImportacaoResultadoMercolab
extends AbstractImportadorResultadoLabExterno {
    private static final String TITULO = "Importa\u00e7\u00e3o de resultados";
    private static final String DESCRICAO = "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio Mercolab via Web Service";
    public static final String TAG_COD_LAB = "CodLab";
    public static final String TAG_COD_LOTE_LAB = "CodLoteLab";
    public static final String TAG_PROTOCOLO = "Protocolo";
    public static final String TAG_ID = "ID";
    public static final String TAG_CONSULTA = "Consulta";
    public static final String TAG_SOLICITA_RESULTADO = "SolicitaResultado";
    public static final String TAG_SOLICITA_LOTE = "SolicitaLote";
    public static final String TAG_OPERACAO = "Operacao";
    public static final String TAG_ACAO = "Acao";
    public static final String TAG_DATA_INICIAL = "DataInicial";
    public static final String TAG_HORA_INICIAL = "HoraInicial";
    public static final String TAG_DATA_FINAL = "DataFinal";
    public static final String TAG_HORA_FINAL = "HoraFinal";
    public static final String TAG_GRAFICO = "Grafico";
    public static final String TAG_UNIDADE_VALOR = "UnidadeNoValor";
    public static final String TAG_DADOS_CONSTANTES = "DadosConstantes";
    public static final String FORMATO = "formato";
    public static final String FORMATOS = "Formatos";
    public static final String EXAME = "Exame";
    public static final String ELEMENTO_ITEMEXAME = "ItemDeExame";
    public static final String FORMATACAO = "formatacao";
    public static final String CODIGO_LAYOUT = "codigo-layout";
    public static final String CABECALHO = "cabecalho";
    public static final String FORMATO_TEXTO = "formatotexto";
    public static final String TAG_FORMATO = "Formato";
    public static final String TAG_REGISTRO_REJEITADO = "</RegistroRejeitado>";
    public static final String TAG_ERRO = "Erro";
    public static final String TAG_DESCRICAO = "Descricao";
    private final int SITUACAO_FORMATO_OK = 0;
    private final int SITUACAO_FORMATO_INCORRETO = 1;
    private final int SITUACAO_FORMATO_VERSAO_NAO_LOCALIZADA = 2;
    private final int SITUACAO_FORMATO_IMPORTAR_ESTRUTURA_DIFERENTE = 3;
    private final int SITUACAO_FORMATO_ATRIBUTOS_DIFERENTES = 4;
    private final int SITUACAO_FORMATO_ATUALIZADO_WEB = 5;
    private static final SimpleDateFormat dataHPardini = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dataUsuario = new SimpleDateFormat("dd/MM/yyyy");
    private ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private boolean conferirAutomatico = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    private LaboratorioExterno labExterno = null;
    private AbstractIntegracaoProtocolo integracaoModeloWeb = null;
    private int codigoModeloWeb = -1;
    private int codigoLabExterno;
    private LoteExternoExameRequisicaoService loteExternoExameRequisicaoService = new LoteExternoExameRequisicaoService();
    private InformaPeriodoImportacaoMercolabWS periodoImportacao;
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    private ImportacaoResultadoMercolabService service;
    List<ConfiguracaoExameMercolabVO> desmembradosImportados;

    public ImportacaoResultadoMercolab(int codigoLabExterno) {
        super(TITULO, DESCRICAO, codigoLabExterno, Protocolo.MercolabWS, new JPanel(new FlowLayout(2)));
        this.buttonImportar.setVisible(false);
        this.modeloRelatorio.clear();
        this.codigoLabExterno = codigoLabExterno;
        this.getPanelAdicional().add(this.buttonImprimir);
        this.buttonImportarWS.setVisible(true);
        this.buttonImportarWS.setEnabled(true);
        this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
        this.service = new ImportacaoResultadoMercolabService();
        this.desmembradosImportados = new ArrayList<ConfiguracaoExameMercolabVO>();
        try {
            LabExternoVO vo = this.pesquisarPorCodLabExterno(codigoLabExterno);
            if (vo.getCodigo() != null) {
                this.conferirAutomatico = vo.getConferirAutomatico();
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(vo.getCodigoUsuarioConferir()) || Funcoes.textoVazio(vo.getCodigoUsuarioConferir()) ? null : vo.getCodigoUsuarioConferir();
                this.codigoModeloWeb = vo.getCodigoModeloWeb();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoMercolab (122)");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.buttonImportarWS) {
            if (this.periodoImportacaoPreenchido()) {
                this.desmembradosImportados = new ArrayList<ConfiguracaoExameMercolabVO>();
                this.modeloRelatorio.clear();
                this.buttonImportarWS.setEnabled(false);
                super.actionPerformed(e);
            }
        } else if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean periodoImportacaoPreenchido() {
        this.periodoImportacao = InformaPeriodoImportacaoMercolabWS.novaInstancia(this.getTopLevelAncestor(), this.codigoLabExterno);
        this.periodoImportacao.setVisible(true);
        return this.periodoImportacao.isOk();
    }

    @Override
    protected void importarResultado() {
    }

    @Override
    protected void importarResultadoWs() {
        if (null != this.periodoImportacao) {
            this.setTextoInformacoes("Aguarde... Consultando resultados");
            this.setTextoInformacoes("\nSolicitando os resultados do Per\u00edodo informado...", false);
            String descricaoLabExterno = StringUtil.removerAcentos(this.labExterno.descricao).replaceAll(" ", "");
            String xmlConsulta = this.gerarXMLConsultaResultadosPorPeriodo();
            String respostaMercolab = this.service.requisitarResultadosWebServiceMercolab(this.labExterno, xmlConsulta);
            if (Funcoes.textoVazio(respostaMercolab) || !respostaMercolab.contains("<CodExmApoio>")) {
                this.setTextoInformacoes("\nN\u00e3o h\u00e1 resultados dispon\u00edveis para o per\u00edodo informado", false);
                return;
            }
            if (respostaMercolab.startsWith("Falha ao consultar resultados")) {
                this.setTextoInformacoes("\n" + respostaMercolab, false);
                return;
            }
            if (respostaMercolab.contains(TAG_REGISTRO_REJEITADO)) {
                String erro = StringUtil.getValor(respostaMercolab, TAG_ERRO);
                String descricaoErro = StringUtil.getValor(erro, TAG_DESCRICAO);
                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel consultar resultados.\nMotivo: " + descricaoErro, false);
                return;
            }
            this.setTextoInformacoes("\nIniciando a importa\u00e7\u00e3o...", false);
            String falhaAoSalvar = this.service.salvarXmlResultadoNoPcLocal(this.labExterno.descricao, respostaMercolab);
            if (!Funcoes.textoVazio(falhaAoSalvar)) {
                this.setTextoInformacoes(falhaAoSalvar, false);
            }
            ElementoHPardini resultados = null;
            try {
                String xmlPadraoPardini = this.padronizarXmlResultadosParaFormatoPardini(respostaMercolab);
                resultados = ParserResultadoMercolab.analisarXMLHPardini(new ByteArrayInputStream(xmlPadraoPardini.getBytes()));
            }
            catch (Exception e) {
                this.setTextoInformacoes("\nFalha ao importar resultados - " + e.getMessage(), false);
            }
            if (resultados != null) {
                this.importarResultados(resultados.getFilhos());
            }
        }
    }

    private String padronizarXmlResultadosParaFormatoPardini(String xmlRespostaMercolab) throws UnsupportedEncodingException {
        String xmlCodificado = new String(xmlRespostaMercolab.getBytes(), "ISO-8859-1");
        int posicaoInicial = xmlCodificado.indexOf("<Protocolo>");
        int posicaoFinal = xmlCodificado.indexOf("</Resultados>");
        String conteudoResultados = xmlCodificado.substring(posicaoInicial, posicaoFinal);
        return StringUtil.escreveCabecalho(conteudoResultados);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    private boolean exameJaLancado(Registro reg) {
        String sit = reg.getString("exr_situacao");
        return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
    }

    private boolean exameColetado(Registro reg) {
        return null != reg && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private List<FilialVOAux> getFiliaisExportacao(List<ElementoHPardini> pedidos) {
        ArrayList<String> filiaisSolicitacoes = new ArrayList<String>();
        for (ElementoHPardini pedido : pedidos) {
            if (pedido.getFilhos("SuperExame").isEmpty() || pedido.getFilho("CodPedLab") == null) continue;
            String codFilial = pedido.getFilho("CodPedLab").getValor().substring(0, ParametrosGerais.getDigitosTuboFilial());
            filiaisSolicitacoes.add(codFilial);
        }
        filiaisSolicitacoes = new ArrayList(new LinkedHashSet(filiaisSolicitacoes));
        ArrayList<FilialVOAux> filiaisExportacao = new ArrayList<FilialVOAux>();
        for (String filial : filiaisSolicitacoes) {
            FilialVOAux filialExportacao = this.getDadosExportacao(filial);
            if (null == filialExportacao || filialExportacao.getCodigo() == null) continue;
            filiaisExportacao.add(filialExportacao);
        }
        return filiaisExportacao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importarResultados(List<ElementoHPardini> pedidos) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st != null) {
            try {
                this.progress.setMaximum(pedidos.size());
                this.progress.setValue(0);
                this.progress.setVisible(true);
                HashMap<String, String> requisicoesEnvioNotificacao = new HashMap<String, String>();
                List<FilialVOAux> filiaisExportacao = this.getFiliaisExportacao(pedidos);
                for (ElementoHPardini pedido : pedidos) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    if (pedido.getFilhos("SuperExame").isEmpty()) continue;
                    if (pedido.getFilho("CodPedLab") == null || Funcoes.textoVazio(pedido.getFilho("CodPedLab").getValor())) {
                        String tmp = pedido.getFilho("CodPedApoio") != null ? pedido.getFilho("CodPedApoio").getValor() : "";
                        this.setTextoInformacoes("\nNenhuma requisi\u00e7\u00e3o encontrada para o codigo apoio: " + tmp, false);
                        continue;
                    }
                    String fil_codigo = pedido.getFilho("CodPedLab").getValor().substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String req_codigo = pedido.getFilho("CodPedLab").getValor().substring(ParametrosGerais.getDigitosTuboFilial());
                    String codigoPedidoApoio = pedido.getFilho("CodPedApoio").getValor();
                    Integer[] multiguias = this.verificarRequisicaoMultiguia(fil_codigo, req_codigo, this.labExterno.agruparMultiguias);
                    if (null == multiguias) {
                        this.setTextoInformacoes("\nNenhuma requisi\u00e7\u00e3o encontrada para o codigo apoio: " + codigoPedidoApoio, false);
                        continue;
                    }
                    if (pedido.getFilho("CodPedLab") == null || Funcoes.textoVazio(pedido.getFilho("CodPedLab").getValor())) {
                        this.setTextoInformacoes("\nNenhuma requisi\u00e7\u00e3o encontrada para o codigo apoio: " + codigoPedidoApoio, false);
                        continue;
                    }
                    int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                    if (pedido.getFilho("CodPedLab").getValor().length() != tamTubo) {
                        this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + pedido.getFilho("CodPedLab").getValor(), false);
                        continue;
                    }
                    if (!Funcoes.isNumeric(pedido.getFilho("CodPedLab").getValor()) || pedido.getFilho("CodPedLab").getValor().contains(".") || pedido.getFilho("CodPedLab").getValor().contains(",")) {
                        this.setTextoInformacoes("\nRequisi\u00e7\u00e3o: " + pedido.getFilho("CodPedLab").getValor() + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o", false);
                        continue;
                    }
                    for (ElementoHPardini superExame : pedido.getFilhos("SuperExame")) {
                        String materialJalis;
                        if (!this.exameEMaterialValido(superExame)) {
                            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o encontrada: " + fil_codigo + req_codigo, false);
                            continue;
                        }
                        String exameJalis = superExame.getFilho("CodExmLab").getValor();
                        String situacaoExame = this.service.getSituacaoExame(fil_codigo, this.labExterno.codigoLab, multiguias, exameJalis, materialJalis = superExame.getFilho("MaterialNome").getValor().split("\\|")[0]);
                        if (!Funcoes.textoVazio(situacaoExame) && !situacaoExame.equals("P")) {
                            boolean exameDesmPDF = this.exameDesmembradoImportadoEmPDF(multiguias, fil_codigo, req_codigo, exameJalis, materialJalis);
                            if (exameDesmPDF) continue;
                            String descricaoSituacao = Tipos.tipoSituacaoExame(situacaoExame);
                            this.setTextoInformacoes(String.format("\n Exame %s %s", exameJalis + "|" + materialJalis, descricaoSituacao), false);
                            continue;
                        }
                        LinkedList<Registro> listaRegistros = this.processarPaiFilhos(st, superExame, fil_codigo, multiguias, codigoPedidoApoio);
                        if (listaRegistros == null || listaRegistros.isEmpty()) {
                            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o encontrada: " + fil_codigo + req_codigo, false);
                            continue;
                        }
                        for (Registro reg : listaRegistros) {
                            if (null != reg) {
                                String codExame;
                                String string = codExame = this.exameDesmembrado(reg) ? reg.getString("examePai") : reg.getString("exa_codigo");
                                if (this.exameJaLancado(reg)) {
                                    if (!this.importaEmPDF(reg)) {
                                        this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO);
                                        this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do %s: %s exame %s %s", this.protocolo.getDescricao(), codigoPedidoApoio, codExame, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO.descricao), false);
                                        continue;
                                    }
                                } else {
                                    if (!this.exameColetado(reg) && !reg.getString("exr_situacao").equals("P")) {
                                        this.setTextoInformacoes(String.format("\nRequisi\u00e7\u00e3o do %s: %s exame %s %s", this.protocolo.getDescricao(), codigoPedidoApoio, codExame, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL.descricao), false);
                                        this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL);
                                        continue;
                                    }
                                    if (!this.exameRelacionado(reg)) {
                                        this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.SEM_RELACIONAMENTO);
                                        this.setTextoInformacoes("\nResultado de " + reg.getString("req_codigo") + "|" + codExame + " - Sem relacionamento", false);
                                        continue;
                                    }
                                    boolean resultadoEmPDF = this.resultadoImportadoEmPDF(reg, superExame);
                                    if (resultadoEmPDF) continue;
                                    if (reg.nulo("examePai")) {
                                        reg.setValor("examePai", reg.getString("exa_codigo"));
                                    }
                                    boolean salvoParcial = reg.getString("exr_situacao").equals("P");
                                    ExameUtil.pegaLayoutIdade(reg.getString("fil_codigo"), Integer.parseInt(reg.getString("req_idade")), reg.getString("req_anomes"), reg.getString(CODIGO_LAYOUT), reg.getString("examePai"), Integer.parseInt(reg.getString("mco_codigo")), Integer.parseInt(reg.getString("met_codigo")), "elm_formato", reg);
                                    Registro formato = new Registro();
                                    formato.setValor(FORMATO, reg.getValor("formatoPadrao"));
                                    formato.setValor("met_codigo", reg.getValor("met_codigo"));
                                    Registro formatacao = salvoParcial ? (Registro)reg.getValor(FORMATACAO) : formato;
                                    int situacaoFormato = this.validaSituacaoVersaoIncorreta(formatacao, superExame, reg);
                                    if (superExame.getFilho("CodigoFormato").getValor().equalsIgnoreCase("PDF")) {
                                        this.setTextoInformacoes("\nResultado em PDF para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - Dispon\u00edvel em PDF no site do Laborat\u00f3rio Hermes Pardini", false);
                                        continue;
                                    }
                                    if (situacaoFormato == 1 || situacaoFormato == 3 || situacaoFormato == 2) {
                                        this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL);
                                        String mensagem = "";
                                        if (situacaoFormato == 2) {
                                            mensagem = " - N\u00e3o localizado modelo para importa\u00e7\u00e3o";
                                        } else if (situacaoFormato == 1) {
                                            mensagem = " - Vers\u00e3o incorreta ";
                                        } else if (situacaoFormato == 3) {
                                            mensagem = " - Estrutura incorreta";
                                        }
                                        String codFormatoMercolab = superExame.contemFilho("CodigoFormato") ? superExame.getFilho("CodigoFormato").getValor() : "";
                                        this.setTextoInformacoes("\nResultado de " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " formato: " + codFormatoMercolab + mensagem, false);
                                        continue;
                                    }
                                    if (situacaoFormato == 4) {
                                        this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.VERSAO_INCOMPATIVEL);
                                        this.setTextoInformacoes("\nResultado de " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Estrutura incorreta", false);
                                        continue;
                                    }
                                    Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                                    Map<Object, Object> camposImportacao = new HashMap();
                                    camposImportacao = this.carregarCamposImportacao(superExame, reg);
                                    dados.putAll(camposImportacao);
                                    Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                                    Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                                    if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                                        historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                                    }
                                    dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                                    Map<String, Object> resposta = Resultado.getCamposResultado(reg.getString("exr_resposta"));
                                    Resultado res = new Resultado(formatacao.getString(FORMATO), dados);
                                    res.atualizarComponentes();
                                    res = new Resultado(null, formatacao.getString(FORMATO), dados, resposta, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
                                    res.atualizarComponentes();
                                    if (!res.verificarCondicao()) {
                                        this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA);
                                        this.setTextoInformacoes("\nResultado de " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                                        continue;
                                    }
                                    boolean completo = true;
                                    if (reg.getBoolean("exa_salvaparcial")) {
                                        completo = res.resultadoCompleto(true);
                                    }
                                    if (!completo && reg.getBoolean("exa_salvaparcial")) {
                                        completo = res.resultadoCompleto(false);
                                    }
                                    String novaSituacao = completo ? "L" : "P";
                                    String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                                    Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                                    boolean marcarConferido = false;
                                    if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                                        int verificacao = res.verificarValidacao();
                                        boolean bl = marcarConferido = verificacao == 1;
                                        if (!marcarConferido && verificacao != 2) {
                                            this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA);
                                            this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                                        }
                                    }
                                    if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), codigoPedidoApoio)) {
                                        this.inserirDadosRequisicao(st, this.codigoLabExterno, codigoPedidoApoio, reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                                    }
                                    if (reg.getValor("examePai") != null) {
                                        reg.setValor("exa_codigo", reg.getString("examePai"));
                                    }
                                    boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                                    boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                                    this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                                    Optional<FilialVOAux> filialExportacao = filiaisExportacao.stream().filter(f -> f.getCodigo().equals(reg.getInt("fil_codigo"))).findAny();
                                    if (this.exportarBaseWeb(filialExportacao)) {
                                        Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                                        this.exportarParaWeb(st, this.getCodigoBaseWeb(reg.getString("fil_codigo")), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                                        if (ExportaWeb.isGerarPdfResultado(st2, reg.getString("fil_codigo"))) {
                                            ExportaWeb.enviarResultadoPDF(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), this.getCodigoBaseWeb(reg.getString("fil_codigo")));
                                        }
                                        this.atualizarPaginaOrdemExameWeb(st2, reg);
                                    }
                                    this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE);
                                    if (completo) {
                                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                                        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                                        this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                                    }
                                    if (this.filialExportaExames(filialExportacao)) {
                                        this.editarRequisicaoExportaFiliais(reg);
                                    }
                                    this.atualizarSituacaoExameInterfaceamento(st, reg);
                                    this.adicionarAoModeloRelatorio(reg.getString("fil_codigo"), reg.getString("req_codigo"), codExame, reg.getString("mco_codigo"), completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE);
                                    this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE)), false);
                                }
                            }
                            String filialRequisicao = reg.getString("fil_codigo") + "|" + reg.getString("req_codigo");
                            requisicoesEnvioNotificacao.put(filialRequisicao, codigoPedidoApoio);
                        }
                    }
                    Conexao.arquivaSQL();
                }
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > -1);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoMercolab");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    this.buttonImportarWS.setEnabled(true);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
                this.buttonImportarWS.setEnabled(true);
            }
            Conexao.fecharStatement(st, st2);
            this.buttonImportarWS.setEnabled(true);
        }
        this.progress.setVisible(false);
    }

    private boolean exameDesmembradoImportadoEmPDF(Integer[] multiguias, String fil_codigo, String req_codigo, String exameJalis, String materialJalis) {
        boolean exameDesmPDF = false;
        if (multiguias.length > 1) {
            for (Integer guia : multiguias) {
                ConfiguracaoExameMercolabVO temp = new ConfiguracaoExameMercolabVO();
                temp.setCodigoFilial(Integer.valueOf(fil_codigo).toString());
                temp.setCodigoRequisicao(guia.toString());
                temp.setCodigoExame(exameJalis);
                temp.setCodigoMaterial(Integer.valueOf(materialJalis).toString());
                exameDesmPDF = this.desmembradosImportados.contains(temp);
                if (!exameDesmPDF) {
                    continue;
                }
                break;
            }
        } else {
            ConfiguracaoExameMercolabVO temp = new ConfiguracaoExameMercolabVO();
            temp.setCodigoFilial(Integer.valueOf(fil_codigo).toString());
            temp.setCodigoRequisicao(Integer.valueOf(req_codigo).toString());
            temp.setCodigoExame(exameJalis);
            temp.setCodigoMaterial(Integer.valueOf(materialJalis).toString());
            exameDesmPDF = this.desmembradosImportados.contains(temp);
        }
        return exameDesmPDF;
    }

    private Map<String, Object> carregarCamposImportacao(ElementoHPardini superExame, Registro reg) {
        HashMap<String, Object> dados = new HashMap<String, Object>();
        if (null == superExame) {
            return dados;
        }
        String codExame = reg.getString("exa_codigo");
        String codExamePai = reg.getString("examePai");
        String inicioCampo = "";
        String fimCampo = "";
        ArrayList<String> formatos = new ArrayList<String>();
        if (codExame.equals(codExamePai)) {
            formatos.add(superExame.getFilho("CodigoFormato").getValor());
        } else {
            String xmlExameDesm = reg.getString("ele_xmllabexterno");
            List<String> formatosDesm = StringUtil.getListValores(xmlExameDesm, "codigoFormato");
            for (String formatoDesm : formatosDesm) {
                formatos.add(formatoDesm);
            }
            fimCampo = "@" + reg.getString("exa_codigo") + "#" + reg.getString("mco_codigo");
        }
        for (String formato : formatos) {
            inicioCampo = "~" + formato + "|";
            String codigoExame = superExame.contemFilho("CodExmApoio") ? superExame.getFilho("CodExmApoio").getValor() : "";
            dados.put(inicioCampo + "codigoExame" + fimCampo, codigoExame);
            String descricaoExame = superExame.contemFilho("ExameNome") ? superExame.getFilho("ExameNome").getValor() : "";
            dados.put(inicioCampo + "descricaoExame" + fimCampo, descricaoExame);
            String materialNome = superExame.contemFilho("MaterialNome") ? superExame.getFilho("MaterialNome").getValor().split("\\|")[1] : "";
            dados.put(inicioCampo + "descricaoMaterial" + fimCampo, materialNome);
            String codigoFormato = superExame.getFilho("CodigoFormato").getValor();
            dados.put(inicioCampo + "codigoFormato" + fimCampo, codigoFormato);
            ElementoHPardini exameMercolab = superExame.getFilho(EXAME);
            String metodo = exameMercolab.contemFilho("Metodo") ? exameMercolab.getFilho("Metodo").getValor() : "";
            dados.put(inicioCampo + "metodo" + fimCampo, metodo);
            String nota = exameMercolab.contemFilho("Nota") ? exameMercolab.getFilho("Nota").getValor() : "";
            dados.put(inicioCampo + "nota" + fimCampo, nota);
            for (ElementoHPardini itemDeExame : superExame.getFilhos(ELEMENTO_ITEMEXAME)) {
                this.carregarItensDeExame(itemDeExame, inicioCampo, dados, fimCampo);
            }
        }
        return dados;
    }

    private void carregarItensDeExame(ElementoHPardini elemento, String inicioCampo, Map<String, Object> dados, String fimCampo) {
        String nome;
        String string = nome = elemento.contemFilho("Nome") ? elemento.getFilho("Nome").getValor() : "";
        if (!Funcoes.textoVazio(nome)) {
            ElementoHPardini conteudo = elemento.getFilho("Resultado").getFilho("Conteudo");
            ElementoHPardini valorRef = elemento.getFilho("Resultado").getFilho("ValorDeReferencia");
            ElementoHPardini unidadeMedida = elemento.getFilho("Resultado").getFilho("UnidadeDeMedida");
            if (null != conteudo) {
                String valorConteudo = conteudo.contemFilho("Valor") ? StringUtil.xmlToTexto(conteudo.getFilho("Valor").getValor()) : "";
                dados.put(inicioCampo + nome + fimCampo, valorConteudo);
            }
            if (null != valorRef) {
                String valorValorRef = valorRef.contemFilho("Valor") ? StringUtil.xmlToTexto(valorRef.getFilho("Valor").getValor()) : "";
                dados.put(inicioCampo + "valorReferencia" + "_" + nome + fimCampo, valorValorRef);
            }
            if (null != unidadeMedida && !Funcoes.textoVazio(unidadeMedida.getValor())) {
                String valorUnMedida = unidadeMedida.getValor();
                dados.put(inicioCampo + "unidadeMedida" + "_" + nome + fimCampo, valorUnMedida);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (null != reg) {
            Statement st;
            block4: {
                block5: {
                    boolean bl;
                    String fil = reg.getString("fil_codigo");
                    String exa = reg.getString("exa_codigo");
                    String mco = reg.getString("mco_codigo");
                    StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
                    sql.append(" where fil_codigo = ").append(fil);
                    sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
                    sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
                    st = Conexao.getStatement();
                    ResultSet rs = st.executeQuery(sql.toString());
                    try {
                        if (!rs.next()) break block4;
                        if (rs.getInt("lae_codigo") != this.codigoLabExterno) break block5;
                        String xml = rs.getString("ele_xmllabexterno");
                        reg.setValor("ele_xmllabexterno", xml);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                    return bl;
                }
                boolean bl = false;
                Conexao.fecharStatement(st);
                return bl;
            }
            Conexao.fecharStatement(st);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarNotificacoes(HashMap<String, String> hashMapFilialRequisicao) throws Exception {
        if (!hashMapFilialRequisicao.isEmpty() && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica)) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            String filial = "";
            String requisicao = "";
            try {
                for (Map.Entry<String, String> filReq : hashMapFilialRequisicao.entrySet()) {
                    String[] filialRequisicao = filReq.getKey().split("-");
                    if (filialRequisicao.length > 1) {
                        filial = filialRequisicao[0];
                    }
                    requisicao = filReq.getValue();
                    if (Funcoes.textoVazio(filial) || Funcoes.textoVazio(requisicao)) continue;
                    if (!SMSUtil.isBloquearSMSExamePronto(filial, requisicao, st)) {
                        SMSUtil.criaLogSmsComDadosRequisicao(filial, requisicao, ExportaSMS.TipoSMS.RESULTADO, st, st2);
                    }
                    if (!EmailUtil.isBloquearEmailExamePronto(filial, requisicao, st)) {
                        EmailUtil.criaLogEmail(filial, requisicao, null, EmailUtil.TipoEmail.RESULTADO, true, st);
                    }
                    if (!PushUtil.isBloquearPushExamePronto(filial, requisicao, st)) {
                        PushUtil.criaLogPushComDadosRequisicao(filial, requisicao, TipoPush.RESULTADO, st, st2);
                    }
                    if (WhatsAppUtil.isBloquearWhatsappExamePronto(filial, requisicao, st)) continue;
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(filial, requisicao, TipoWhatsapp.RESULTADO, st, st2);
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private boolean exameDesmembrado(Registro reg) {
        return !Funcoes.textoVazio(reg.getString("examePai")) && !reg.getString("examePai").equals(reg.getString("exa_codigo"));
    }

    private boolean importaEmPDF(Registro reg) {
        String nomeColuna = this.exameDesmembrado(reg) ? "xmllabexternopai" : "ele_xmllabexterno";
        return reg.getString(nomeColuna).contains("<formato_pdf>SIM</formato_pdf>") || reg.getString("lae_configuracao").contains("<importarResultadoPdf>true</importarResultadoPdf>");
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    private boolean resultadoImportadoEmPDF(Registro reg, ElementoHPardini examePardini) throws Exception {
        boolean conferido;
        boolean importouPDF = false;
        boolean bl = conferido = this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica);
        if (this.importaEmPDF(reg)) {
            if (this.exameDesmembrado(reg)) {
                byte[] resultadosDesmembrados = null;
                List<ConfiguracaoExameMercolabVO> desmembrados = this.service.getExamesDesmembradosPDF(reg);
                Base64 base64 = new Base64();
                int resultadosRecebidos = 0;
                for (ConfiguracaoExameMercolabVO desm2 : desmembrados) {
                    String resultadoPDFBase64 = this.service.importarResultadoPDFWebServiceEmBase64(this.labExterno, this.gerarXMLConsultaResultadosPDF(examePardini, desm2.getCodigoExame()));
                    if (!Funcoes.textoVazio(resultadoPDFBase64) && !resultadoPDFBase64.startsWith("Falha") && resultadoPDFBase64.contains("<PDF>")) {
                        String pdfBase64 = StringUtil.getValor(resultadoPDFBase64, "PDF");
                        byte[] resultadoEmBytes = Base64.decodeBase64((String)pdfBase64);
                        resultadosDesmembrados = ResultadosUtil.concatenarPdfs(resultadosDesmembrados, resultadoEmBytes, "Resultado");
                        ++resultadosRecebidos;
                        continue;
                    }
                    if (Funcoes.textoVazio(resultadoPDFBase64) || !resultadoPDFBase64.startsWith("Falha") && !resultadoPDFBase64.contains("<Erro>")) continue;
                    if (resultadoPDFBase64.contains("<Erro>")) {
                        String mensagemErro;
                        resultadoPDFBase64 = mensagemErro = StringUtil.getValor(resultadoPDFBase64, TAG_ERRO);
                    }
                    this.setTextoInformacoes(String.format("\nFalha na importa\u00e7\u00e3o do exame %s em PDF - motivo: %s", desm2.getCodigoExame(), resultadoPDFBase64), false);
                }
                if (resultadosRecebidos == desmembrados.size()) {
                    String resultadoDesmembradosBase64 = base64.encodeAsString(resultadosDesmembrados);
                    ConfiguracaoExameMercolabVO examePai = ConfiguracaoExameMercolabVO.fromRegistro(reg);
                    examePai.setCodigoExame(reg.getString("examePai"));
                    this.service.salvarResultadoPDF(examePai, resultadoDesmembradosBase64, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
                    this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", Funcoes.preencheZero(examePai.getCodigoFilial(), ParametrosGerais.getDigitosTuboFilial()), Funcoes.preencheZero(examePai.getCodigoRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()), examePai.getCodigoExame()), false);
                    this.adicionarAoModeloRelatorio(examePai.getCodigoFilial(), examePai.getCodigoRequisicao(), examePai.getCodigoExame(), examePai.getCodigoMaterial(), conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO);
                    desmembrados.forEach(desm -> this.desmembradosImportados.add((ConfiguracaoExameMercolabVO)desm));
                    importouPDF = true;
                }
            } else {
                ConfiguracaoExameMercolabVO exame = ConfiguracaoExameMercolabVO.fromRegistro(reg);
                String resultadoPDFBase64 = this.service.importarResultadoPDFWebServiceEmBase64(this.labExterno, this.gerarXMLConsultaResultadosPDF(examePardini, reg.getString("exa_codigo")));
                if (!Funcoes.textoVazio(resultadoPDFBase64) && !resultadoPDFBase64.startsWith("Falha") && resultadoPDFBase64.contains("<PDF>")) {
                    String pdfBase64 = StringUtil.getValor(resultadoPDFBase64, "PDF");
                    this.service.salvarResultadoPDF(exame, pdfBase64, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
                    this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", Funcoes.preencheZero(exame.getCodigoFilial(), ParametrosGerais.getDigitosTuboFilial()), Funcoes.preencheZero(exame.getCodigoRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()), exame.getCodigoExame()), false);
                    this.adicionarAoModeloRelatorio(exame.getCodigoFilial(), exame.getCodigoRequisicao(), exame.getCodigoExame(), exame.getCodigoMaterial(), conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO);
                    importouPDF = true;
                } else if (!Funcoes.textoVazio(resultadoPDFBase64) && (resultadoPDFBase64.startsWith("Falha") || resultadoPDFBase64.contains("<Erro>"))) {
                    if (resultadoPDFBase64.contains("<Erro>")) {
                        String mensagemErro;
                        resultadoPDFBase64 = mensagemErro = StringUtil.getValor(resultadoPDFBase64, TAG_ERRO);
                    }
                    this.setTextoInformacoes(String.format("\nFalha na importa\u00e7\u00e3o do exame %s em PDF - motivo: %s", exame.getCodigoExame(), resultadoPDFBase64), false);
                }
            }
        }
        return importouPDF;
    }

    private boolean filialExportaExames(Optional<FilialVOAux> filialVO) {
        if (filialVO.isPresent()) {
            return filialVO.get().isExportarexames();
        }
        return false;
    }

    private boolean exportarBaseWeb(Optional<FilialVOAux> filialVO) {
        if (filialVO.isPresent()) {
            return !Funcoes.textoVazio(filialVO.get().getTipoBase()) && filialVO.get().isWebStandAlone() == false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FilialVOAux getDadosExportacao(String codFilial) {
        FilialVOAux filialVO;
        Statement st;
        block4: {
            FilialVOAux filialVOAux;
            st = Conexao.getStatement();
            filialVO = new FilialVOAux();
            try {
                FilialService filService = new FilialService();
                filialVO = filService.getDadosExportacao(st, codFilial);
                if (!this.carregouVO(filialVO)) break block4;
                filialVOAux = filialVO;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return filialVOAux;
        }
        Conexao.fecharStatement(st);
        return filialVO;
    }

    private String adicionarVersaoAoFormato(String numeroVersaoRecebida, String xml) {
        int posInicial = xml.indexOf("<versaoExameLabExterno>");
        int posFinal = xml.indexOf("</versaoExameLabExterno>");
        StringBuilder buf = new StringBuilder(xml);
        buf.delete(posInicial, posFinal + "</versaoExameLabExterno>".length());
        buf.insert(posInicial, "<versaoExameLabExterno>" + numeroVersaoRecebida + "</versaoExameLabExterno>");
        return buf.toString();
    }

    private boolean mesmaVersaoEstrutura(ElementoHPardini superExame, Registro reg) throws ParserResultadoHPardiniException {
        boolean mesmaEstrutura = false;
        ExameMercolabDTO exameMercolabDTO = this.service.getXmlExameLabExterno(reg.getString("fil_codigo"), superExame.getFilho("CodExmApoio").getValor(), this.labExterno.codigoLab);
        if (!Funcoes.textoVazio(exameMercolabDTO.getCodigoExame()) && exameMercolabDTO.getCodigoExame().equals(superExame.getFilho("CodExmApoio").getValor())) {
            String materialResultado = superExame.getFilho("MaterialNome").getValor().split("\\|")[1].replace("\n", " ");
            for (MaterialMercolabDTO materialMercolab : exameMercolabDTO.getMaterialMercolab()) {
                String material = materialMercolab.getDescricaoMaterial().replace("\n", " ");
                if (!(material = StringUtil.limpaXmlEnvioWebService(material)).equals(materialResultado)) continue;
                String formatoResultado = superExame.getFilho("CodigoFormato").getValor();
                Optional<FormatosMercolabDTO> formatoOpt = materialMercolab.getFormatosMercolab().stream().filter(formato -> formato.getCodigoFormato().equals(formatoResultado)).findAny();
                int qtdeCampos = -1;
                if (!formatoOpt.isPresent()) continue;
                qtdeCampos = formatoOpt.get().getCamposExameMercolab().stream().filter(c -> c.getObrigatorio().equals("SIM")).collect(Collectors.toList()).size();
                List<ElementoHPardini> itensDeExameNoResultado = superExame.getFilhos(ELEMENTO_ITEMEXAME);
                block1: for (ElementoHPardini itemExame : itensDeExameNoResultado) {
                    String nome = itemExame.getFilho("Nome").getValor();
                    String idItem = itemExame.getValorAtributo("idItemDeExame");
                    List<CamposExameMercolabDTO> camposExame = formatoOpt.get().getCamposExameMercolab();
                    for (CamposExameMercolabDTO campo : camposExame) {
                        if (!nome.equals(campo.getNomeCampo()) || !idItem.equals(campo.getIdCampo()) || !campo.getObrigatorio().equals("SIM")) continue;
                        --qtdeCampos;
                        continue block1;
                    }
                }
                if (qtdeCampos != 0) continue;
                mesmaEstrutura = true;
                break;
            }
        }
        return mesmaEstrutura;
    }

    private static boolean verificaCDDATA(String campo, String valor, String xml) {
        String abre = "<" + campo + ">";
        String fecha = "</" + campo + ">";
        if (valor.toLowerCase().indexOf(abre) >= 0) {
            xml = xml + valor.substring(0, valor.toLowerCase().indexOf(abre) + abre.length()) + "<![CDATA[" + valor.substring(valor.toLowerCase().indexOf(abre) + abre.length(), valor.toLowerCase().indexOf(fecha)) + "]]>" + valor.substring(valor.toLowerCase().indexOf(fecha)) + "\n";
            return true;
        }
        return false;
    }

    private int validaSituacaoVersaoIncorreta(Registro formatacao, ElementoHPardini superExame, Registro reg) throws Exception {
        boolean mesmaVersao = false;
        String codExame = reg.getString("exa_codigo");
        String codExamePai = reg.getString("examePai");
        if (Funcoes.textoVazio(formatacao.getString(FORMATO))) {
            return 2;
        }
        if (codExame.equals(codExamePai)) {
            mesmaVersao = this.mesmaVersao(formatacao.getString(FORMATO), superExame);
        } else {
            String formatoDesm;
            String xmlExameDesm = reg.getString("ele_xmllabexterno");
            List<String> versoesExameDesm = StringUtil.getListValores(xmlExameDesm, "codigoFormato");
            String string = formatoDesm = superExame.contemFilho("CodigoFormato") ? superExame.getFilho("CodigoFormato").getValor() : "";
            if (!Funcoes.textoVazio(formatoDesm)) {
                mesmaVersao = versoesExameDesm.contains(formatoDesm);
            }
        }
        boolean mesmaVersaoEstrutura = false;
        if (mesmaVersao) {
            mesmaVersaoEstrutura = this.mesmaVersaoEstrutura(superExame, reg);
        }
        if (!mesmaVersao) {
            return 1;
        }
        if (!mesmaVersaoEstrutura) {
            return 3;
        }
        return 0;
    }

    private String getVersaoExameElementoPardini(ElementoHPardini superExame) {
        return superExame.contemFilho("CodigoFormato") ? superExame.getFilho("CodigoFormato").getValor() : "";
    }

    private void alterarFormatoLayout(Registro reg, String formato) throws Exception {
        ExameLayoutMetodoService service = new ExameLayoutMetodoService();
        FilialVO filial = new FilialVO();
        filial.setCodigo(reg.getInt("fil_codigo"));
        ExameVO exame = new ExameVO();
        exame.setFilial(filial);
        exame.setCodigo(reg.getString("exa_codigo"));
        MaterialColetaVO material = new MaterialColetaVO();
        material.setFilial(filial);
        material.setCodigo(reg.getInt("mco_codigo"));
        LayoutVO layout = new LayoutVO();
        layout.setFilial(filial);
        layout.setCodigo(reg.getInt("lay_codigo"));
        MetodologiaVO metodo = new MetodologiaVO();
        metodo.setFilial(filial);
        metodo.setCodigo(reg.getInt("met_codigo"));
        ExameLayoutMetodoBean bean = new ExameLayoutMetodoBean();
        bean.setFilial(filial);
        bean.setExame(exame);
        bean.setMatColeta(material);
        bean.setLayout(layout);
        bean.setMetodologia(metodo);
        bean.setIdadeFim(reg.getInt("ela_idadefim"));
        bean.setIdadeInicial(reg.getInt("ela_idadeini"));
        bean.setIdadeFimTipo(reg.getString("ela_idadefimtipo"));
        bean.setIdadeInicioTipo(reg.getString("ela_idadeinitipo"));
        bean.setFormato(formato);
        service.update(bean, null, Variaveis.filialPadrao, ParametrosGerais.getCopiaExame());
    }

    private boolean mesmaVersao(String formato, ElementoHPardini superExame) {
        String versao = this.getVersaoExameLabExternoLocal(formato);
        return superExame.contemFilho("CodigoFormato") && versao.contains(superExame.getFilho("CodigoFormato").getValor()) || versao.equals("0");
    }

    private String getVersaoExameLabExternoLocal(String formato) {
        return StringUtil.getValor(StringUtil.getValor(formato, "exame"), "versaoExameLabExterno");
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini (1506)");
        }
    }

    private void atualizarPaginaOrdemExameWeb(Statement st, Registro dados) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, dados.getString("fil_codigo"), dados.getString("req_codigo"), Variaveis.codigoBaseWeb);
    }

    private boolean existePai(ExameDesmembrado pai) {
        return pai != null;
    }

    private void adicionarAoModeloRelatorio(String filial, String req, String codExame, String codMaterial, AbstractImportadorResultadoLabExterno.Situacao situacao) {
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, req, codExame, Integer.parseInt(codMaterial), situacao.descricao);
    }

    private LinkedList<Registro> processarPaiFilhos(Statement st, ElementoHPardini exResultado, String fil_codigo, Integer[] multiguias, String codigoPedidoApoio) throws Exception {
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        String exameJalis = exResultado.getFilho("CodExmLab").getValor();
        String materialJalis = exResultado.getFilho("MaterialNome").getValor().split("\\|")[0];
        if (!Funcoes.isNumeric(materialJalis)) {
            return retorno;
        }
        for (Integer multiguia : multiguias) {
            Registro reg;
            ExameDesmembrado pai;
            boolean isExameLabExterno = LoteExternoExameRequisicaoService.validaExameLabExterno(Variaveis.filialPadrao, multiguia.toString(), exameJalis, materialJalis, fil_codigo, st);
            if (isExameLabExterno) {
                String codigoJalis = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                Registro exameSeparado = this.service.localizarExameRequisicao(fil_codigo, multiguia.toString(), exameJalis, materialJalis, this.labExterno.codigoLab);
                if (exameSeparado.possuiCampo("req_codigo")) {
                    exameSeparado.setValor("leq_codigoreqapoio", codigoPedidoApoio);
                    retorno.add(exameSeparado);
                }
            }
            if (!this.existePai(pai = this.service.getExameDesmembrado(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exameJalis, materialJalis))) continue;
            boolean isExameLabExternoDesm = LoteExternoExameRequisicaoService.validaExameLabExterno(Variaveis.filialPadrao, multiguia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()), fil_codigo, st);
            if (!isExameLabExternoDesm || !(reg = this.service.localizarExameRequisicao(fil_codigo, multiguia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()), this.labExterno.codigoLab)).possuiCampo("req_codigo")) continue;
            reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
            reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
            reg.setValor("xmllabexternopai", pai.getXmlLabExterno());
            reg.setValor("examePai", pai.getCodigoExame());
            reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
            reg.setValor("leq_codigoreqapoio", codigoPedidoApoio);
            retorno.add(reg);
        }
        return retorno;
    }

    private boolean exameEMaterialValido(ElementoHPardini exResultado) {
        return exResultado.contemFilho("CodExmLab") && exResultado.contemFilho("MaterialNome") && !Funcoes.textoVazio(exResultado.getFilho("CodExmLab").getValor()) && !Funcoes.textoVazio(exResultado.getFilho("MaterialNome").getValor()) && exResultado.getFilho("MaterialNome").getValor().contains("|");
    }

    private String gerarXMLConsultaResultadosPorPeriodo() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dataInicial = sdf.format(this.periodoImportacao.getDataInicial());
        String dataFinal = sdf.format(this.periodoImportacao.getDataFinal());
        String horaInicial = this.periodoImportacao.getHoraInicial() + ":00";
        String horaFinal = this.periodoImportacao.getHoraFinal() + ":59";
        XMLStringBuilder xmlConsulta = new XMLStringBuilder(true);
        xmlConsulta.abrir(TAG_CONSULTA);
        xmlConsulta.escrever(TAG_PROTOCOLO, "1");
        xmlConsulta.escrever(TAG_ID, "");
        xmlConsulta.abrir(TAG_SOLICITA_RESULTADO);
        xmlConsulta.escrever(TAG_COD_LAB, "");
        xmlConsulta.escrever(TAG_OPERACAO, "Resultados");
        xmlConsulta.escrever(TAG_ACAO, "Download");
        xmlConsulta.escrever(TAG_DATA_INICIAL, dataInicial);
        xmlConsulta.escrever(TAG_HORA_INICIAL, horaInicial);
        xmlConsulta.escrever(TAG_DATA_FINAL, dataFinal);
        xmlConsulta.escrever(TAG_HORA_FINAL, horaFinal);
        xmlConsulta.escrever(TAG_GRAFICO, "1");
        xmlConsulta.escrever(TAG_UNIDADE_VALOR, "0");
        xmlConsulta.escrever(TAG_DADOS_CONSTANTES, "1");
        try {
            xmlConsulta.fechar(TAG_SOLICITA_RESULTADO);
            xmlConsulta.fechar(TAG_CONSULTA);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder xml = new StringBuilder();
        String configuracaoLabExterno = this.labExterno.configuracao;
        String login = StringUtil.getValor(configuracaoLabExterno, "idLaboratorio");
        String passwd = StringUtil.getValor(configuracaoLabExterno, "senha");
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:asc=\"https://ascherer.com.br/\">");
        xml.append("<soapenv:Header/>");
        xml.append("<soapenv:Body>");
        xml.append("<asc:getResultado>");
        xml.append("<asc:login>").append(login).append("</asc:login>");
        xml.append("<asc:passwd>").append(passwd).append("</asc:passwd>");
        xml.append("<asc:XML><![CDATA[");
        xml.append(xmlConsulta.toString().replace(System.lineSeparator(), ""));
        xml.append("]]></asc:XML>");
        xml.append("</asc:getResultado>");
        xml.append("</soapenv:Body>");
        xml.append("</soapenv:Envelope>");
        return xml.toString();
    }

    private String gerarXMLConsultaResultadosPDF(ElementoHPardini examePardini, String codExameJalis) {
        String codPedLab = examePardini.getPai().getFilho("CodPedLab").getValor();
        String anoPedido = new SimpleDateFormat("yyyy").format(this.periodoImportacao.getDataFinal());
        String idLaboratorio = StringUtil.getValor(this.labExterno.configuracao, "idLaboratorio");
        String senhaWebservice = StringUtil.getValor(this.labExterno.configuracao, "senha");
        StringBuilder xml = new StringBuilder();
        xml.append("<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:asc=\"https://ascherer.com.br/\">");
        xml.append("<soapenv:Header/>");
        xml.append("<soapenv:Body>");
        xml.append("<asc:getResultadoPedido>");
        xml.append("<asc:login>").append(idLaboratorio).append("</asc:login>");
        xml.append("<asc:passwd>").append(senhaWebservice).append("</asc:passwd>");
        xml.append("<asc:anoCodPedApoio>").append(anoPedido).append("</asc:anoCodPedApoio>");
        xml.append("<asc:CodPedApoio>").append(codPedLab).append("</asc:CodPedApoio>");
        xml.append("<asc:CodExmApoio>").append(codExameJalis).append("</asc:CodExmApoio>");
        xml.append("<asc:PDF>2</asc:PDF>");
        xml.append("</asc:getResultadoPedido>");
        xml.append("</soapenv:Body>");
        xml.append("</soapenv:Envelope>");
        return xml.toString();
    }
}

