/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.mercolabws.ExameImportacaoMercolabWSDTO;
import jalis.laboratorio.util.parsers.mercolabws.ParserImportacaoMercolabWS;
import jalis.laboratorio.util.parsers.mercolabws.dto.DadosAdicionaisMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.ExameMercolabDTO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportacaoMercolabWS
extends AbstractImportadorLabExterno {
    private static final String TITULO = "Importa\u00e7\u00e3o de Exames";
    private static final String DESCRICAO = "Importa\u00e7\u00e3o de exames do Lab. Mercolab.";
    private static final String COL_COD_EXAME_UNIMED = "C\u00f3d. Exame Unimed";
    private static final String COL_NOME_EXAME = "Nome Exame";
    private static final String COL_METODO = "M\u00e9todo";
    private static final String COL_MATERIAL = "Material";
    private static final String COL_VERSAO_MASCARA = "Vers\u00e3o da M\u00e1scara";
    private static final String COL_NOME_MASCARA = "Nome da M\u00e1scara";
    private static final String COL_CODIGO_CAMPO = "C\u00f3digo do Campo";
    private static final String COL_ID_CAMPO = "ID do Campo";
    private static final String COL_NOME_CAMPO = "Nome do Campo";
    private static final String COL_UNIDADE_MEDIDA = "Unidade de Medida";
    private static final String COL_SEQUENCIA = "Sequ\u00eancia";
    private static final String COL_OBRIGATORIO = "Obrigat\u00f3rio";
    private static final String COL_TIPO_CAMPO = "Tipo de Campo";
    private static final String COL_MINIMO_VALIDO = "M\u00ednimo V\u00e1lido";
    private static final String COL_MAXIMO_VALIDO = "M\u00e1ximo V\u00e1lido";
    private static final String COL_MINIMO_CRITICO = "M\u00ednimo Cr\u00edtico";
    private static final String COL_MAXIMO_CRITICO = "M\u00e1ximo Cr\u00edtico";
    private static final String COL_VALOR_REFERENCIA = "Valor de Refer\u00eancia";
    private static final String COL_INFORMACOES = "CodigoPerguntaQuestionario";
    private static final String COL_RESPOSTAS = "RespostaQuestionario";
    private static final long ACESSO_TELA = Long.valueOf("904000101");
    private int colCodExame = -1;
    private int colNomeExame = -1;
    private int colMetodo = -1;
    private int colMaterial = -1;
    private int colVersaoMascara = -1;
    private int colNomeMascara = -1;
    private int colCodCampo = -1;
    private int colIdCampo = -1;
    private int colNomeCampo = -1;
    private int colUnidadeMedida = -1;
    private int colSequencia = -1;
    private int colObrigatorio = -1;
    private int colTipoCampo = -1;
    private int colMinimoValido = -1;
    private int colMaximoValido = -1;
    private int colMinimoCritico = -1;
    private int colMaximoCritico = -1;
    private int colValorReferencia = -1;
    private int colCodExameInfo = -1;
    private int colInformacao = -1;
    private int colRespostas = -1;
    private int codigoLabExterno;
    private List<ExameMercolabDTO> examesAtualizados;
    private final ParserImportacaoMercolabWS parserImportacao;

    public ImportacaoMercolabWS(int codigoLabExterno) {
        super(TITULO, DESCRICAO, codigoLabExterno, Protocolo.MercolabWS);
        this.getButtonImportar().setText("Importar Exames");
        this.parserImportacao = new ParserImportacaoMercolabWS();
        this.codigoLabExterno = codigoLabExterno;
    }

    @Override
    protected boolean importarArquivo() {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLS do Lab. ".concat(this.protocolo.name()).concat(" (*.xls, *.xlsx)"), "xls", "xlsx"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = chooser.getSelectedFile();
                ArrayList<DadosAdicionaisMercolabDTO> dadosAdicionaisMercolabDTO = new ArrayList();
                List<ExameImportacaoMercolabWSDTO> examesMercolab = this.converterListaExamesXLSParaExameImportacaoMercolabWSDTO(new FileInputStream(file));
                if (examesMercolab.isEmpty()) {
                    return false;
                }
                dadosAdicionaisMercolabDTO = this.converterListaExamesXLSParaDadosAdicionaisMercolabWSDTO(new FileInputStream(file));
                this.setTextoInformacoes("Importando exames...\n");
                this.progress.setValue(0);
                this.progress.setVisible(true);
                List<ExameMercolabDTO> examesListaImportada = this.parserImportacao.importarExames(examesMercolab, dadosAdicionaisMercolabDTO, this.progress);
                Statement st = Conexao.getStatement();
                List<ExameMercolabDTO> examesAntigo = this.parserImportacao.loadExamesMercolab(st, this.codigoLabExterno);
                ArrayList<ExameMercolabDTO> examesRemovidos = new ArrayList<ExameMercolabDTO>();
                this.examesAtualizados = new ArrayList<ExameMercolabDTO>();
                if (!examesAntigo.isEmpty()) {
                    for (ExameMercolabDTO exameMercolabDTO : examesAntigo) {
                        if (examesListaImportada.stream().anyMatch(a -> a.getCodigoExame().contentEquals(exameMercolabDTO.getCodigoExame()) && this.comparaXmlExameMercolab(exameMercolabDTO, (ExameMercolabDTO)a))) {
                            IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, this.codigoLabExterno, 15, exameMercolabDTO.getCodigoExame());
                            continue;
                        }
                        ExameMercolabDTO exameremovido = new ExameMercolabDTO();
                        exameremovido.setCodigoExame(exameMercolabDTO.getCodigoExame());
                        exameremovido.setDescricaoExame(exameMercolabDTO.getDescricaoExame());
                        examesRemovidos.add(exameremovido);
                        IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, this.codigoLabExterno, 15, exameMercolabDTO.getCodigoExame());
                    }
                }
                this.progress.setMaximum(examesListaImportada.size());
                int contador = 1;
                for (ExameMercolabDTO exameMercolab : examesListaImportada) {
                    this.progress.setValue(contador++);
                    IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, this.codigoLabExterno, 15, exameMercolab.getCodigoExame(), exameMercolab.getDescricaoExame(), this.parserImportacao.getXmlExameMercolab(exameMercolab));
                }
                Thread.sleep(50L);
                StringBuilder stringBuilder = new StringBuilder();
                if (examesRemovidos != null && examesRemovidos.size() > 0) {
                    stringBuilder.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    stringBuilder.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    stringBuilder.append("\t|              CODIGO EXAME                        |               DESCRICAO EXAME                    |\n");
                    stringBuilder.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (ExameMercolabDTO e : examesRemovidos) {
                        stringBuilder.append("\n\t|").append(StringUtil.formatarColuna(e.getCodigoExame(), 50, 'c'));
                        stringBuilder.append("|").append(StringUtil.formatarColuna(e.getDescricaoExame(), 50, 'c')).append("|");
                    }
                    stringBuilder.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(stringBuilder.toString());
                }
                if (this.examesAtualizados != null && this.examesAtualizados.size() > 0) {
                    stringBuilder.delete(0, stringBuilder.length());
                    stringBuilder.append("\n\nOs seguintes exames abaixo foram atualizados: \n\n");
                    stringBuilder.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    stringBuilder.append("\t|              CODIGO EXAME                        |               DESCRICAO EXAME                    |\n");
                    stringBuilder.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (ExameMercolabDTO e : this.examesAtualizados) {
                        stringBuilder.append("\n\t|").append(StringUtil.formatarColuna(e.getCodigoExame(), 50, 'c'));
                        stringBuilder.append("|").append(StringUtil.formatarColuna(e.getDescricaoExame(), 50, 'c')).append("|");
                    }
                    stringBuilder.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(stringBuilder.toString(), false);
                }
                this.setTextoInformacoes("\nImporta\u00e7\u00e3o conclu\u00edda", false);
                this.progress.setVisible(false);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, String.format("N\u00e3o foi possivel importar arquivo - Lab. %s %s ", this.protocolo.name(), e.getMessage()), e.getStackTrace());
            return false;
        }
        return true;
    }

    private boolean comparaXmlExameMercolab(ExameMercolabDTO exameAntigo, ExameMercolabDTO exameNovo) {
        String xmlExameAntigo = "";
        if (exameAntigo.isExameAntigo()) {
            xmlExameAntigo = exameAntigo.getXmlExameAntigo().trim();
        }
        if (!this.parserImportacao.getXmlExameMercolab(exameNovo).trim().equalsIgnoreCase(xmlExameAntigo)) {
            this.examesAtualizados.add(exameNovo);
        }
        return true;
    }

    private List<ExameImportacaoMercolabWSDTO> converterListaExamesXLSParaExameImportacaoMercolabWSDTO(InputStream input) throws Exception {
        ArrayList<ExameImportacaoMercolabWSDTO> examesImportacao = new ArrayList<ExameImportacaoMercolabWSDTO>();
        XSSFWorkbook arquivoExcel = new XSSFWorkbook(input);
        int indicePlanilhaImportacao = this.getIndicePlanilhaImportacao(arquivoExcel);
        if (indicePlanilhaImportacao == -1) {
            Funcoes.mensagem(this, "Planilha 'DE...PARA... CAMPOS' n\u00e3o encontrada no arquivo.\nImporta\u00e7\u00e3o n\u00e3o realizada", 2);
            return examesImportacao;
        }
        XSSFSheet planilha = arquivoExcel.getSheetAt(indicePlanilhaImportacao);
        for (int numLinha = 0; numLinha <= planilha.getLastRowNum(); ++numLinha) {
            XSSFRow linha = planilha.getRow(numLinha);
            Iterator colunas = linha.cellIterator();
            if (numLinha == 0) {
                this.definirPosicaoColunas(colunas);
                continue;
            }
            if (numLinha == 1 && !this.colunasPosicionadas()) {
                Funcoes.mensagem(this, "Colunas n\u00e3o conferem com o padr\u00e3o da lista de exames.\nImporta\u00e7\u00e3o n\u00e3o realizada", 2);
                return examesImportacao;
            }
            ExameImportacaoMercolabWSDTO exameImp = this.converterLinhaPlanilhaParaExameImportacaoMercolabWSDTO(colunas);
            examesImportacao.add(exameImp);
        }
        return examesImportacao;
    }

    private List<DadosAdicionaisMercolabDTO> converterListaExamesXLSParaDadosAdicionaisMercolabWSDTO(InputStream input) throws IOException {
        ArrayList<DadosAdicionaisMercolabDTO> dadosAdicionaisMercolab = new ArrayList<DadosAdicionaisMercolabDTO>();
        XSSFWorkbook arquivoExcel = new XSSFWorkbook(input);
        int indicePlanilhaDadosAdicionais = this.getIndicePlanilhaDadosAdicionais(arquivoExcel);
        XSSFSheet planilhaDadosAdicionais = arquivoExcel.getSheetAt(indicePlanilhaDadosAdicionais);
        if (indicePlanilhaDadosAdicionais == -1) {
            Funcoes.mensagem(this, "Planilha 'INFORMACOES EXAMES' n\u00e3o encontrada no arquivo.\nImporta\u00e7\u00e3o n\u00e3o realizada", 2);
            return dadosAdicionaisMercolab;
        }
        for (int numLinha = 0; numLinha <= planilhaDadosAdicionais.getLastRowNum(); ++numLinha) {
            XSSFRow linha = planilhaDadosAdicionais.getRow(numLinha);
            Iterator colunas = linha.cellIterator();
            if (numLinha == 0) {
                this.definirPosicaoColunasDadosAdicionais(colunas);
                continue;
            }
            if (numLinha == 1 && !this.colunasDadosAdicionaisPosicionadas()) {
                Funcoes.mensagem(this, "Colunas n\u00e3o conferem com o padr\u00e3o da lista de exames.\nImporta\u00e7\u00e3o n\u00e3o realizada", 2);
                return dadosAdicionaisMercolab;
            }
            DadosAdicionaisMercolabDTO dadosAdicionais = this.converterLinhaPlanilhaParaDadosAdicionaisMercolabWSDTO(colunas);
            dadosAdicionaisMercolab.add(dadosAdicionais);
        }
        return dadosAdicionaisMercolab;
    }

    private ExameImportacaoMercolabWSDTO converterLinhaPlanilhaParaExameImportacaoMercolabWSDTO(Iterator<Cell> colunas) {
        ExameImportacaoMercolabWSDTO exameImp = new ExameImportacaoMercolabWSDTO();
        int posicaoColuna = 0;
        while (colunas.hasNext()) {
            Double d;
            Cell celula = colunas.next();
            if (posicaoColuna == this.colCodExame) {
                exameImp.setCodExameUnimed(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colNomeExame) {
                exameImp.setNomeExame(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colMetodo) {
                exameImp.setMetodo(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colMaterial) {
                exameImp.setMaterial(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colVersaoMascara) {
                d = new Double(celula.getNumericCellValue());
                exameImp.setVersaoMascara(d.intValue());
            } else if (posicaoColuna == this.colNomeMascara) {
                exameImp.setNomeMascara(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colCodCampo) {
                d = new Double(celula.getNumericCellValue());
                exameImp.setCodigoCampo(d.intValue());
            } else if (posicaoColuna == this.colIdCampo) {
                exameImp.setIdCampo(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colNomeCampo) {
                exameImp.setNomeCampo(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colUnidadeMedida) {
                exameImp.setUnidadeMedida(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colSequencia) {
                d = new Double(celula.getNumericCellValue());
                exameImp.setSequencia(d.intValue());
            } else if (posicaoColuna == this.colObrigatorio) {
                String obrigatorio = celula.getStringCellValue().trim();
                exameImp.setObrigatorio(obrigatorio);
            } else if (posicaoColuna == this.colTipoCampo) {
                exameImp.setTipoCampo(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colMinimoValido) {
                exameImp.setMinimoValido(celula.getNumericCellValue());
            } else if (posicaoColuna == this.colMaximoValido) {
                exameImp.setMaximoValido(celula.getNumericCellValue());
            } else if (posicaoColuna == this.colMinimoCritico) {
                exameImp.setMinimoCritico(celula.getNumericCellValue());
            } else if (posicaoColuna == this.colMaximoCritico) {
                exameImp.setMaximoCritico(celula.getNumericCellValue());
            } else if (posicaoColuna == this.colValorReferencia) {
                exameImp.setValorReferencia(celula.getStringCellValue().trim());
            }
            ++posicaoColuna;
        }
        return exameImp;
    }

    private DadosAdicionaisMercolabDTO converterLinhaPlanilhaParaDadosAdicionaisMercolabWSDTO(Iterator<Cell> colunas) {
        DadosAdicionaisMercolabDTO dadosAdicionais = new DadosAdicionaisMercolabDTO();
        int posicaoColuna = 0;
        while (colunas.hasNext()) {
            Cell celula = colunas.next();
            if (posicaoColuna == this.colCodExameInfo) {
                dadosAdicionais.setCodigoExame(celula.getStringCellValue().trim());
            } else if (posicaoColuna == this.colInformacao) {
                dadosAdicionais.setInformacao(celula.getStringCellValue());
            } else if (posicaoColuna == this.colRespostas) {
                dadosAdicionais.setRespostas(celula.getStringCellValue().trim());
            }
            ++posicaoColuna;
        }
        return dadosAdicionais;
    }

    private void definirPosicaoColunas(Iterator<Cell> colunas) {
        int posicaoColuna = 0;
        while (colunas.hasNext()) {
            Cell celula = colunas.next();
            String nomeColuna = celula.getStringCellValue();
            if (nomeColuna.equals(COL_COD_EXAME_UNIMED)) {
                this.colCodExame = posicaoColuna;
            } else if (nomeColuna.equals(COL_NOME_EXAME)) {
                this.colNomeExame = posicaoColuna;
            } else if (nomeColuna.equals(COL_METODO)) {
                this.colMetodo = posicaoColuna;
            } else if (nomeColuna.equals(COL_MATERIAL)) {
                this.colMaterial = posicaoColuna;
            } else if (nomeColuna.equals(COL_VERSAO_MASCARA)) {
                this.colVersaoMascara = posicaoColuna;
            } else if (nomeColuna.equals(COL_NOME_MASCARA)) {
                this.colNomeMascara = posicaoColuna;
            } else if (nomeColuna.equals(COL_CODIGO_CAMPO)) {
                this.colCodCampo = posicaoColuna;
            } else if (nomeColuna.equals(COL_ID_CAMPO)) {
                this.colIdCampo = posicaoColuna;
            } else if (nomeColuna.equals(COL_NOME_CAMPO)) {
                this.colNomeCampo = posicaoColuna;
            } else if (nomeColuna.equals(COL_UNIDADE_MEDIDA)) {
                this.colUnidadeMedida = posicaoColuna;
            } else if (nomeColuna.equals(COL_SEQUENCIA)) {
                this.colSequencia = posicaoColuna;
            } else if (nomeColuna.equals(COL_OBRIGATORIO)) {
                this.colObrigatorio = posicaoColuna;
            } else if (nomeColuna.equals(COL_TIPO_CAMPO)) {
                this.colTipoCampo = posicaoColuna;
            } else if (nomeColuna.equals(COL_MINIMO_VALIDO)) {
                this.colMinimoValido = posicaoColuna;
            } else if (nomeColuna.equals(COL_MAXIMO_VALIDO)) {
                this.colMaximoValido = posicaoColuna;
            } else if (nomeColuna.equals(COL_MINIMO_CRITICO)) {
                this.colMinimoCritico = posicaoColuna;
            } else if (nomeColuna.equals(COL_MAXIMO_CRITICO)) {
                this.colMaximoCritico = posicaoColuna;
            } else if (nomeColuna.equals(COL_VALOR_REFERENCIA)) {
                this.colValorReferencia = posicaoColuna;
            }
            ++posicaoColuna;
        }
    }

    private void definirPosicaoColunasDadosAdicionais(Iterator<Cell> colunas) {
        int posicaoColuna = 0;
        while (colunas.hasNext()) {
            Cell celula = colunas.next();
            String nomeColuna = celula.getStringCellValue();
            if (nomeColuna.contains(COL_COD_EXAME_UNIMED)) {
                this.colCodExameInfo = posicaoColuna;
            } else if (nomeColuna.contains(COL_INFORMACOES)) {
                this.colInformacao = posicaoColuna;
            } else if (nomeColuna.contains(COL_RESPOSTAS)) {
                this.colRespostas = posicaoColuna;
            }
            ++posicaoColuna;
        }
    }

    private boolean colunasPosicionadas() {
        return this.colCodExame > -1 && this.colNomeExame > -1 && this.colMaterial > -1 && this.colMetodo > -1 && this.colVersaoMascara > -1 && this.colNomeMascara > -1 && this.colIdCampo > -1 && this.colNomeCampo > -1 && this.colUnidadeMedida > -1 && this.colValorReferencia > -1;
    }

    private boolean colunasDadosAdicionaisPosicionadas() {
        return this.colCodExameInfo > -1 && this.colInformacao > -1 && this.colRespostas > -1;
    }

    private int getIndicePlanilhaImportacao(XSSFWorkbook arquivoExcel) {
        int quantPlanilhas = arquivoExcel.getNumberOfSheets();
        int indicePlanilhaImportacao = -1;
        for (int i = 0; i < quantPlanilhas; ++i) {
            XSSFSheet planilha = arquivoExcel.getSheetAt(i);
            if (!planilha.getSheetName().contains("DE...PARA... CAMPOS")) continue;
            indicePlanilhaImportacao = i;
            break;
        }
        return indicePlanilhaImportacao;
    }

    private int getIndicePlanilhaDadosAdicionais(XSSFWorkbook arquivoExcel) {
        int quantPlanilhas = arquivoExcel.getNumberOfSheets();
        int indicePlanilhaImportacao = -1;
        for (int i = 0; i < quantPlanilhas; ++i) {
            XSSFSheet planilha = arquivoExcel.getSheetAt(i);
            if (!planilha.getSheetName().contains("INFORMACOES EXAMES")) continue;
            indicePlanilhaImportacao = i;
            break;
        }
        return indicePlanilhaImportacao;
    }

    public static long getModuloAcesso() {
        return ACESSO_TELA;
    }
}

