/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.laboratorio.util.parsers.mercolabws.ParserImportacaoMercolabWS;
import jalis.laboratorio.util.parsers.mercolabws.dto.DadosAdicionaisMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.ExameMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.FormatosMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.MaterialMercolabDTO;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.tabela.Registro;
import java.util.ArrayList;
import java.util.List;

public class ExameMercolab {
    public static final String TAG_UTILIZAR_MAT_REQUISICAO = "utilizar-mat-requisicao";
    public static final String PESO = "Peso";
    public static final String ALTURA = "Altura";
    public static final String VOLUME_DIURESE = "VolumeDiurese";
    public static final String TEMPO_DIURESE = "TempoDiurese";
    public static final String PESO_AMOSTRA = "PesoAmostra";
    public static final String TEMPO_AMOSTRA = "TempoAmostra";
    public static final String LINFOCITOS_ABSOLUTO = "LinfocitosAbsoluto";
    public static final String INFO_COMP = "infoComp";
    public static final String HEMATOCRITO = "Hematocrito";
    public static final String GLICEMIA = "Glicemia";
    public static final String SEMANA_GESTACAO = "SemanaGestacao";
    public static final String SEXO_COLHEDOR = "SexoColhedor";
    public static final String DATA_SINTOMA = "DataSintoma";
    public static final String MUNICIPIO_RESIDENCIA = "MunicipioResidencia";
    public static final String APRESENTOU_SINTOMA = "Sintoma";
    public static final String SIM = "SIM";
    public static final String NAO = "NAO";
    private String exameJalis;
    private String codigoExame;
    private String descricaoExame;
    private String descricaoMaterial;
    private String metodo;
    private String nota;
    private String xmlExame;
    private MaterialMercolabDTO materialMercolab = new MaterialMercolabDTO();
    private List<FormatosMercolabDTO> formatos = new ArrayList<FormatosMercolabDTO>();
    private List<DadosAdicionaisMercolabDTO> dadosAdicionais = new ArrayList<DadosAdicionaisMercolabDTO>();
    private boolean formatoPdf = false;
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String DESC_MAT = "descricaoMaterial";
    private static final String OBJ_EXAME_MERCOLAB = "objExameMercolab";
    private final ParserImportacaoMercolabWS parserImportacao = new ParserImportacaoMercolabWS();

    public ExameMercolab novaInstancia(Registro registro, boolean formatoPDF) {
        ExameMercolab exameMercolab = new ExameMercolab();
        ExameMercolabDTO exameDto = (ExameMercolabDTO)registro.getValor(OBJ_EXAME_MERCOLAB);
        exameDto.setFormatoPDF(formatoPDF);
        exameMercolab.setFormatoPdf(formatoPDF);
        String materialSelecionado = (String)registro.getValor(DESC_MAT);
        MaterialMercolabDTO materialMercolab = exameDto.getMaterialSelecionado(exameDto.getMaterialMercolab(), materialSelecionado);
        exameMercolab.setDescricaoMaterial(materialSelecionado);
        exameMercolab.setCodigoExame(exameDto.getCodigoExame());
        exameMercolab.setDescricaoExame(exameDto.getDescricaoExame());
        exameMercolab.setMaterialMercolab(materialMercolab);
        if (materialMercolab != null) {
            exameMercolab.setMetodo(Funcoes.textoVazio(materialMercolab.getMetodo()) ? "" : materialMercolab.getMetodo());
            exameMercolab.setFormatos(materialMercolab.getFormatosMercolab());
        }
        exameMercolab.setDadosAdicionais(exameDto.getDadosAdicionaisMercolab());
        String xml = this.getXmlExameMercolab(exameMercolab);
        if (!Funcoes.textoVazio(xml)) {
            exameMercolab.setXmlExame(xml);
        }
        return exameMercolab;
    }

    public ExameMercolab novaInstancia(ExameMercolabDTO exameDto, String xmlExame) {
        ExameMercolab exameMercolab = new ExameMercolab();
        String materialSelecionado = StringUtil.getValor(xmlExame, DESC_MAT);
        MaterialMercolabDTO materialMercolab = exameDto.getMaterialSelecionado(exameDto.getMaterialMercolab(), materialSelecionado);
        exameMercolab.setDescricaoMaterial(materialSelecionado);
        exameMercolab.setCodigoExame(exameDto.getCodigoExame());
        exameMercolab.setDescricaoExame(exameDto.getDescricaoExame());
        exameMercolab.setMaterialMercolab(materialMercolab);
        if (materialMercolab != null) {
            exameMercolab.setMetodo(Funcoes.textoVazio(materialMercolab.getMetodo()) ? "" : materialMercolab.getMetodo());
            exameMercolab.setFormatos(materialMercolab.getFormatosMercolab());
        }
        exameMercolab.setDadosAdicionais(exameDto.getDadosAdicionaisMercolab());
        Boolean formatoPdf = StringUtil.getBoolean(xmlExame, "formato_pdf");
        exameMercolab.setFormatoPdf(formatoPdf);
        String xml = this.getXmlExameMercolab(exameMercolab);
        if (!Funcoes.textoVazio(xml)) {
            exameMercolab.setXmlExame(xml);
        }
        return exameMercolab;
    }

    public static ExameMercolab novaInstancia(String xml) {
        ExameMercolab exa = new ExameMercolab();
        exa.setCodigoExame(StringUtil.getValor(xml, COD_EXA));
        exa.setDescricaoExame(StringUtil.getValor(xml, DESC_EXA));
        exa.setDescricaoMaterial(StringUtil.getValor(xml, DESC_MAT));
        return exa;
    }

    public String getXmlExameMercolab(ExameMercolab exame) {
        StringBuilder retorno = new StringBuilder(this.parserImportacao.getXmlExame(exame));
        return retorno.toString();
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getDescricaoExame() {
        return this.descricaoExame;
    }

    public void setDescricaoExame(String descricaoExame) {
        this.descricaoExame = descricaoExame;
    }

    public String getDescricaoMaterial() {
        return this.descricaoMaterial;
    }

    public void setDescricaoMaterial(String descricaoMaterial) {
        this.descricaoMaterial = descricaoMaterial;
    }

    public String getMetodo() {
        return this.metodo;
    }

    public void setMetodo(String metodo) {
        this.metodo = metodo;
    }

    public String getNota() {
        return this.nota;
    }

    public void setNota(String nota) {
        this.nota = nota;
    }

    public List<FormatosMercolabDTO> getFormatos() {
        return this.formatos;
    }

    public void setFormatos(List<FormatosMercolabDTO> formatos) {
        this.formatos = formatos;
    }

    public List<DadosAdicionaisMercolabDTO> getDadosAdicionais() {
        return this.dadosAdicionais;
    }

    public void setDadosAdicionais(List<DadosAdicionaisMercolabDTO> dadosAdicionais) {
        this.dadosAdicionais = dadosAdicionais;
    }

    public boolean isFormatoPdf() {
        return this.formatoPdf;
    }

    public void setFormatoPdf(boolean formatoPdf) {
        this.formatoPdf = formatoPdf;
    }

    public MaterialMercolabDTO getMaterialMercolab() {
        return this.materialMercolab;
    }

    public void setMaterialMercolab(MaterialMercolabDTO materialMercolab) {
        this.materialMercolab = materialMercolab;
    }

    public String getXmlExame() {
        return this.xmlExame;
    }

    public void setXmlExame(String xmlExame) {
        this.xmlExame = xmlExame;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }
}

