/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.pardini.ConfiguradorException;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloMercolabWS
extends AbstractConfiguradorProtocolo {
    public static final String TITULO = "Laborat\u00f3rio Mercolab";
    public static final String TAG_MERCOLABWS = "mercolabws";
    public static final String TAG_LOTE = "lote";
    public static final String TAG_ID_LABORATORIO = "idLaboratorio";
    public static final String TAG_SENHA = "senha";
    public static final String TAG_WEB_SERVICE = "enderecoWebService";
    public static final String TAG_ENVIAR_LOTE_WEBSERVICE = "enviarLoteWebService";
    public static final String TAG_ENVIO_AUTOMATICO = "envioAutomatico";
    public static final String TAG_IMPORTAR_RESULTADO_PDF = "importarResultadoPdf";
    private JTextField textLote = new TTextField(100, 1);
    private JTextField textUsuario = new TTextField(100, 3);
    private JTextField textSenha = new TTextField(100, 3);
    private JTextField textWebServices = new TTextField(100, 3);
    private JCheckBox checkEnviarLoteWS = new JCheckBox("Enviar lote utilizando WebService");
    private JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    private JCheckBox checkImportarResultadoPDF = new JCheckBox("Importar resultados no formato PDF");

    private ConfiguradorProtocoloMercolabWS(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.construirTela();
    }

    private ConfiguradorProtocoloMercolabWS(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.construirTela();
    }

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        return pai instanceof Frame ? new ConfiguradorProtocoloMercolabWS((Frame)pai, TITULO, codigoLaboratorio) : new ConfiguradorProtocoloMercolabWS((Dialog)pai, TITULO, codigoLaboratorio);
    }

    private void construirTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        Dimension dimText = new Dimension(200, 20);
        Dimension dimLabel = new Dimension(85, 20);
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", dimLabel);
        lblLote.setMinimumSize(dimLabel);
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(dimText);
        this.textLote.setMinimumSize(dimText);
        this.textLote.setEnabled(false);
        this.getPanelCentral().add((Component)this.textLote, cons);
        cons.gridx = 0;
        cons.gridy = 3;
        JLabel lblAgente = ComponenteFactory.novoJLabel("Usu\u00e1rio:", dimLabel);
        lblAgente.setMinimumSize(dimLabel);
        this.getPanelCentral().add((Component)lblAgente, cons);
        cons.gridx = 1;
        this.textUsuario.setPreferredSize(dimText);
        this.textUsuario.setMinimumSize(dimText);
        this.getPanelCentral().add((Component)this.textUsuario, cons);
        this.textSenha.setHorizontalAlignment(4);
        cons.gridx = 0;
        cons.gridy = 4;
        JLabel lblSenha = ComponenteFactory.novoJLabel("Senha:", dimLabel);
        lblSenha.setMinimumSize(dimLabel);
        this.getPanelCentral().add((Component)lblSenha, cons);
        cons.gridx = 1;
        this.textSenha.setPreferredSize(dimText);
        this.textSenha.setMinimumSize(dimText);
        this.getPanelCentral().add((Component)this.textSenha, cons);
        cons.gridx = 0;
        cons.gridy = 5;
        JLabel lblService = ComponenteFactory.novoJLabel("Web Services:", dimLabel);
        lblSenha.setMinimumSize(dimLabel);
        this.getPanelCentral().add((Component)lblService, cons);
        cons.gridx = 1;
        this.textWebServices.setPreferredSize(dimText);
        this.textWebServices.setMinimumSize(dimText);
        this.getPanelCentral().add((Component)this.textWebServices, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridwidth = 2;
        this.checkEnviarLoteWS.setEnabled(false);
        this.getPanelCentral().add((Component)this.checkEnviarLoteWS, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridy = 8;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        cons.gridx = 0;
        cons.gridy = 8;
        cons.gridy = 9;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkImportarResultadoPDF, cons);
        this.pack();
        this.setSize(new Dimension(380, 280));
        this.setUsuarioPodeCancelar(false);
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textUsuario);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o.equals(this.buttonCancelar)) {
            this.dispose();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textUsuario.getText())) {
            Funcoes.mensagem(this, "Informe o usu\u00e1rio do laborat\u00f3rio para realizar a integra\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textUsuario);
            return false;
        }
        if (Funcoes.textoVazio(this.textSenha.getText())) {
            Funcoes.mensagem(this, "Informe a senha do laborat\u00f3rio para realizar a integra\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textSenha);
            return false;
        }
        if (Funcoes.textoVazio(this.textWebServices.getText())) {
            Funcoes.mensagem(this, "Informe o link de integra\u00e7\u00e3o.", 2);
            ScreenUtil.requisitarFoco(this.textWebServices);
            return false;
        }
        return true;
    }

    @Override
    public String getXML() {
        XMLStringBuilder xml = new XMLStringBuilder();
        xml.escrever(TAG_LOTE, this.textLote.getText());
        xml.escrever(TAG_ID_LABORATORIO, this.textUsuario.getText());
        xml.escrever(TAG_SENHA, this.textSenha.getText());
        xml.escrever(TAG_WEB_SERVICE, this.textWebServices.getText());
        xml.escrever(TAG_ENVIAR_LOTE_WEBSERVICE, this.checkEnviarLoteWS.isSelected() ? "true" : "false");
        xml.escrever(TAG_ENVIO_AUTOMATICO, this.checkEnvioAutomatico.isSelected() ? "true" : "false");
        xml.escrever(TAG_IMPORTAR_RESULTADO_PDF, this.checkImportarResultadoPDF.isSelected() ? "true" : "false");
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.getTag(TAG_MERCOLABWS, xml.getXML()));
        return buf.toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (!Funcoes.textoVazio(xml)) {
            xml = StringUtil.getValor(xml, TAG_MERCOLABWS);
            this.textLote.setText(StringUtil.getValor(xml, TAG_LOTE));
            this.textUsuario.setText(StringUtil.getValor(xml, TAG_ID_LABORATORIO));
            this.textSenha.setText(StringUtil.getValor(xml, TAG_SENHA));
            this.textWebServices.setText(StringUtil.getValor(xml, TAG_WEB_SERVICE));
            this.textWebServices.setText(StringUtil.getValor(xml, TAG_WEB_SERVICE));
            this.checkEnviarLoteWS.setSelected(true);
            String envioAutomatico = StringUtil.getValor(xml, TAG_ENVIO_AUTOMATICO);
            String importarResultadoEmPDF = StringUtil.getValor(xml, TAG_IMPORTAR_RESULTADO_PDF);
            this.checkEnvioAutomatico.setSelected(envioAutomatico.equalsIgnoreCase(Boolean.TRUE.toString()));
            this.checkImportarResultadoPDF.setSelected(importarResultadoEmPDF.equalsIgnoreCase(Boolean.TRUE.toString()));
        }
    }

    @Override
    public void setNumeroLote(int numeroLote) throws ConfiguradorException {
        this.textLote.setText(String.valueOf(numeroLote));
    }
}

