/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.mercolabws;

import jalis.comum.Conexao;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.mercolabws.ExameMercolab;
import jalis.laboratorio.util.parsers.mercolabws.ParserImportacaoMercolabWS;
import jalis.laboratorio.util.parsers.mercolabws.dto.DadosAdicionaisMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.ExameMercolabDTO;
import jalis.laboratorio.util.parsers.mercolabws.dto.MaterialMercolabDTO;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorMercolabWS
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String DESC_MAT = "descricaoMaterial";
    private static final String OBJ_EXAME_MERCOLAB = "objExameMercolab";
    private ModeloResultSet modExa = new ModeloResultSet("Mnem\u00f4nico", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "descricaoMaterial");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 95, 0, 210);
    private JTextField textLocalizar = new JTextField();
    private JPanel panelMaterial = new JPanel();
    private ModeloResultSet modDadosAdicionais = new ModeloResultSet("Dado Adicional", "dadoAdicional", "Sel", "selecionado");
    private JTable tableDadosAdicionais = ComponenteFactory.novoJTable((TableModel)this.modDadosAdicionais, null, 0, 40);
    private JScrollPane scrollDadosAdicionais = new JScrollPane(this.tableDadosAdicionais);
    private ModeloResultSet modLinhasResultados = new ModeloResultSet("C\u00f3digo", "codigo", "Descri\u00e7\u00e3o", "descricao", "Tempos", "tempos");
    private JTable tableLinhasResultados = ComponenteFactory.novoJTable((TableModel)this.modLinhasResultados, null, 75, 0, 150);
    private JScrollPane scrollLinhasResultados = new JScrollPane(this.tableLinhasResultados);
    private JCheckBox checkImportarResultadoPDF = new JCheckBox("Importar resultado no formato PDF");
    private String xmlSelecionado = "";
    private final ParserImportacaoMercolabWS parserImportacao = new ParserImportacaoMercolabWS();
    private final String codigoLabExterno;

    public ConfiguradorMercolabWS(Dialog pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.codigoLabExterno = codigoLabExterno;
        this.iniciar();
    }

    public ConfiguradorMercolabWS(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.codigoLabExterno = codigoLabExterno;
        this.iniciar();
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(750, 200));
        this.panelMaterial.setPreferredSize(new Dimension(650, 22));
        this.panelMaterial.setBorder(BorderFactory.createEmptyBorder(0, 2, 2, 2));
        this.scrollDadosAdicionais.setPreferredSize(new Dimension(650, 100));
        this.modDadosAdicionais.setColunaEditavel("selecionado");
        TableColumn col = this.tableDadosAdicionais.getColumnModel().getColumn(1);
        col.setMinWidth(30);
        col.setMaxWidth(30);
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Dados Adicionais", (Component)this.scrollDadosAdicionais, null, null, null, null), "Center");
        this.getPanelBotoesEsquerda().add(this.checkImportarResultadoPDF);
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private void carregarExames() {
        Statement st = Conexao.getStatement();
        try {
            for (ExameMercolabDTO exame : this.parserImportacao.loadExamesMercolab(st, Integer.parseInt(this.codigoLabExterno))) {
                for (MaterialMercolabDTO material : exame.getMaterialMercolab()) {
                    Registro reg = new Registro();
                    reg.setValor(COD_EXA, exame.getCodigoExame());
                    reg.setValor(DESC_EXA, exame.getDescricaoExame());
                    reg.setValor(DESC_MAT, material.getDescricaoMaterial());
                    reg.setValor(OBJ_EXAME_MERCOLAB, exame);
                    this.modExa.addRegistro(reg);
                }
            }
        }
        catch (NumberFormatException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public boolean acaoOk() {
        ExameMercolab exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorMercolabWS.this.modExa.filtrar(ConfiguradorMercolabWS.DESC_EXA, ConfiguradorMercolabWS.this.textLocalizar.getText());
                if (ConfiguradorMercolabWS.this.modExa.getRowCount() > 0) {
                    ConfiguradorMercolabWS.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            ExameMercolab exame = new ExameMercolab();
            exame = exame.novaInstancia(reg, this.checkImportarResultadoPDF.isSelected());
            this.atualizarDadosAdicionais(exame);
        }
    }

    private void atualizarDadosAdicionais(ExameMercolab exame) {
        this.modDadosAdicionais.limpar();
        if (exame.getDadosAdicionais().size() > 0) {
            for (DadosAdicionaisMercolabDTO dado : exame.getDadosAdicionais()) {
                Registro r = new Registro();
                r.setValor("dadoAdicional", dado.getInformacao());
                String xmlExame = StringUtil.getValor(this.xmlSelecionado, "exame");
                boolean semDado = true;
                for (String xmlDado : StringUtil.getValores(this.xmlSelecionado, "dadosAdicionais")) {
                    if (StringUtil.getValor(xmlExame, COD_EXA).equals(exame.getCodigoExame()) && StringUtil.getValor(xmlDado, "informacao").equals(dado.getInformacao()) && StringUtil.getValor(xmlExame, DESC_MAT).equalsIgnoreCase(exame.getDescricaoMaterial())) {
                        r.setValor("selecionado", Boolean.TRUE);
                        semDado = false;
                        break;
                    }
                    r.setValor("selecionado", Boolean.FALSE);
                }
                if (semDado) {
                    r.setValor("selecionado", Boolean.FALSE);
                }
                this.modDadosAdicionais.addRegistro(r);
            }
        }
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameMercolabDTO.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameMercolabDTO exa = ExameMercolabDTO.criaObjetoExame(xml);
            ExameMercolab exameMercolab = new ExameMercolab();
            exameMercolab = exameMercolab.novaInstancia(exa, xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exameMercolab.getCodigoExame().equals(reg.getValor(COD_EXA)) || !exameMercolab.getDescricaoMaterial().equals(reg.getValor(DESC_MAT))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                this.checkImportarResultadoPDF.setSelected(exameMercolab.isFormatoPdf());
                for (int j = 0; j < this.modDadosAdicionais.getRowCount(); ++j) {
                    Registro r = this.modDadosAdicionais.getRegistro(j);
                    for (DadosAdicionaisMercolabDTO dado : exa.getDadosAdicionaisMercolab()) {
                        if (!dado.getInformacao().equals(r.getValor("dadoAdicional"))) continue;
                        r.setValor("selecionado", Boolean.TRUE);
                    }
                }
                break;
            }
        }
    }

    private ExameMercolab getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            ExameMercolab exameMercolab = new ExameMercolab();
            exameMercolab = exameMercolab.novaInstancia(reg, this.checkImportarResultadoPDF.isSelected());
            return exameMercolab;
        }
        return null;
    }

    private String getRespostaDadoAdicional(List<DadosAdicionaisMercolabDTO> dadosExame, DadosAdicionaisMercolabDTO dadoAdicionalSelecionado) {
        String retorno;
        block0: {
            Iterator<DadosAdicionaisMercolabDTO> iterator;
            retorno = "";
            if ((dadosExame = dadosExame.stream().filter(a -> a.getInformacao().equalsIgnoreCase(dadoAdicionalSelecionado.getInformacao())).collect(Collectors.toList())).isEmpty() || !(iterator = dadosExame.iterator()).hasNext()) break block0;
            DadosAdicionaisMercolabDTO dadoAdicional = iterator.next();
            retorno = dadoAdicional.getRespostas();
        }
        return retorno;
    }

    private boolean atualizarXMLSelecionado() {
        ExameMercolab exa = this.getExameSelecionado();
        if (exa != null) {
            ArrayList<DadosAdicionaisMercolabDTO> dados = new ArrayList<DadosAdicionaisMercolabDTO>();
            for (int i = 0; i < this.modDadosAdicionais.getRowCount(); ++i) {
                Registro r = this.modDadosAdicionais.getRegistro(i);
                if (!r.contemValor("selecionado", Boolean.TRUE)) continue;
                DadosAdicionaisMercolabDTO dadoSelecionado = new DadosAdicionaisMercolabDTO();
                dadoSelecionado.setInformacao((String)r.getValor("dadoAdicional"));
                dadoSelecionado.setRespostas(this.getRespostaDadoAdicional(exa.getDadosAdicionais(), dadoSelecionado));
                dados.add(dadoSelecionado);
            }
            exa.setDadosAdicionais(dados);
            exa.setFormatoPdf(this.checkImportarResultadoPDF.isSelected());
            this.xmlSelecionado = exa.getXmlExameMercolab(exa);
            return true;
        }
        return false;
    }

    public static ConfiguradorMercolabWS novaInstancia(Object pai, String codigoLabExterno, String titulo) {
        if (pai instanceof Frame) {
            return new ConfiguradorMercolabWS((Frame)pai, codigoLabExterno, titulo);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorMercolabWS((Dialog)pai, codigoLabExterno, titulo);
        }
        return null;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(70);
        mod.getColumn(2).setMaxWidth(70);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorMercolabWS.this.tableExa.hasFocus() && (row = ConfiguradorMercolabWS.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorMercolabWS.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorMercolabWS.this.tableExa.scrollRectToVisible(ConfiguradorMercolabWS.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorMercolabWS.this.tableExa.hasFocus() && (row = ConfiguradorMercolabWS.this.tableExa.getSelectedRow()) < ConfiguradorMercolabWS.this.tableExa.getRowCount() - 1) {
                    ConfiguradorMercolabWS.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorMercolabWS.this.tableExa.scrollRectToVisible(ConfiguradorMercolabWS.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            return StringUtil.getValor(xml, DESC_EXA);
        }
        return "";
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameMercolabDTO exa = ExameMercolabDTO.criaObjetoExame(xml);
            return exa.getCodigoExame() + "|" + exa.getDescricaoExame() + "|";
        }
        return "";
    }
}

