/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.matrix;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.matrix.ExameMatrix;
import jalis.laboratorio.util.parsers.matrix.ImportacaoMatrix;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;

public class ParserImportacaoMatrix {
    private static final int TAG_DESCRICAO_EXAME = 0;
    private static final int TAG_CODIGO_EXAME = 1;
    private static final int TAG_MNEMONICO_EXAME = 2;
    private static final int TAG_CRIESP_CODIGO_EXAME = 0;
    private static final int TAG_CRIESP_DESCRICAO_EXAME = 1;

    public static Map<String, ExameMatrix> importarExamesMatrix(File bufCsv, int codigoLabExterno, JProgressBar progress, ImportacaoMatrix telaImportacao) {
        HashMap<String, ExameMatrix> examesNovos = new HashMap<String, ExameMatrix>();
        boolean arquivoResultado = false;
        String[] linhas = null;
        try {
            linhas = StringUtil.lerArquivoTexto(bufCsv).split("\n");
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(null, "N\u00e3o foi poss\u00edvel ler o arquivo", e1.getStackTrace());
            return null;
        }
        for (String s : linhas) {
            String[] exame = s.split(";");
            ExameMatrix em = (exame.length < 3 || !Funcoes.isNumeric(exame[1])) && Funcoes.isNumeric(exame[0]) ? new ExameMatrix(StringUtil.textoDB(exame[1]), exame[0], Integer.parseInt((String)exame[0])) : new ExameMatrix(StringUtil.textoDB(exame[0]), exame[2], Funcoes.isNumeric((String)exame[1]) ? Integer.parseInt((String)exame[1]) : 0);
            if (em.getCodigoExame() == 0) continue;
            if (examesNovos.containsKey(em.getMnemonicoExame())) {
                ExameMatrix emAnt = new ExameMatrix(((ExameMatrix)examesNovos.get(em.getMnemonicoExame())).getXml());
                if (emAnt.getCodigoExame() < em.getCodigoExame()) {
                    em.setMnemonicoExame(em.getMnemonicoExame().concat("2"));
                    examesNovos.put(em.getMnemonicoExame(), em);
                    continue;
                }
                examesNovos.remove(em.getMnemonicoExame());
                emAnt.setMnemonicoExame(em.getMnemonicoExame().concat("2"));
                examesNovos.put(em.getMnemonicoExame(), em);
                examesNovos.put(emAnt.getMnemonicoExame(), emAnt);
                continue;
            }
            examesNovos.put(em.getMnemonicoExame(), em);
        }
        HashMap<String, ExameMatrix> examesExcluidos = new HashMap<String, ExameMatrix>();
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                HashSet examesNovosRel;
                Map<String, ExameMatrix> examesAntigosRelac = ParserImportacaoMatrix.examesMap(ParserImportacaoMatrix.getExamesRelacionados(codigoLabExterno));
                Map<String, ExameMatrix> examesAntigos = ParserImportacaoMatrix.loadExamesMatrix(st, codigoLabExterno);
                if (arquivoResultado) {
                    for (Iterator<Object> exame : examesNovos.keySet()) {
                        ExameMatrix ex = (ExameMatrix)examesNovos.get(exame);
                        IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, ex.getMnemonicoExame(), ex.getCodigoExame());
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoMatrix.inserirExamesMatrix(examesNovos, st, codigoLabExterno, progress, examesAntigos);
                    examesNovosRel = new HashSet(examesNovos.values());
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (ExameMatrix ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        ExameMatrix exAntigo = examesAntigosRelac.get(ex.getCodigoExame().toString());
                        ex.setExameJalis(exAntigo.getExameJalis());
                        ex.setMaterialJalis(exAntigo.getMaterialJalis());
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), ex.getXml());
                    }
                } else {
                    IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, new Object[0]);
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoMatrix.inserirExamesMatrix(examesNovos, st, codigoLabExterno, progress, examesAntigos);
                    examesNovosRel = new HashSet(examesNovos.values());
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (Object ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        ExameMatrix exAntigo = examesAntigosRelac.get(((ExameMatrix)ex).getCodigoExame().toString());
                        ((ExameMatrix)ex).setExameJalis(exAntigo.getExameJalis());
                        ((ExameMatrix)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                        if (!exAntigo.getMaterial().equals(((ExameMatrix)ex).getMaterial())) {
                            ((ExameMatrix)ex).setMaterial(exAntigo.getMaterial());
                        }
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameMatrix)ex).getExameJalis(), Integer.parseInt(((ExameMatrix)ex).getMaterialJalis()), ((ExameMatrix)ex).getXml().replace("'", ""));
                    }
                    examesExcluidos.putAll(examesAntigos);
                    for (Object ex : examesNovos.keySet()) {
                        if (!examesExcluidos.containsKey(ex)) continue;
                        examesExcluidos.remove(ex);
                    }
                    HashSet<ExameMatrix> examesExcluidosRel = new HashSet<ExameMatrix>(examesAntigosRelac.values());
                    examesExcluidosRel.removeAll(examesNovos.values());
                    for (ExameMatrix ex : examesExcluidosRel) {
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), ex.getXml().replace("'", ""));
                    }
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return examesExcluidos;
    }

    private static Map<String, ExameMatrix> examesMap(Collection<ExameMatrix> exames) {
        HashMap<String, ExameMatrix> examesMap = new HashMap<String, ExameMatrix>();
        for (ExameMatrix ex : exames) {
            examesMap.put(ex.getCodigoExame().toString(), ex);
        }
        return examesMap;
    }

    private static Map<String, ExameMatrix> loadExamesMatrix(Statement st, int codigoLabExterno) throws SQLException {
        HashMap<String, ExameMatrix> exames = new HashMap<String, ExameMatrix>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select fil_codigo, lae_codigo, mar_codexame, mar_codexamenumerico, mar_descricaoexame, mar_xml");
        sql.append(" from examesMatrix ");
        sql.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append("  and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            exames.put(rs.getString("mar_codexame"), new ExameMatrix(rs.getString("mar_xml")));
            if (rs.getLong("mar_codexamenumerico") != 187L) continue;
            rs.getString("mar_xml");
        }
        return exames;
    }

    private static void inserirExamesMatrix(Map<String, ExameMatrix> exames, Statement st, int codigoLabExterno, JProgressBar progress, Map<String, ExameMatrix> examesAnt) throws SQLException, SalvaDadosException {
        for (String mnemonico : exames.keySet()) {
            ExameMatrix exame = exames.get(mnemonico);
            if (Funcoes.textoVazio(exame.getMaterial()) && examesAnt.size() > 0 && examesAnt.get(mnemonico) != null && !Funcoes.textoVazio(examesAnt.get(mnemonico).getMaterial())) {
                exame.setMaterial(examesAnt.get(mnemonico).getMaterial());
            }
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, exame.getMnemonicoExame(), exame.getCodigoExame(), StringUtil.textoDB(exame.getDescricaoExame()), exame.getXml().replace("'", ""));
        }
    }

    private static Set<ExameMatrix> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno);
                bui.append("  and a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameMatrix.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameMatrix>();
    }

    public static String calculcaDv(String linha) {
        int soma = 0;
        for (int i = 0; i < linha.length(); ++i) {
            soma += linha.charAt(i);
        }
        return Funcoes.preencheZero(Integer.toHexString(soma % 256), 2);
    }
}

