/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.matrix;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.matrix.CampoMatrix;
import jalis.laboratorio.util.parsers.matrix.Exame;
import jalis.laboratorio.util.parsers.matrix.ParserImportacaoMatrix;
import jalis.laboratorio.util.parsers.matrix.Requisicao;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;

public class ImportacaoResultadoMatrix
extends AbstractImportadorResultadoLabExterno {
    private static final int REGISTRO_PACIENTE = 11;
    private static final int REGISTRO_AMOSTRA = 20;
    private static final int REGISTRO_RESULTADO = 21;
    private static final int REGISTRO_FIM_LOTE = 22;
    private static final int REGISTRO_FLAG = 23;
    private static final int REGISTRO_REPETICOES = 24;
    private static final int REGISTRO_DADOS_GRAFICO = 25;
    private static final int REGISTRO_DADOS_GRAFICO_ADICIONAIS = 26;
    private static final int REGISTRO_NOME_END_ARQ_GRAFICO = 27;
    private ModeloGridTable modeloRelatorio;
    private JButton buttonImprimir;
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportacaoResultadoMatrix(int codigoLabExterno, Protocolo protocolo) {
        Statement st;
        block4: {
            super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Laborat\u00f3rio ".concat(protocolo.name()).concat(" a partir de arquivo XML"), codigoLabExterno, protocolo, new JPanel(new FlowLayout(2)));
            this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
            this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
            this.conferirAutomatico = false;
            this.codigoUsuarioConferenciaAutomatica = null;
            this.getPanelAdicional().add(this.buttonImprimir);
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block4;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoMatrix (97)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo do Lab. " + this.protocolo.name() + "(*.ENV)", "env"));
            chooser.setMultiSelectionEnabled(true);
            if (chooser.showOpenDialog(this) == 0) {
                String xmlLaboratorio = this.getConfiguracaoLaboratorio(this.codigoLabExterno);
                File[] files = chooser.getSelectedFiles();
                this.setTextoInformacoes("");
                this.anexarTextoInformacoes("Importando Resultados de exames...\n");
                for (File file : files) {
                    if (!file.getName().substring(0, 3).equals(StringUtil.getValor(xmlLaboratorio, "empresa"))) {
                        this.setTextoInformacoes("Arquivo selecionado n\u00e3o pertence ao laborat\u00f3rio para importa\u00e7\u00e3o");
                        return;
                    }
                    this.anexarTextoInformacoes("\nImportando Arquivo:" + file.getName());
                    List<Requisicao> requisicoes = this.loadDados(file);
                    StringBuilder bui = new StringBuilder();
                    this.importarResultados(Integer.valueOf(Variaveis.filialPadrao), requisicoes);
                    this.progress.setValue(0);
                    this.progress.setVisible(false);
                }
                this.anexarTextoInformacoes("\nImporta\u00e7\u00e3o conclu\u00edda");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private String getConfiguracaoLaboratorio(int codigoLabExterno) throws SQLException {
        Statement st = Conexao.getStatement();
        ResultSet rs = Conexao.executeQuery(st, "select lae_configuracao from labexterno  where" + " fil_codigo = " + Variaveis.filialPadrao + " and lae_codigo = " + codigoLabExterno);
        if (rs.next()) {
            return rs.getString("lae_configuracao");
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else {
            super.actionPerformed(e);
        }
    }

    private List<Requisicao> loadDados(File file) throws Exception {
        ArrayList<Requisicao> requisicoes = new ArrayList<Requisicao>();
        String[] buf = StringUtil.lerArquivoTexto(file).split("\n");
        int linhas = 0;
        Requisicao requisicao = new Requisicao();
        Exame exame = new Exame();
        block11: for (String linha : buf) {
            int registro = Integer.parseInt(linha.substring(0, 2));
            ++linhas;
            if (!this.validaLinha(linha).booleanValue()) continue;
            switch (registro) {
                case 11: {
                    requisicao = new Requisicao();
                    this.setPaciente(requisicao, linha);
                    requisicoes.add(requisicao);
                    continue block11;
                }
                case 20: {
                    this.setRequisicao(requisicao, linha);
                    exame = new Exame();
                    requisicao.addExame(exame);
                    continue block11;
                }
                case 21: {
                    String[] resultado = this.getLinhaResultado(linha);
                    this.obtemExameMatrix(requisicao, resultado[0], exame);
                    CampoMatrix campo = new CampoMatrix();
                    campo.setCodigo(resultado[1].trim());
                    if (Funcoes.isNumeric(resultado[2].trim())) {
                        campo.setResultado(resultado[2].trim().replace('.', ','));
                    } else {
                        campo.setResultado(resultado[2].trim().toString());
                    }
                    exame.addCampo(campo);
                    exame.setDataLiberacao(Funcoes.stringToDate("yyyyMMddhhmm", resultado[4] + resultado[5]));
                    exame.setDataResultado(Funcoes.stringToDate("yyyyMMddhhmm", resultado[6] + resultado[7]));
                    exame.setOperadorLiberou(resultado[8]);
                    continue block11;
                }
                case 22: {
                    continue block11;
                }
                case 23: {
                    continue block11;
                }
                case 24: {
                    continue block11;
                }
                case 25: {
                    continue block11;
                }
                case 26: {
                    continue block11;
                }
                case 27: {
                    continue block11;
                }
            }
        }
        return requisicoes;
    }

    private void obtemExameMatrix(Requisicao requisicao, String exame, Exame ex) throws SQLException {
        if (!Funcoes.textoVazio(ex.getExameJalis())) {
            return;
        }
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder("select a.lae_codigo, c.exa_codigo, c.mco_codigo, c.met_codigo, pegaResultadoExame(c.fil_codigo, c.req_codigo, c.exa_codigo, c.mco_codigo) as exr_resultado, ");
        bui.append(" a.mar_codexame, a.mar_codexamenumerico, a.mar_descricaoexame, a.mar_xml from examesmatrix a");
        bui.append(" join examematcoletalabexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo");
        bui.append(" join examerequisicao c on b.exa_codigo = c.exa_codigo and b.mco_codigo = b.mco_codigo and b.fil_codigo = c.fil_codigo");
        bui.append(" where a.fil_codigo = ").append(requisicao.getFilial());
        bui.append(" and a.lae_codigo = ").append(this.codigoLabExterno);
        bui.append(" and c.req_codigo = ").append(requisicao.getCodRequisicao());
        bui.append(" and a.mar_codexamenumerico = ").append(exame);
        bui.append(" and b.ele_xmllabexterno ilike '%<codigoExame>").append(Integer.parseInt(exame.trim())).append("</codigoExame>%'");
        ResultSet rs = Conexao.executeQuery(st, bui.toString());
        if (rs.next()) {
            ex.parseXml(rs.getString("mar_xml"));
            ex.setExameJalis(rs.getString("exa_codigo"));
            ex.setMaterialJalis(rs.getString("mco_codigo"));
        }
    }

    private void setRequisicao(Requisicao requisicao, String linha) {
        String[] filialRequisicao = Funcoes.getFilialRequisicao(linha.substring(2, 14).substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()));
        requisicao.setLaboratorio(linha.substring(40, 48));
        requisicao.setFilial(filialRequisicao[0]);
        requisicao.setCodrequisicao(filialRequisicao[1]);
        requisicao.setCodigoPaciente(linha.substring(54, 66));
        requisicao.setOrigem(linha.substring(66, 74));
        requisicao.setObservacao(linha.substring(96, 176));
    }

    private void setPaciente(Requisicao requisicao, String linha) {
        requisicao.setCodigoPaciente(linha.substring(2, 13));
        requisicao.setNomePaciente(linha.substring(14, 63));
    }

    private String[] getLinhaResultado(String linha) {
        String[] retorno = new String[]{linha.substring(2, 10), linha.substring(10, 18), linha.substring(18, 98), linha.substring(98, 215), linha.substring(216, 224), linha.substring(224, 228), linha.substring(228, 235), linha.substring(236, 240), linha.substring(240, 247)};
        return retorno;
    }

    private int fimLote(String linha) {
        return Integer.parseInt(linha.substring(2, 7));
    }

    private Boolean validaLinha(String linha) {
        String dv = linha.substring(linha.length() - 1, linha.length());
        if (dv.equalsIgnoreCase(ParserImportacaoMatrix.calculcaDv(linha.substring(0, linha.length() - 2)))) {
            return false;
        }
        return true;
    }

    private void importarResultados(int codigoFilial, List<Requisicao> requisicoes) throws Exception {
        this.progress.setValue(0);
        this.progress.setMaximum(requisicoes.size());
        this.progress.setVisible(true);
        if (requisicoes.isEmpty()) {
            this.setTextoInformacoes("\nNenhum resultado para importar", false);
            return;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        for (Requisicao requisicao : requisicoes) {
            this.progress.setValue(this.progress.getValue() + 1);
            this.getRequisicao(requisicao, this.codigoLabExterno);
            if (requisicao == null) {
                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Nenhuma requisi\u00e7\u00e3o para o c\u00f3digo do paciente: ".concat(requisicao.getCodigoPaciente()), false);
                continue;
            }
            if (!this.validaPaciente(requisicao)) {
                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Req.: " + requisicao.getCodRequisicao() + "| Pac.:" + requisicao.getCodigoPaciente() + "  " + Situacao.NAO_LOCALIZADO.descricao, false);
                continue;
            }
            for (Exame exame : requisicao.getExames()) {
                if (exame.isLancado()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, exame.isSalvaParcial() ? Situacao.NAO_LOCALIZADO : Situacao.JA_LANCADO);
                    continue;
                }
                if (!Funcoes.textoVazio(exame.getSituacao())) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.SEM_MATERIAL);
                    continue;
                }
                boolean salvoParcial = exame.getSituacao().equals("P");
                if (!salvoParcial) {
                    this.preencheFormatacao(requisicao, exame);
                }
                Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(requisicao.getFilial(), requisicao.getCodRequisicao(), requisicao.getCodigoPaciente(), exame.getExameJalis(), exame.getMaterialJalis(), String.valueOf(exame.getCodigoMetodo()));
                Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(exame.getExameJalis(), String.valueOf(requisicao.getFilial()));
                Map<String, Object> dados = exame.getResultados();
                dados.putAll(ExameUtil.getDadosExameRequisicao(requisicao.getCodRequisicao(), exame.getExameJalis(), exame.getMaterialJalis(), requisicao.getFilial(), false, false));
                if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                    historicos = ExameUtil.getHistoricos(null, String.valueOf(requisicao.getFilial()));
                }
                Resultado resultado = new Resultado(exame.getFormato(), dados, resAnterior, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"));
                resultado.atualizarComponentes();
                if (!resultado.verificarCondicao()) {
                    this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.CONDICAO_INSATISFEITA);
                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + requisicao.getCodRequisicao() + "|" + exame.getExameJalis() + " - " + Situacao.CONDICAO_INSATISFEITA.descricao, false);
                    continue;
                }
                boolean completo = true;
                if (exame.isSalvaParcial()) {
                    completo = resultado.resultadoCompleto(true);
                }
                String novaSituacao = completo ? "L" : "P";
                String resultadoValor = completo ? resultado.getResultado() : resultado.getResultadoParcial();
                Util.gravaAlteracaoExameRequisicao(st, requisicao.getFilial(), requisicao.getCodRequisicao(), exame.getExameJalis(), exame.getMaterialJalis());
                boolean marcarConferido = false;
                if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null) {
                    int verificacao = resultado.verificarValidacao();
                    boolean bl = marcarConferido = verificacao == 1;
                    if (!marcarConferido && verificacao != 2) {
                        this.adicionarAoModeloRelatorio(requisicao, exame, Situacao.VALIDACAO_INSATISFEITA);
                        this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + requisicao.getCodRequisicao() + "|" + exame.getExameJalis() + (!Funcoes.textoVazio(resultado.getMensagemValidacao()) ? " - " + resultado.getMensagemValidacao() : ""), false);
                    }
                }
                Registro dadosRequisicao = this.carregaDadosRequisicao(st, requisicao.getFilial(), requisicao.getCodRequisicao());
                Registro dadosExame = new Registro();
                dadosExame.setValor("exa_codigo", exame.getExameJalis());
                dadosExame.setValor("mco_codigo", exame.getMaterialJalis());
                Registro dadosAutorizacaoETiss = this.carregaDadosExameAutorizacaoETiss(st2, requisicao.getFilial(), requisicao.getCodRequisicao(), exame.getExameJalis(), exame.getMaterialJalis());
                dadosExame.setValor("exr_solicitadotiss", dadosAutorizacaoETiss.getValor("exr_solicitadotiss"));
                dadosExame.setValor("exr_codautorizacao", dadosAutorizacaoETiss.getValor("exr_codautorizacao"));
                boolean validacaoCompulsoria = resultado.verificarValidacaoCompulsoria() == 1;
                boolean validacaoResultadoCritico = resultado.verificarValidacaoResultadoCritico() == 1;
                this.salvarTabelaExameRequisicao(st, this, resultadoValor, novaSituacao, String.valueOf(exame.getCodigoMetodo()), dadosRequisicao, dadosExame, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                if (this.exportarBaseWeb(requisicao.getFilial())) {
                    String reqImagemWeb = IntegracaoUtil.formataCodigoRequisicao(requisicao.getFilial().toString(), requisicao.getCodRequisicao(), st);
                    Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st, requisicao.getFilial().toString(), requisicao.getCodRequisicao(), exame.getExameJalis(), exame.getMaterialJalis(), resultadoValor, false);
                    this.exportarParaWeb(st, ExportaWeb.getCodigoBaseWeb(st, requisicao.getFilial()), novaSituacao, dadosExame, mapa, resultadoValor, exame.getFormatoTexto());
                    if (ExportaWeb.isGerarPdfResultado(st, requisicao.getFilial())) {
                        ExportaWeb.enviarResultadoPDF(st, requisicao.getFilial(), requisicao.getCodRequisicao(), ExportaWeb.getCodigoBaseWeb(st, requisicao.getFilial()));
                    }
                }
                this.adicionarAoModeloRelatorio(requisicao, exame, marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO);
                Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? exame.getDataMaterial() : new Date();
                this.atualizarTabelaExamesControle(st, requisicao, exame, resultado.getResultadoAnterior(dataColeta, dataColeta));
                ExportaWeb.atualizaPaginaOrdemExameWeb(st, requisicao.getFilial(), requisicao.getCodRequisicao(), Variaveis.codigoBaseWeb);
                ExportaFiliais.gravaRequisicao(Integer.parseInt(requisicao.getFilial()), Integer.parseInt(requisicao.getCodRequisicao()), exame.getExameJalis(), Integer.parseInt(exame.getMaterialJalis()), "U", "U");
                DBUtil.setExameSituacaoInterfaceamento(st, requisicao.getFilial(), requisicao.getCodRequisicao(), exame.getExameJalis(), exame.getMaterialJalis(), 8);
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(requisicao.getFilial().toString(), requisicao.getCodRequisicao(), st2)) {
                    SMSUtil.criaLogSmsComDadosRequisicao(requisicao.getFilial().toString(), requisicao.getCodRequisicao(), ExportaSMS.TipoSMS.RESULTADO, st, st2);
                }
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(requisicao.getFilial().toString(), requisicao.getCodRequisicao(), st2)) {
                    EmailUtil.criaLogEmail(requisicao.getFilial().toString(), requisicao.getCodRequisicao(), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                }
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(requisicao.getFilial().toString(), requisicao.getCodRequisicao(), st2)) {
                    PushUtil.criaLogPushComDadosRequisicao(requisicao.getFilial().toString(), requisicao.getCodRequisicao(), TipoPush.RESULTADO, st, st2);
                }
                if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !WhatsAppUtil.isBloquearWhatsappExamePronto(requisicao.getFilial(), requisicao.getCodRequisicao(), st2)) {
                    WhatsAppUtil.criaLogWhatsappComDadosRequisicao(requisicao.getFilial(), requisicao.getCodRequisicao(), TipoWhatsapp.RESULTADO, st, st2);
                }
                this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(requisicao.getFilial(), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(requisicao.getCodRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + exame.getExameJalis() + " - " + (Object)((Object)(marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO)), false);
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
                Conexao.arquivaSQL();
            }
        }
    }

    private Registro carregaDadosRequisicao(Statement st, String filial, String codRequisicao) throws SQLException {
        StringBuilder sqlSelect = new StringBuilder("");
        sqlSelect.append(" select pac_codigo ");
        sqlSelect.append("       ,req_xmlagendamentoids as xmlAgendamentoIDS ");
        sqlSelect.append("       ,con_codigo ");
        sqlSelect.append("       ,req_integracaohospital, req_guia ");
        sqlSelect.append("   from requisicao ");
        sqlSelect.append("  where fil_codigo = ").append(filial);
        sqlSelect.append("    and req_codigo = ").append(codRequisicao);
        ResultSet rs = Conexao.executeQuery(st, sqlSelect.toString());
        if (rs.next()) {
            return Registro.novoRegistro(new Object[]{"fil_codigo", filial, "req_codigo", codRequisicao, "pac_codigo", rs.getString("pac_codigo"), "xmlAgendamentoIDS", rs.getString("xmlAgendamentoIDS"), "con_codigo", rs.getString("con_codigo"), "req_integracaohospital", rs.getString("req_integracaohospital"), "req_guia", rs.getString("req_guia")});
        }
        return null;
    }

    private Registro carregaDadosExameAutorizacaoETiss(Statement st, String filial, String codRequisicao, String material, String exame) throws SQLException {
        StringBuilder sqlSelect = new StringBuilder("");
        sqlSelect.append(" select exr_solicitadotiss ");
        sqlSelect.append("       ,exr_codautorizacao ");
        sqlSelect.append("   from examerequisicao ");
        sqlSelect.append("  where fil_codigo = ").append(filial);
        sqlSelect.append("    and req_codigo = ").append(codRequisicao);
        sqlSelect.append("    and exame_codigo = ").append(exame);
        sqlSelect.append("    and mco_codigo = ").append(material);
        ResultSet rs = Conexao.executeQuery(st, sqlSelect.toString());
        if (rs.next()) {
            return Registro.novoRegistro(new Object[]{"exr_solicitadotiss", rs.getString("exr_solicitadotiss"), "exr_codautorizacao", rs.getString("exr_codautorizacao")});
        }
        return null;
    }

    private void atualizarTabelaExamesControle(Statement st, Requisicao requisicao, Exame exame, String resultadoAnterior) throws SQLException {
        Registro reg = new Registro();
        reg.setValor("fil_codigo", requisicao.getFilial());
        reg.setValor("pac_codigo", requisicao.getCodigoPaciente());
        reg.setValor("exa_codigo", exame.getExameJalis());
        reg.setValor("mco_codigo", exame.getMaterialJalis());
        reg.setValor("req_codigo", requisicao.getCodRequisicao());
        reg.setValor("exc_resultado", resultadoAnterior);
        reg.setValor("exr_datamaterial", exame.getDataMaterial());
        super.atualizarTabelaExamesControle(st, reg, resultadoAnterior);
    }

    private void preencheFormatacao(Requisicao requisicao, Exame exame) {
        Statement st = Conexao.getStatement();
        if (st != null && exame.getCodigoLayout() != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  c.met_codigo, \n");
                bui.append("  b.lay_codigo, b.ela_idadeini, b.ela_idadefim, b.ela_idadeinitipo, b.ela_idadefimtipo, b.ela_padrao \n");
                bui.append("from examematcoleta a \n");
                bui.append("left join examelayout b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and a.mco_codigo = b.mco_codigo \n");
                bui.append("left join examematcoletalabexterno c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo and c.lae_codigo = ").append(this.codigoLabExterno);
                bui.append("where \n");
                bui.append("  a.fil_codigo = ").append(requisicao.getFilial()).append(" and \n");
                bui.append("  a.exa_codigo = '").append(exame.getExameJalis()).append("' and \n");
                bui.append("  a.mco_codigo = ").append(exame.getMaterialJalis()).append(" and \n");
                bui.append("  c.lae_codigo = ").append(this.codigoLabExterno);
                ResultSet rs = Conexao.executeQuery(st, bui.toString());
                int linha = 0;
                while (rs.next()) {
                    boolean idadeZero;
                    boolean padrao = rs.getBoolean("ela_padrao");
                    boolean interValido = exame.getCodigoLayout().intValue() == rs.getInt("lay_codigo") && ExameUtil.intervaloValido(rs.getInt("ela_idadeini"), rs.getInt("ela_idadefim"), rs.getString("ela_idadeinitipo"), rs.getString("ela_idadefimtipo"), requisicao.getTipoIdade(), requisicao.getIdade());
                    boolean bl = idadeZero = exame.getCodigoLayout().intValue() == rs.getInt("lay_codigo") && rs.getInt("ela_idadeini") == 0 && rs.getInt("ela_idadefim") == 0;
                    if ((!padrao || linha != 0) && !idadeZero && !interValido) continue;
                    linha = rs.getRow();
                    if (!interValido) continue;
                    break;
                }
                if (linha > 0) {
                    rs.first();
                    while (rs.getRow() < linha && rs.next()) {
                    }
                    bui.setLength(0);
                    bui.append("select \n");
                    bui.append("  a.elm_formato, a.elm_exportartexto, b.met_codigo \n");
                    bui.append("from examelayoutmetodo a \n");
                    bui.append("left join metodologia b \n");
                    bui.append("  on a.fil_codigo = b.fil_codigo and a.met_codigo = b.met_codigo \n");
                    bui.append("where \n");
                    bui.append("  a.fil_codigo = ").append(requisicao.getFilial()).append(" and \n");
                    bui.append("  a.exa_codigo = '").append(exame.getExameJalis()).append("' and \n");
                    bui.append("  a.mco_codigo = ").append(exame.getMaterialJalis()).append(" and \n");
                    bui.append("  a.lay_codigo = ").append(rs.getString("lay_codigo")).append(" and \n");
                    bui.append("  a.ela_idadeini = ").append(rs.getString("ela_idadeini")).append(" and \n");
                    bui.append("  a.ela_idadefim = ").append(rs.getString("ela_idadefim")).append(" and \n");
                    bui.append("  a.ela_idadeinitipo = '").append(rs.getString("ela_idadeinitipo")).append("' and \n");
                    bui.append("  a.ela_idadefimtipo = '").append(rs.getString("ela_idadefimtipo")).append("' and \n");
                    bui.append("  b.met_codigo = ").append(rs.getString("met_codigo"));
                    rs = Conexao.executeQuery(st, bui.toString());
                    if (rs.next()) {
                        exame.setFormatoTexto(rs.getString("elm_exportartexto"));
                        exame.setFormato(rs.getString("elm_formato"));
                        exame.setCodigoMetodo(rs.getInt("met_codigo"));
                    }
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoMatrix");
            }
        }
    }

    private void getRequisicao(Requisicao requisicao, int codigoLabExterno) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select c.pac_codigo, c.pac_nome, c.pac_idade, c.pac_anomes ");
        sql.append("from paciente c ");
        sql.append("where c.fil_codigo = ? and c.pac_codigo = ? ");
        PreparedStatement prst = Conexao.getPreparedStatement(sql.toString());
        prst.setInt(1, Integer.parseInt(requisicao.getFilial()));
        prst.setInt(2, Integer.parseInt(requisicao.getCodigoPaciente()));
        ResultSet rs = prst.executeQuery();
        if (rs.next()) {
            requisicao.setNomePaciente(rs.getString("pac_nome"));
            requisicao.setIdade(rs.getInt("pac_idade"));
            requisicao.setTipoIdade(rs.getString("pac_anomes"));
            sql.setLength(0);
            sql.append("select a.exa_codigo, a.mco_codigo, a.exr_situacao, pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado,");
            sql.append(" g.met_codigo, a.exr_datamaterial,");
            sql.append(" b.exa_salvaparcial, g.ele_xmllabexterno, ");
            sql.append(" d.fil_codigo, d.req_codigo, d.con_codigo, d.des_codigo, b.exa_salvaparcial");
            sql.append(" from examerequisicao a ");
            sql.append(" left join exames b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo ");
            sql.append(" left join examematcoleta c on a.fil_codigo = c.fil_codigo and a.exa_codigo = c.exa_codigo and a.mco_codigo = c.mco_codigo ");
            sql.append(" left join requisicao d on a.fil_codigo = d.fil_codigo and a.req_codigo = d.req_codigo ");
            sql.append(" left join paciente e on d.pac_codigo = e.pac_codigo and d.fil_codigo = e.fil_codigo ");
            sql.append(" left join examematcoletalabexterno g on c.fil_codigo = g.fil_codigo and c.exa_codigo = g.exa_codigo and c.mco_codigo = g.mco_codigo");
            sql.append(" where a.fil_codigo = ? and g.lae_codigo = ? and e.pac_codigo = ? and a.req_codigo = ? and a.exa_codigo = ? and a.mco_codigo = ? and a.exr_excluido = false and g.ele_xmllabexterno <> '' and g.ele_xmllabexterno is not null ");
            PreparedStatement prst2 = Conexao.getPreparedStatement(sql.toString());
            for (Exame exame : requisicao.getExames()) {
                prst2.clearParameters();
                prst2.setInt(1, Integer.parseInt(requisicao.getFilial()));
                prst2.setInt(2, codigoLabExterno);
                prst2.setInt(3, Integer.parseInt(requisicao.getCodigoPaciente()));
                prst2.setInt(4, Integer.parseInt(requisicao.getCodRequisicao()));
                prst2.setString(5, exame.getExameJalis());
                prst2.setInt(6, Integer.parseInt(exame.getMaterialJalis()));
                ResultSet rs2 = prst2.executeQuery();
                if (!rs2.next()) continue;
                String xmlExame = rs2.getString("ele_xmllabexterno");
                exame.setMaterialJalis(rs2.getString("mco_codigo"));
                exame.setCodigoMetodo(rs2.getInt("met_codigo"));
                exame.setSituacao(rs2.getString("exr_situacao"));
                exame.setFormato(rs2.getString("exr_resultado"));
                exame.setDataMaterial(rs2.getDate("exr_datamaterial"));
                exame.setSalvarParcial(rs2.getBoolean("exa_salvaparcial"));
                String codigoLayout = ExameUtil.getCodigoLayout(requisicao.getFilial(), rs2.getString("con_codigo"), rs2.getString("des_codigo"));
                exame.setCodigoLayout(Integer.valueOf(codigoLayout));
            }
            prst2.close();
        }
        prst.close();
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    private boolean validaPaciente(Requisicao requisicao) throws SQLException {
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        bui.append("select pac_codigo from paciente ");
        bui.append("where fil_codigo = ").append(requisicao.getFilial());
        bui.append("and pac_codigo = ").append(requisicao.getCodigoPaciente());
        ResultSet res = Conexao.executeQuery(st, bui.toString());
        return res.next();
    }

    private void adicionarAoModeloRelatorio(Requisicao requisicao, Exame exame, Situacao situacao) {
        RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, requisicao.getFilial(), requisicao.getCodRequisicao(), exame.getExameJalis(), Integer.parseInt(exame.getMaterialJalis()), situacao.descricao);
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        SEM_MATERIAL("Sem material");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

