/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.matrix;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.matrix.CampoMatrix;
import jalis.laboratorio.util.parsers.matrix.ExameMatrix;
import jalis.laboratorio.util.parsers.matrix.ParserImportacaoMatrix;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;

public class ImportacaoMatrix
extends AbstractImportadorLabExterno {
    private JButton buttonImportarCampos = ComponenteFactory.novoJButton("Importar campos de resultado", this);

    public ImportacaoMatrix(int codigoLabExterno, Protocolo protocolo) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. ".concat(protocolo.name()).concat(" a partir de arquivo XML"), codigoLabExterno, protocolo);
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonImportarCampos, 1);
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo CSV do Lab. ".concat(this.protocolo.name()).concat(" (*.csv)"), "csv"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                StringBuilder bui = new StringBuilder();
                this.setTextoInformacoes("");
                this.anexarTextoInformacoes("Importando exames...\n");
                Thread.sleep(50L);
                this.progress.setValue(0);
                this.progress.setVisible(true);
                Map<String, ExameMatrix> excluidos = ParserImportacaoMatrix.importarExamesMatrix(file, this.codigoLabExterno, this.progress, this);
                this.anexarTextoInformacoes(bui.append("\nImporta\u00e7\u00e3o conclu\u00edda").toString());
                Thread.sleep(50L);
                if (excluidos.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                    bui.append("+--------+-------------------------------------------------------------------------+\n");
                    bui.append("| CODIGO | DESCRI\u00c7\u00c3O EXAME                                                         |\n");
                    bui.append("+--------+-------------------------------------------------------------------------+");
                    for (String ex : excluidos.keySet()) {
                        bui.append("\n| ").append(StringUtil.formatarColuna(Funcoes.preencheZero(excluidos.get(ex).getCodigoExame(), 6), 7, 'e'));
                        bui.append("| ").append(StringUtil.formatarColuna(excluidos.get(ex).getDescricaoExame(), 73, 'e')).append("|");
                    }
                    bui.append("\n+--------+-------------------------------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
                this.progress.setVisible(false);
                retorno = true;
            }
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar arquivo - Lab. ".concat(this.protocolo.name()).concat(" ").concat(e.getMessage()), e.getStackTrace());
        }
        return retorno;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportarCampos) {
            this.importarCampos();
        } else {
            super.actionPerformed(e);
        }
    }

    private void importarCampos() {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo CSV do Lab. ".concat(this.protocolo.name()).concat(" (*.csv)"), "csv"));
            if (chooser.showOpenDialog(this) == 0) {
                File file = new File(chooser.getSelectedFile().getPath());
                this.setTextoInformacoes("");
                this.anexarTextoInformacoes("Importando Campos...\n");
                String[] linhas = StringUtil.lerArquivoTexto(file).split("\n");
                List<ExameMatrix> lista = ExameMatrix.getExamesImportados(String.valueOf(this.codigoLabExterno));
                HashMap<Integer, ExameMatrix> exames = new HashMap<Integer, ExameMatrix>();
                for (ExameMatrix exameMatrix : lista) {
                    exames.put(exameMatrix.getCodigoExame(), exameMatrix);
                    exameMatrix.limparCampos();
                }
                for (String lin : linhas) {
                    String[] campo = lin.split(";");
                    CampoMatrix campoMatrix = new CampoMatrix();
                    campoMatrix.setCodigo(campo[2]);
                    campoMatrix.setComentario(campo[1] + " vers\u00e3o: " + campo[3] + " Validade: " + campo[4]);
                    campoMatrix.setVersao(campo[3]);
                    campoMatrix.setValidade(campo[4]);
                    if (!Funcoes.isNumeric(campo[0]) || !exames.containsKey(Integer.parseInt(campo[0]))) continue;
                    ((ExameMatrix)exames.get(Integer.parseInt(campo[0]))).addCampo(campoMatrix);
                }
                HashMap<Integer, ExameMatrix> examesAtualizar = new HashMap<Integer, ExameMatrix>();
                for (ExameMatrix exameMatrix : exames.values()) {
                    if (exameMatrix.getCampos().size() <= 0) continue;
                    examesAtualizar.put(exameMatrix.getCodigoExame(), exameMatrix);
                }
                if (examesAtualizar.size() > 0) {
                    this.setTextoInformacoes("\n\nOs seguintes exames abaixo foram importado os campos: \n\n", false);
                    this.setTextoInformacoes("+--------+-------------------------------------------------------------------------+\n", false);
                    this.setTextoInformacoes("| CODIGO | DESCRI\u00c7\u00c3O EXAME                                                         |\n", false);
                    this.setTextoInformacoes("+--------+-------------------------------------------------------------------------+", false);
                    this.progress.setValue(0);
                    this.progress.setVisible(true);
                    this.progress.setMaximum(examesAtualizar.size());
                    this.atualizaCampo(this.progress, examesAtualizar, this.codigoLabExterno);
                    this.setTextoInformacoes("\n+--------+-------------------------------------------------------------------------+", false);
                    this.progress.setVisible(false);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi poss\u00edvel importar arquivo - Lab. ".concat(this.protocolo.name()).concat(" ").concat(e.getMessage() != null ? e.getMessage() : ""), e.getStackTrace());
        }
    }

    private void atualizaCampo(JProgressBar progress, Map<Integer, ExameMatrix> examesAtualizar, int codigoLabExterno) throws NumberFormatException, SalvaDadosException, SQLException {
        Map<Integer, ExameMatrix> examesAntigosRelac = ImportacaoMatrix.examesMap(this.getExamesRelacionados(codigoLabExterno));
        Statement st = Conexao.getStatement();
        StringBuilder bui = new StringBuilder();
        for (ExameMatrix exameMatrix : examesAtualizar.values()) {
            IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, exameMatrix.getMnemonicoExame(), exameMatrix.getCodigoExame(), null, exameMatrix.getXml());
            progress.setValue(progress.getValue() + 1);
            bui.setLength(0);
            bui.append("\n| ").append(StringUtil.formatarColuna(Funcoes.preencheZero(exameMatrix.getCodigoExame(), 6), 7, 'e'));
            bui.append("| ").append(StringUtil.formatarColuna(exameMatrix.getDescricaoExame(), 73, 'e')).append("|");
            this.setTextoInformacoes(bui.toString(), false);
            ExameMatrix exAntigo = examesAntigosRelac.get(exameMatrix.getCodigoExame());
            if (exAntigo == null) continue;
            exameMatrix.setExameJalis(exAntigo.getExameJalis());
            exameMatrix.setMaterialJalis(exAntigo.getMaterialJalis());
            IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, exameMatrix.getExameJalis(), Integer.parseInt(exameMatrix.getMaterialJalis()), exameMatrix.getXml().replace("'", ""));
        }
        Conexao.arquivaSQL();
    }

    private Set<ExameMatrix> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append("  a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameMatrix.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameMatrix>();
    }

    private static Map<Integer, ExameMatrix> examesMap(Collection<ExameMatrix> exames) {
        HashMap<Integer, ExameMatrix> examesMap = new HashMap<Integer, ExameMatrix>();
        for (ExameMatrix ex : exames) {
            examesMap.put(ex.getCodigoExame(), ex);
        }
        return examesMap;
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }
}

