/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.matrix;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.matrix.CampoMatrix;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExameMatrix {
    private static final String TAG_PROTOCOLO = "matrix";
    private static final String TAG_EXAME = "exame";
    private static final String TAG_CODIGO_EXAME = "codigoExame";
    private static final String TAG_MNEMONICO_EXAME = "mnemonicoExame";
    private static final String TAG_DESCRICAO_EXAME = "descricaoExame";
    private static final String TAG_MATERIAL = "material";
    private static final String TAG_CAMPOS = "camposExame";
    private String descricaoExame;
    private String mnemonicoExame;
    private Integer codigoExame;
    private String material;
    private List<CampoMatrix> campos;
    private String exameJalis;
    private String materialJalis;
    private String laboratorioExternoJalis;

    public ExameMatrix() {
        this.campos = new ArrayList<CampoMatrix>();
    }

    public ExameMatrix(String descricaoExame, String mnemonicoExame, Integer codigoExame) {
        this.mnemonicoExame = mnemonicoExame;
        this.descricaoExame = descricaoExame;
        this.codigoExame = codigoExame;
        this.material = "";
        this.campos = new ArrayList<CampoMatrix>();
    }

    public ExameMatrix(String xml) {
        this.parseXml(xml);
    }

    public String getDescricaoExame() {
        return this.descricaoExame;
    }

    public void setDescricaoExame(String descricaoExame) {
        this.descricaoExame = descricaoExame;
    }

    public String getMnemonicoExame() {
        return this.mnemonicoExame;
    }

    public void setMnemonicoExame(String mnemonicoExame) {
        this.mnemonicoExame = mnemonicoExame;
    }

    public Integer getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(Integer codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public List<CampoMatrix> getCampos() {
        return Collections.unmodifiableList(this.campos);
    }

    public void limparCampos() {
        this.campos.clear();
    }

    public void addCampo(CampoMatrix campo) {
        this.campos.add(campo);
    }

    public String getLaboratorioExternoJalis() {
        return this.laboratorioExternoJalis;
    }

    public void setLaboratorioExternoJalis(String laboratorioExternoJalis) {
        this.laboratorioExternoJalis = laboratorioExternoJalis;
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_PROTOCOLO);
            xml.abrir(TAG_EXAME);
            xml.escrever(TAG_CODIGO_EXAME, this.getCodigoExame().toString());
            xml.escrever(TAG_MNEMONICO_EXAME, this.getMnemonicoExame());
            xml.escrever(TAG_DESCRICAO_EXAME, this.getDescricaoExame());
            xml.escrever(TAG_MATERIAL, this.getMaterial());
            xml.abrir(TAG_CAMPOS);
            for (CampoMatrix campo : this.campos) {
                campo.escreverXml(xml);
            }
            xml.fechar(TAG_CAMPOS);
            xml.fechar(TAG_EXAME);
            xml.fechar(TAG_PROTOCOLO);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExameMatrix");
        }
        return xml.getXML();
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorMatrix = StringUtil.getValor(xml, TAG_PROTOCOLO);
        return valorMatrix != null && valorMatrix.trim().length() > 0 && (valorExame = StringUtil.getValor(valorMatrix, TAG_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public void atualizaXml(String codigoLabExterno) {
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append("update ExamesMatrix \n");
                bui.append(" set mar_xml = '").append(StringUtil.textoDB(this.getXml())).append("' ");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" \n");
                bui.append(" and  lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append(" and  mar_codexame = '").append(this.getMnemonicoExame()).append("' ");
                bui.append(" and  mar_codexamenumerico = ").append(this.getCodigoExame()).append(" ");
                SQL = bui.toString();
                Conexao.executeUpdate(Variaveis.filialPadrao, st, SQL);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
    }

    public static Set<ExameMatrix> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameMatrix> list = new HashSet<ExameMatrix>();
        if (res.first()) {
            do {
                list.add(new ExameMatrix(res));
            } while (res.next());
        }
        return list;
    }

    public static List<ExameMatrix> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameMatrix> exames = new ArrayList<ExameMatrix>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" select * \n");
                bui.append("   from examesmatrix \n");
                bui.append("  where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("        lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("  order by mar_descricaoexame ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    ExameMatrix exa = new ExameMatrix(res.getString("mar_xml"));
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return exames;
    }

    public ExameMatrix(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.laboratorioExternoJalis = res.getString("lae_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    public void parseXml(String xml) {
        if (xml != null) {
            this.mnemonicoExame = StringUtil.getValor(xml, TAG_MNEMONICO_EXAME);
            this.descricaoExame = StringUtil.getValor(xml, TAG_DESCRICAO_EXAME);
            this.codigoExame = StringUtil.getInt(xml, TAG_CODIGO_EXAME);
            this.material = StringUtil.getValor(xml, TAG_MATERIAL);
            this.campos = new ArrayList<CampoMatrix>();
            for (String campos : StringUtil.getValores(xml, "campo")) {
                CampoMatrix campo = new CampoMatrix();
                campo.setCodigo(StringUtil.getValor(campos, "parametro"));
                campo.setComentario(StringUtil.getValor(campos, "comentario"));
                campo.setValidade(StringUtil.getValor(campos, "validade"));
                campo.setVersao(StringUtil.getValor(campos, "versao"));
                this.addCampo(campo);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExameMatrix)) {
            return false;
        }
        ExameMatrix e = (ExameMatrix)o;
        return e.codigoExame.equals(this.codigoExame);
    }
}

