/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.matrix;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloMatrix
extends AbstractConfiguradorProtocolo {
    protected JTextField textEmpresa = new TTextField(3, 3);
    public static final String TAG_CODIGO_PROTOCOLO = "codigoProtocolo";

    public static ConfiguradorProtocoloMatrix novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloMatrix((Frame)pai, "Configurador ", codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloMatrix((Dialog)pai, "Configurador ", codigoLabExterno);
        }
        return null;
    }

    public ConfiguradorProtocoloMatrix(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    public ConfiguradorProtocoloMatrix(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    private void montarTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        JLabel labelCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(85, 20));
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(85, 20));
        JLabel labelEmpresa = ComponenteFactory.novoJLabel("Empresa:", new Dimension(85, 20));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        this.getPanelCentral().add((Component)labelCodigo, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelEmpresa, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelLote, cons);
        ++cons.gridx;
        cons.gridy = 0;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.textEmpresa, cons);
        ++cons.gridy;
        this.textLote.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textLote, cons);
        this.setSize(new Dimension(270, 180));
        this.setLocationRelativeTo(this.getParent());
        ScreenUtil.requisitarFoco(this.textEmpresa);
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<matrix>");
        bui.append(StringUtil.getTag(TAG_CODIGO_PROTOCOLO, this.textCodigo.getText()));
        bui.append(StringUtil.getTag("empresa", this.textEmpresa.getText()));
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        return bui.append("</matrix>").toString();
    }

    @Override
    public boolean acaoOk() {
        return !Funcoes.textoVazio(this.textEmpresa) && !Funcoes.textoVazio(this.textLote);
    }

    @Override
    public int getNumeroLote() {
        if (Funcoes.textoVazio(this.textLote)) {
            return 0;
        }
        return Integer.parseInt(this.textLote.getText());
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "matrix");
            this.textCodigo.setText(StringUtil.getValor(xml, TAG_CODIGO_PROTOCOLO));
            this.textEmpresa.setText(StringUtil.getValor(xml, "empresa"));
            this.textLote.setText(StringUtil.getValor(xml, "lote"));
        }
    }
}

