/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.matrix;

import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.laboratorio.util.parsers.maricondi.ExameMaricondi;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.tabela.CorTableCellRenderer;
import jalis.util.tabela.ModeloResultSet;
import jalis.util.tabela.Registro;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class ConfiguradorMaricondi
extends AbstractConfigurador
implements ListSelectionListener {
    private static final String COD_EXA = "codigoExame";
    private static final String MATERIAL_EXAME = "materialExame";
    private static final String DESC_EXA = "descricaoExame";
    private static final String XML_EXAME = "xmlExame";
    private static final String OBJ_EXAME_MARICONDI = "objExameMaricondi";
    private ModeloResultSet modExa = new ModeloResultSet("C\u00f3digo", "codigoExame", "Descri\u00e7\u00e3o", "descricaoExame", "Material", "materialExame");
    private JTable tableExa = ComponenteFactory.novoJTable((TableModel)this.modExa, (ListSelectionListener)this, 80, 0, 160);
    private JTextField textLocalizar = new JTextField();
    private JTextField textMaterial = ComponenteFactory.novoTTextField(8, 3);
    private String xmlSelecionado = "";

    public ConfiguradorMaricondi(Frame pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public ConfiguradorMaricondi(Dialog pai, String codigoLabExterno, String titulo) {
        super(pai, titulo, codigoLabExterno);
        this.iniciar();
    }

    public static ConfiguradorMaricondi novaInstancia(Object pai, String codigoLabExterno, String titulo) {
        if (pai instanceof Frame) {
            return new ConfiguradorMaricondi((Frame)pai, codigoLabExterno, titulo);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorMaricondi((Dialog)pai, codigoLabExterno, titulo);
        }
        return null;
    }

    @Override
    public String getXML() {
        return this.xmlSelecionado;
    }

    @Override
    public void setXML(String xml) {
        if (ExameMaricondi.isXmlValido(xml)) {
            this.xmlSelecionado = xml;
            ExameMaricondi exa = new ExameMaricondi(xml);
            for (int i = 0; i < this.tableExa.getRowCount(); ++i) {
                Registro reg = this.modExa.getRegistro(i);
                if (reg == null || !exa.getMnemonicoExame().equals(reg.getValor(COD_EXA))) continue;
                this.tableExa.setRowSelectionInterval(i, i);
                this.tableExa.scrollRectToVisible(this.tableExa.getCellRect(i, 0, true));
                break;
            }
        }
    }

    private void iniciar() {
        JScrollPane scrollExa = new JScrollPane(this.tableExa);
        scrollExa.setPreferredSize(new Dimension(650, 200));
        this.getPanelCentral().setLayout(new BorderLayout());
        this.getPanelCentral().add((Component)ComponenteFactory.novoJPanelBorderLayout("Exames", null, (Component)scrollExa, (Component)this.montarPanelLocalizar(), null, null), "North");
        this.configurarTabelas();
        this.definirAcaoTeclas();
        this.carregarExames();
        this.pack();
        this.setSize(this.getPreferredSize());
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
    }

    private JPanel montarPanelLocalizar() {
        this.textLocalizar.setPreferredSize(new Dimension(10, 22));
        ScreenUtil.addDocumentListener(this.textLocalizar.getDocument(), new Runnable(){

            @Override
            public void run() {
                ConfiguradorMaricondi.this.modExa.filtrar(ConfiguradorMaricondi.DESC_EXA, ConfiguradorMaricondi.this.textLocalizar.getText());
                if (ConfiguradorMaricondi.this.modExa.getRowCount() > 0) {
                    ConfiguradorMaricondi.this.tableExa.setRowSelectionInterval(0, 0);
                }
            }
        });
        JPanel panelLocalizar = ComponenteFactory.novoJPanelBorderLayout(this.textLocalizar, null, null, null, ComponenteFactory.novoJLabel("Localizar:", 'L', new Dimension(70, 22), this.textLocalizar));
        panelLocalizar.setBorder(BorderFactory.createEmptyBorder(5, 2, 5, 2));
        return panelLocalizar;
    }

    private void configurarTabelas() {
        TableColumnModel mod = this.tableExa.getColumnModel();
        mod.getColumn(0).setMaxWidth(80);
        CorTableCellRenderer renderer = new CorTableCellRenderer();
        renderer.setAlinhamentoColuna(0, 0);
        this.tableExa.setDefaultRenderer(Object.class, renderer);
    }

    private void definirAcaoTeclas() {
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(38, 0, false), "up", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorMaricondi.this.tableExa.hasFocus() && (row = ConfiguradorMaricondi.this.tableExa.getSelectedRow()) > 0) {
                    ConfiguradorMaricondi.this.tableExa.setRowSelectionInterval(row - 1, row - 1);
                    ConfiguradorMaricondi.this.tableExa.scrollRectToVisible(ConfiguradorMaricondi.this.tableExa.getCellRect(row - 1, 0, false));
                }
            }
        });
        ScreenUtil.addActionMap((JComponent)this.getContentPane(), KeyStroke.getKeyStroke(40, 0, false), "down", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row;
                if (!ConfiguradorMaricondi.this.tableExa.hasFocus() && (row = ConfiguradorMaricondi.this.tableExa.getSelectedRow()) < ConfiguradorMaricondi.this.tableExa.getRowCount() - 1) {
                    ConfiguradorMaricondi.this.tableExa.setRowSelectionInterval(row + 1, row + 1);
                    ConfiguradorMaricondi.this.tableExa.scrollRectToVisible(ConfiguradorMaricondi.this.tableExa.getCellRect(row + 1, 0, false));
                }
            }
        });
    }

    private void carregarExames() {
        for (ExameMaricondi exame : ExameMaricondi.getExamesImportados(this.getCodigoLabExterno())) {
            Registro reg = new Registro();
            reg.setValor(COD_EXA, exame.getCodigoExame());
            reg.setValor(DESC_EXA, exame.getDescricaoExame());
            if (exame.getCodigoExame() != null) {
                reg.setValor(MATERIAL_EXAME, exame.getMaterial());
            } else {
                reg.setValor(MATERIAL_EXAME, exame.getDescricaoMaterial());
            }
            reg.setValor(XML_EXAME, exame.getXMLConfiguradoExame());
            reg.setValor(OBJ_EXAME_MARICONDI, exame);
            this.modExa.addRegistro(reg);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            this.textMaterial.setText(((ExameMaricondi)reg.getValor(OBJ_EXAME_MARICONDI)).getDescricaoMaterial());
        }
    }

    public static String getCodigoIdentExameLabExterno(String xml) {
        if (xml != null) {
            ExameMaricondi exa = new ExameMaricondi(xml);
            return exa.getCodigoExame() + "|" + exa.getMnemonicoExame() + "|1";
        }
        return "";
    }

    @Override
    public boolean acaoOk() {
        ExameMaricondi exa = this.getExameSelecionado();
        if (exa == null) {
            Funcoes.mensagem(this, "Nenhum exame foi selecionado", 1);
            return false;
        }
        if (Funcoes.textoVazio(exa.getMaterial()) && Funcoes.textoVazio(this.textMaterial)) {
            Funcoes.mensagem(this, "Material do exame deve ser preenchido!", 1);
            return false;
        }
        if (!(Funcoes.textoVazio(exa.getMaterial()) || Funcoes.textoVazio(this.textMaterial) || exa.getMaterial().equals(this.textMaterial.getText()) || Funcoes.mensagem(this, "Alterar material do exame?", 4, true) == 0)) {
            return false;
        }
        return this.atualizarXMLSelecionado();
    }

    private boolean atualizarXMLSelecionado() {
        ExameMaricondi exa = this.getExameSelecionado();
        if (exa != null) {
            if (!Funcoes.textoVazio(this.textMaterial.getText())) {
                exa.setMaterial(this.textMaterial.getText().toUpperCase());
            }
            this.xmlSelecionado = exa.atualizaXml(this.getCodigoLabExterno());
            return true;
        }
        return false;
    }

    private ExameMaricondi getExameSelecionado() {
        Registro reg = this.modExa.getRegistro(this.tableExa.getSelectedRow());
        if (reg != null) {
            return (ExameMaricondi)reg.getValor(OBJ_EXAME_MARICONDI);
        }
        return null;
    }

    public static String getDescricaoExameSelecionado(String xml) {
        if (xml != null && xml.trim().length() > 0) {
            ExameMaricondi exa = new ExameMaricondi(xml);
            return exa.getDescricaoExame();
        }
        return "";
    }
}

