/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.matrix;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.matrix.CampoMatrix;
import jalis.laboratorio.util.parsers.matrix.ExameMatrix;
import java.util.LinkedHashMap;

class CamposImportacaoMatrix
implements CamposImportacao {
    LinkedHashMap<String, String> linhas = new LinkedHashMap();
    private String versao;
    private String codigoExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    public CamposImportacaoMatrix(ExameMatrix exame, String codigoExamePai, Integer codigoMaterialPai) {
        this.codigoExamePai = codigoExamePai;
        this.codigoMaterialPai = codigoMaterialPai;
        this.linhas.put("", "Nenhum");
        this.codigoExame = String.valueOf(exame.getCodigoExame());
        for (CampoMatrix campo : exame.getCampos()) {
            this.versao = campo.getVersao();
            this.linhas.put(campo.getCodigo(), campo.getComentario());
        }
    }

    @Override
    public Object getCamposImportacao() {
        return this.linhas;
    }

    @Override
    public String getCodigoExameLabExterno() {
        return this.codigoExame;
    }

    @Override
    public String getVersao() {
        return this.versao;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }
}

