/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.maricondi;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.maricondi.ExameMaricondi;
import jalis.laboratorio.util.parsers.maricondi.ImportacaoMaricondi;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;

public class ParserImportacaoMaricondi {
    private static final int TAG_CODIGO_EXAME = 1;
    private static final int TAG_DESCRICAO_EXAME = 2;
    private static final int TAG_MATERIAL = 3;

    public static Map<String, ExameMaricondi> importarExamesMaricondi(String bufCsv, int codigoLabExterno, JProgressBar progress, ImportacaoMaricondi telaImportacao) {
        HashMap<String, ExameMaricondi> examesNovos = new HashMap<String, ExameMaricondi>();
        boolean arquivoResultado = false;
        String[] linhas = bufCsv.split("\n");
        ExameMaricondi em = null;
        for (String s : linhas) {
            String[] exame = s.split(";");
            if (!(!linhas[0].equals(s) || exame.length >= 4 && exame[1].equalsIgnoreCase("Codigo") && exame[2].equalsIgnoreCase("Nome") && ((String)exame[3]).equalsIgnoreCase("Material"))) {
                return null;
            }
            if (!(exame.length < 4 || Funcoes.textoVazio(exame[1]) || Funcoes.textoVazio(exame[2]) || Funcoes.textoVazio((String)exame[3]))) {
                String descricaoExame = ((String)exame[2]).replace(String.valueOf('\u2019'), "'");
                Object material = exame[3];
                Object mnemonicoExame = ((String)exame[1]).indexOf(".") < 0 ? exame[1] : ((String)exame[1]).replaceAll("0*$", "").replaceAll("\\.$", "");
                em = new ExameMaricondi((String)mnemonicoExame, descricaoExame, (String)material);
            }
            if (Funcoes.textoVazio(em.getMnemonicoExame()) || em.getMnemonicoExame().equalsIgnoreCase("exame")) continue;
            if (examesNovos.containsKey(em.getMnemonicoExame())) {
                ExameMaricondi emAnt = new ExameMaricondi(((ExameMaricondi)examesNovos.get(em.getMnemonicoExame())).getXml());
                examesNovos.remove(em.getMnemonicoExame());
                emAnt.setMnemonicoExame(em.getMnemonicoExame());
                examesNovos.put(em.getMnemonicoExame(), em);
                examesNovos.put(emAnt.getMnemonicoExame(), emAnt);
                continue;
            }
            examesNovos.put(em.getMnemonicoExame(), em);
        }
        HashMap<String, ExameMaricondi> examesExcluidos = new HashMap<String, ExameMaricondi>();
        Statement st = Conexao.getStatement();
        if (st != null && examesNovos.size() > 0) {
            try {
                ExameMaricondi exAntigo;
                HashSet examesNovosRel;
                Map<String, ExameMaricondi> examesAntigosRelac = ParserImportacaoMaricondi.examesMap(ParserImportacaoMaricondi.getExamesRelacionados(codigoLabExterno));
                Map<String, ExameMaricondi> examesAntigos = ParserImportacaoMaricondi.loadExamesMaricondi(st, codigoLabExterno);
                if (arquivoResultado) {
                    for (Iterator<Object> exame : examesNovos.keySet()) {
                        Object ex = (ExameMaricondi)examesNovos.get(exame);
                        IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, ((ExameMaricondi)ex).getMnemonicoExame(), ((ExameMaricondi)ex).getCodigoExame());
                    }
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoMaricondi.inserirExamesMaricondi(examesNovos, st, codigoLabExterno, progress, examesAntigos);
                    examesNovosRel = new HashSet(examesNovos.values());
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (Object ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        exAntigo = examesAntigosRelac.get(((ExameMaricondi)ex).getCodigoExame());
                        ((ExameMaricondi)ex).setExameJalis(exAntigo.getExameJalis());
                        ((ExameMaricondi)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameMaricondi)ex).getExameJalis(), Integer.parseInt(((ExameMaricondi)ex).getMaterialJalis()), ((ExameMaricondi)ex).getXml());
                    }
                } else {
                    IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, new Object[0]);
                    if (progress != null) {
                        progress.setMaximum(examesNovos.size());
                        progress.setValue(0);
                    }
                    ParserImportacaoMaricondi.inserirExamesMaricondi(examesNovos, st, codigoLabExterno, progress, examesAntigos);
                    examesNovosRel = new HashSet(examesNovos.values());
                    examesNovosRel.retainAll(examesAntigosRelac.values());
                    if (progress != null) {
                        progress.setMaximum(examesNovosRel.size());
                        progress.setValue(0);
                    }
                    for (Object ex : examesNovosRel) {
                        if (progress != null) {
                            progress.setValue(progress.getValue() + 1);
                        }
                        exAntigo = examesAntigosRelac.get(((ExameMaricondi)ex).getCodigoExame().toString());
                        ((ExameMaricondi)ex).setExameJalis(exAntigo.getExameJalis());
                        ((ExameMaricondi)ex).setMaterialJalis(exAntigo.getMaterialJalis());
                        if (!exAntigo.getMaterial().equals(((ExameMaricondi)ex).getMaterial())) {
                            ((ExameMaricondi)ex).setMaterial(exAntigo.getMaterial());
                        }
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ((ExameMaricondi)ex).getExameJalis(), Integer.parseInt(((ExameMaricondi)ex).getMaterialJalis()), ((ExameMaricondi)ex).getXml().replace("'", ""));
                    }
                    examesExcluidos.putAll(examesAntigos);
                    for (Object ex : examesNovos.keySet()) {
                        if (!examesExcluidos.containsKey(ex)) continue;
                        examesExcluidos.remove(ex);
                    }
                    HashSet<ExameMaricondi> examesExcluidosRel = new HashSet<ExameMaricondi>(examesAntigosRelac.values());
                    examesExcluidosRel.removeAll(examesNovos.values());
                    for (ExameMaricondi ex : examesExcluidosRel) {
                        if (examesNovos.containsKey(ex.getCodigoExame())) {
                            String xml = Funcoes.textoVazio(ex.getXMLConfiguradoExame()) ? ex.getXml() : ex.getXMLConfiguradoExame();
                            IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), Integer.parseInt(ex.getMaterialJalis()), xml.replace("'", ""));
                            continue;
                        }
                        IntegracaoLabExternoUtil.removeLigacaoExameLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ex.getExameJalis(), ex.getMaterialJalis());
                    }
                }
                Conexao.arquivaSQL();
            }
            catch (Exception e) {
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException e2) {
                    e.printStackTrace();
                }
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
        return examesExcluidos;
    }

    private static Map<String, ExameMaricondi> examesMap(Collection<ExameMaricondi> exames) {
        HashMap<String, ExameMaricondi> examesMap = new HashMap<String, ExameMaricondi>();
        for (ExameMaricondi ex : exames) {
            examesMap.put(ex.getCodigoExame().toString(), ex);
        }
        return examesMap;
    }

    private static Map<String, ExameMaricondi> loadExamesMaricondi(Statement st, int codigoLabExterno) throws SQLException {
        HashMap<String, ExameMaricondi> exames = new HashMap<String, ExameMaricondi>();
        StringBuilder sql = new StringBuilder();
        sql.append(" select fil_codigo, lae_codigo, mar_codexame, mar_codexamenumerico, mar_descricaoexame, mar_xml");
        sql.append(" from examesmatrix ");
        sql.append("  where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append("  and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            exames.put(rs.getString("mar_codexame"), new ExameMaricondi(rs.getString("mar_xml")));
        }
        return exames;
    }

    private static void inserirExamesMaricondi(Map<String, ExameMaricondi> exames, Statement st, int codigoLabExterno, JProgressBar progress, Map<String, ExameMaricondi> examesAnt) throws SQLException, SalvaDadosException {
        for (String mnemonico : exames.keySet()) {
            ExameMaricondi exame = exames.get(mnemonico);
            if (Funcoes.textoVazio(exame.getMaterial()) && examesAnt.size() > 0 && examesAnt.get(mnemonico) != null && !Funcoes.textoVazio(examesAnt.get(mnemonico).getMaterial())) {
                exame.setMaterial(examesAnt.get(mnemonico).getMaterial());
            }
            if (exame.getMnemonicoExame().equals("Codigo") || exame.getDescricaoExame().equals("Nome") || exame.getMaterial().equals("Material")) continue;
            if (exame.getMnemonicoExame().equalsIgnoreCase(exame.getCodigoExame())) {
                IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 18, exame.getCodigoExame(), StringUtil.textoDB(exame.getDescricaoExame()), exame.getXml().replace("'", ""));
                continue;
            }
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, exame.getMnemonicoExame(), exame.getCodigoExame(), StringUtil.textoDB(exame.getDescricaoExame()), exame.getXml().replace("'", ""));
        }
    }

    private static Set<ExameMaricondi> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append(" a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append(" from examematcoletalabexterno a \n");
                bui.append(" left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append(" where \n");
                bui.append(" b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append(" a.lae_codigo = ").append(codigoLabExterno);
                bui.append(" and a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameMaricondi.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameMaricondi>();
    }

    public static List<ElementoHPardini> importarCamposResultadoMaricondi(ElementoHPardini resultados, int codigoLabExterno, JProgressBar progress) {
        ArrayList<ElementoHPardini> rejeitados = new ArrayList<ElementoHPardini>();
        Funcoes.validarNaoNull(resultados, "resultados");
        List<ElementoHPardini> superExames = resultados.getFilhos("SuperExame");
        if (progress != null) {
            progress.setMaximum(superExames.size());
        }
        try {
            for (ElementoHPardini superExame : superExames) {
                if (progress != null) {
                    progress.setValue(progress.getValue() + 1);
                }
                ParserImportacaoMaricondi.salvarSuperExame(superExame, codigoLabExterno, rejeitados);
            }
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoMaricondi: 168");
        }
        catch (SalvaDadosException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoMaricondi");
        }
        return rejeitados;
    }

    protected static void salvarSuperExame(ElementoHPardini superExame, int codigoLabExterno, List<ElementoHPardini> rejeitados) throws SQLException, SalvaDadosException {
        Statement st = Conexao.getStatement();
        if (st != null && superExame.contemFilho("CodExmApoio")) {
            String codExmApoio = superExame.getFilho("CodExmApoio").getValor();
            String exameNome = superExame.getFilho("ExameNome").getValor();
            StringBuilder sql = new StringBuilder("select mar_xml, mar_codexame, mar_codexamenumerico \n");
            sql.append("from examesmatrix \n");
            sql.append("where \n  fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
            sql.append("  lae_codigo = ").append(codigoLabExterno).append(" and \n");
            sql.append("  mar_codexame = '").append(codExmApoio).append("'\n");
            ResultSet res = Conexao.executeQuery(st, sql);
            if (!res.next()) {
                rejeitados.add(superExame);
            } else {
                IntegracaoLabExternoUtil.updateExame(st, Variaveis.filialPadrao, codigoLabExterno, 2, res.getString("mar_codexame"), res.getString("mar_codexamenumerico"), exameNome, ParserImportacaoMaricondi.montarXMLCamposResultados(res.getString("mar_xml"), superExame));
            }
        } else {
            rejeitados.add(superExame);
        }
    }

    private static String montarXMLCamposResultados(String ehpXML, ElementoHPardini superExame) {
        int beginIndex = ehpXML.indexOf("<maricondi>");
        int endIndex = ehpXML.indexOf("</maricondi>") + "</maricondi>".length();
        StringBuilder bui = new StringBuilder(StringUtil.textoDB(ehpXML.substring(beginIndex, endIndex)));
        bui.append('\n');
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            ParserImportacaoMaricondi.carregarXMLBuilder(xml, superExame);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage() + "\nExame: " + superExame.getFilho("CodExmApoio").getValor(), e.getStackTrace(), "ParserImportacaoHPardini: 220");
        }
        bui.append(StringUtil.textoDB(xml.getXML()));
        return bui.toString();
    }

    protected static void carregarXMLBuilder(XMLStringBuilder xml, ElementoHPardini ele) throws XMLStringBuilderException {
        if (!ele.contemFilhos()) {
            String valor = ele.getValor();
            if (ele.getNome().equalsIgnoreCase("descricao") || ele.getNome().equalsIgnoreCase("nota") || ele.getNome().equalsIgnoreCase("observacao") || ele.getNome().equalsIgnoreCase("comentariodopatologista") || ele.getNome().equalsIgnoreCase("metodo") || ele.getNome().equalsIgnoreCase("examenome") || ele.getNome().equalsIgnoreCase("UnidadeDeMedida") || ele.getNome().equalsIgnoreCase("valorReferenciaBloxoTexto") || ele.getNome().equalsIgnoreCase("interpretacao")) {
                valor = "<![CDATA[" + valor + "]]>";
            }
            xml.escrever(ele.getNome(), valor, ele.getMapaAtributos());
        } else {
            xml.abrir(ele.getNome(), ele.getMapaAtributos());
            for (ElementoHPardini filho : ele.getFilhos()) {
                ParserImportacaoMaricondi.carregarXMLBuilder(xml, filho);
            }
            xml.fechar(ele.getNome());
        }
    }
}

