/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.maricondi;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.maricondi.SolicitaPeriodo;
import jalis.laboratorio.util.parsers.maricondi.TagsConfiguradorProtocoloMaricondi;
import jalis.laboratorio.util.parsers.pardini.resultado.CamposRelacionamentoHPardiniUtil;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardini;
import jalis.model.vo.cadastro.auxiliares.FilialVO;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.json.JSONObject;

public class ImportacaoResultadoMaricondi
extends AbstractImportadorResultadoLabExterno {
    boolean debug;
    public static final String TAG_ENDERECO_WEBSERVICE = "enderecoWebService";
    protected List<Registro> requisicoes;
    public static final String TAG_COD_LAB = "CodLab";
    public static final String TAG_COD_LOTE_LAB = "CodLoteLab";
    public static final String TAG_PROTOCOLO = "Protocolo";
    public static final String TAG_ID = "ID";
    public static final String TAG_CONSULTA = "Consulta";
    public static final String TAG_SOLICITA_RESULTADO = "SolicitaResultado";
    public static final String TAG_SOLICITA_LOTE = "SolicitaLote";
    public static final String TAG_OPERACAO = "Operacao";
    public static final String TAG_ACAO = "Acao";
    public static final String TAG_DATA_INICIAL = "DataInicial";
    public static final String TAG_HORA_INICIAL = "HoraInicial";
    public static final String TAG_DATA_FINAL = "DataFinal";
    public static final String TAG_HORA_FINAL = "HoraFinal";
    public static final String TAG_GRAFICO = "Grafico";
    public static final String TAG_UNIDADE_VALOR = "UnidadeNoValor";
    public static final String TAG_DADOS_CONSTANTES = "DadosConstantes";
    private JButton buttonImportarWebService;
    private static String ULTIMO_SQL = "";
    private static final String FORMATO = "formato";
    private static final String FORMATACAO = "formatacao";
    private static final String CODIGO_LAYOUT = "codigo-layout";
    private static final String CABECALHO = "cabecalho";
    private static final String FORMATO_TEXTO = "formatotexto";
    private static final SimpleDateFormat dataMaricondi = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat dataUsuario = new SimpleDateFormat("dd/MM/yyyy");
    private static final DateTimeFormatter dataFormatter = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final DateTimeFormatter dataFormatter2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private ModeloGridTable modeloRelatorio;
    private boolean conferirAutomatico;
    private String codigoUsuarioConferenciaAutomatica;
    private LaboratorioExterno labExterno;
    private String configuracaoLabExterno;
    private JButton buttonImprimir;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImportacaoResultadoMaricondi(int codigoLabExterno) {
        Statement st;
        block6: {
            boolean enviarUsandoWS;
            super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Lab. Maricondi a partir de arquivo XML", codigoLabExterno, Protocolo.Maricondi, new JPanel(new FlowLayout(2)));
            this.debug = true;
            this.requisicoes = null;
            this.buttonImportarWebService = ComponenteFactory.novoJButton("Importar Webservice", 'W', this);
            this.modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
            this.conferirAutomatico = false;
            this.codigoUsuarioConferenciaAutomatica = null;
            this.labExterno = null;
            this.buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
            this.labExterno = LaboratorioExterno.getLabExterno(Integer.toString(codigoLabExterno));
            this.getPanelAdicional().add(this.buttonImprimir);
            this.configuracaoLabExterno = this.labExterno.configuracao;
            this.isWebService = enviarUsandoWS = this.labExterno.configuracao.indexOf("enviarLoteWebservice") > 0 ? StringUtil.getBoolean(this.labExterno.configuracao, "enviarLoteWebservice") : false;
            if (enviarUsandoWS) {
                this.getPanelAdicional().add(this.buttonImportarWebService);
                this.getPanelAdicional().remove(this.buttonImportar);
                this.buttonImportar.setText("Importar Arquivo");
                this.getPanelAdicional().add(this.buttonImportar);
            } else {
                this.buttonImportar.setText("Importar Arquivo");
            }
            st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir from labexterno ");
            buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append("   and lae_codigo = ").append(codigoLabExterno);
            try {
                ResultSet rs = Conexao.executeQuery(st, buf);
                if (!rs.next()) break block6;
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoMaricondi (122)");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
        }
        Conexao.fecharStatement(st);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser();
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Maricondi (*.xml)", "xml"));
            if (chooser.showOpenDialog(this) == 0) {
                ElementoHPardini res = ParserResultadoHPardini.analisarXMLHPardini(chooser.getSelectedFile());
                this.processaRetornosResultado(res, false, false, "", "");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoMaricondi: 35");
        }
    }

    private void processaRetornosResultado(ElementoHPardini res, boolean isWebservice, boolean isRequisicao, String requisicao, String data) throws ParseException {
        if (res != null) {
            List<ElementoHPardini> pedidos;
            StringBuilder str = new StringBuilder();
            if (!res.getNome().equals("Resultados")) {
                this.setTextoInformacoes("\nO XML de resultado inv\u00e1lido");
                return;
            }
            if (res.contemFilho("ControleDeLote")) {
                ElementoHPardini aux = res.getFilho("ControleDeLote");
                str.append("\nControle de Lote \n");
                str.append("  Emissor: ").append(aux.getFilho("Emissor").getValor()).append(" \n");
                str.append("  Data Emiss\u00e3o: ").append(this.formataData(aux.getFilho("DataEmissao").getValor())).append(" \n");
                str.append("  Hora Emiss\u00e3o:   ").append(aux.getFilho("HoraEmissao").getValor()).append(" \n");
                aux = aux.getFilho("Periodo");
                if (aux != null) {
                    str.append("Per\u00edodo \n");
                    if (aux.getFilho(TAG_DATA_INICIAL) != null) {
                        str.append("  Data Inicial: ").append(this.formataData(aux.getFilho(TAG_DATA_INICIAL).getValor())).append(" \n");
                    }
                    if (aux.getFilho(TAG_HORA_INICIAL) != null) {
                        str.append("  Hora Inicial:   ").append(aux.getFilho(TAG_HORA_INICIAL).getValor()).append(" \n");
                    }
                    if (aux.getFilho(TAG_DATA_FINAL) != null) {
                        str.append("  Data Final:   ").append(this.formataData(aux.getFilho(TAG_DATA_FINAL).getValor())).append(" \n");
                    }
                    if (aux.getFilho(TAG_HORA_FINAL) != null) {
                        str.append("  Hora Final:     ").append(aux.getFilho(TAG_HORA_FINAL).getValor()).append(" \n");
                    }
                }
                this.setTextoInformacoes(str.toString());
            }
            if (!(pedidos = res.getFilhos("Pedido")).isEmpty()) {
                this.importarResultados(pedidos);
            } else if (isWebservice) {
                if (isRequisicao) {
                    this.setTextoInformacoes("\nAinda n\u00e3o h\u00e1 resultados liberados na Data informada: " + data, false);
                } else {
                    this.setTextoInformacoes("\nAinda n\u00e3o h\u00e1 resultados liberados para a Requisi\u00e7\u00e3o: " + requisicao, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importarResultados(List<ElementoHPardini> pedidos) {
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st != null) {
            try {
                String req_codigo;
                String fil_codigo;
                this.progress.setValue(0);
                this.progress.setMaximum(pedidos.size());
                this.progress.setVisible(true);
                block6: for (ElementoHPardini pedido : pedidos) {
                    this.progress.setValue(this.progress.getValue() + 1);
                    for (ElementoHPardini superExame : pedido.getFilhos("SuperExame")) {
                        if (pedido.getFilho("CodPedLab") == null || Funcoes.textoVazio(pedido.getFilho("CodPedLab").getValor())) {
                            String codigoPedidoApoio = pedido.getFilho("CodPedApoio").getValor();
                            this.setTextoInformacoes("\nNenhuma requisi\u00e7\u00e3o encontrada para o codigo apoio: " + codigoPedidoApoio, false);
                            continue block6;
                        }
                        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                        if (pedido.getFilho("CodPedLab").getValor().length() != tamTubo) {
                            this.setTextoInformacoes("\nC\u00f3digo da requisi\u00e7\u00e3o recebida \u00e9 incompativel com as configura\u00e7\u00f5es de tubo: " + pedido.getFilho("CodPedLab").getValor(), false);
                            continue block6;
                        }
                        if (!Funcoes.isNumeric(pedido.getFilho("CodPedLab").getValor()) || pedido.getFilho("CodPedLab").getValor().contains(".") || pedido.getFilho("CodPedLab").getValor().contains(",")) {
                            this.setTextoInformacoes("Requisi\u00e7\u00e3o: " + pedido.getFilho("CodPedLab").getValor() + " n\u00e3o gerada pelo Jalis ignorada na importa\u00e7\u00e3o\n", false);
                            continue block6;
                        }
                        fil_codigo = pedido.getFilho("CodPedLab").getValor().substring(0, ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = pedido.getFilho("CodPedLab").getValor().substring(ParametrosGerais.getDigitosTuboFilial());
                        Integer[] multiguias = null;
                        boolean agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(st, fil_codigo, req_codigo);
                        multiguias = agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true) : new Integer[]{Integer.parseInt(req_codigo)};
                        if (null == multiguias || multiguias.length == -1) {
                            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o n\u00e3o encontrada: " + fil_codigo + req_codigo, false);
                            continue;
                        }
                        LinkedList<Registro> listaRegistros = this.processarPaiFilhos(st, pedido, superExame, fil_codigo, req_codigo, false);
                        if (listaRegistros == null || listaRegistros.isEmpty()) {
                            String[] exameJalis = new String[2];
                            exameJalis = superExame.getFilho("CodExmLab").getValor().split("[|]");
                            this.setTextoInformacoes("\n Exame n\u00e3o configurado: Filial: " + fil_codigo + " Requisi\u00e7\u00e3o: " + req_codigo + " Exame: " + exameJalis[0], false);
                            continue;
                        }
                        for (Registro reg : listaRegistros) {
                            if (reg == null) continue;
                            if (this.exameJaLancado(reg)) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.JA_LANCADO, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                continue;
                            }
                            if (!this.exameColetado(reg) && reg != null && !reg.getString("exr_situacao").equals("P")) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_MATERIAL, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                continue;
                            }
                            if (!this.exameRelacionado(reg)) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.SEM_RELACIONAMENTO, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
                                continue;
                            }
                            boolean salvoParcial = reg.getString("exr_situacao").equals("P");
                            StringBuilder resultadoAtual = new StringBuilder();
                            String matPai = reg.getString("mco_codigo");
                            if (!StringUtil.isEmpty(reg.getString("matFilho"))) {
                                reg.setValor("mco_codigo", reg.getString("matFilho"));
                            }
                            Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                            dados.putAll(CamposRelacionamentoHPardiniUtil.getMapCampoValor(superExame, resultadoAtual, reg));
                            if (reg.getValor("examePai") != null) {
                                reg.setValor("exa_codigo", reg.getString("examePai"));
                                reg.setValor("mco_codigo", matPai);
                            }
                            Registro formatacao = salvoParcial ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
                            Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                            Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                            if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                                historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                            }
                            dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                            Resultado res = new Resultado(null, formatacao.getString(FORMATO), dados, null, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, resultadoAtual.toString());
                            res.atualizarComponentes();
                            if (!res.verificarCondicao()) {
                                this.adicionarAoModeloRelatorio(superExame, Situacao.CONDICAO_INSATISFEITA, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                                continue;
                            }
                            if (!this.mesmaVersao(reg.getString("VERSAO"), superExame) && reg.getValor("matFilho") == null) {
                                if (!this.mesmaVersaoEstrutura(formatacao.getString(FORMATO), superExame, fil_codigo)) {
                                    this.adicionarAoModeloRelatorio(superExame, Situacao.VERSAO_INCOMPATIVEL, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                    this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Vers\u00e3o incorreta (Vers\u00e3o e estrutura incorreta)", false);
                                    continue;
                                }
                                this.adicionarAoModeloRelatorio(superExame, Situacao.VERSAO_INCOMPATIVEL, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Relacionamento do exame em desacordo com a vers\u00e3o atual, \u00e9 necess\u00e1rio importar o layout novamente", false);
                            }
                            boolean completo = true;
                            if (reg.getBoolean("exa_salvaparcial")) {
                                completo = res.resultadoCompleto(true);
                            }
                            String novaSituacao = completo ? "L" : "P";
                            String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                            Util.gravaAlteracaoExameRequisicao(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                            boolean marcarConferido = false;
                            if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                                int verificacao = res.verificarValidacao();
                                boolean bl = marcarConferido = verificacao == 1;
                                if (!marcarConferido && verificacao != 2) {
                                    this.adicionarAoModeloRelatorio(superExame, Situacao.VALIDACAO_INSATISFEITA, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                                    this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                                }
                            }
                            String codPedApoio = pedido.getFilho("CodPedApoio").getValor();
                            String[] divisaoCodPedApoio = codPedApoio.split("|");
                            if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), divisaoCodPedApoio[2])) {
                                this.inserirDadosRequisicao(st, this.codigoLabExterno, divisaoCodPedApoio[2], reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                            }
                            boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                            boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                            this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                            if (this.exportarBaseWeb(reg)) {
                                Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                                this.exportarParaWeb(st, this.getCodigoBaseWeb(reg.getString("fil_codigo")), novaSituacao, reg, mapa, resultado, formatacao.getString(FORMATO_TEXTO));
                                if (ExportaWeb.isGerarPdfResultado(st2, reg.getString("fil_codigo"))) {
                                    ExportaWeb.enviarResultadoPDF(st2, reg.getString("fil_codigo"), reg.getString("req_codigo"), this.getCodigoBaseWeb(reg.getString("fil_codigo")));
                                }
                            }
                            this.adicionarAoModeloRelatorio(superExame, completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE, reg.getString("req_codigo"), reg.getString("mco_codigo"), reg.getString("exa_codigo"));
                            if (completo) {
                                Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                                Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                                this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                            }
                            this.atualizarPaginaOrdemExameWeb(st, reg);
                            this.editarRequisicaoExportaFiliais(reg);
                            this.atualizarSituacaoExameInterfaceamento(st, reg);
                            this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + reg.getString("exa_codigo") + " - " + (Object)((Object)(completo ? (marcarConferido ? Situacao.CONFERIDO : Situacao.LANCADO) : Situacao.LANCADO_PARCIALMENTE)), false);
                        }
                    }
                }
                for (ElementoHPardini pedido : pedidos) {
                    for (ElementoHPardini superExame : pedido.getFilhos("SuperExame")) {
                        if (pedido.getFilho("CodPedLab") == null || Funcoes.textoVazio(pedido.getFilho("CodPedLab").getValor())) continue;
                        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
                        if (pedido.getFilho("CodPedLab").getValor().length() != tamTubo || !Funcoes.isNumeric(pedido.getFilho("CodPedLab").getValor()) || pedido.getFilho("CodPedLab").getValor().contains(".") || pedido.getFilho("CodPedLab").getValor().contains(",")) continue;
                        fil_codigo = pedido.getFilho("CodPedLab").getValor().substring(0, ParametrosGerais.getDigitosTuboFilial());
                        req_codigo = pedido.getFilho("CodPedLab").getValor().substring(ParametrosGerais.getDigitosTuboFilial());
                        this.processarPaiFilhos(st, pedido, superExame, fil_codigo, req_codigo, true);
                    }
                }
                Conexao.arquivaSQL();
                this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > -1);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(this, e.getMessage() + "\nSQL: " + ULTIMO_SQL, e.getStackTrace(), "ImportacaoResultadoMaricondi: 114");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st, st2);
                    throw throwable;
                }
                Conexao.fecharStatement(st, st2);
            }
            Conexao.fecharStatement(st, st2);
        }
        this.progress.setVisible(false);
    }

    private LinkedList<Registro> processarPaiFilhos(Statement st, ElementoHPardini pedido, ElementoHPardini exResultado, String fil_codigo, String req_codigo, boolean isLogEmailSMS) throws Exception {
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        Integer[] multiguias = null;
        boolean agruparMultiguias = ParametrosGerais.isAgruparGuiasInterface() || this.labExterno.agruparMultiguias;
        multiguias = agruparMultiguias ? RecepcaoUtil.verificaMultiGuias(fil_codigo, req_codigo, true) : new Integer[]{Integer.parseInt(req_codigo)};
        String[] exameJalis = new String[2];
        if (exResultado.contemFilho("CodExmLab") && !Funcoes.textoVazio(exResultado.getFilho("CodExmLab").getValor()) && ((exameJalis = exResultado.getFilho("CodExmLab").getValor().split("[|]")).length < 2 || Funcoes.textoVazio(exameJalis[0]) || !Funcoes.isNumeric(exameJalis[1]))) {
            return retorno;
        }
        for (Integer multiguia : multiguias) {
            ExameDesmembrado pai;
            Registro exameSeparado = this.localizarExameRequisicao(fil_codigo, multiguia.toString(), exameJalis[0], exameJalis[1]);
            if (exameSeparado == null) continue;
            retorno.add(exameSeparado);
            if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                SMSUtil.criaLogSmsComDadosRequisicao(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
            }
            if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                EmailUtil.criaLogEmail(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
            }
            if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                PushUtil.criaLogPushComDadosRequisicao(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), TipoPush.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
            }
            if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !WhatsAppUtil.isBloquearWhatsappExamePronto(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), Conexao.getStatement())) {
                WhatsAppUtil.criaLogWhatsappComDadosRequisicao(exameSeparado.getString("fil_codigo"), exameSeparado.getString("req_codigo"), TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
            }
            if ((pai = this.getExamesDesmembrados(fil_codigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exameJalis[0], exameJalis[1])) == null) continue;
            String codigoJalisTemp = exameJalis[0];
            Registro reg = this.localizarExameRequisicao(fil_codigo, multiguia.toString(), pai.getCodigoExame(), String.valueOf(pai.getCodigomaterial()));
            if (reg == null) continue;
            reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
            reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
            reg.setValor("examePai", pai.getCodigoExame());
            reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
            reg.setValor("matFilho", pai.getFilhos().get(0).getCodigomaterial());
            retorno.add(reg);
            if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                SMSUtil.criaLogSmsComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), ExportaSMS.TipoSMS.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
            }
            if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                EmailUtil.criaLogEmail(reg.getString("fil_codigo"), reg.getString("req_codigo"), null, EmailUtil.TipoEmail.RESULTADO, true, st);
            }
            if (isLogEmailSMS && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) {
                PushUtil.criaLogPushComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoPush.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
            }
            if (!isLogEmailSMS || !this.conferirAutomatico || Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) || WhatsAppUtil.isBloquearWhatsappExamePronto(reg.getString("fil_codigo"), reg.getString("req_codigo"), Conexao.getStatement())) continue;
            WhatsAppUtil.criaLogWhatsappComDadosRequisicao(reg.getString("fil_codigo"), reg.getString("req_codigo"), TipoWhatsapp.RESULTADO, Conexao.getStatement(), Conexao.getStatement());
        }
        return retorno;
    }

    protected StringBuilder getSqlLocalizaExame(String fil, String req, String exa, String mco) {
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  a.fil_codigo, a.req_codigo, a.des_codigo, a.con_codigo, a.pac_codigo,  a.req_idade, a.req_anomes, \n");
        sql.append("  b.exa_codigo, b.mco_codigo, b.exr_situacao, pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, COALESCE(g.met_codigo, b.met_codigo) as met_codigo, \n");
        sql.append("  c.pac_idade, c.pac_anomes, b.exr_datamaterial, \n");
        sql.append("  d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, a.req_xmlagendamentoids as xmlAgendamentoIDS, a.req_integracaohospital, \n");
        sql.append("  a.req_guia, b.exr_solicitadotiss, b.exr_codautorizacao \n");
        sql.append("from requisicao a \n");
        sql.append("left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append("left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo \n");
        sql.append("left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' \n");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        sql.append("  b.exa_codigo = '").append(exa).append("' and \n");
        sql.append("  b.mco_codigo = ").append(mco).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false \n");
        return sql;
    }

    private Registro localizarExameRequisicao(String filial, String requisicao, String exame, String material) throws SQLException {
        Statement st = Conexao.getStatement();
        if (st != null) {
            StringBuilder sql = this.getSqlLocalizaExame(filial, requisicao, exame, material);
            ULTIMO_SQL = sql.toString();
            ResultSet res = Conexao.executeQuery(st, ULTIMO_SQL);
            if (res.next()) {
                Registro reg = new Registro(res);
                reg.setValor(CODIGO_LAYOUT, ExameUtil.getCodigoLayout(filial, res.getString("con_codigo"), res.getString("des_codigo")));
                reg.setValor(CABECALHO, ExameUtil.getCabecalhoRodape(filial, reg.getString(CODIGO_LAYOUT)));
                Registro formatacao = new Registro();
                formatacao.setValor(FORMATO, reg.getValor("exr_resultado"));
                formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
                reg.setValor(FORMATACAO, formatacao);
                reg.setValor("VERSAO", StringUtil.getValor(reg.getString("ele_xmllabexterno"), "CodigoFormato"));
                return reg;
            }
            if (!Funcoes.textoVazio(exame) && !Funcoes.textoVazio(requisicao)) {
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, requisicao, exame, null, Situacao.NAO_LOCALIZADO.descricao);
            }
        }
        return null;
    }

    private boolean exameJaLancado(Registro reg) {
        String sit = reg.getString("exr_situacao");
        return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    private String formataData(String data) throws ParseException {
        return dataUsuario.format(dataMaricondi.parse(data));
    }

    private void atualizarPaginaOrdemExameWeb(Statement st, Registro dados) throws Exception {
        ExportaWeb.atualizaPaginaOrdemExameWeb(st, dados.getString("fil_codigo"), dados.getString("req_codigo"), Variaveis.codigoBaseWeb);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoMaricondi (1506)");
        }
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private boolean mesmaVersao(String versao, ElementoHPardini superExame) {
        return superExame.contemFilho("CodigoFormato") && superExame.getFilho("CodigoFormato").getValor().equals(versao);
    }

    /*
     * Exception decompiling
     */
    private boolean mesmaVersaoEstrutura(String formato, ElementoHPardini superExame, String filial) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean verificaCDDATA(String campo, String valor, String xml) {
        String abre = "<" + campo + ">";
        String fecha = "</" + campo + ">";
        if (valor.toLowerCase().indexOf(abre) >= 0) {
            xml = xml + valor.substring(0, valor.toLowerCase().indexOf(abre) + abre.length()) + "<![CDATA[" + valor.substring(valor.toLowerCase().indexOf(abre) + abre.length(), valor.toLowerCase().indexOf(fecha)) + "]]>" + valor.substring(valor.toLowerCase().indexOf(fecha)) + "\n";
            return true;
        }
        return false;
    }

    private boolean exportarBaseWeb(Registro reg) {
        try {
            Statement st = Conexao.getStatement();
            FilialService filService = new FilialService();
            FilialVOAux filialVO = filService.getDadosExportaBaseWeb(st, reg.getString("fil_codigo"));
            if (this.carregouVO(filialVO)) {
                return this.isExportarBaseWeb(filialVO);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoHPardini: 261");
        }
        return false;
    }

    private boolean carregouVO(FilialVO filialVO) {
        return filialVO != null;
    }

    private boolean isExportarBaseWeb(FilialVOAux filialVO) {
        return !Funcoes.textoVazio(filialVO.getTipoBase()) && filialVO.isWebStandAlone() == false;
    }

    private void adicionarAoModeloRelatorio(ElementoHPardini superExame, Situacao situacao, String req, String metodo, String exame) {
        ElementoHPardini pedido = superExame.getPai();
        if (pedido != null && pedido.contemFilho("CodPedLab") && pedido.getFilho("CodPedLab").getValor().length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() && superExame.contemFilho("CodExmLab")) {
            String str = superExame.getFilho("CodExmLab").getValor();
            String exa = exame;
            String mco = metodo;
            String requisicao = pedido.getFilho("CodPedLab").getValor();
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
            if (!situacao.equals((Object)Situacao.VERSAO_INCOMPATIVEL)) {
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filial, req, exa, Integer.parseInt(mco), situacao.descricao);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else if (e.getSource() == this.buttonImportarWebService) {
            if (this.isWebService) {
                this.requisicoes = null;
                SolicitaPeriodo solicita = SolicitaPeriodo.novaInstancia(this.getTopLevelAncestor());
                solicita.setVisible(true);
                if (solicita.isOk()) {
                    if (solicita.isPeriodoSelecionado()) {
                        this.solicitarWebServiceData(solicita.getDataInicial(), solicita.getDataFinal());
                    } else {
                        this.solicitarWebServiceRequisicao(solicita.getFiltroFilial(), solicita.getFiltroRequisicao());
                    }
                }
            }
        } else if (e.getSource() == this.buttonImportar) {
            this.importarResultado();
        } else {
            super.actionPerformed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void solicitarWebServiceRequisicao(String filtroFilial, String filtroRequisicao) {
        String senha = StringUtil.getValor(this.configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CHAVE.getTag());
        String agente = StringUtil.getValor(this.configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag());
        String enderecoWebService = this.configuracaoLabExterno.indexOf(TAG_ENDERECO_WEBSERVICE) >= 0 ? StringUtil.getValor(this.configuracaoLabExterno, TAG_ENDERECO_WEBSERVICE) : null;
        String cid = Funcoes.preencheZero(filtroFilial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(filtroRequisicao, ParametrosGerais.getDigitosTuboRequisicao());
        this.setTextoInformacoes("Iniciando a consulta dos resultado...", true);
        this.setTextoInformacoes("\nSolicitando resultados da Requisi\u00e7\u00e3o: " + cid, false);
        HttpURLConnection urlConnection = null;
        try {
            if (UtilExportadores.comunicacaoOk(enderecoWebService, false, Protocolo.Maricondi.getDescricao()).isImprimiu()) {
                String linha;
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                if (enderecoWebService.contains("https")) {
                    sc.init(null, trustAllCerts, new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                }
                URL url = new URL(enderecoWebService + "/recebeResultados");
                urlConnection = (HttpURLConnection)url.openConnection();
                urlConnection.setDoOutput(true);
                urlConnection.setDoInput(true);
                urlConnection.setRequestMethod("POST");
                urlConnection.setRequestProperty("Content-type", "application/xml; charset=ISO-8859-1");
                urlConnection.setRequestProperty("idcliente", agente);
                urlConnection.setRequestProperty("chaveseguranca", senha);
                urlConnection.setRequestProperty("cid", cid);
                urlConnection.connect();
                OutputStream os = urlConnection.getOutputStream();
                BufferedReader leitura = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.ISO_8859_1));
                StringBuilder retornoWebService = new StringBuilder();
                StringBuilder erro = new StringBuilder();
                while ((linha = leitura.readLine()) != null) {
                    retornoWebService.append(linha);
                }
                leitura.close();
                if (this.debug) {
                    System.out.println("=====XML RETORNO=====");
                    System.out.println(retornoWebService.toString());
                }
                if (!Funcoes.textoVazio(retornoWebService.toString())) {
                    if (retornoWebService.toString().contains("status")) {
                        JSONObject jsonObject = new JSONObject(retornoWebService.toString());
                        String erroDescricao = jsonObject.getString("detalhes");
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Retorno Apoio: Erro ao buscar resultado por requisi\u00e7\u00e3o. Integra\u00e7\u00e3o: " + erroDescricao, 2);
                    } else if (retornoWebService.toString().contains("message")) {
                        Funcoes.mensagem(Laboratorio.getInstancia(), "Retorno Apoio: Erro ao buscar resultado por requisi\u00e7\u00e3o.", 2);
                    } else {
                        this.setTextoInformacoes("\nXML recebido. Iniciando a importa\u00e7\u00e3o de resultados...", false);
                        String retorno = retornoWebService.toString();
                        ElementoHPardini res = ParserResultadoHPardini.analisarXMLHPardini(new ByteArrayInputStream(retorno.getBytes("ISO-8859-1")));
                        if (res == null) {
                            this.setTextoInformacoes("\nAinda n\u00e3o h\u00e1 resultados liberados na Requisi\u00e7\u00e3o: " + cid, false);
                        } else {
                            this.processaRetornosResultado(res, true, true, cid, null);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel receber o resultado.\n" + e.getMessage(), e.getStackTrace());
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void solicitarWebServiceData(String dataInicial, String dataFinal) {
        String senha = StringUtil.getValor(this.configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CHAVE.getTag());
        String agente = StringUtil.getValor(this.configuracaoLabExterno, TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag());
        String enderecoWebService = this.configuracaoLabExterno.indexOf(TAG_ENDERECO_WEBSERVICE) >= 0 ? StringUtil.getValor(this.configuracaoLabExterno, TAG_ENDERECO_WEBSERVICE) : null;
        String[] dataSeparadaInicial = dataInicial.split("/");
        LocalDate dataInicialLC = LocalDate.of((int)Integer.valueOf(dataSeparadaInicial[2]), Integer.valueOf(dataSeparadaInicial[1]), (int)Integer.valueOf(dataSeparadaInicial[0]));
        String[] dataSeparadaFinal = dataFinal.split("/");
        LocalDate dataFinalLC = LocalDate.of((int)Integer.valueOf(dataSeparadaFinal[2]), Integer.valueOf(dataSeparadaFinal[1]), (int)Integer.valueOf(dataSeparadaFinal[0]));
        this.setTextoInformacoes("Iniciando a consulta dos resultado...", true);
        while (!dataInicialLC.isAfter(dataFinalLC)) {
            this.setTextoInformacoes("\nSolicitando resultados do Dia: " + dataInicialLC.format(dataFormatter), false);
            HttpURLConnection urlConnection = null;
            try {
                if (UtilExportadores.comunicacaoOk(enderecoWebService, false, Protocolo.Maricondi.getDescricao()).isImprimiu()) {
                    String linha;
                    TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return null;
                        }

                        @Override
                        public void checkClientTrusted(X509Certificate[] certs, String authType) {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] certs, String authType) {
                        }
                    }};
                    SSLContext sc = SSLContext.getInstance("SSL");
                    if (enderecoWebService.contains("https")) {
                        sc.init(null, trustAllCerts, new SecureRandom());
                        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                    }
                    URL url = new URL(enderecoWebService + "/recebeResultadosPendentes");
                    urlConnection = (HttpURLConnection)url.openConnection();
                    urlConnection.setDoOutput(true);
                    urlConnection.setDoInput(true);
                    urlConnection.setRequestMethod("POST");
                    urlConnection.setRequestProperty("Content-type", "application/xml; charset=ISO-8859-1");
                    urlConnection.setRequestProperty("idcliente", agente);
                    urlConnection.setRequestProperty("chaveseguranca", senha);
                    urlConnection.setRequestProperty("devento", dataInicialLC.format(dataFormatter2));
                    urlConnection.connect();
                    OutputStream os = urlConnection.getOutputStream();
                    BufferedReader leitura = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.ISO_8859_1));
                    StringBuilder retornoWebService = new StringBuilder();
                    StringBuilder erro = new StringBuilder();
                    while ((linha = leitura.readLine()) != null) {
                        retornoWebService.append(linha);
                    }
                    leitura.close();
                    if (this.debug) {
                        System.out.println("=====XML RETORNO=====");
                        System.out.println(retornoWebService.toString());
                    }
                    if (!Funcoes.textoVazio(retornoWebService.toString())) {
                        if (retornoWebService.toString().contains("status")) {
                            JSONObject jsonObject = new JSONObject(retornoWebService.toString());
                            String erroDescricao = jsonObject.getString("detalhes");
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Retorno Apoio: Erro ao buscar resultado por per\u00edodo. Integra\u00e7\u00e3o: " + erroDescricao, 2);
                        } else if (retornoWebService.toString().contains("message")) {
                            Funcoes.mensagem(Laboratorio.getInstancia(), "Retorno Apoio: Erro ao buscar resultado por per\u00edodo.", 2);
                        } else {
                            this.setTextoInformacoes("\nXML recebido. Iniciando a importa\u00e7\u00e3o de resultados...", false);
                            String retorno = retornoWebService.toString();
                            ElementoHPardini res = ParserResultadoHPardini.analisarXMLHPardini(new ByteArrayInputStream(retorno.getBytes("ISO-8859-1")));
                            if (res == null) {
                                this.setTextoInformacoes("\nAinda n\u00e3o h\u00e1 resultados liberados na Data informada: " + dataInicialLC.format(dataFormatter), false);
                            } else {
                                this.processaRetornosResultado(res, true, false, "", dataInicialLC.format(dataFormatter));
                            }
                        }
                    }
                }
                dataInicialLC = dataInicialLC.plusDays(1L);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel receber o resultado.\n" + e.getMessage(), e.getStackTrace());
            }
            finally {
                if (urlConnection == null) continue;
                urlConnection.disconnect();
            }
        }
        this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada!", false);
    }

    private boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = StringUtil.isEmpty(reg.getString("matFilho")) ? reg.getString("mco_codigo") : reg.getString("matFilho");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "mnemonicoExame");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select mar_xml from examesmatrix where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and mar_codexame = '").append(exa).append("'");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("mar_xml", rs.getString("mar_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameDesmembrado getExamesDesmembrados(String filial, String reqCodigo, String laeCodigo, String exaFilho) {
        Statement st;
        block4: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block4;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ");
                buf.append("       ,a.mco_codigo ");
                buf.append("       ,p.ele_xmllabexterno ");
                buf.append("   from examerequisicao a ");
                buf.append("   join examematcoletalabextdesm e on a.fil_codigo = e.fil_codigo and a.exa_codigo = e.exa_codigo and a.mco_codigo = e.mco_codigo ");
                buf.append("   join examematcoletalabexterno p on e.fil_codigo = p.fil_codigo and e.exa_kodigo = p.exa_codigo and e.mco_codigo = p.mco_codigo and e.lae_codigo = p.lae_codigo ");
                buf.append("  where a.fil_codigo = ").append(filial);
                buf.append("    and a.req_codigo  = ").append(reqCodigo);
                buf.append("    and e.exa_kodigo = '").append(exaFilho).append("' ");
                buf.append("    and e.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block4;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"));
                ex.addFilho(new Exame(exaFilho, res.getInt("mco_codigo"), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 261");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    @Override
    protected void importarResultadoWs() {
    }

    static enum Situacao {
        LANCADO("Lan\u00e7ado"),
        CONFERIDO("Conferido"),
        LANCADO_PARCIALMENTE("Lan\u00e7ado Parcialmente"),
        SEM_COD_EXM_LAB("XML sem campo CodExmLab"),
        NAO_LOCALIZADO("N\u00e3o Localizado"),
        JA_LANCADO("J\u00e1 lan\u00e7ado"),
        VERSAO_INCOMPATIVEL("Vers\u00e3o incompat\u00edvel"),
        CONDICAO_INSATISFEITA("Condi\u00e7\u00e3o insatisfeita"),
        VALIDACAO_INSATISFEITA("Express\u00e3o de valida\u00e7\u00e3o insatisfeita"),
        SEM_MATERIAL("Sem material"),
        SEM_RELACIONAMENTO("Sem relacionamento");

        String descricao;

        private Situacao(String descricao) {
            this.descricao = descricao;
        }
    }
}

