/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.maricondi;

import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.maricondi.ExameMaricondi;
import jalis.laboratorio.util.parsers.maricondi.ParserImportacaoMaricondi;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JProgressBar;

public class ImportacaoMaricondi
extends AbstractImportadorLabExterno {
    private JButton buttonImportarCamposResultado = ComponenteFactory.novoJButton("Importar Campos Resultado", 'R', this);
    private File arquivoExames = null;
    public String configuracoes = null;

    public ImportacaoMaricondi(int codigoLabExterno, String configuracoes) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab. Maricondi a partir de arquivo XLSX", codigoLabExterno, Protocolo.Maricondi);
        this.configuracoes = configuracoes;
    }

    public ImportacaoMaricondi(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames do Lab.Maricondi a partir de arquivo XLSX", codigoLabExterno, Protocolo.Maricondi);
        this.getButtonImportar().setText("Importar Exames");
        this.getPanelBotoes().add((Component)this.buttonImportarCamposResultado, 1);
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImportarCamposResultado) {
            this.habilitarBotoes(false);
            new Thread("Thread de Importa\u00e7\u00e3o de Campos de Resultados"){

                @Override
                public void run() {
                    ImportacaoMaricondi.this.importarCamposResultado();
                }
            }.start();
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void habilitarBotoes(boolean habilitar) {
        super.habilitarBotoes(habilitar);
        this.buttonImportarCamposResultado.setEnabled(habilitar);
    }

    public File lerArquivoExames() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XLSX do Lab. Maricondi (*.xlsx)", "xlsx"));
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile();
        }
        return null;
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        this.arquivoExames = this.lerArquivoExames();
        if (this.arquivoExames == null) {
            return retorno;
        }
        try {
            retorno = this.importaArquivo(StringUtil.lerArquivoXls(this.arquivoExames.getAbsoluteFile(), false), this.progress, Variaveis.filialPadrao);
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoMaricondi: 112");
        }
        this.progress.setVisible(false);
        return retorno;
    }

    public boolean importaArquivo(String xlsxTabela, JProgressBar progress, String filialPadrao) throws InterruptedException, SQLException, NumberFormatException, SalvaDadosException {
        return this.importaArquivo(xlsxTabela, progress, filialPadrao, true);
    }

    public boolean importaArquivo(String xlsxTabela, JProgressBar progress, String filialPadrao, boolean mostrarLog) throws InterruptedException, SQLException, NumberFormatException, SalvaDadosException {
        boolean retorno = false;
        try {
            StringBuilder bui = new StringBuilder();
            this.setTextoInformacoes("");
            this.anexarTextoInformacoes("Importando exames...\n");
            Thread.sleep(50L);
            progress.setValue(0);
            progress.setVisible(true);
            Map<String, ExameMaricondi> excluidos = ParserImportacaoMaricondi.importarExamesMaricondi(xlsxTabela, this.codigoLabExterno, progress, this);
            if (excluidos == null) {
                this.anexarTextoInformacoes(bui.append("\nArquivo XLSX fornecido, n\u00e3o est\u00e1 no formato que foi implementado para importa\u00e7\u00e3o da lista de exames.").toString());
                return false;
            }
            this.anexarTextoInformacoes(bui.append("\nImporta\u00e7\u00e3o conclu\u00edda").toString());
            Thread.sleep(50L);
            if (excluidos.size() > 0) {
                bui.append("\n\nOs seguintes exames abaixo foram exclu\u00eddos: \n\n");
                bui.append("+--------+-------------------------------------------------------------------------+\n");
                bui.append("| CODIGO | DESCRI\u00c7\u00c3O EXAME                                                         |\n");
                bui.append("+--------+-------------------------------------------------------------------------+");
                for (String ex : excluidos.keySet()) {
                    bui.append("\n| ").append(StringUtil.formatarColuna(Funcoes.preencheZero(excluidos.get(ex).getCodigoExame(), 6), 7, 'e'));
                    bui.append("| ").append(StringUtil.formatarColuna(excluidos.get(ex).getDescricaoExame(), 73, 'e')).append("|");
                }
                bui.append("\n+--------+-------------------------------------------------------------------------+");
                this.setTextoInformacoes(bui.toString());
            }
            progress.setVisible(false);
            retorno = true;
        }
        catch (Exception e) {
            retorno = false;
            ErrorLogger.mostraMensagem(this, "N\u00e3o foi possivel importar arquivo - Lab. ".concat(this.protocolo.name()).concat(" ").concat(e.getMessage()), e.getStackTrace());
        }
        return retorno;
    }

    private void importarCamposResultado() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Maricondi (*.xml)", "xml"));
        if (chooser.showOpenDialog(this) == 0) {
            this.setTextoInformacoes("Carregando arquivo \"" + chooser.getSelectedFile().getName() + "\"\n");
            try {
                ElementoHPardini resultados = ParserResultadoHPardini.analisarXMLHPardini(chooser.getSelectedFile());
                if (resultados == null || !resultados.getNome().equals("Resultados")) {
                    this.anexarTextoInformacoes("O arquivo especificado n\u00e3o \u00e9 um XML de campos de resultados do laborat\u00f3rio Maricondi");
                    this.habilitarBotoes(true);
                    return;
                }
                this.progress.setValue(0);
                this.progress.setVisible(true);
                this.anexarTextoInformacoes("Importando campos de resultado...\n");
                List<ElementoHPardini> rejeitados = ParserImportacaoMaricondi.importarCamposResultadoMaricondi(resultados, this.codigoLabExterno, this.progress);
                this.anexarTextoInformacoes("Importa\u00e7\u00e3o conclu\u00edda.\n");
                if (rejeitados.size() > 0) {
                    this.anexarTextoInformacoes("\nOs campos de resultado dos exames listados abaixo n\u00e3o foram importados, pois\n");
                    this.anexarTextoInformacoes("esses exames ainda n\u00e3o foram importados.\n\n");
                    this.anexarTextoInformacoes("\t+-----------------+----------------+\n");
                    this.anexarTextoInformacoes("\t|      EXAME      |    MATERIAL    |\n");
                    this.anexarTextoInformacoes("\t+-----------------+----------------+");
                    for (ElementoHPardini ele : rejeitados) {
                        String tmp = ele.getFilho("CodExmApoio").getValor();
                        String mat = tmp.substring(0, tmp.indexOf(124));
                        String exa = tmp.substring(tmp.indexOf(124) + 1, tmp.lastIndexOf(124));
                        this.anexarTextoInformacoes("\n\t|");
                        this.anexarTextoInformacoes(StringUtil.formatarColuna(exa, 17, 'c'));
                        this.anexarTextoInformacoes("|");
                        this.anexarTextoInformacoes(StringUtil.formatarColuna(mat, 16, 'c'));
                        this.anexarTextoInformacoes("|");
                    }
                    this.anexarTextoInformacoes("\n\t+-----------------+----------------+");
                }
            }
            catch (ParserResultadoHPardiniException e) {
                this.anexarTextoInformacoes(e.getMessage());
                return;
            }
        }
        this.habilitarBotoes(true);
        this.progress.setVisible(false);
    }
}

