/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.maricondi;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.maricondi.CampoMaricondi;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.xml.XMLStringBuilder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ExameMaricondi {
    private static final String TAG_PROTOCOLO = "maricondi";
    private static final String TAG_CODIGO_EXAME = "codigoExame";
    private static final String TAG_DESCRICAO_EXAME = "descricaoExame";
    private static final String TAG_MNEMONICO_EXAME = "mnemonicoExame";
    private static final String TAG_MATERIAL = "material";
    private static final String TAG_DESCRICAO_MATERIAL = "descricaoMaterial";
    private static final String TAG_TUBO = "tubo";
    private static final String TAG_GRUPO_EXAME = "grupoExame";
    private static final String TAG_CAMPOS = "camposExame";
    private String descricaoExame;
    private String mnemonicoExame;
    private String codigoExame;
    private String material;
    private String descricaoMaterial;
    private String tubo;
    private String grupoExame;
    private List<CampoMaricondi> campos;
    private String exameJalis;
    private String materialJalis;
    private String laboratorioExternoJalis;
    private String xmlExame;

    public ExameMaricondi() {
        this.campos = new ArrayList<CampoMaricondi>();
    }

    public ExameMaricondi(String mnemonicoExame, String descricaoExame, String material) {
        this.mnemonicoExame = mnemonicoExame;
        this.descricaoExame = descricaoExame;
        this.material = material;
        this.campos = new ArrayList<CampoMaricondi>();
    }

    public ExameMaricondi(String codigoExame, String descricaoExame, String mnemonicoExame, String material, String descricaoMaterial, String tubo, String grupoExame) {
        this.codigoExame = codigoExame;
        this.descricaoExame = descricaoExame;
        this.mnemonicoExame = mnemonicoExame;
        this.material = material;
        this.descricaoMaterial = descricaoMaterial;
        this.tubo = tubo;
        this.grupoExame = grupoExame;
        this.campos = new ArrayList<CampoMaricondi>();
    }

    public ExameMaricondi(String xml) {
        this.parseXml(xml);
    }

    public String getDescricaoExame() {
        return this.descricaoExame;
    }

    public void setDescricaoExame(String descricaoExame) {
        this.descricaoExame = descricaoExame;
    }

    public String getMnemonicoExame() {
        return this.mnemonicoExame;
    }

    public void setMnemonicoExame(String mnemonicoExame) {
        this.mnemonicoExame = mnemonicoExame;
    }

    public String getCodigoExame() {
        return this.codigoExame;
    }

    public void setCodigoExame(String codigoExame) {
        this.codigoExame = codigoExame;
    }

    public String getExameJalis() {
        return this.exameJalis;
    }

    public void setExameJalis(String exameJalis) {
        this.exameJalis = exameJalis;
    }

    public String getMaterialJalis() {
        return this.materialJalis;
    }

    public void setMaterialJalis(String materialJalis) {
        this.materialJalis = materialJalis;
    }

    public String getMaterial() {
        return this.material;
    }

    public void setMaterial(String material) {
        this.material = material;
    }

    public List<CampoMaricondi> getCampos() {
        return Collections.unmodifiableList(this.campos);
    }

    public void limparCampos() {
        this.campos.clear();
    }

    public void addCampo(CampoMaricondi campo) {
        this.campos.add(campo);
    }

    public String getLaboratorioExternoJalis() {
        return this.laboratorioExternoJalis;
    }

    public void setLaboratorioExternoJalis(String laboratorioExternoJalis) {
        this.laboratorioExternoJalis = laboratorioExternoJalis;
    }

    public String getTubo() {
        return this.tubo;
    }

    public void setTubo(String tubo) {
        this.tubo = tubo;
    }

    public void setCampos(List<CampoMaricondi> campos) {
        this.campos = campos;
    }

    public String getDescricaoMaterial() {
        return this.descricaoMaterial;
    }

    public void setDescricaoMaterial(String descricaoMaterial) {
        this.descricaoMaterial = descricaoMaterial;
    }

    public String getGrupoExame() {
        return this.grupoExame;
    }

    public void setGrupoExame(String grupoExame) {
        this.grupoExame = grupoExame;
    }

    public String getXMLConfiguradoExame() {
        return this.xmlExame;
    }

    public void setXMLConfiguradoExame(String xmlExame) {
        this.xmlExame = xmlExame;
    }

    public String getXml() {
        XMLStringBuilder xml = new XMLStringBuilder();
        try {
            xml.abrir(TAG_PROTOCOLO);
            xml.escrever(TAG_CODIGO_EXAME, this.getMnemonicoExame());
            xml.escrever(TAG_DESCRICAO_EXAME, this.getDescricaoExame());
            xml.escrever(TAG_MATERIAL, this.getMaterial());
            xml.abrir(TAG_CAMPOS);
            for (CampoMaricondi campo : this.campos) {
                campo.escreverXml(xml);
            }
            xml.fechar(TAG_CAMPOS);
            xml.fechar(TAG_PROTOCOLO);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ExameMaricondi");
        }
        return xml.getXML();
    }

    public static boolean isXmlValido(String xml) {
        String valorExame;
        String valorMaricondi = StringUtil.getValor(xml, TAG_PROTOCOLO);
        return valorMaricondi != null && valorMaricondi.trim().length() > 0 && (valorExame = StringUtil.getValor(valorMaricondi, TAG_MNEMONICO_EXAME)) != null && valorExame.trim().length() > 0;
    }

    public String atualizaXml(String codigoLabExterno) {
        String xml = "";
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                xml = Funcoes.textoVazio(this.getXMLConfiguradoExame()) ? this.getXml() : this.getXMLConfiguradoExame();
                StringBuilder bui = new StringBuilder();
                bui.append("update examesmatrix \n");
                bui.append(" set mar_xml = '").append(StringUtil.textoDB(xml)).append("' ");
                bui.append("where fil_codigo = ").append(Variaveis.filialPadrao).append(" \n");
                bui.append(" and  lae_codigo = ").append(codigoLabExterno).append(" \n");
                if (this.getMnemonicoExame() != null) {
                    bui.append(" and  mar_codexame = '").append(this.getMnemonicoExame()).append("' ");
                    bui.append(" and  mar_codexamenumerico = ").append(this.getCodigoExame()).append(" ");
                } else {
                    bui.append(" and  mar_codexame = '").append(this.getCodigoExame()).append("' ");
                }
                SQL = bui.toString();
                Conexao.executeUpdate(Variaveis.filialPadrao, st, SQL);
                this.setXMLConfiguradoExame(xml);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return xml;
    }

    public static Set<ExameMaricondi> getExames(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        HashSet<ExameMaricondi> list = new HashSet<ExameMaricondi>();
        if (res.first()) {
            do {
                list.add(new ExameMaricondi(res));
            } while (res.next());
        }
        return list;
    }

    public static List<ExameMaricondi> getExamesImportados(String codigoLabExterno) {
        ArrayList<ExameMaricondi> exames = new ArrayList<ExameMaricondi>();
        Statement st = Conexao.getStatement();
        String SQL = "";
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder();
                bui.append(" select * \n");
                bui.append("   from examesmatrix \n");
                bui.append("  where fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("        lae_codigo = ").append(codigoLabExterno).append(" \n");
                bui.append("  order by mar_codexamenumerico ");
                SQL = bui.toString();
                ResultSet res = Conexao.executeQuery(st, SQL);
                while (res.next()) {
                    ExameMaricondi exa = new ExameMaricondi(res.getString("mar_xml"));
                    if (exa.getMnemonicoExame() != null) {
                        exa.setCodigoExame(res.getString("mar_codexamenumerico"));
                    }
                    exames.add(exa);
                }
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return exames;
    }

    public ExameMaricondi(ResultSet res) throws SQLException {
        Funcoes.validarNaoNull(res, "res");
        this.exameJalis = res.getString("exa_codigo");
        this.materialJalis = res.getString("mco_codigo");
        this.laboratorioExternoJalis = res.getString("lae_codigo");
        this.parseXml(res.getString("ele_xmllabexterno"));
    }

    public void parseXml(String xml) {
        if (xml != null) {
            this.descricaoExame = StringUtil.getValor(xml, TAG_DESCRICAO_EXAME);
            if (xml.contains(TAG_MNEMONICO_EXAME)) {
                this.codigoExame = StringUtil.getValor(xml, TAG_CODIGO_EXAME);
                this.mnemonicoExame = StringUtil.getValor(xml, TAG_MNEMONICO_EXAME);
                this.descricaoMaterial = StringUtil.getValor(xml, TAG_DESCRICAO_MATERIAL);
                this.tubo = StringUtil.getValor(xml, TAG_TUBO);
                this.grupoExame = StringUtil.getValor(xml, TAG_GRUPO_EXAME);
            } else {
                this.codigoExame = StringUtil.getValor(xml, TAG_CODIGO_EXAME);
            }
            this.material = StringUtil.getValor(xml, TAG_MATERIAL);
            this.campos = new ArrayList<CampoMaricondi>();
            this.xmlExame = xml;
            for (String camposXML : StringUtil.getValores(xml, "campo")) {
                CampoMaricondi campo = new CampoMaricondi();
                campo.setCodigo(StringUtil.getValor(camposXML, "parametro"));
                campo.setComentario(StringUtil.getValor(camposXML, "comentario"));
                campo.setValidade(StringUtil.getValor(camposXML, "validade"));
                campo.setVersao(StringUtil.getValor(camposXML, "versao"));
                this.addCampo(campo);
            }
        }
    }

    public static ExameMaricondi novaInstancia(String xml) {
        Funcoes.validarNaoNull(xml, "xml");
        ExameMaricondi exa = new ExameMaricondi();
        exa.parseXml(xml);
        return exa;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExameMaricondi)) {
            return false;
        }
        ExameMaricondi e = (ExameMaricondi)o;
        return e.codigoExame != null && this.codigoExame != null && e.codigoExame.equals(this.codigoExame) || e.codigoExame == null && this.codigoExame == null && e.mnemonicoExame.equals(this.mnemonicoExame);
    }
}

