/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.maricondi;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.maricondi.TagsConfiguradorProtocoloMaricondi;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.impressao.termica.EditorTermica;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloMaricondi
extends AbstractConfiguradorProtocolo {
    protected JTextField textChave = new TTextField(100, 3);
    protected JTextField textWebService = new TTextField(100, 3);
    protected JButton buttonConfigurarCabecalhoEtiqueta = ComponenteFactory.novoJButton("Configurar impress\u00e3o de etiquetas", this);
    protected JCheckBox checkEnviaLoteUsandoWebService = new JCheckBox("Enviar lote utilizando WebService");
    protected JCheckBox checkEnvioAutomatico = new JCheckBox("Enviar automaticamente pela tela de requisi\u00e7\u00e3o");
    private String xmlCabecalhoEtiqueta = "";

    public static ConfiguradorProtocoloMaricondi novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloMaricondi((Frame)pai, "Configurador Maricondi", codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloMaricondi((Dialog)pai, "Configurador Maricondi", codigoLabExterno);
        }
        return null;
    }

    public ConfiguradorProtocoloMaricondi(Frame pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    public ConfiguradorProtocoloMaricondi(Dialog pai, String titulo, String codigoLabExterno) {
        super(pai, titulo, codigoLabExterno);
        this.montarTela();
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<" + TagsConfiguradorProtocoloMaricondi.TAG_MATRIX.getTag() + ">");
        bui.append(StringUtil.getTag("lote", this.textLote.getText()));
        bui.append(StringUtil.getTag(TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag(), this.textCodigo.getText()));
        bui.append(StringUtil.getTag(TagsConfiguradorProtocoloMaricondi.TAG_CHAVE.getTag(), this.textChave.getText()));
        bui.append(StringUtil.getTag(TagsConfiguradorProtocoloMaricondi.TAG_ENDERECO_WEBSERVICE.getTag(), this.textWebService.getText()));
        bui.append(StringUtil.getTag(TagsConfiguradorProtocoloMaricondi.TAG_ENVIAR_UTILIZANDO_WEBSERVICE.getTag(), this.checkEnviaLoteUsandoWebService.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TagsConfiguradorProtocoloMaricondi.TAG_ENVIO_AUTOMATICO_REQUISICAO.getTag(), this.checkEnvioAutomatico.isSelected() ? "true" : "false"));
        bui.append(StringUtil.getTag(TagsConfiguradorProtocoloMaricondi.TAG_CONFIGURADOR_CABECALHO_ETIQUETA.getTag(), this.xmlCabecalhoEtiqueta));
        return bui.append("</" + TagsConfiguradorProtocoloMaricondi.TAG_MATRIX.getTag() + ">").toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            if ((xml = StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_MATRIX.getTag())).contains(TagsConfiguradorProtocoloMaricondi.TAG_EMPRESA.getTag())) {
                this.textCodigo.setText(StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag()));
                this.textChave.setText(StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_EMPRESA.getTag()));
                this.textLote.setText(StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_LOTE.getTag()));
            } else {
                this.textCodigo.setText(StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_CODIGO_PROTOCOLO.getTag()));
                this.textChave.setText(StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_CHAVE.getTag()));
                this.textLote.setText(StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_LOTE.getTag()));
                this.textWebService.setText(StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_ENDERECO_WEBSERVICE.getTag()));
                this.xmlCabecalhoEtiqueta = StringUtil.getValor(xml, TagsConfiguradorProtocoloMaricondi.TAG_CONFIGURADOR_CABECALHO_ETIQUETA.getTag());
                if (StringUtil.getBoolean(xml, TagsConfiguradorProtocoloMaricondi.TAG_ENVIAR_UTILIZANDO_WEBSERVICE.getTag())) {
                    this.checkEnviaLoteUsandoWebService.setSelected(true);
                } else {
                    this.checkEnviaLoteUsandoWebService.setSelected(false);
                }
                if (StringUtil.getBoolean(xml, TagsConfiguradorProtocoloMaricondi.TAG_ENVIO_AUTOMATICO_REQUISICAO.getTag())) {
                    this.checkEnvioAutomatico.setSelected(true);
                } else {
                    this.checkEnvioAutomatico.setSelected(false);
                }
            }
        }
    }

    private void montarTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        JLabel labelCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(85, 20));
        JLabel labelLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(85, 20));
        JLabel labelChave = ComponenteFactory.novoJLabel("Chave:", new Dimension(85, 20));
        JLabel labelWebService = ComponenteFactory.novoJLabel("Web Service:", new Dimension(85, 20));
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridwidth = 1;
        cons.gridheight = 1;
        this.getPanelCentral().add((Component)labelLote, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelCodigo, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelChave, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)labelWebService, cons);
        ++cons.gridx;
        cons.gridy = 0;
        cons.fill = 2;
        cons.weightx = 1.0;
        this.textLote.setHorizontalAlignment(4);
        this.getPanelCentral().add((Component)this.textLote, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.textChave, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.textWebService, cons);
        cons.gridx = 0;
        cons.gridy = 6;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnviaLoteUsandoWebService, cons);
        cons.gridx = 0;
        cons.gridy = 7;
        cons.gridwidth = 3;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        cons.gridx = 0;
        cons.gridy = 8;
        cons.gridwidth = 3;
        cons.gridheight = 6;
        this.getPanelCentral().add((Component)this.buttonConfigurarCabecalhoEtiqueta, cons);
        this.buttonConfigurarCabecalhoEtiqueta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTermica termica = EditorTermica.novaInstancia(Laboratorio.getInstancia(), "Configurando ", true, true);
                if (!Funcoes.textoVazio(ConfiguradorProtocoloMaricondi.this.xmlCabecalhoEtiqueta)) {
                    termica.setDocumento(ConfiguradorProtocoloMaricondi.this.xmlCabecalhoEtiqueta);
                }
                termica.setVisible(true);
                if (!Funcoes.textoVazio(termica.getDocumento())) {
                    ConfiguradorProtocoloMaricondi.this.xmlCabecalhoEtiqueta = termica.getDocumento();
                }
            }
        });
        this.checkEnvioAutomatico.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfiguradorProtocoloMaricondi.this.checkEnvioAutomatico.isSelected()) {
                    ConfiguradorProtocoloMaricondi.this.checkEnviaLoteUsandoWebService.setSelected(true);
                }
            }
        });
        this.checkEnviaLoteUsandoWebService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ConfiguradorProtocoloMaricondi.this.checkEnviaLoteUsandoWebService.isSelected()) {
                    ConfiguradorProtocoloMaricondi.this.checkEnvioAutomatico.setSelected(false);
                }
            }
        });
        this.setSize(new Dimension(510, 320));
        this.setLocationRelativeTo(this.getParent());
        ScreenUtil.requisitarFoco(this.textChave);
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textCodigo.getText())) {
            Funcoes.mensagem(this, "Informe o campo c\u00f3digo.", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
            return false;
        }
        if (Funcoes.textoVazio(this.textChave.getText())) {
            Funcoes.mensagem(this, "Informe o campo chave.", 2);
            ScreenUtil.requisitarFoco(this.textChave);
            return false;
        }
        if (this.checkEnviaLoteUsandoWebService.isSelected() && Funcoes.textoVazio(this.textWebService.getText())) {
            Funcoes.mensagem(this, "Informe o campo web services.", 2);
            ScreenUtil.requisitarFoco(this.textWebService);
            return false;
        }
        return true;
    }
}

