/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.maricondi;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.maricondi.CamposImportacaoHPardini;
import jalis.laboratorio.util.parsers.maricondi.Elemento;
import jalis.laboratorio.util.parsers.maricondi.ParserElemento;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardini;
import jalis.laboratorio.util.parsers.pardini.resultado.ParserResultadoHPardiniException;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;

public class CamposRelacionamentoMaricondiUtil {
    public static Map<String, Object> getMapCampoValor(Object origem, StringBuilder resultadoAtual, Registro reg) {
        if (origem != null) {
            Funcoes.validarInstanciaDe(ElementoHPardini.class, origem, "origem");
            ElementoHPardini superExa = (ElementoHPardini)origem;
            if (!superExa.getNome().equals("SuperExame")) {
                throw new IllegalArgumentException("A origem especificada n\u00e3o \u00e9 um elemento SuperExame");
            }
            HashMap<String, Object> mapa = new HashMap<String, Object>();
            CamposRelacionamentoMaricondiUtil.carregarCampos(mapa, superExa, "", resultadoAtual, reg);
            return mapa;
        }
        return null;
    }

    public static void carregarCampos(Map<String, Object> mapa, ElementoHPardini ele, String caminho, StringBuilder resultadoAtual, Registro reg) {
        String novoCaminho = caminho + CamposRelacionamentoMaricondiUtil.getNomeAtributo(ele);
        if (!ele.contemFilhos()) {
            mapa.put(novoCaminho, ele.getValor());
            CamposRelacionamentoMaricondiUtil.atualizaXmlResultadoAtual(reg, resultadoAtual, ele);
            CamposRelacionamentoMaricondiUtil.adicionaValorExameDesmemmbrado(reg, mapa, ele, novoCaminho);
        } else {
            novoCaminho = novoCaminho + "|";
            for (ElementoHPardini filho : ele.getFilhos()) {
                CamposRelacionamentoMaricondiUtil.carregarCampos(mapa, filho, novoCaminho, resultadoAtual, reg);
            }
        }
    }

    private static void adicionaValorExameDesmemmbrado(Registro reg, Map<String, Object> dados, ElementoHPardini ele, String caminho) {
        if (reg.getString("examePai") != null) {
            String chave = caminho.trim() + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, ele.getValor());
        }
    }

    private static void atualizaXmlResultadoAtual(Registro reg, StringBuilder resultadoAtual, ElementoHPardini ele) {
        String tag = reg.getValor("exameFilho") == null ? reg.getValor("exa_codigo").toString() : reg.getValor("exameFilho").toString();
        tag = tag.toLowerCase();
        resultadoAtual.append("<").append(tag).append(">");
        resultadoAtual.append(ele.getValor());
        resultadoAtual.append("</").append(tag).append(">");
    }

    public static String getStringCaminhoDeCampoSelecionado(ElementoHPardini[] caminho) {
        StringBuilder bui = new StringBuilder();
        for (ElementoHPardini ele : caminho) {
            if (bui.length() > 0) {
                bui.append('|');
            }
            bui.append(CamposRelacionamentoMaricondiUtil.getNomeAtributo(ele));
        }
        return bui.toString();
    }

    private static String getNomeAtributo(ElementoHPardini ele) {
        StringBuilder bui = new StringBuilder(ele.getNome());
        if (ele.contemAtributoID()) {
            bui.append(':');
            bui.append(ele.getNomeAtributoID());
            bui.append('=');
            bui.append(ele.getValorAtributoID());
        }
        return bui.toString();
    }

    public static ElementoHPardini getCampoDoSuperExame(ElementoHPardini superExame, String caminhoDoCampo) {
        Funcoes.validarNaoNull(superExame, "superExame");
        Funcoes.validarNaoNull(caminhoDoCampo, "caminhoDoCampo");
        if (!"SuperExame".equals(superExame.getNome())) {
            throw new IllegalArgumentException("O par\u00e2metro superExame n\u00e3o \u00e9 o elemento SuperExame do XML do Lab. Maricondi");
        }
        ParserElemento parser = new ParserElemento(caminhoDoCampo);
        return CamposRelacionamentoMaricondiUtil.procurarCampo(superExame, parser.proximoElemento(), parser);
    }

    private static ElementoHPardini procurarCampo(ElementoHPardini eleHP, Elemento candidato, ParserElemento parser) {
        if (CamposRelacionamentoMaricondiUtil.iguais(eleHP, candidato.nome, candidato.idNome, candidato.idValor)) {
            if (!eleHP.contemFilhos()) {
                return eleHP;
            }
            Elemento novoCandidato = parser.proximoElemento();
            for (ElementoHPardini filho : eleHP.getFilhos()) {
                ElementoHPardini encontrado = CamposRelacionamentoMaricondiUtil.procurarCampo(filho, novoCandidato, parser);
                if (encontrado == null) continue;
                return encontrado;
            }
        }
        return null;
    }

    public static boolean iguais(ElementoHPardini elemento, String nomeCampo, String nomeID, String valorID) {
        if (elemento != null && elemento.getNome().equals(nomeCampo)) {
            if (elemento.contemAtributoID()) {
                return elemento.getNomeAtributoID().equals(nomeID) && elemento.getValorAtributoID().equals(valorID);
            }
            return nomeID == null;
        }
        return false;
    }

    public static CamposImportacao carregarCampos(String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Lab. Maricondi (*.xml)", "xml"));
        if (chooser.showOpenDialog(Laboratorio.getInstancia()) == 0) {
            try {
                ElementoHPardini raiz = ParserResultadoHPardini.analisarXMLHPardini(chooser.getSelectedFile());
                ElementoHPardini superExame = CamposRelacionamentoMaricondiUtil.localizarSuperExame(raiz, codigoExameLabApoio);
                if (superExame != null) {
                    return new CamposImportacaoHPardini(superExame, codigoExamePai, codigoMaterialPai);
                }
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CamposRelacionamentoMaricondiUtil: 93");
            }
        }
        return null;
    }

    private static ElementoHPardini localizarSuperExame(ElementoHPardini ele, String codigoExame) {
        if (ele.getNome().equals("SuperExame") && ele.contemFilhos() && ele.getFilho("CodExmApoio").getValor().equals(codigoExame)) {
            return ele;
        }
        if (ele.contemFilhos()) {
            for (ElementoHPardini filho : ele.getFilhos()) {
                ElementoHPardini superExame = CamposRelacionamentoMaricondiUtil.localizarSuperExame(filho, codigoExame);
                if (superExame == null) continue;
                return superExame;
            }
        }
        return null;
    }

    public static CamposImportacao carregarCamposAutomaticamente(String codigoLabExterno, String codigoExameLabApoio, String codigoExamePai, Integer codigoMaterialPai) {
        StringBuilder SQL = new StringBuilder();
        Statement st = Conexao.getStatement();
        String exa = codigoExameLabApoio.substring(0, codigoExameLabApoio.indexOf(124));
        if (!(null == st || Funcoes.textoVazio(codigoLabExterno) || Funcoes.textoVazio(codigoExameLabApoio) || Funcoes.textoVazio(exa))) {
            try {
                String tmp;
                StringBuilder sql = new StringBuilder("select mar_xml \n");
                sql.append("from examesmatrix \n");
                sql.append("where \n  fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                sql.append("  lae_codigo = ").append(codigoLabExterno).append(" and \n");
                if (StringUtil.validaNumero(exa)) {
                    sql.append("  mar_codexamenumerico = ").append(exa);
                } else {
                    sql.append("  mar_codexame = '").append(exa).append("' ");
                }
                ResultSet res = Conexao.executeQuery(st, SQL.append((CharSequence)sql));
                if (res.next() && (tmp = res.getString("mar_xml")).indexOf("<SuperExame>") > -1) {
                    tmp = tmp.substring(tmp.indexOf("<SuperExame>"), tmp.indexOf("</SuperExame>") + "</SuperExame>".length());
                    String[] linhas = tmp.split("\n");
                    String se = "";
                    for (String s : linhas) {
                        if (s.toLowerCase().indexOf("![cdata[") >= 0) {
                            se = se + s + "\n";
                            continue;
                        }
                        if (CamposRelacionamentoMaricondiUtil.verificaCDDATA("metodo", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("descricao", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("nota", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("observacao", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("metodo", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("examenome", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("valor", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("interpretacao", s, se) || CamposRelacionamentoMaricondiUtil.verificaCDDATA("unidadedemedida", s, se)) continue;
                        se = se + s + "\n";
                    }
                    ElementoHPardini superExame = ParserResultadoHPardini.analisarXMLHPardini(new ByteArrayInputStream((se = new String(se.getBytes(), StandardCharsets.UTF_8)).getBytes(StandardCharsets.UTF_8)));
                    if (superExame != null && superExame.getNome().equals("SuperExame") && superExame.contemFilho("CodExmApoio")) {
                        return new CamposImportacaoHPardini(superExame, codigoExamePai, codigoMaterialPai);
                    }
                }
            }
            catch (ParserResultadoHPardiniException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "CarregaCamposRelacionamentoMaricondi: 22");
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace(), "CarregaCamposRelacionamentoMaricondi: 108");
            }
        }
        return null;
    }

    private static boolean verificaCDDATA(String campo, String valor, String xml) {
        String abre = "<" + campo + ">";
        String fecha = "</" + campo + ">";
        if (valor.toLowerCase().indexOf(abre) >= 0) {
            xml = xml + valor.substring(0, valor.toLowerCase().indexOf(abre) + abre.length()) + "<![CDATA[" + valor.substring(valor.toLowerCase().indexOf(abre) + abre.length(), valor.toLowerCase().indexOf(fecha)) + "]]>" + valor.substring(valor.toLowerCase().indexOf(fecha)) + "\n";
            return true;
        }
        return false;
    }
}

