/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.maricondi;

import jalis.laboratorio.util.parsers.CamposImportacao;
import jalis.laboratorio.util.parsers.pardini.resultado.ElementoHPardini;
import jalis.util.Funcoes;

class CamposImportacaoHPardini
implements CamposImportacao {
    private ElementoHPardini superExame;
    private String codigoExamePai;
    private Integer codigoMaterialPai;

    CamposImportacaoHPardini(ElementoHPardini superExame, String codigoExamePai, Integer codigoMaterialPai) {
        Funcoes.validarNaoNull(superExame, "superExame");
        if (!superExame.getNome().equals("SuperExame")) {
            throw new InternalError("O par\u00e2metro superExame deve ser o elemento SuperExame do XML do Maricondi");
        }
        this.superExame = superExame;
        this.codigoExamePai = codigoExamePai;
        this.codigoMaterialPai = codigoMaterialPai;
    }

    @Override
    public String getVersao() {
        if (this.superExame.contemFilho("CodigoFormato")) {
            return this.superExame.getFilho("CodigoFormato").getValor();
        }
        return "0";
    }

    @Override
    public String getCodigoExameLabExterno() {
        if (this.superExame.contemFilho("CodExmApoio")) {
            String str = this.superExame.getFilho("CodExmApoio").getValor();
            if (str.indexOf("|") > 0) {
                return str.substring(str.indexOf(124) + 1, str.lastIndexOf(124));
            }
            return str;
        }
        return "";
    }

    @Override
    public Object getCamposImportacao() {
        return this.superExame;
    }

    @Override
    public Object getCodigoExame() {
        return this.codigoExamePai;
    }

    @Override
    public Integer getMaterialPaiDesm() {
        return this.codigoMaterialPai;
    }
}

