/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.comum.Conexao;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.alvaro.DadoAdicional;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDadosException;
import jalis.util.xml.XMLUtil;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JProgressBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ParserImportacaoJalisWS {
    public static ArrayList<ExameAlvaro> importarDadosAdicionais(File fileDadosAdicionais, int codigoLabExterno, JProgressBar progress) throws Exception {
        try {
            Map<String, List<DadoAdicional>> dadosAdicionais = ParserImportacaoJalisWS.loadDadosAdicionais(fileDadosAdicionais);
            HashMap dadosNaoImportados = new HashMap();
            Statement st = Conexao.getStatement();
            if (dadosAdicionais.size() > 0) {
                Set<ExameAlvaro> examesAlvaro = ParserImportacaoJalisWS.loadExamesAlvaro(st, codigoLabExterno);
                Set<ExameAlvaro> examesRelacionados = ParserImportacaoJalisWS.getExamesRelacionados(codigoLabExterno);
                ArrayList<ExameAlvaro> examesAtualizados = new ArrayList<ExameAlvaro>();
                ArrayList<ExameAlvaro> examesAtualizar = new ArrayList<ExameAlvaro>();
                if (progress != null) {
                    progress.setMaximum(examesAlvaro.size() * 2);
                    progress.setValue(0);
                }
                IntegracaoLabExternoUtil.deletaExame(st, Variaveis.filialPadrao, codigoLabExterno, 1, new Object[0]);
                for (ExameAlvaro exAlvaro : examesAlvaro) {
                    progress.setValue(progress.getValue() + 1);
                    List<DadoAdicional> listDados = dadosAdicionais.get(exAlvaro.getCodigo().trim());
                    if (listDados == null) continue;
                    examesAtualizar.add(exAlvaro);
                    exAlvaro.setDadosAdicionais(listDados);
                }
                for (ExameAlvaro a : examesAtualizar) {
                    for (ExameAlvaro ea : examesRelacionados) {
                        if (!ea.equals(a)) continue;
                        IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, Variaveis.filialPadrao, codigoLabExterno, ea.getExameJalis(), Integer.parseInt(ea.getMaterialJalis()), a.getXml());
                    }
                    examesAtualizados.add(a);
                }
                ParserImportacaoJalisWS.inserirExamesAlvaro(examesAlvaro, st, codigoLabExterno, progress);
                Conexao.arquivaSQL();
                return examesAtualizados;
            }
        }
        catch (SQLException e) {
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException e2) {
                e.printStackTrace();
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoJalisWS: 303");
            return null;
        }
        catch (SalvaDadosException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "ParserImportacaoJalisWS");
        }
        return null;
    }

    private static Set<ExameAlvaro> getExamesRelacionados(int codigoLabExterno) {
        String SQL = "";
        Statement st = Conexao.getStatement();
        if (st != null) {
            try {
                StringBuilder bui = new StringBuilder("select \n");
                bui.append("  a.exa_codigo, a.mco_codigo, a.ele_xmllabexterno, a.lae_codigo \n");
                bui.append("from examematcoletalabexterno a \n");
                bui.append("left join labexterno b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo \n");
                bui.append("where \n");
                bui.append("  b.fil_codigo = ").append(Variaveis.filialPadrao).append(" and \n");
                bui.append("  a.lae_codigo = ").append(codigoLabExterno).append(" and \n");
                bui.append("  a.ele_xmllabexterno is not null and a.ele_xmllabexterno <> '' ");
                return ExameAlvaro.getExames(Conexao.executeQuery(st, SQL + bui.toString()));
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage() + "\nSQL: " + SQL, e.getStackTrace());
            }
        }
        return new HashSet<ExameAlvaro>();
    }

    private static Set<ExameAlvaro> loadExamesAlvaro(Statement st, int codigoLabExterno) throws SQLException {
        HashSet<ExameAlvaro> exames = new HashSet<ExameAlvaro>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, lae_codigo, alv_codexame, alv_codmaterial, alv_descricaoexame, alv_descricaomaterial, alv_xml ");
        sql.append(" from examesalvaro ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(codigoLabExterno);
        ResultSet rs = Conexao.executeQuery(st, sql.toString());
        while (rs.next()) {
            ExameAlvaro e = new ExameAlvaro(rs.getString("alv_xml"));
            e.setCodigo(rs.getString("alv_codexame"));
            e.setDescricao(rs.getString("alv_descricaoexame"));
            e.setMaterial(rs.getString("alv_codmaterial"));
            e.setMaterialDescricao(rs.getString("alv_descricaomaterial"));
            exames.add(e);
        }
        return exames;
    }

    private static Map<String, List<DadoAdicional>> loadDadosAdicionais(File fileDadosAdicionais) throws Exception {
        Document doc;
        HashMap<String, List<DadoAdicional>> dadosAdicionais = new HashMap<String, List<DadoAdicional>>();
        if (fileDadosAdicionais.getName().toLowerCase().endsWith("xml") && (doc = XMLUtil.analisarXML(fileDadosAdicionais)) != null) {
            Element raiz = doc.getDocumentElement();
            if (!raiz.getNodeName().equalsIgnoreCase("exames")) {
                return dadosAdicionais;
            }
            List<Element> filhos = XMLUtil.getElementosFilhos(raiz);
            if (raiz.getNodeName().equalsIgnoreCase("exames")) {
                for (Element e : filhos) {
                    if (!e.getNodeName().equalsIgnoreCase("exame")) continue;
                    ArrayList<DadoAdicional> dadosAdc = new ArrayList<DadoAdicional>();
                    List<Element> filhosEx = XMLUtil.getElementosFilhos(e);
                    String codigo = "";
                    for (Element ef : filhosEx) {
                        if (ef.getNodeName().equalsIgnoreCase("codigo")) {
                            codigo = ef.getTextContent();
                            continue;
                        }
                        if (!ef.getNodeName().equalsIgnoreCase("dadosobrigatorios")) continue;
                        List<Element> filhosDados = XMLUtil.getElementosFilhos(ef);
                        for (Element dobg : filhosDados) {
                            DadoAdicional dadoAd = new DadoAdicional();
                            if (!dobg.getNodeName().equalsIgnoreCase("dado")) continue;
                            List<Element> infosCritica = XMLUtil.getElementosFilhos(dobg);
                            for (Element info : infosCritica) {
                                if (info.getNodeName().equalsIgnoreCase("critica")) {
                                    dadoAd.setDescricao(info.getTextContent());
                                    continue;
                                }
                                if (!info.getNodeName().equalsIgnoreCase("unidade")) continue;
                                dadoAd.setUnidade(info.getTextContent());
                            }
                            dadosAdc.add(dadoAd);
                        }
                    }
                    dadosAdicionais.put(codigo.trim(), dadosAdc);
                }
            }
        }
        return dadosAdicionais;
    }

    private static void inserirExamesAlvaro(Set<ExameAlvaro> exames, Statement st, int codigoLabExterno, JProgressBar progress) throws SalvaDadosException, SQLException {
        for (ExameAlvaro ep : exames) {
            if (progress != null) {
                progress.setValue(progress.getValue() + 1);
            }
            if (Funcoes.textoVazio(ep.getCodigo()) || Funcoes.textoVazio(ep.getMaterial())) continue;
            IntegracaoLabExternoUtil.insertExame(st, Variaveis.filialPadrao, codigoLabExterno, 1, ep.getCodigo(), ep.getMaterial(), ep.getDescricao(), StringUtil.textoDB(ep.getMaterialDescricao() != null ? ep.getMaterialDescricao() : ""), ep.getXml().replace("'", ""));
        }
    }
}

