/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.util.parsers.jalisws.CampoExportacaoJalisWs;
import jalis.util.Funcoes;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ParserExportacaoJalisWs {
    private static final String EXR_RESULTADO = "exr_resultado";
    private static final String ERT_RESULTADOPDF = "ert_resultadopdf";
    private static final String EXR_CODIGO_APOIADO = "exr_codigoapoiado";
    private static final String EXR_CODIGO_EXTERNO = "exr_codigoexterno";
    private static final String ROTULO = "rotulo";

    private ParserExportacaoJalisWs() {
    }

    public static Registro geraRegistroPaciente(Integer codigo, String codigoLis, String codigoAol, Date datanasc, String nome, String sexo) {
        Registro r = new Registro();
        r.setValor(CampoExportacaoJalisWs.TAG_CODIGO.getTag(), codigo);
        r.setValor(CampoExportacaoJalisWs.TAG_CODIGO_LIS.getTag(), codigoLis);
        r.setValor(CampoExportacaoJalisWs.TAG_CODIGO_AOL.getTag(), codigoAol);
        r.setValor(CampoExportacaoJalisWs.TAG_DATANASC.getTag(), datanasc != null ? datanasc : "");
        r.setValor(CampoExportacaoJalisWs.TAG_NOME.getTag(), nome);
        r.setValor(CampoExportacaoJalisWs.TAG_SEXO.getTag(), sexo);
        return r;
    }

    public static Registro geraRegistroMaterial(Integer codigo, String descricao) {
        Registro r = new Registro();
        r.setValor(CampoExportacaoJalisWs.TAG_CODIGO.getTag(), codigo);
        r.setValor(CampoExportacaoJalisWs.TAG_DESCRICAO.getTag(), descricao);
        return r;
    }

    public static Registro geraRegistroSolicitacao(Integer codigo, String codigoAol, String codigoLis, String codigoPaciente) {
        Registro solicitacao = new Registro();
        solicitacao.setValor(CampoExportacaoJalisWs.TAG_CODIGO.getTag(), codigo);
        solicitacao.setValor(CampoExportacaoJalisWs.TAG_CODIGO_AOL.getTag(), codigoAol);
        solicitacao.setValor(CampoExportacaoJalisWs.TAG_CODIGO_LIS.getTag(), codigoLis);
        solicitacao.setValor(CampoExportacaoJalisWs.TAG_PACIENTE.getTag(), codigoPaciente);
        return solicitacao;
    }

    public static Registro geraRegistroResultadoExame(String codigoExame, Date dataResultado, String metodo, String observacao, String normal, ResultSet rs, Map<String, String> amostrasId, boolean codigoapoiado, boolean ignorarRotulo, String tipo) throws SQLException {
        Registro exame = new Registro();
        exame.setValor(CampoExportacaoJalisWs.TAG_CODIGO.getTag(), codigoExame);
        exame.setValor(CampoExportacaoJalisWs.TAG_DATARESULTADO.getTag(), dataResultado);
        exame.setValor(CampoExportacaoJalisWs.TAG_METODO.getTag(), metodo);
        exame.setValor(CampoExportacaoJalisWs.TAG_OBSERVACAO.getTag(), observacao != null ? observacao : "");
        exame.setValor(CampoExportacaoJalisWs.TAG_NORMAL.getTag(), normal);
        return ParserExportacaoJalisWs.trataTipoResultado(rs, amostrasId, codigoapoiado, ignorarRotulo, exame, tipo);
    }

    private static Registro trataTipoResultado(ResultSet rs, Map<String, String> amostrasId, boolean codigoapoiado, boolean ignorarRotulo, Registro exame, String tipo) throws SQLException {
        if (Integer.valueOf(tipo) == 0 && !Funcoes.textoVazio(rs.getString(EXR_RESULTADO))) {
            exame.setValor(CampoExportacaoJalisWs.TAG_RESULTADOS.getTag(), ParserExportacaoJalisWs.geraRegistroLinhasResultadosCampoCampo(rs, amostrasId, codigoapoiado, ignorarRotulo));
        } else {
            String campoImportacao = Integer.valueOf(tipo) == 1 ? CampoExportacaoJalisWs.TAG_RESULTADO_LAYOUT.getTag() : CampoExportacaoJalisWs.TAG_RESULTADO_PDF.getTag();
            exame.setValor(campoImportacao, ParserExportacaoJalisWs.geraRegistroIdLis(rs.getString(EXR_CODIGO_EXTERNO)));
        }
        return exame;
    }

    public static Registro geraResultadoLayoutPorExame(String filialRequisicao, String exameMaterial, String resultadoLayout) {
        Registro exame = new Registro();
        exame.setValor(CampoExportacaoJalisWs.TAG_RESULTADO_LAYOUT.getTag(), ParserExportacaoJalisWs.geraRegistroResultadoLayout(filialRequisicao, exameMaterial, resultadoLayout));
        return exame;
    }

    private static Registro geraRegistroResultadoLayout(String filialRequisicao, String exameMaterial, String resultadoLayout) {
        Registro resultado = new Registro();
        resultado.setValor(CampoExportacaoJalisWs.TAG_CODIGO_LIS.getTag(), filialRequisicao);
        resultado.setValor(CampoExportacaoJalisWs.TAG_ID_LIS.getTag(), exameMaterial);
        resultado.setValor(CampoExportacaoJalisWs.TAG_CONTEUDO_LAYOUT.getTag(), resultadoLayout);
        return resultado;
    }

    public static Registro geraResultadoPDFPorExame(String filialRequisicao, String exameMaterial, String resultadoPDF) {
        Registro exame = new Registro();
        exame.setValor(CampoExportacaoJalisWs.TAG_RESULTADO_PDF.getTag(), ParserExportacaoJalisWs.geraRegistroResultadoPDF(filialRequisicao, exameMaterial, resultadoPDF));
        return exame;
    }

    private static Registro geraRegistroResultadoPDF(String filialRequisicao, String exameMaterial, String resultadoPDF) {
        Registro resultado = new Registro();
        resultado.setValor(CampoExportacaoJalisWs.TAG_CODIGO_LIS.getTag(), filialRequisicao);
        resultado.setValor(CampoExportacaoJalisWs.TAG_ID_LIS.getTag(), exameMaterial);
        resultado.setValor(CampoExportacaoJalisWs.TAG_CONTEUDO_PDF.getTag(), resultadoPDF);
        return resultado;
    }

    private static List<Registro> geraRegistroLinhasResultadosCampoCampo(ResultSet rs, Map<String, String> amostrasId, boolean codigoapoiado, boolean ignorarRotulo) throws SQLException {
        LinkedList<Registro> resultados = new LinkedList<Registro>();
        Map<String, Object> campos = Resultado.getCamposResultado(rs.getString(EXR_RESULTADO));
        for (Map.Entry<String, Object> entry : campos.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Registro resultado = new Registro();
            if (codigoapoiado && !Funcoes.textoVazio(rs.getString(EXR_CODIGO_APOIADO)) && amostrasId.containsKey(rs.getString(EXR_CODIGO_APOIADO))) {
                resultado.setValor(CampoExportacaoJalisWs.TAG_AMOSTRA.getTag(), amostrasId.get(rs.getString(EXR_CODIGO_APOIADO)));
            } else {
                resultado.setValor(CampoExportacaoJalisWs.TAG_AMOSTRA.getTag(), 0);
            }
            if (key.toLowerCase().startsWith(ROTULO) && ignorarRotulo) continue;
            resultado.setValor(CampoExportacaoJalisWs.TAG_LINHA_RESULTADO.getTag(), key);
            resultado.setValor(CampoExportacaoJalisWs.TAG_RESULTADO.getTag(), value);
            resultado.setValor(CampoExportacaoJalisWs.TAG_ID_LIS.getTag(), rs.getString(EXR_CODIGO_EXTERNO));
            resultados.add(resultado);
        }
        return resultados;
    }

    private static Registro geraRegistroIdLis(String idLis) {
        Registro resultado = new Registro();
        resultado.setValor(CampoExportacaoJalisWs.TAG_ID_LIS.getTag(), idLis);
        return resultado;
    }
}

