/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.comum.ParametrosLocais;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.comum.padroes.AbstractDialogoOKCancelar;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.parsers.jalisws.ImportacaoResultadoJalisWSDao;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Date;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class InformaPeriodoImportacaoJalisWS
extends AbstractDialogoOKCancelar {
    private static final String TITULO = "Importa\u00e7\u00e3o via Webservice";
    private static final int ALTURA = 270;
    private static final int LARGURA = 360;
    private static final int CARACTERES_TEMPO = 5;
    private static final int CARACTERES_TEXTO = 10;
    private static final String FILTRO_DATA_INICIAL = "dataInicial";
    private static final String FILTRO_DATA_FINAL = "dataFinal";
    private static final String FILTRO_HORA_INICIAL = "horaInicial";
    private static final String FILTRO_HORA_FINAL = "horaFinal";
    private static final String MSG_VALIDA_FILIAL = "A Filial deve ser informada";
    private TTextField textDataInicial = new TTextField(10, 4);
    private TTextField textDataFinal = new TTextField(10, 4);
    private TTextField textHoraInicial = new TTextField(5, 6);
    private TTextField textHoraFinal = new TTextField(5, 6);
    private TTextField textFilial = new TTextField(10, 1);
    private TTextField textRequisicao = new TTextField(10, 1);
    private JButton buttonFilial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonRequisicao = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataInicial = ComponenteFactory.novoJButton(this, true);
    private JButton buttonDataFinal = ComponenteFactory.novoJButton(this, true);
    private JCheckBox checkBoxPeriodo = new JCheckBox("Periodo: ");
    private JCheckBox checkBoxRequisicao = new JCheckBox("Requisi\u00e7\u00e3o: ");
    private String dataInicial = null;
    private String dataFinal = null;
    private String horaInicial = null;
    private String horaFinal = null;
    private boolean isOk = false;
    private int codigoLabExterno;

    public static InformaPeriodoImportacaoJalisWS novaInstancia(Object pai, int codigoLabExterno) {
        return pai instanceof Dialog ? new InformaPeriodoImportacaoJalisWS((Dialog)pai, codigoLabExterno) : new InformaPeriodoImportacaoJalisWS((Frame)pai, codigoLabExterno);
    }

    public InformaPeriodoImportacaoJalisWS(Dialog pai, int codigoLabExterno) {
        super(pai, TITULO);
        this.codigoLabExterno = codigoLabExterno;
        this.setPeriodo();
        this.montaTela();
    }

    public InformaPeriodoImportacaoJalisWS(Frame pai, int codigoLabExterno) {
        super(pai, TITULO);
        this.codigoLabExterno = codigoLabExterno;
        this.setPeriodo();
        this.montaTela();
    }

    private void montaTela() {
        this.setSize(new Dimension(360, 270));
        this.setResizable(false);
        this.setModal(true);
        this.definirTamanhoComponentes();
        this.desabilitarComponentes();
        this.buttonOK.setText("Importar");
        this.textDataInicial.setText(!Funcoes.textoVazio(this.dataInicial) ? this.dataInicial : "");
        this.textDataFinal.setText(!Funcoes.textoVazio(this.dataFinal) ? this.dataFinal : "");
        this.textHoraInicial.setText(!Funcoes.textoVazio(this.horaInicial) ? this.horaInicial : "");
        this.textHoraFinal.setText(!Funcoes.textoVazio(this.horaFinal) ? this.horaFinal : "");
        JPanel panel = this.getPanelCentral();
        panel.setLayout(new BorderLayout());
        JPanel panelInicial = this.posicionarComponentes();
        JPanel aux = new JPanel(new BorderLayout());
        aux.add((Component)panelInicial, "North");
        panel.add((Component)aux, "West");
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textDataInicial);
        this.adicionarEventos();
        this.setVisible(true);
    }

    private void setPeriodo() {
        String periodoFiltro = ParametrosLocais.getParametro("filtroImportacaoJalisWS");
        Date dataHoraServidor = Funcoes.getDataHoraServidor();
        this.dataInicial = !Funcoes.textoVazio(periodoFiltro) ? StringUtil.getValor(periodoFiltro, FILTRO_DATA_INICIAL) : "";
        this.horaInicial = !Funcoes.textoVazio(periodoFiltro) ? StringUtil.getValor(periodoFiltro, FILTRO_HORA_INICIAL) : "";
        this.dataFinal = Funcoes.formataData(dataHoraServidor);
        this.horaFinal = Funcoes.formataHora(dataHoraServidor, false);
    }

    private void definirTamanhoComponentes() {
        int alturaPadrao = 20;
        int larguraText = 100;
        int larguraButton = 20;
        this.textDataInicial.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataInicial.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraInicial.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraInicial.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textDataFinal.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraFinal.setPreferredSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraFinal.setMinimumSize(new Dimension(larguraText, alturaPadrao));
        this.textHoraFinal.setMaximumSize(new Dimension(larguraText, alturaPadrao));
        this.buttonDataInicial.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataInicial.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonDataFinal.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonRequisicao.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonRequisicao.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonFilial.setPreferredSize(new Dimension(larguraButton, alturaPadrao));
        this.buttonFilial.setMinimumSize(new Dimension(larguraButton, alturaPadrao));
    }

    private void desabilitarComponentes() {
        this.textFilial.setEnabled(false);
        this.textRequisicao.setEnabled(false);
        this.buttonFilial.setEnabled(false);
        this.buttonRequisicao.setEnabled(false);
        this.checkBoxPeriodo.setSelected(true);
    }

    private void adicionarEventos() {
        this.checkBoxPeriodo.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                if (this.checkBoxRequisicao.isSelected()) {
                    this.checkBoxRequisicao.setSelected(!this.checkBoxRequisicao.isSelected());
                }
                this.habilitarDesabilitarComponentesDataHora(true);
                this.habilitarDesabilitarComponentesRequisicao(false);
            }
        });
        this.checkBoxRequisicao.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                if (this.checkBoxPeriodo.isSelected()) {
                    this.checkBoxPeriodo.setSelected(!this.checkBoxPeriodo.isSelected());
                }
                this.habilitarDesabilitarComponentesDataHora(false);
                this.habilitarDesabilitarComponentesRequisicao(true);
            }
        });
        this.textRequisicao.addActionListener(actionEvent -> {
            if (Funcoes.textoVazio(this.textFilial)) {
                Funcoes.mensagem(this, MSG_VALIDA_FILIAL, 2);
            }
        });
    }

    private void habilitarDesabilitarComponentesDataHora(boolean habilitaComponentes) {
        this.textDataInicial.setText(habilitaComponentes ? this.dataInicial : "");
        this.textDataFinal.setText(habilitaComponentes ? this.dataFinal : "");
        this.textDataInicial.setEnabled(habilitaComponentes);
        this.textDataFinal.setEnabled(habilitaComponentes);
        this.textHoraInicial.setText(habilitaComponentes ? this.horaInicial : "");
        this.textHoraFinal.setText(habilitaComponentes ? this.horaFinal : "");
        this.textHoraFinal.setEnabled(habilitaComponentes);
        this.textHoraFinal.setEnabled(habilitaComponentes);
        this.buttonDataFinal.setEnabled(habilitaComponentes);
        this.buttonDataInicial.setEnabled(habilitaComponentes);
    }

    private void habilitarDesabilitarComponentesRequisicao(boolean habilitaComponentes) {
        if (!habilitaComponentes) {
            this.textFilial.setText("");
            this.textRequisicao.setText("");
        } else {
            this.textFilial.setText(Variaveis.filialPadrao);
        }
        this.textFilial.setEnabled(habilitaComponentes);
        this.textRequisicao.setEnabled(habilitaComponentes);
        this.buttonFilial.setEnabled(habilitaComponentes);
        this.buttonRequisicao.setEnabled(habilitaComponentes);
    }

    private JPanel posicionarComponentes() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 0;
        c1.gridy = 0;
        c1.insets = new Insets(1, 1, 0, 0);
        c1.fill = 1;
        c1.anchor = 16;
        panel.add((Component)this.checkBoxPeriodo, c1);
        ++c1.gridx;
        panel.add((Component)new JLabel("Data Inicial:"), c1);
        c1.gridx = 3;
        c1.insets = new Insets(1, 10, 0, 0);
        panel.add((Component)new JLabel("Hora Inicial:"), c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)this.textDataInicial, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonDataInicial, c1);
        ++c1.gridx;
        c1.insets = new Insets(1, 10, 0, 0);
        panel.add((Component)this.textHoraInicial, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)new JLabel("Data Final:"), c1);
        c1.gridx = 3;
        c1.insets = new Insets(1, 10, 0, 0);
        panel.add((Component)new JLabel("Hora Final:"), c1);
        c1.insets = new Insets(1, 1, 15, 0);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)this.textDataFinal, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonDataFinal, c1);
        ++c1.gridx;
        c1.insets = new Insets(1, 10, 15, 0);
        panel.add((Component)this.textHoraFinal, c1);
        c1.insets = new Insets(1, 1, 0, 0);
        ++c1.gridy;
        c1.gridx = 0;
        panel.add((Component)this.checkBoxRequisicao, c1);
        ++c1.gridx;
        panel.add((Component)new JLabel("C\u00f3d. Filial:"), c1);
        ++c1.gridy;
        panel.add((Component)this.textFilial, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonFilial, c1);
        ++c1.gridy;
        c1.gridx = 1;
        panel.add((Component)new JLabel("C\u00f3d. Requisi\u00e7\u00e3o:"), c1);
        ++c1.gridy;
        panel.add((Component)this.textRequisicao, c1);
        ++c1.gridx;
        panel.add((Component)this.buttonRequisicao, c1);
        return panel;
    }

    public boolean isOk() {
        if (this.isOk) {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("filtro");
            this.dataInicial = !Funcoes.textoVazio(this.textDataInicial.getText()) ? this.textDataInicial.getText() : this.dataInicial;
            this.dataFinal = !Funcoes.textoVazio(this.textDataFinal.getText()) ? this.textDataFinal.getText() : this.dataFinal;
            this.horaInicial = !Funcoes.textoVazio(this.textHoraInicial.getText()) ? this.textHoraInicial.getText() : this.horaInicial;
            this.horaFinal = !Funcoes.textoVazio(this.textHoraFinal.getText()) ? this.textHoraFinal.getText() : this.horaFinal;
            xml.escrever(FILTRO_DATA_INICIAL, this.dataInicial);
            xml.escrever(FILTRO_DATA_FINAL, this.dataFinal);
            xml.escrever(FILTRO_HORA_INICIAL, this.horaInicial);
            xml.escrever(FILTRO_HORA_FINAL, this.horaFinal);
            try {
                xml.fechar("filtro");
            }
            catch (XMLStringBuilderException xMLStringBuilderException) {
                // empty catch block
            }
            ParametrosLocais.setParametro("filtroImportacaoJalisWS", xml.toString());
            ParametrosLocais.salvaParametros();
            ParametrosLocais.carregaParametros();
        }
        return this.isOk;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonDataInicial) {
            Funcoes.mostraData(this.textDataInicial, this.buttonDataInicial, (JPanel)this.textDataInicial.getParent(), true);
        } else if (e.getSource() == this.buttonDataFinal) {
            Funcoes.mostraData(this.textDataFinal, this.buttonDataFinal, (JPanel)this.textDataFinal.getParent(), true);
        } else if (e.getSource() == this.buttonFilial) {
            this.buscaFilial();
        } else if (e.getSource() == this.buttonRequisicao) {
            this.buscaRequisicao();
        } else if (e.getSource() == this.buttonOK && this.preenchimentoValido()) {
            this.isOk = true;
            this.setVisible(false);
        } else if (e.getSource() == this.buttonCancelar) {
            this.dispose();
        }
    }

    private void buscaFilial() {
        Hashtable resultado = Pesquisas.filial(Laboratorio.getInstancia(), false);
        boolean retorno = false;
        if (resultado != null) {
            this.textFilial.setText(resultado.get("fil_codigo").toString());
        }
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private void buscaRequisicao() {
        if (!Funcoes.textoVazio(this.textFilial)) {
            Hashtable resultado = Pesquisas.requisicao(Laboratorio.getInstancia(), this.textFilial.getText(), true, false, false);
            if (resultado != null) {
                this.textRequisicao.setText(resultado.get("req_codigo").toString());
            }
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return;
        }
        Funcoes.mensagem(this, "Filial deve ser informada.", 2);
        ScreenUtil.requisitarFoco(this.textFilial);
    }

    private boolean preenchimentoValido() {
        if (this.filtroPeriodoSelecionado()) {
            return this.preenchimentoValidoPeriodo();
        }
        if (this.filtroRequisicaoSelecionado()) {
            return this.preenchimentoValidoRequisicao();
        }
        return true;
    }

    private boolean preenchimentoValidoPeriodo() {
        if (Funcoes.textoVazio(this.textDataInicial.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Data inicial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return false;
        }
        if (Funcoes.textoVazio(this.textDataFinal.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Data final deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return false;
        }
        if (Funcoes.textoVazio(this.textHoraInicial.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Hora inicial n\u00e3o informada", 2);
            ScreenUtil.requisitarFoco(this.textHoraInicial);
            return false;
        }
        if (Funcoes.textoVazio(this.textHoraFinal.getText())) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Hora final n\u00e3o informada", 2);
            ScreenUtil.requisitarFoco(this.textHoraFinal);
            return false;
        }
        int intervalo = Funcoes.diasPorPeriodo(this.textDataInicial.getText(), this.textDataFinal.getText());
        if (intervalo < 0) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "A data final n\u00e3o pode ser menor que a data inicial.", 2);
            ScreenUtil.requisitarFoco(this.textDataFinal);
            return false;
        }
        if (intervalo > 7) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "O per\u00edodo informado, excede a quantidade m\u00e1xima de dias permitida para a Importa\u00e7\u00e3o (7 dias)", 2);
            ScreenUtil.requisitarFoco(this.textDataInicial);
            return false;
        }
        return true;
    }

    private boolean preenchimentoValidoRequisicao() {
        if (Funcoes.textoVazio(this.textFilial.getText())) {
            Funcoes.mensagem(this, "Filial deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textFilial);
            return false;
        }
        if (Funcoes.textoVazio(this.textRequisicao.getText())) {
            Funcoes.mensagem(this, "Requisi\u00e7\u00e3o deve ser informada.", 2);
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return false;
        }
        ImportacaoResultadoJalisWSDao dao = new ImportacaoResultadoJalisWSDao();
        if (!dao.requisicaoValida(this.textFilial.getText(), this.textRequisicao.getText())) {
            Funcoes.mensagem(this, "C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o encontrado no sistema", 2);
            ScreenUtil.requisitarFoco(this.textRequisicao);
            return false;
        }
        return true;
    }

    public boolean filtroPeriodoSelecionado() {
        return this.checkBoxPeriodo.isSelected();
    }

    public boolean filtroRequisicaoSelecionado() {
        return this.checkBoxRequisicao.isSelected();
    }

    public String getDataInicial() {
        return this.textDataInicial.getText();
    }

    public String getDataFinal() {
        return this.textDataFinal.getText();
    }

    public String getHoraInicial() {
        return !Funcoes.textoVazio(this.textHoraInicial.getText()) ? this.textHoraInicial.getText() : "00:00";
    }

    public String getHoraFinal() {
        return !Funcoes.textoVazio(this.textHoraFinal.getText()) ? this.textHoraFinal.getText() : "23:59";
    }

    public String getFilial() {
        return this.textFilial.getText();
    }

    public String getRequisicao() {
        return this.textRequisicao.getText();
    }

    public int getCodigoLabExterno() {
        return this.codigoLabExterno;
    }
}

