/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.alvaro.ExameAlvaro;
import jalis.laboratorio.util.parsers.alvaro.ImportacaoAlvaro;
import jalis.laboratorio.util.parsers.jalisws.ParserImportacaoJalisWS;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JFileChooser;

public class ImportadorJalisWS
extends ImportacaoAlvaro {
    public ImportadorJalisWS(int codigoLabExterno) {
        super(codigoLabExterno, "Importa\u00e7\u00e3o de exames do Jalis WS a partir de arquivo XML", Protocolo.JalisWS);
        this.getButtonImportar().setText("Importar Exames");
    }

    @Override
    public void importarDadosAdicionais() {
        JFileChooser chooser = ComponenteFactory.novoJFileChooser();
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo XML do Jalis WS (*.xml)", "xml"));
        if (chooser.showOpenDialog(this) == 0) {
            File file = new File(chooser.getSelectedFile().getPath());
            try {
                ArrayList<ExameAlvaro> importarDadosAdicionais = ParserImportacaoJalisWS.importarDadosAdicionais(file, this.codigoLabExterno, this.progress);
                StringBuilder bui = new StringBuilder();
                bui.append("\nImporta\u00e7\u00e3o conclu\u00edda");
                this.setTextoInformacoes(bui.toString());
                Thread.sleep(50L);
                if (importarDadosAdicionais != null && importarDadosAdicionais.size() > 0) {
                    bui.append("\n\nOs seguintes exames abaixo foram atualizados: \n\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+\n");
                    bui.append("\t|                     EXAME                        |                      MATERIAL                    |\n");
                    bui.append("\t+--------------------------------------------------+--------------------------------------------------+");
                    for (ExameAlvaro e : importarDadosAdicionais) {
                        bui.append("\n\t|").append(StringUtil.formatarColuna(e.getDescricao(), 50, 'c'));
                        bui.append("|").append(StringUtil.formatarColuna(e.getMaterialDescricao(), 50, 'c')).append("|");
                    }
                    bui.append("\n\t+--------------------------------------------------+--------------------------------------------------+");
                    this.setTextoInformacoes(bui.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.habilitarBotoes(true);
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }
}

