/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.triagem.externo.exportadores.UtilExportadores;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.jalisws.ImportacaoResultadoJalisWSDao;
import jalis.laboratorio.util.parsers.jalisws.InformaPeriodoImportacaoJalisWS;
import jalis.model.dao.util.parsers.alvaro.ImportacaoResultadoAlvaroDao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONObject;

public class ImportacaoResultadoJalisWSService {
    private static final String RESULTADOS_POR_EXAME = "/resultadosporexame";
    private static final String RESULTADOS_POR_DATA = "/resultadospordata";
    private static final String RESULTADOS_POR_REQUISICAO_JALIS = "/resultadosporrequisicaojalis";
    private static final String HOME = System.getProperty("user.home");
    private static final boolean DEBUG = Funcoes.arquivoExiste(HOME + System.getProperty("file.separator") + "debug.jalis");
    public static final int TIPO_CAMPO_A_CAMPO = 0;
    public static final int TIPO_LAYOUT_XML = 1;
    public static final int TIPO_PDF = 2;
    protected int tipoResultado = 0;
    private final ImportacaoResultadoAlvaroDao dao = new ImportacaoResultadoAlvaroDao();
    private String enderecoWebService = "";
    private String convenio = "";
    private String chave = "";
    private String codigoLab = "";

    private int tipoImportacao(String configuracao) {
        if (StringUtil.getBoolean(configuracao, "importarResultadoPdf")) {
            return 2;
        }
        if (StringUtil.getBoolean(configuracao, "importarLayoutLaudo")) {
            return 1;
        }
        return 0;
    }

    public List<File> importarResultadosWS(InformaPeriodoImportacaoJalisWS periodoImportacao, String configuracao, String codigoLab) {
        ArrayList<File> arquivosSalvos = new ArrayList<File>();
        try {
            this.enderecoWebService = StringUtil.getValor(configuracao, "enderecoWebService");
            this.tipoResultado = this.tipoImportacao(configuracao);
            this.codigoLab = codigoLab;
            if (UtilExportadores.comunicacaoOk(this.enderecoWebService, false, Protocolo.JalisWS.getDescricao()).isImprimiu()) {
                SSLContext sc = SSLContext.getInstance("TLS");
                if (this.enderecoWebService.contains("https")) {
                    sc.init(null, this.getTrustAllCerts(), new SecureRandom());
                    HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                }
                this.convenio = StringUtil.getValor(configuracao, "codigo");
                this.chave = StringUtil.getValor(configuracao, "chave");
                String enderecoWebServiceJalisWs = this.getEndereco(periodoImportacao, this.enderecoWebService, this.convenio, this.chave, codigoLab, String.valueOf(this.tipoResultado));
                if (enderecoWebServiceJalisWs == null) {
                    return new ArrayList<File>();
                }
                StringBuilder respJson = this.consultaEnderecoWebService(enderecoWebServiceJalisWs);
                this.debug("============================respJson============================");
                this.debug(respJson.toString());
                this.debug("================================================================");
                if (!Funcoes.textoVazio(respJson.toString())) {
                    File arquivo = this.salvarArquivoResultado(respJson.toString(), periodoImportacao.getCodigoLabExterno());
                    arquivosSalvos.add(arquivo);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return arquivosSalvos;
    }

    private StringBuilder consultaEnderecoWebService(String enderecoWebService) throws IOException {
        String tipoRequest = "GET";
        URL url = new URL(enderecoWebService);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setDoOutput(true);
        urlConnection.setDoInput(true);
        urlConnection.setRequestMethod(tipoRequest);
        urlConnection.setRequestProperty("Content-type", "text/xml; charset=UTF-8");
        urlConnection.connect();
        StringBuilder respJson = new StringBuilder();
        String line = null;
        if (urlConnection.getResponseCode() == 200) {
            InputStreamReader isr = new InputStreamReader(urlConnection.getInputStream(), StandardCharsets.UTF_8);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                respJson.append(line);
            }
        }
        return respJson;
    }

    private String getEndereco(InformaPeriodoImportacaoJalisWS periodoImportacao, String enderecoWebService, String convenio, String chave, String codigoLab, String tipoResultado) {
        if (periodoImportacao.filtroRequisicaoSelecionado()) {
            ImportacaoResultadoJalisWSDao jalisDao = new ImportacaoResultadoJalisWSDao();
            String idLis = jalisDao.retornaRequisicaoDoApoio(periodoImportacao.getFilial(), periodoImportacao.getRequisicao(), codigoLab);
            if (Funcoes.textoVazio(idLis)) {
                return null;
            }
            return enderecoWebService.concat(RESULTADOS_POR_REQUISICAO_JALIS).concat(this.getConvenio(convenio)).concat(this.getChave(chave)).concat(this.getRequisicao(idLis)).concat(this.getTipo(tipoResultado));
        }
        return enderecoWebService.concat(RESULTADOS_POR_DATA).concat(this.getConvenio(convenio)).concat(this.getChave(chave)).concat("&dataInicio=").concat(Funcoes.formataData("yyyy-MM-dd", periodoImportacao.getDataInicial())).concat("&dataFim=").concat(Funcoes.formataData("yyyy-MM-dd", periodoImportacao.getDataFinal())).concat("&horaInicio=").concat(periodoImportacao.getHoraInicial()).concat("&horaFinal=").concat(periodoImportacao.getHoraFinal()).concat(this.getTipo(tipoResultado));
    }

    public File importarResultadoPorExameWS(String codigoRequisicao, String exame, String material, String tipo) throws IOException {
        StringBuilder endereco = new StringBuilder();
        endereco.append(this.enderecoWebService);
        endereco.append(RESULTADOS_POR_EXAME);
        endereco.append(this.getConvenio(this.convenio));
        endereco.append(this.getChave(this.chave));
        endereco.append(this.getRequisicao(codigoRequisicao));
        endereco.append("&exame=").append(exame);
        endereco.append("&material=").append(material);
        endereco.append(this.getTipo(tipo));
        StringBuilder respJson = this.consultaEnderecoWebService(endereco.toString());
        this.debug("============================respJson============================");
        this.debug(respJson.toString());
        this.debug("================================================================");
        return this.salvarArquivoResultado(respJson.toString(), Integer.valueOf(this.codigoLab));
    }

    private String getConvenio(String convenio) {
        return "?codigo=" + convenio;
    }

    private String getChave(String chave) {
        return "&chave=" + chave;
    }

    private String getRequisicao(String requisicao) {
        return "&requisicao=" + requisicao;
    }

    private String getTipo(String tipo) {
        return "&tipo=" + tipo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File salvarArquivoResultado(String xmlResultado, int codLaboratorioExterno) {
        File arquivo = null;
        OutputStreamWriter bufferOut = null;
        String barra = "/";
        String metodoResultado = "resultados";
        try {
            LaboratorioExterno lab = LaboratorioExterno.getLabExterno(String.valueOf(codLaboratorioExterno));
            if (!Funcoes.diretorioExiste(HOME + barra + metodoResultado + lab.descricao)) {
                new File(HOME + barra + metodoResultado + lab.descricao).mkdirs();
            }
            SimpleDateFormat sf = new SimpleDateFormat("yyyyMMdd HH-mm-ss-SSS");
            String nomeArquivo = sf.format(new Date());
            arquivo = new File(HOME + barra + metodoResultado + lab.descricao + barra + nomeArquivo + ".xml");
            JSONObject json = new JSONObject(xmlResultado);
            String resultado = (String)json.get(metodoResultado);
            bufferOut = new OutputStreamWriter((OutputStream)new FileOutputStream(arquivo.getAbsoluteFile()), StandardCharsets.ISO_8859_1);
            bufferOut.write(resultado);
            this.fechaOutputStream(bufferOut);
            return arquivo;
        }
        catch (Exception exception) {
            return arquivo;
        }
        finally {
            this.fechaOutputStream(bufferOut);
        }
    }

    private void fechaOutputStream(OutputStreamWriter bufferOut) {
        if (bufferOut != null) {
            try {
                bufferOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private TrustManager[] getTrustAllCerts() {
        return new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
    }

    private void debug(String mensagem) {
        if (DEBUG) {
            System.out.println(mensagem);
        }
    }
}

