/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.comum.Conexao;
import jalis.comum.ConexaoTemporaria;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.parsers.Exame;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.jalisws.ConfiguracaoExameJalisVO;
import jalis.laboratorio.util.parsers.jalisws.ExameRelacionamentoJalisWs;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ImportacaoResultadoJalisWSDao {
    private static final String ASPA = "'";
    private static final String VIRGULA = ",";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requisicaoValida(String codFilial, String codRequisicao) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select req_codigo from requisicao ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and req_excluida is not null and req_excluida = false ");
        Statement st = ConexaoTemporaria.getStatement();
        boolean valida = false;
        try {
            ResultSet resultado = st.executeQuery(sql.toString());
            if (resultado.next()) {
                valida = true;
            }
        }
        catch (SQLException e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return valida;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String retornaRequisicaoDoApoio(String codFilial, String codRequisicao, String codLaboratorio) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select leq_codigoreqapoio from loteexternorequisicao l ");
        sql.append(" where fil_codigo = ").append(codFilial);
        sql.append(" and req_codigo = ").append(codRequisicao);
        sql.append(" and lae_codigo = ").append(codLaboratorio);
        Statement st = ConexaoTemporaria.getStatement();
        try {
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                String string = rs.getString("leq_codigoreqapoio");
                return string;
            }
        }
        catch (SQLException e) {
            this.anularSQL();
        }
        finally {
            ConexaoTemporaria.fecharStatement(st);
        }
        return "";
    }

    public void salvarResultado(ConfiguracaoExameJalisVO configExameJalisWs, String resultadoPDFEmBase64, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica, boolean isPDF) {
        if (!Funcoes.textoVazio(resultadoPDFEmBase64)) {
            this.salvarResultado(configExameJalisWs, resultadoPDFEmBase64, isPDF);
            this.atualizarExameRequisicao(configExameJalisWs, conferirAutomatico, codigoUsuarioConferenciaAutomatica, isPDF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void salvarResultado(ConfiguracaoExameJalisVO configExameJalisWs, String resultado, boolean isPDF) {
        Statement st = Conexao.getStatement();
        String campoResultado = "ert_resultadopdf";
        try {
            String resultadoFormatado = StringUtil.textoDBEscape(resultado);
            if (!isPDF) {
                resultadoFormatado = resultadoFormatado.replace("&quot;", "\"");
                campoResultado = "ert_resultado";
            }
            StringBuilder sql = new StringBuilder();
            String condicaoWhere = this.getCondicaoWhere(configExameJalisWs);
            sql.append(" select 1 as resultado from examerequisicaoresultado");
            sql.append(condicaoWhere);
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            sql.delete(0, sql.length());
            if (rs.next()) {
                sql.append(" update examerequisicaoresultado set ");
                sql.append(campoResultado).append(" = ").append(resultadoFormatado);
                sql.append(condicaoWhere);
            } else {
                sql.append(" insert into examerequisicaoresultado (fil_codigo, exa_codigo, mco_codigo, req_codigo, ").append(campoResultado).append(") ");
                sql.append(" values (");
                sql.append(configExameJalisWs.getCodigoFilial()).append(VIRGULA);
                sql.append(ASPA.concat(configExameJalisWs.getCodigoExame()).concat(ASPA)).append(VIRGULA);
                sql.append(configExameJalisWs.getCodigoMaterial()).append(VIRGULA);
                sql.append(configExameJalisWs.getCodigoRequisicao()).append(VIRGULA);
                sql.append(resultadoFormatado).append(" );");
            }
            Conexao.executeUpdate(configExameJalisWs.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizarExameRequisicao(ConfiguracaoExameJalisVO configExameJalisWs, boolean conferirAutomatico, String codigoUsuarioConferenciaAutomatica, boolean isPDF) {
        StringBuilder sql = new StringBuilder();
        sql.append(" update examerequisicao set ");
        if (isPDF) {
            sql.append(" exr_resultadoempdf = true, ");
        }
        if (!conferirAutomatico && Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" exr_situacao = '").append("L").append("', ");
        }
        sql.append(" exr_datadigita = current_timestamp, ");
        sql.append(" usr_coddigitador = '").append(Variaveis.login).append(ASPA);
        if (conferirAutomatico && !Funcoes.textoVazio(codigoUsuarioConferenciaAutomatica)) {
            sql.append(" ,exr_situacao = '").append("C").append("', ");
            sql.append(" exr_dataassina = current_timestamp, ");
            sql.append(" usr_codassina = '").append(codigoUsuarioConferenciaAutomatica).append(ASPA);
        }
        sql.append(this.getCondicaoWhere(configExameJalisWs));
        Statement st = Conexao.getStatement();
        try {
            Conexao.executeUpdate(configExameJalisWs.getCodigoFilial(), st, sql.toString());
            Conexao.arquivaSQL();
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private String getCondicaoWhere(ConfiguracaoExameJalisVO configExameJalisWs) {
        StringBuilder where = new StringBuilder(" where ");
        where.append(" fil_codigo = ").append(configExameJalisWs.getCodigoFilial());
        where.append(" and req_codigo = ").append(configExameJalisWs.getCodigoRequisicao());
        where.append(" and exa_codigo = '").append(configExameJalisWs.getCodigoExame()).append(ASPA);
        where.append(" and mco_codigo = ").append(configExameJalisWs.getCodigoMaterial());
        return where.toString();
    }

    public static Registro localizaExame(String filial, String requisicao, String exame, String mco) throws SQLException {
        Statement st = Conexao.getStatement();
        ResultSet res = Conexao.executeQuery(st, ImportacaoResultadoJalisWSDao.getSqlLocalizaExame(filial, requisicao, exame, mco));
        if (res.next()) {
            Registro reg = new Registro(res);
            reg.setValor("codigo-layout", ExameUtil.getCodigoLayout(filial, res.getString("con_codigo"), res.getString("des_codigo")));
            reg.setValor("cabecalho", ExameUtil.getCabecalhoRodape(filial, reg.getString("codigo-layout")));
            Registro formatacao = new Registro();
            formatacao.setValor("formato", reg.getValor("exr_resultado"));
            formatacao.setValor("met_codigo", reg.getValor("met_codigo"));
            reg.setValor("formatacao", formatacao);
            return reg;
        }
        return null;
    }

    private static StringBuilder getSqlLocalizaExame(String filial, String requisicao, String exame, String mco) {
        StringBuilder sql = new StringBuilder();
        sql.append(" select a.fil_codigo, a.req_codigo, a.req_guia, a.des_codigo, a.con_codigo, a.pac_codigo, ");
        sql.append(" a.req_idade, a.req_anomes, b.exa_codigo, b.mco_codigo, b.exr_situacao, ");
        sql.append(" pegaResultadoExame(b.fil_codigo, b.req_codigo, b.exa_codigo, b.mco_codigo) as exr_resultado, ");
        sql.append(" coalesce(g.met_codigo, b.met_codigo) as met_codigo, c.pac_idade, c.pac_anomes, ");
        sql.append(" b.exr_datamaterial, a.req_xmlagendamentoids as xmlAgendamentoIDS, ");
        sql.append(" a.req_integracaohospital, b.exr_solicitadotiss, b.exr_codautorizacao, ");
        sql.append(" d.exa_salvaparcial, g.ele_xmllabexterno, null as examePai, l.lae_configuracao ");
        sql.append(" from requisicao a ");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
        sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo ");
        sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo ");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo ");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' ");
        sql.append(" left join labexterno l on g.fil_codigo = l.fil_codigo and g.lae_codigo = l.lae_codigo ");
        sql.append(" where a.fil_codigo = ").append(filial);
        sql.append(" and a.req_codigo = ").append(requisicao);
        sql.append(" and b.exa_codigo = '").append(exame).append(ASPA);
        sql.append(" and b.mco_codigo = ").append(mco);
        sql.append(" and a.req_excluida = false ");
        sql.append(" and b.exr_excluido = false ");
        return sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfiguracaoExameJalisVO> pesquisarExamesDesmembradosNoLote(Registro reg) {
        ArrayList<ConfiguracaoExameJalisVO> desmembrados = new ArrayList<ConfiguracaoExameJalisVO>();
        StringBuilder sql = new StringBuilder(" select ");
        sql.append(" ldesm.fil_kodigo, ldesm.req_codigo, ldesm.exa_kodigo, ldesm.mco_kodigo, ler.leq_codigoreqapoio,  exlabext.ele_xmllabexterno ");
        sql.append(" from loteexternoexamerequisicaodesm ldesm ");
        sql.append(" left join loteexternoexamerequisicao leer ");
        sql.append(" on ldesm.fil_kodigo = leer.fil_kodigo ");
        sql.append(" and ldesm.fil_codigo = leer.fil_codigo ");
        sql.append(" and ldesm .lex_codigo = leer.lex_codigo ");
        sql.append(" and ldesm.req_codigo = leer.req_codigo ");
        sql.append(" and ldesm.exa_codigo = leer.exa_codigo ");
        sql.append(" and ldesm.mco_codigo = leer.mco_codigo ");
        sql.append(" left join loteexternorequisicao ler ");
        sql.append(" on leer.fil_kodigo = ler.fil_kodigo ");
        sql.append(" and leer.fil_codigo = ler.fil_codigo ");
        sql.append(" and leer .lex_codigo = ler.lex_codigo ");
        sql.append(" and leer.req_codigo = ler.req_codigo ");
        sql.append(" left join examematcoletalabexterno exlabext ");
        sql.append(" on ldesm.fil_kodigo = exlabext.fil_codigo ");
        sql.append(" and ldesm.exa_kodigo = exlabext.exa_codigo ");
        sql.append(" and ldesm.mco_kodigo  = exlabext.mco_codigo ");
        sql.append(" and ldesm.lae_codigo = exlabext.lae_codigo ");
        sql.append(" where ldesm.fil_kodigo = ").append(reg.getInt("fil_codigo"));
        sql.append(" and ldesm.req_codigo = ").append(reg.getInt("req_codigo"));
        sql.append(" and ldesm.exa_codigo = ").append(StringUtil.textoDBEscape(reg.getString("examePai")));
        sql.append(" and ldesm.mco_codigo = ").append(reg.getInt("mco_codigo"));
        sql.append(" and leer.ler_datahoraestorno  is null and leer.usr_codestorno is null ");
        sql.append(" and ler.leq_dataestorno is null and ler.usr_codestorno  is null ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = Conexao.executeQuery(st, sql.toString());
            while (rs.next()) {
                ConfiguracaoExameJalisVO confExame = new ConfiguracaoExameJalisVO();
                confExame.setCodigoExame(rs.getString("exa_kodigo"));
                confExame.setCodigoFilial(rs.getString("fil_kodigo"));
                confExame.setCodigoMaterial(rs.getString("mco_kodigo"));
                confExame.setCodigoRequisicao(rs.getString("req_codigo"));
                confExame.setCodPedApoio(rs.getString("leq_codigoreqapoio"));
                confExame.setConfigExameJalisWs(rs.getString("ele_xmllabexterno"));
                desmembrados.add(confExame);
            }
        }
        catch (Exception e) {
            try {
                this.anularSQL();
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return desmembrados;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameDesmembrado getExamesDesmembrados(String filial, String reqCodigo, String laeCodigo, String exaFilho, String mcoFilho) {
        Statement st;
        block4: {
            ExameDesmembrado exameDesmembrado;
            st = Conexao.getStatement();
            try {
                if (st == null) break block4;
                StringBuilder buf = new StringBuilder();
                buf.append(" select a.exa_codigo ,a.mco_codigo ,p.ele_xmllabexterno, pai.ele_xmllabexterno as xmllabexternopai ");
                buf.append(" from loteexternoexamerequisicaodesm a ");
                buf.append(" left join examematcoletalabexterno p on a.fil_kodigo = p.fil_codigo and a.exa_kodigo = p.exa_codigo and a.mco_kodigo = p.mco_codigo and a.lae_codigo = p.lae_codigo ");
                buf.append(" left join examematcoletalabexterno pai on a.fil_kodigo = pai.fil_codigo and a.exa_codigo = pai.exa_codigo and a.mco_codigo = pai.mco_codigo and a.lae_codigo = pai.lae_codigo ");
                buf.append(" where a.fil_kodigo = ").append(filial);
                buf.append(" and a.req_codigo  = ").append(reqCodigo);
                buf.append(" and a.exa_kodigo = ").append(StringUtil.textoDBEscape(exaFilho));
                buf.append(" and a.mco_kodigo = ").append(mcoFilho);
                buf.append(" and a.lae_codigo = ").append(laeCodigo);
                ResultSet res = Conexao.executeQuery(st, buf.toString());
                if (!res.next()) break block4;
                ExameDesmembrado ex = new ExameDesmembrado(res.getString("exa_codigo"), res.getInt("mco_codigo"), res.getString("xmllabexternopai"));
                ex.addFilho(new Exame(exaFilho, Integer.parseInt(mcoFilho), res.getString("ele_xmllabexterno")));
                exameDesmembrado = ex;
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace(), "ImportacaoResultadoJalisWSDao");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameDesmembrado;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    public List<ExameRelacionamentoJalisWs> pesquisarExamesRelacionados(Statement st, String codFilial, String codRequisicao, int codLabExterno, boolean agruparMultiguiaLabExterno) throws SQLException {
        boolean agruparMultiguia;
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(codFilial, codRequisicao, true);
        boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || agruparMultiguiaLabExterno;
        if (!agruparMultiguia) {
            multiguias = new Integer[]{Integer.parseInt(codRequisicao)};
        }
        StringBuilder sql = new StringBuilder();
        sql.append(" select b.exa_codigo, b.mco_codigo, g.ele_xmllabexterno, h.exa_kodigo, h.mco_kodigo, i.ele_xmllabexterno as ele_xmllabexterno_desm ");
        sql.append(" from requisicao a ");
        sql.append(" left join examerequisicao b on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo ");
        sql.append(" left join paciente c on a.fil_codigo = c.fil_codigo and a.pac_codigo = c.pac_codigo ");
        sql.append(" left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo ");
        sql.append(" left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo ");
        sql.append(" left join loteexternoexamerequisicao f on b.fil_codigo = f.fil_kodigo and b.req_codigo = f.req_codigo and b.exa_codigo = f.exa_codigo and b.mco_codigo = f.mco_codigo ");
        sql.append(" left join examematcoletalabexterno g on f.fil_codigo = g.fil_codigo and f.exa_codigo = g.exa_codigo and f.mco_codigo = g.mco_codigo and f.lae_codigo = g.lae_codigo and g.ele_xmllabexterno is not null and g.ele_xmllabexterno <> '' ");
        sql.append(" left join examematcoletalabextdesm h on f.fil_codigo = h.fil_codigo and f.exa_codigo = h.exa_codigo and f.mco_codigo = h.mco_codigo and f.lae_codigo = h.lae_codigo ");
        sql.append(" left join examematcoletalabexterno i on h.fil_codigo = i.fil_codigo and i.exa_codigo = h.exa_kodigo and i.mco_codigo = h.mco_kodigo and h.lae_codigo = i.lae_codigo ");
        sql.append(" where a.fil_codigo = ").append(codFilial);
        sql.append(" and a.req_codigo in (").append(StringUtil.implode(Arrays.asList(multiguias), VIRGULA)).append(")");
        sql.append(" and f.lae_codigo = ").append(codLabExterno);
        ResultSet rs = st.executeQuery(sql.toString());
        ArrayList<ExameRelacionamentoJalisWs> examesRelacionados = new ArrayList<ExameRelacionamentoJalisWs>();
        while (rs.next()) {
            if (Funcoes.textoVazio(rs.getString("exa_codigo")) || Funcoes.textoVazio(rs.getString("mco_codigo")) || Funcoes.textoVazio(rs.getString("ele_xmllabexterno"))) continue;
            ExameRelacionamentoJalisWs exame = new ExameRelacionamentoJalisWs();
            exame.setExame(rs.getString("exa_codigo"));
            exame.setMaterial(rs.getString("mco_codigo"));
            exame.setXml(rs.getString("ele_xmllabexterno"));
            boolean exameJaAdicionado = false;
            for (ExameRelacionamentoJalisWs exameJalis : examesRelacionados) {
                if (!exameJalis.getExame().equals(exame.getExame()) || !exameJalis.getMaterial().equals(exame.getMaterial())) continue;
                this.montaExameFilho(rs, exameJalis);
                exameJaAdicionado = true;
            }
            if (exameJaAdicionado) continue;
            this.montaExameFilho(rs, exame);
            examesRelacionados.add(exame);
        }
        return examesRelacionados;
    }

    private void montaExameFilho(ResultSet rs, ExameRelacionamentoJalisWs exame) throws SQLException {
        if (!(Funcoes.textoVazio(rs.getString("exa_kodigo")) || Funcoes.textoVazio(rs.getString("mco_kodigo")) || Funcoes.textoVazio(rs.getString("ele_xmllabexterno_desm")))) {
            ExameRelacionamentoJalisWs exameDesm = new ExameRelacionamentoJalisWs();
            exameDesm.setExame(rs.getString("exa_kodigo"));
            exameDesm.setMaterial(rs.getString("mco_kodigo"));
            exameDesm.setXml(rs.getString("ele_xmllabexterno_desm"));
            exame.getExameDesm().add(exameDesm);
        }
    }

    private void anularSQL() {
        try {
            ConexaoTemporaria.anulaSQL();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

