/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.triagem.externo.LaboratorioExterno;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.RecepcaoUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.ExameDesmembrado;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.jalisws.AmostraJalisWS;
import jalis.laboratorio.util.parsers.jalisws.CampoResultadoJalisWS;
import jalis.laboratorio.util.parsers.jalisws.ConfiguracaoExameJalisVO;
import jalis.laboratorio.util.parsers.jalisws.ExameJalisWS;
import jalis.laboratorio.util.parsers.jalisws.ExameRelacionamentoJalisWs;
import jalis.laboratorio.util.parsers.jalisws.ExameResultadoJalisWS;
import jalis.laboratorio.util.parsers.jalisws.ImportacaoResultadoJalisWSDao;
import jalis.laboratorio.util.parsers.jalisws.ImportacaoResultadoJalisWSService;
import jalis.laboratorio.util.parsers.jalisws.InformaPeriodoImportacaoJalisWS;
import jalis.laboratorio.util.parsers.jalisws.LinhaResultado;
import jalis.laboratorio.util.parsers.jalisws.LinhaResultadoJalisWS;
import jalis.laboratorio.util.parsers.jalisws.PacienteJalisWS;
import jalis.laboratorio.util.parsers.jalisws.RequisicaoJalisWS;
import jalis.util.DBUtil;
import jalis.util.ExameUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import jalis.util.xml.XMLUtil;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ImportacaoResultadoJalisWS
extends AbstractImportadorResultadoLabExterno {
    private static final String VERSAO = "20060809";
    protected static final String FORMATACAO = "formatacao";
    protected static final String CABECALHO = "cabecalho";
    private transient ArrayList<PacienteJalisWS> pacientes = new ArrayList();
    protected transient ArrayList<RequisicaoJalisWS> requisicoes = new ArrayList();
    private transient Map<String, ExameJalisWS> examesCadastro = new HashMap<String, ExameJalisWS>();
    protected JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);
    protected JButton buttonImportarWS = ComponenteFactory.novoJButton("Importar Webservice", 'W', this);
    protected ModeloGridTable modeloRelatorio = RelatorioImportacaoResultadoUtil.novoModeloGridTable();
    private final transient ImportacaoResultadoJalisWSService service;
    private final transient ImportacaoResultadoJalisWSDao dao;
    protected boolean adicionarEnterNaTagResultado = false;
    private boolean conferirAutomatico = false;
    private boolean enviarUsandoWS = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    private boolean agruparMultiguiaLabExterno = false;
    private HashMap<String, String> requisicoesNotificar = new HashMap();
    private InformaPeriodoImportacaoJalisWS periodoImportacao;

    public ImportacaoResultadoJalisWS(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de resultados", "Importa\u00e7\u00e3o de resultados do Jalis WS a partir do web service", codigoLabExterno, Protocolo.JalisWS, new JPanel(new FlowLayout(2)));
        this.service = new ImportacaoResultadoJalisWSService();
        this.dao = new ImportacaoResultadoJalisWSDao();
        this.jbInit(codigoLabExterno);
    }

    public ImportacaoResultadoJalisWS(int codigoLabExterno, String titulo, String descricao, Protocolo protocolo) {
        super(titulo, descricao, codigoLabExterno, protocolo, new JPanel(new FlowLayout(2)));
        this.protocolo = protocolo;
        this.service = new ImportacaoResultadoJalisWSService();
        this.dao = new ImportacaoResultadoJalisWSDao();
        this.jbInit(codigoLabExterno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jbInit(int codigoLabExterno) {
        this.getPanelAdicional().add(this.buttonImprimir);
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select lae_configuracao, coalesce(lae_conferirautomatico, false) as lae_conferirautomatico, usr_codconferir, lae_agruparmultiguias from labexterno ");
        buf.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        buf.append("   and lae_codigo = ").append(codigoLabExterno);
        try {
            ResultSet rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                if (!DBUtil.campoNull(rs.getString("lae_configuracao")) && StringUtil.getValor(rs.getString("lae_configuracao"), "processarEnter").trim().length() > 0) {
                    this.adicionarEnterNaTagResultado = StringUtil.getBoolean(rs.getString("lae_configuracao"), "processarEnter");
                }
                this.enviarUsandoWS = StringUtil.getBoolean(rs.getString("lae_configuracao"), "enviarLoteWebService");
                this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
                this.agruparMultiguiaLabExterno = rs.getBoolean("lae_agruparmultiguias");
                this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
            }
            this.getPanelAdicional().add(this.buttonImportarWS);
            this.buttonImportar.setVisible(false);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoJalisWS (128)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    @Override
    protected void importarResultadoWs() {
        LaboratorioExterno lab = LaboratorioExterno.getLabExterno(String.valueOf(this.codigoLabExterno));
        String urlResultados = StringUtil.getValor(lab.configuracao, "enderecoWebService");
        if (Funcoes.textoVazio(urlResultados)) {
            Funcoes.mensagem(Laboratorio.getInstancia(), "Web Service Resultado n\u00e3o configurado no Laborat\u00f3rio Externo.", 2);
            return;
        }
        if (this.periodoImportacao != null && this.periodoImportacao.isOk()) {
            this.setTextoInformacoes("Aguarde... Consultando resultados \n");
            if (this.periodoImportacao.filtroRequisicaoSelecionado()) {
                this.setTextoInformacoes("\nSolicitando os resultados da requisi\u00e7\u00e3o " + this.periodoImportacao.getRequisicao() + "\n", false);
            } else if (this.periodoImportacao.filtroPeriodoSelecionado()) {
                this.setTextoInformacoes("\nSolicitando os resultados do Per\u00edodo informado... \n", false);
            }
            List<File> resultadosImportados = this.service.importarResultadosWS(this.periodoImportacao, lab.configuracao, lab.codigoLab);
            for (File arquivoSalvo : resultadosImportados) {
                this.processarResultados(arquivoSalvo);
            }
            if (resultadosImportados.isEmpty()) {
                this.setTextoInformacoes("\nN\u00e3o h\u00e1 resultados para serem importados", false);
            } else {
                this.setTextoInformacoes("\nImporta\u00e7\u00e3o Finalizada!", false);
            }
        }
        this.buttonImportarWS.setEnabled(true);
    }

    @Override
    public void run() {
        this.importarResultadoWs();
        this.habilitarBotoes(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processarResultados(File arquivo) {
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
        }
        catch (Exception e2) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e2.getMessage(), e2.getStackTrace());
        }
        if (doc == null) {
            this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + arquivo.getPath());
            return;
        }
        Element raiz = doc.getDocumentElement();
        List<Element> elements = XMLUtil.getElementosFilhos(raiz);
        Long quantidadeSolitacao = elements.stream().filter(e -> e.getNodeName().equalsIgnoreCase("solicitacao")).count();
        if (quantidadeSolitacao.intValue() > 0) {
            this.progress.setValue(0);
            this.progress.setMaximum(quantidadeSolitacao.intValue() * 2);
            this.progress.setVisible(true);
        }
        this.parse(elements);
        if (this.requisicoes == null || this.requisicoes.isEmpty()) {
            this.setTextoInformacoes("O arquivo informado n\u00e3o possui requisi\u00e7\u00f5es a serem importadas!");
            return;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        if (st == null) {
            return;
        }
        try {
            this.requisicoesNotificar = new HashMap();
            this.progress.setMaximum(this.requisicoes.size());
            this.processarRetorno(st, st2);
            ResultadosUtil.enviarNotificacoes(this.requisicoesNotificar, this.conferirAutomatico, this.codigoUsuarioConferenciaAutomatica);
            Conexao.arquivaSQL();
            this.buttonImprimir.setEnabled(this.modeloRelatorio.getRowCount() > 0);
        }
        catch (Exception e3) {
            try {
                try {
                    Conexao.anulaSQL();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ErrorLogger.mostraMensagem(this, e3.getMessage(), e3.getStackTrace(), "ImportacaoResultadoAlvaro: 69");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                this.requisicoes = new ArrayList();
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
            this.requisicoes = new ArrayList();
        }
        Conexao.fecharStatement(st, st2);
        this.requisicoes = new ArrayList();
        this.progress.setVisible(false);
    }

    private boolean resultadoLancado(Registro reg, RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado) {
        if (this.exameLancado(reg)) {
            if (this.exameDesmembrado(reg)) {
                this.setTextoInformacoes(String.format("%nRequisi\u00e7\u00e3o do %s: %s exame %s - %s %s", this.protocolo.getDescricao(), reqAlvaro.codigoJalis, reg.getString("examePai"), exResultado.codigo, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO.descricao), false);
            } else {
                this.setTextoInformacoes(String.format("%nRequisi\u00e7\u00e3o do %s: %s exame %s %s", this.protocolo.getDescricao(), reqAlvaro.codigoJalis, exResultado.codigo, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO.descricao), false);
            }
            this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, AbstractImportadorResultadoLabExterno.Situacao.JA_LANCADO);
            return true;
        }
        return false;
    }

    private boolean pararImportacao(Registro reg, RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado) throws SQLException {
        if (reg == null) {
            return true;
        }
        if (!this.exameColetado(reg) && reg != null && !reg.getString("exr_situacao").equals("P")) {
            this.setTextoInformacoes(String.format("%nRequisi\u00e7\u00e3o do %s: %s exame %s %s", this.protocolo.getDescricao(), reqAlvaro.codigoAlvaro, exResultado.codigo, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL.descricao), false);
            this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, AbstractImportadorResultadoLabExterno.Situacao.SEM_MATERIAL);
            return true;
        }
        if (!this.exameRelacionado(reg)) {
            this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, AbstractImportadorResultadoLabExterno.Situacao.SEM_RELACIONAMENTO);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Sem relacionamento", false);
            return true;
        }
        if (this.importaEmLayout(reg) && Funcoes.textoVazio(exResultado.resultadoLayout)) {
            this.setTextoInformacoes(String.format("%nFalha na importa\u00e7\u00e3o do exame %s em XML", reg.getString("exa_codigo")), false);
            return true;
        }
        if (this.importaEmPDF(reg) && Funcoes.textoVazio(exResultado.resultadoPdf)) {
            this.setTextoInformacoes(String.format("%nFalha na importa\u00e7\u00e3o do exame %s em PDF", reg.getString("exa_codigo")), false);
            return true;
        }
        return false;
    }

    private boolean importaEmPDF(Registro reg) {
        return reg.getString("lae_configuracao").contains("<importarResultadoPdf>true</importarResultadoPdf>");
    }

    private boolean exameDesmembrado(Registro reg) {
        return !Funcoes.textoVazio(reg.getString("examePai")) && !reg.getString("examePai").equals(reg.getString("exa_codigo"));
    }

    private boolean importaExamePDF(Registro reg, RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado, boolean importouPDF, String codigoUsuarioConferenciaAutomatica, boolean conferido) {
        ConfiguracaoExameJalisVO exame = ConfiguracaoExameJalisVO.fromRegistro(reg);
        String resultadoPDF = exResultado.resultadoPdf;
        if (!Funcoes.textoVazio(resultadoPDF) && resultadoPDF.length() > 1000) {
            this.dao.salvarResultado(exame, resultadoPDF, conferido, codigoUsuarioConferenciaAutomatica, true);
            AbstractImportadorResultadoLabExterno.Situacao situacao = conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO;
            this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", Funcoes.preencheZero(exame.getCodigoFilial(), ParametrosGerais.getDigitosTuboFilial()), Funcoes.preencheZero(exame.getCodigoRequisicao(), ParametrosGerais.getDigitosTuboFilial()), exame.getCodigoExame(), situacao.descricao), false);
            this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, situacao);
            importouPDF = true;
        }
        return importouPDF;
    }

    private boolean importaPdfDesmembrado(Registro reg, RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado, boolean importouPDF, String codigoUsuarioConferenciaAutomatica, boolean conferido) throws IOException {
        byte[] resultadosDesmembrados = null;
        List<ConfiguracaoExameJalisVO> desmembrados = this.dao.pesquisarExamesDesmembradosNoLote(reg);
        int resultadosRecebidos = 0;
        for (ConfiguracaoExameJalisVO desm : desmembrados) {
            String resultadoPDFBase64 = "";
            for (ExameResultadoJalisWS pdf : reqAlvaro.exames) {
                if (!desm.getCodigoExame().equals(pdf.exameJalis) || !desm.getCodigoMaterial().equals(pdf.materialJalis)) continue;
                resultadoPDFBase64 = pdf.resultadoPdf;
                pdf.importado = true;
            }
            if (!Funcoes.textoVazio(resultadoPDFBase64) && resultadoPDFBase64.length() > 1000) {
                byte[] resultadoEmBytes = Base64.decodeBase64((String)resultadoPDFBase64);
                resultadosDesmembrados = ResultadosUtil.concatenarPdfs(resultadosDesmembrados, resultadoEmBytes, "Resultado");
                ++resultadosRecebidos;
                continue;
            }
            if (!Funcoes.textoVazio(resultadoPDFBase64)) continue;
            this.setTextoInformacoes(String.format("%nFalha na import\u00e7\u00e3o do exame %s desmembrado em PDF", desm.getCodigoExame()), false);
        }
        if (resultadosRecebidos == desmembrados.size()) {
            Base64 base64 = new Base64();
            String resultadoDesmembradosBase64 = base64.encodeAsString(resultadosDesmembrados);
            ConfiguracaoExameJalisVO examePai = ConfiguracaoExameJalisVO.fromRegistro(reg);
            examePai.setCodigoExame(reg.getString("examePai"));
            this.dao.salvarResultado(examePai, resultadoDesmembradosBase64, conferido, codigoUsuarioConferenciaAutomatica, true);
            this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato PDF - %s", examePai.getCodigoFilial(), examePai.getCodigoRequisicao(), reg.getString("examePai")), false);
            this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO);
            importouPDF = true;
        }
        return importouPDF;
    }

    private boolean resultadoImportadoEmLayout(Registro reg, ExameResultadoJalisWS exResultado, RequisicaoJalisWS reqJalisSw) {
        boolean conferido;
        boolean importouLayout = false;
        boolean bl = conferido = this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica);
        if (this.importaEmLayout(reg)) {
            if (this.exameDesmembrado(reg)) {
                this.setTextoInformacoes(String.format("%nExame %s - %s|%s Desmembrado - Importa\u00e7\u00e3o n\u00e3o realizada", reg.getString("exa_codigo"), reg.getString("examePai"), reg.getString("mco_codigo")), false);
                importouLayout = true;
            } else {
                importouLayout = this.importaExameLayout(reg, reqJalisSw, exResultado, importouLayout, this.codigoUsuarioConferenciaAutomatica, conferido);
            }
        }
        return importouLayout;
    }

    private boolean importaEmLayout(Registro reg) {
        return reg.getString("lae_configuracao").contains("<importarLayoutLaudo>true</importarLayoutLaudo>");
    }

    private boolean importaExameLayout(Registro reg, RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado, boolean importouLayout, String codigoUsuarioConferenciaAutomatica, boolean conferido) {
        ConfiguracaoExameJalisVO exame = ConfiguracaoExameJalisVO.fromRegistro(reg);
        String resultadoLayout = exResultado.resultadoLayout;
        if (!Funcoes.textoVazio(resultadoLayout) && resultadoLayout.length() > 1000) {
            this.dao.salvarResultado(exame, resultadoLayout, conferido, codigoUsuarioConferenciaAutomatica, false);
            AbstractImportadorResultadoLabExterno.Situacao situacao = conferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO;
            this.setTextoInformacoes(String.format("\nResultado recebido para: %s%s|%s - Formato XML - %s", Funcoes.preencheZero(exame.getCodigoFilial(), ParametrosGerais.getDigitosTuboFilial()), Funcoes.preencheZero(exame.getCodigoRequisicao(), ParametrosGerais.getDigitosTuboFilial()), exame.getCodigoExame(), situacao.descricao), false);
            this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, situacao);
            importouLayout = true;
        }
        return importouLayout;
    }

    private boolean resultadoImportadoEmPdf(Registro reg, ExameResultadoJalisWS exResultado, RequisicaoJalisWS reqAlvaro) throws IOException {
        boolean conferido;
        boolean importouPDF = false;
        boolean bl = conferido = this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica);
        if (this.importaEmPDF(reg)) {
            importouPDF = this.exameDesmembrado(reg) ? this.importaPdfDesmembrado(reg, reqAlvaro, exResultado, importouPDF, this.codigoUsuarioConferenciaAutomatica, conferido) : this.importaExamePDF(reg, reqAlvaro, exResultado, importouPDF, this.codigoUsuarioConferenciaAutomatica, conferido);
        }
        return importouPDF;
    }

    private boolean pdfDesmImportado(Registro reg) {
        return reg.getBoolean("importado");
    }

    private boolean importacaoInvalida(ExameResultadoJalisWS exResultado) {
        return this.service.tipoResultado == 0 && (exResultado.resultadoLayout != null || exResultado.resultadoPdf != null) || this.service.tipoResultado == 2 && (!exResultado.linhasResultado.isEmpty() || !Funcoes.textoVazio(exResultado.resultadoAntibiogramas) || !Funcoes.textoVazio(exResultado.grafico) || !Funcoes.textoVazio(exResultado.resultadoLayout)) || this.service.tipoResultado == 1 && (!exResultado.linhasResultado.isEmpty() || !Funcoes.textoVazio(exResultado.resultadoAntibiogramas) || !Funcoes.textoVazio(exResultado.grafico) || !Funcoes.textoVazio(exResultado.resultadoPdf));
    }

    private void processarRetorno(Statement st, Statement st2) throws Exception {
        for (RequisicaoJalisWS reqAlvaro : this.requisicoes) {
            this.progress.setValue(this.progress.getValue() + 1);
            String filCodigo = reqAlvaro.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = reqAlvaro.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial());
            List<ExameRelacionamentoJalisWs> examesJalis = this.dao.pesquisarExamesRelacionados(st, filCodigo, reqCodigo, this.codigoLabExterno, this.agruparMultiguiaLabExterno);
            this.associaExameMaterialJalis(reqAlvaro, examesJalis);
            for (ExameResultadoJalisWS exResultado : reqAlvaro.exames) {
                LinkedList<Registro> listaRegistros = this.processarPaiFilhos(reqAlvaro, exResultado, filCodigo, reqCodigo, false);
                if (listaRegistros == null || listaRegistros.isEmpty()) {
                    this.setTextoInformacoes(String.format("%nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis Fil.: %s Req.: %s. C\u00f3digo %s:%s ", filCodigo, reqCodigo, this.protocolo.getDescricao(), reqAlvaro.codigoAlvaro), false);
                    this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, AbstractImportadorResultadoLabExterno.Situacao.NAO_LOCALIZADO);
                    continue;
                }
                for (Registro reg : listaRegistros) {
                    boolean salvoParcial;
                    Registro formatacao;
                    String codExameTexto;
                    if (this.pararImportacaoExame(reqAlvaro, exResultado, reg)) continue;
                    String string = codExameTexto = this.exameDesmembrado(reg) ? exResultado.codigo + " - " + reg.getString("examePai") : exResultado.codigo;
                    if (this.importacaoInvalida(exResultado)) {
                        this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + codExameTexto + " - Formato incompat\u00edvel", false);
                        continue;
                    }
                    if (reg.getValor("examePai") != null) {
                        reg.setValor("exa_codigo", reg.getString("examePai"));
                    }
                    Registro registro = formatacao = (salvoParcial = reg.getString("exr_situacao").equals("P")) ? (Registro)reg.getValor(FORMATACAO) : this.localizarFormatacao(reg);
                    if (formatacao == null) {
                        this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + codExameTexto + " - Formata\u00e7\u00e3o n\u00e3o encontrada", false);
                        continue;
                    }
                    ExameJalisWS exJalisWsSalvo = new ExameJalisWS(reg.getString("ele_xmllabexterno"));
                    ExameJalisWS exAlvaroNovo = this.examesCadastro.get(exResultado.codigo);
                    Map<String, Object> dados = ExameUtil.getDadosExameRequisicao(reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("fil_codigo"), false, false);
                    this.gerarResultadoAtual(reqAlvaro, exResultado, reg, exJalisWsSalvo, dados);
                    this.gerarResultadoAntibiogramas(exResultado, reg, dados);
                    this.gerarGrafico(exResultado, reg, dados);
                    this.gerarResultado(reqAlvaro, exResultado, reg, exJalisWsSalvo, exAlvaroNovo, dados);
                    Map<Integer, String> resAnterior = ExameUtil.getResultadosAnteriores(filCodigo, reg.getString("req_codigo"), reg.getString("pac_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), reg.getString("met_codigo"));
                    dados.putAll(RecepcaoUtil.preencheHashDados(reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo")));
                    Map<String, Map<String, String>> historicos = ExameUtil.getHistoricos(reg.getString("exa_codigo"), reg.getString("fil_codigo"));
                    if (!historicos.isEmpty() && historicos.get("historicoporcodigo").isEmpty()) {
                        historicos = ExameUtil.getHistoricos(null, reg.getString("fil_codigo"));
                    }
                    Resultado res = new Resultado(formatacao.getString("formato"), dados);
                    res.atualizarComponentes();
                    res = new Resultado(null, formatacao.getString("formato"), dados, null, historicos.get("historicoporcodigo"), historicos.get("historicopormnemonico"), resAnterior, null, true, ParametrosGerais.getOrdenarExamesAnteriores().equals("C") ? 0 : 1, false, res.getResultado());
                    res.atualizarComponentes();
                    if (!res.verificarCondicao()) {
                        this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA);
                        this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + " - Condi\u00e7\u00e3o insatisfeita", false);
                        continue;
                    }
                    boolean completo = true;
                    if (reg.getBoolean("exa_salvaparcial")) {
                        completo = res.resultadoCompleto(true);
                    }
                    if (!completo && reg.getBoolean("exa_salvaparcial")) {
                        completo = res.resultadoCompleto(false);
                    }
                    String novaSituacao = completo ? "L" : "P";
                    String resultado = completo ? res.getResultado() : res.getResultadoParcial();
                    Util.gravaAlteracaoExameRequisicao(st, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"));
                    boolean marcarConferido = false;
                    if (this.conferirAutomatico && this.codigoUsuarioConferenciaAutomatica != null && completo) {
                        int verificacao = res.verificarValidacao();
                        boolean bl = marcarConferido = verificacao == 1;
                        if (!marcarConferido && verificacao != 2) {
                            this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, AbstractImportadorResultadoLabExterno.Situacao.VALIDACAO_INSATISFEITA);
                            this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + reg.getString("req_codigo") + "|" + reg.getString("exa_codigo") + (!Funcoes.textoVazio(res.getMensagemValidacao()) ? " - " + res.getMensagemValidacao() : ""), false);
                        }
                        if (marcarConferido) {
                            String string2 = novaSituacao = completo ? "C" : "P";
                        }
                    }
                    if (!this.existeRequisicaoLabExterno(reg.getInt("fil_codigo"), this.codigoLabExterno, reg.getInt("req_codigo"), reqAlvaro.codigoAlvaro)) {
                        this.inserirDadosRequisicao(st, this.codigoLabExterno, reqAlvaro.codigoAlvaro, reg.getString("fil_codigo"), reg.getInt("req_codigo"));
                    }
                    boolean validacaoCompulsoria = res.verificarValidacaoCompulsoria() == 1;
                    boolean validacaoResultadoCritico = res.verificarValidacaoResultadoCritico() == 1;
                    this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, formatacao.getString("met_codigo"), reg, reg, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                    if (this.exportarBaseWeb(filCodigo)) {
                        Map<String, Object> mapa = ResultadosUtil.geraResultadoParaWeb(st2, filCodigo, reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), resultado, false);
                        this.exportarParaWeb(st, this.getCodigoBaseWeb(filCodigo), novaSituacao, reg, mapa, resultado, formatacao.getString("formato"));
                        if (ExportaWeb.isGerarPdfResultado(st2, filCodigo)) {
                            ExportaWeb.enviarResultadoPDF(st2, filCodigo, reg.getString("req_codigo"), this.getCodigoBaseWeb(filCodigo));
                        }
                    }
                    this.adicionarAoModeloRelatorio(reqAlvaro, exResultado, completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE);
                    if (completo) {
                        Date dataColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        Date horaColeta = ParametrosGerais.getDataAnterioresUsandoColeta() ? reg.getDate("exr_datamaterial") : new Date();
                        this.atualizarTabelaExamesControle(st, reg, res.getResultadoAnterior(dataColeta, horaColeta));
                    }
                    ExportaWeb.atualizaPaginaOrdemExameWeb(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), this.getCodigoBaseWeb(filCodigo));
                    this.editarRequisicaoExportaFiliais(reg);
                    this.atualizarSituacaoExameInterfaceamento(st, reg);
                    this.setTextoInformacoes("\nResultado recebido para: " + Funcoes.preencheZero(reg.getString("fil_codigo"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reg.getString("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao()) + "|" + codExameTexto + " - " + (Object)((Object)(completo ? (marcarConferido ? AbstractImportadorResultadoLabExterno.Situacao.CONFERIDO : AbstractImportadorResultadoLabExterno.Situacao.LANCADO) : AbstractImportadorResultadoLabExterno.Situacao.LANCADO_PARCIALMENTE)), false);
                    this.requisicoesNotificar.put(Funcoes.getChaveFilReq(reg.getString("fil_codigo"), reg.getString("req_codigo")), reg.getString("req_codigo"));
                }
            }
        }
    }

    private void associaExameMaterialJalis(RequisicaoJalisWS reqAlvaro, List<ExameRelacionamentoJalisWs> examesJalis) {
        block0: for (ExameResultadoJalisWS exResultado : reqAlvaro.exames) {
            block1: for (ExameRelacionamentoJalisWs exameMatJalis : examesJalis) {
                if (StringUtil.getValor(exameMatJalis.getXml(), "codigo").equals(exResultado.codigo)) {
                    exResultado.exameJalis = exameMatJalis.getExame();
                    exResultado.materialJalis = exameMatJalis.getMaterial();
                    continue block0;
                }
                for (ExameRelacionamentoJalisWs exameMatDesmJalis : exameMatJalis.getExameDesm()) {
                    if (!StringUtil.getValor(exameMatDesmJalis.getXml(), "codigo").equals(exResultado.codigo)) continue;
                    exResultado.exameJalis = exameMatDesmJalis.getExame();
                    exResultado.materialJalis = exameMatDesmJalis.getMaterial();
                    continue block1;
                }
            }
        }
    }

    private boolean pararImportacaoExame(RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado, Registro reg) throws IOException, SQLException {
        return this.pdfDesmImportado(reg) || this.resultadoLancado(reg, reqAlvaro, exResultado) || this.resultadoImportadoEmPdf(reg, exResultado, reqAlvaro) || this.resultadoImportadoEmLayout(reg, exResultado, reqAlvaro) || this.pararImportacao(reg, reqAlvaro, exResultado);
    }

    private void gerarResultadoAtual(RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado, Registro reg, ExameJalisWS exJalisWsSalvo, Map<String, Object> dados) {
        String resultadoAtual = "";
        for (LinhaResultadoJalisWS linha : exResultado.linhasResultado) {
            LinhaResultado linhaEstrutura = exJalisWsSalvo.getLinha(linha.codigo);
            if (linhaEstrutura != null && !linhaEstrutura.getTempos().isEmpty()) {
                Iterator<Object> iterator = linhaEstrutura.getTempos().iterator();
                while (iterator.hasNext()) {
                    String tempo;
                    String descricao = tempo = iterator.next();
                    AmostraJalisWS amostra = reqAlvaro.amostras.get(linha.codigoAmostra);
                    if (amostra == null || !descricao.equals(amostra.descricao)) continue;
                    dados.put(linha.codigo + "_tempo_" + tempo, linha.resultado);
                    if (this.validaLinhasResultado(exResultado)) {
                        dados.put("unidade_" + linha.codigo + "_tempo_" + tempo, linha.unidade);
                    } else {
                        dados.put("unidade_tempo_" + tempo, linha.unidade);
                    }
                    this.adicionaValorExameDesmembrado(reg, dados, linha);
                    break;
                }
            } else if (!linha.codigoAmostra.equals("0") && reqAlvaro.amostras.get(linha.codigoAmostra) != null && reqAlvaro.amostras.get((Object)linha.codigoAmostra).descricao.equals("basal")) {
                dados.put(linha.codigo + "_tempo_0", linha.resultado);
                dados.put(linha.codigo, linha.resultado);
                if (this.validaLinhasResultado(exResultado)) {
                    dados.put("unidade_" + linha.codigo, linha.unidade);
                } else {
                    dados.put("unidade", linha.unidade);
                }
                resultadoAtual = this.getXmlResultadoAtual(reg, resultadoAtual, linha);
                this.adicionaValorExameDesmembrado(reg, dados, linha);
            } else {
                if (linha.codigoAmostra.equals("0")) {
                    dados.put(linha.codigo + "_tempo_" + linha.codigoAmostra, linha.resultado);
                }
                dados.put(linha.codigo, linha.resultado);
                if (this.validaLinhasResultado(exResultado)) {
                    dados.put("unidade_" + linha.codigo, linha.unidade);
                } else {
                    dados.put("unidade", linha.unidade);
                }
                resultadoAtual = this.getXmlResultadoAtual(reg, resultadoAtual, linha);
                this.adicionaValorExameDesmembrado(reg, dados, linha);
            }
            for (CampoResultadoJalisWS campo : linha.camposCompl) {
                dados.put(linha.codigo + "_" + campo.codigo, campo.resultado);
            }
        }
    }

    private void gerarGrafico(ExameResultadoJalisWS exResultado, Registro reg, Map<String, Object> dados) {
        if (!Funcoes.textoVazio(exResultado.grafico)) {
            if (reg.getValor("examePai") != null) {
                String chave = "grafico@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
                dados.put(chave, this.getGrafico(exResultado.grafico));
            } else {
                dados.put("grafico", this.getGrafico(exResultado.grafico));
            }
        }
    }

    private void gerarResultadoAntibiogramas(ExameResultadoJalisWS exResultado, Registro reg, Map<String, Object> dados) {
        if (!Funcoes.textoVazio(exResultado.resultadoAntibiogramas)) {
            if (reg.getValor("examePai") != null) {
                String chave = "antibiogramas@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
                dados.put(chave, exResultado.resultadoAntibiogramas);
            } else {
                dados.put("antibiogramas", exResultado.resultadoAntibiogramas);
            }
        }
    }

    private void gerarResultado(RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado, Registro reg, ExameJalisWS exJalisWsSalvo, ExameJalisWS exJalisWsNovo, Map<String, Object> dados) {
        if (reg.getValor("examePai") != null) {
            dados.put(this.padronizarCampo("codigo", reg), reqAlvaro.codigoAlvaro);
            dados.put(this.padronizarCampo("codigo_aol", reg), reqAlvaro.codigoAOL);
            dados.put(this.padronizarCampo("observacao", reg), exResultado.observacao);
            dados.put(this.padronizarCampo("metodologia", reg), exResultado.metodo);
            dados.put(this.padronizarCampo("data_rst", reg), exResultado.dataResultado);
            dados.put(this.padronizarCampo("desc_exame", reg), exJalisWsSalvo.getDescricao());
            dados.put(this.padronizarCampo("cod_exame_alv", reg), exJalisWsSalvo.getCodigo());
            dados.put(this.padronizarCampo("data_alt", reg), exJalisWsSalvo.getDataAlteracao());
            dados.put(this.padronizarCampo("valor_ref", reg), exJalisWsNovo != null && exJalisWsNovo.getValorReferencia() != null && !exJalisWsNovo.getValorReferencia().equals(exJalisWsSalvo.getValorReferencia()) ? exJalisWsNovo.getValorReferencia() : exJalisWsSalvo.getValorReferencia());
            dados.put(this.padronizarCampo("cod_mat_alv", reg), exJalisWsSalvo.getMaterial());
        } else {
            dados.put("codigo", reqAlvaro.codigoAlvaro);
            dados.put("codigo_aol", reqAlvaro.codigoAOL);
            dados.put("observacao", exResultado.observacao);
            dados.put("metodologia", exResultado.metodo);
            dados.put("data_rst", exResultado.dataResultado);
            dados.put("desc_exame", exJalisWsSalvo.getDescricao());
            dados.put("cod_exame_alv", exJalisWsSalvo.getCodigo());
            dados.put("data_alt", exJalisWsSalvo.getDataAlteracao());
            dados.put("valor_ref", exJalisWsNovo != null && exJalisWsNovo.getValorReferencia() != null && !exJalisWsNovo.getValorReferencia().equals(exJalisWsSalvo.getValorReferencia()) ? exJalisWsNovo.getValorReferencia() : exJalisWsSalvo.getValorReferencia());
            dados.put("cod_mat_alv", exJalisWsSalvo.getMaterial());
        }
    }

    private String padronizarCampo(String campo, Registro reg) {
        return campo + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
    }

    private boolean validaLinhasResultado(ExameResultadoJalisWS exResultado) {
        return exResultado.linhasResultado.size() > 1;
    }

    private String getXmlResultadoAtual(Registro reg, String resultadoAtual, LinhaResultadoJalisWS linha) {
        String tag = reg.getValor("exameFilho") == null ? reg.getValor("exa_codigo").toString() : reg.getValor("exameFilho").toString();
        tag = tag.toLowerCase();
        resultadoAtual = resultadoAtual + "<" + tag + ">";
        resultadoAtual = resultadoAtual + linha.resultado;
        resultadoAtual = resultadoAtual + "</" + tag + ">";
        return resultadoAtual;
    }

    private void adicionaValorExameDesmembrado(Registro reg, Map<String, Object> dados, LinhaResultadoJalisWS linha) {
        if (reg.getValor("examePai") != null) {
            String chave = linha.codigo.trim() + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linha.resultado);
            chave = "unidade".trim() + "@" + reg.getString("exameFilho") + "#" + reg.getString("mco_codigo");
            dados.put(chave, linha.unidade);
        }
    }

    private LinkedList<Registro> processarPaiFilhos(RequisicaoJalisWS reqAlvaro, ExameResultadoJalisWS exResultado, String filCodigo, String reqCodigo, boolean isLogEmailSMS) throws SQLException {
        ArrayList<Registro> reqLote;
        boolean agruparMultiguia;
        LinkedList<Registro> retorno = new LinkedList<Registro>();
        Integer[] multiguias = RecepcaoUtil.verificaMultiGuias(filCodigo, reqCodigo, true);
        boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || this.agruparMultiguiaLabExterno;
        if (!agruparMultiguia) {
            multiguias = new Integer[]{Integer.parseInt(reqCodigo)};
        }
        if (!(reqLote = ImportacaoResultadoJalisWS.verificaRequisicoesComLote(multiguias, filCodigo)).isEmpty()) {
            for (Integer multiguia : multiguias) {
                ExameDesmembrado pai;
                String codigoJalisAux = reqAlvaro.codigoJalis;
                reqAlvaro.codigoJalis = StringUtil.preencheString(filCodigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1) + StringUtil.preencheString(multiguia.toString(), ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                Registro exameSeparado = this.localizaExameRequisicao(reqAlvaro, exResultado);
                if (exameSeparado != null) {
                    retorno.add(exameSeparado);
                }
                if (this.existePai(pai = this.dao.getExamesDesmembrados(filCodigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exResultado.exameJalis, exResultado.materialJalis))) {
                    String codigoJalisTemp = exResultado.exameJalis;
                    exResultado.exameJalis = pai.getCodigoExame();
                    Registro reg = this.localizaExameRequisicao(reqAlvaro, exResultado);
                    if (reg != null) {
                        reg.setValor("exa_codigo", pai.getFilhos().get(0).getCodigoExame());
                        reg.setValor("ele_xmllabexterno", pai.getFilhos().get(0).getXmlLabExterno());
                        reg.setValor("xmllabexternopai", pai.getXmlLabExterno());
                        reg.setValor("examePai", pai.getCodigoExame());
                        reg.setValor("exameFilho", pai.getFilhos().get(0).getCodigoExame());
                        reg.setValor("importado", exResultado.importado);
                        exResultado.exameJalis = codigoJalisTemp;
                        retorno.add(reg);
                    }
                }
                reqAlvaro.codigoJalis = codigoJalisAux;
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Registro> verificaRequisicoesComLote(Integer[] multiguias, String filial) {
        ArrayList<Registro> lista = new ArrayList<Registro>();
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder();
        buf.append("select distinct lot.leq_retornows as retornoWs, lot.lex_codigo ");
        buf.append("  from loteexternorequisicao lot ");
        buf.append(" where lot.fil_kodigo = ").append(filial);
        buf.append("   and lot.req_codigo in (").append(StringUtil.implode(Arrays.asList(multiguias), ",")).append(") ");
        buf.append("   and lot.leq_dataestorno is null ");
        try {
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            while (rs.next()) {
                lista.add(new Registro(rs));
            }
            rs.close();
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e2o foi poss\u00edvel verificar lote externo.\n" + e.getMessage(), e.getStackTrace());
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
        return lista;
    }

    private String getGrafico(String pontos) {
        LinkedList<String[]> coordenadas = new LinkedList<String[]>();
        Double pontoMaisAlto = 0.0;
        for (String hex : pontos.split(";")) {
            Double ponto = this.ponto(hex.substring(1));
            if (ponto > pontoMaisAlto) {
                pontoMaisAlto = ponto;
            }
            coordenadas.add(new String[]{hex.substring(0, 1), String.valueOf(ponto)});
        }
        Image i = Toolkit.getDefaultToolkit().createImage(this.criarImagem(coordenadas, pontoMaisAlto).getSource());
        return new Base64().encodeAsString(ImagemUtils.imageToByte(i));
    }

    private Double ponto(String ponto) {
        Double ret = 0.0;
        String hex = "0123456789ABCDEF";
        int x = ponto.length();
        for (int i = 0; i < ponto.length(); ++i) {
            int pos = hex.indexOf(String.valueOf(ponto.charAt(i)));
            pos = pos == -1 ? 0 : pos;
            Double d = Math.pow(Double.parseDouble("16"), Double.parseDouble(String.valueOf(x)));
            ret = ret + (double)pos * d;
            --x;
        }
        return ret / 100.0;
    }

    private BufferedImage criarImagem(List<String[]> coordenadas, double pontoMaisAlto) {
        BufferedImage b = new BufferedImage(640, 480, 1);
        Graphics2D g = b.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 640, 480);
        g.setColor(Color.BLACK);
        int px1 = 0;
        int py1 = 480;
        int max = coordenadas.size();
        int pos = 0;
        for (String[] coordenada : coordenadas) {
            int px2 = Math.round(pos * 640 / max);
            int py2 = (int)(480L - Math.round(Double.parseDouble(coordenada[1]) * 480.0 / pontoMaisAlto) - 1L);
            g.drawLine(px1, py1, px2, py2);
            if (coordenada[0].equals("B")) {
                g.drawLine(px1, 480, px2 - 1, py2);
            }
            px1 = px2 + 1;
            py1 = py2;
            ++pos;
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExameJalisWS getExameAlvaro(String codigoFilial, String codigoExameAlvaro) {
        Statement st;
        block4: {
            ExameJalisWS exameJalisWS;
            st = Conexao.getStatement();
            try {
                String sql = "select alv_xml from examesalvaro where fil_codigo = " + codigoFilial + " and alv_codexame = '" + codigoExameAlvaro + "'";
                ResultSet rs = st.executeQuery(sql);
                if (!rs.next()) break block4;
                exameJalisWS = new ExameJalisWS(rs.getString("alv_xml"));
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 237");
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
            return exameJalisWS;
        }
        Conexao.fecharStatement(st);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void atualizaVersaoLayoutExame(Registro reg, ExameResultadoJalisWS exame) {
        Statement st = Conexao.getStatement();
        try {
            ExameJalisWS exaAlvaro = new ExameJalisWS(reg.getString("ele_xmllabexterno"));
            exaAlvaro.setDataAlteracao(exame.dataAlteracao);
            String exa = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "codigo");
            String mco = StringUtil.getValor(reg.getString("ele_xmllabexterno"), "material");
            StringBuilder bui = new StringBuilder("");
            bui.append("update examematcoletalabexterno set \n");
            bui.append("  ele_xmllabexterno = '").append(exaAlvaro.getXml()).append("' \n");
            bui.append("where \n");
            bui.append("  fil_codigo = ").append(reg.getString("fil_codigo")).append(" and \n");
            bui.append("  exa_codigo = '").append(exa).append("' and \n");
            bui.append("  mco_codigo = ").append(mco).append(" and \n");
            bui.append("  lae_codigo = ").append(this.codigoLabExterno).append(" \n");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
            exaAlvaro = null;
            exaAlvaro = new ExameJalisWS(reg.getString("alv_xml"));
            exaAlvaro.setDataAlteracao(exame.dataAlteracao);
            bui.setLength(0);
            bui.append("update examesalvaro set alv_xml = '").append(exaAlvaro.getXml()).append("' ");
            bui.append(" where fil_codigo = ").append(reg.getString("fil_codigo"));
            bui.append(" and lae_codigo = ").append(this.codigoLabExterno);
            bui.append(" and alv_codexame = '").append(exa).append("'");
            bui.append(" and alv_codmaterial = '").append(mco).append("' ");
            Conexao.executeUpdate(reg.getString("fil_codigo"), st, bui.toString());
        }
        catch (SQLException e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoAlvaro: 268");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enviarNotificacoes(Map<String, String> hashMapFilialRequisicao) throws Exception {
        if (!hashMapFilialRequisicao.isEmpty() && this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica)) {
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            String filial = "";
            String requisicao = "";
            try {
                for (Map.Entry<String, String> filReq : hashMapFilialRequisicao.entrySet()) {
                    String[] filialRequisicao = filReq.getKey().split("-");
                    if (filialRequisicao.length <= 1) continue;
                    filial = filialRequisicao[0];
                    requisicao = filialRequisicao[1];
                    this.criarLog(st, st2, filial, requisicao);
                }
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st, st2);
                throw throwable;
            }
            Conexao.fecharStatement(st, st2);
        }
    }

    private void criarLog(Statement st, Statement st2, String filial, String requisicao) throws Exception {
        if (!SMSUtil.isBloquearSMSExamePronto(filial, requisicao, st)) {
            SMSUtil.criaLogSmsComDadosRequisicao(filial, requisicao, ExportaSMS.TipoSMS.RESULTADO, st, st2);
        }
        if (!EmailUtil.isBloquearEmailExamePronto(filial, requisicao, st)) {
            EmailUtil.criaLogEmail(filial, requisicao, null, EmailUtil.TipoEmail.RESULTADO, true, st);
        }
        if (!PushUtil.isBloquearPushExamePronto(filial, requisicao, st)) {
            PushUtil.criaLogPushComDadosRequisicao(filial, requisicao, TipoPush.RESULTADO, st, st2);
        }
        if (!WhatsAppUtil.isBloquearWhatsappExamePronto(filial, requisicao, st)) {
            WhatsAppUtil.criaLogWhatsappComDadosRequisicao(filial, requisicao, TipoWhatsapp.RESULTADO, st, st2);
        }
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    protected void parse(List<Element> elements) {
        for (Element e : elements) {
            if (e.getNodeName().equalsIgnoreCase("resultados")) {
                if (e.getAttribute("versao").equalsIgnoreCase(VERSAO)) continue;
                this.setTextoInformacoes("O arquivo selecionado n\u00e3o \u00e9 um XML de resultado v\u00e1lido");
                return;
            }
            if (e.getNodeName().equalsIgnoreCase("exame")) {
                this.parseExameCadastro(e);
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("pacientes")) {
                this.parsePacientes(XMLUtil.getElementosFilhos(e));
                continue;
            }
            if (e.getNodeName().equalsIgnoreCase("solicitacao")) {
                this.parseSolicitacao(e);
                this.progress.setValue(this.progress.getValue() + 1);
                continue;
            }
            if (!e.hasChildNodes()) continue;
            this.parse(XMLUtil.getElementosFilhos(e));
        }
    }

    private void parseExameCadastro(Element element) {
        ExameJalisWS exame = new ExameJalisWS();
        String codigoExame = element.getAttribute("codigo");
        exame.setCodigo(codigoExame);
        exame.setDescricao(element.getAttribute("descricao"));
        exame.setDataAlteracao(element.getAttribute("dataalteracao"));
        List<Element> list = XMLUtil.getElementosFilhos(element);
        for (Element e : list) {
            if (e.getNodeName().equalsIgnoreCase("linhasresultado")) {
                for (Element l : XMLUtil.getElementosFilhos(e)) {
                    LinhaResultado linha = new LinhaResultado();
                    linha.setCodigo(l.getAttribute("codigo"));
                    linha.setDescricao(l.getAttribute("descricao"));
                    linha.setUnidade(l.getAttribute("unidade"));
                    exame.getLinhasResultado().add(linha);
                }
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("valorreferencia") || Funcoes.textoVazio(e.getTextContent())) continue;
            exame.setValorReferencia(e.getTextContent().trim());
        }
        this.examesCadastro.put(codigoExame, exame);
    }

    private void parsePacientes(List<Element> elements) {
        for (Element e : elements) {
            PacienteJalisWS paciente = new PacienteJalisWS();
            paciente.codigoAlvaro = e.getAttribute("codigo");
            paciente.codigoJalis = e.getAttribute("codigo_lis");
            paciente.codigoAOL = e.getAttribute("codigo_aol");
            paciente.dataNascimento = e.getAttribute("datanasc");
            paciente.nome = e.getAttribute("nome");
            paciente.sexo = e.getAttribute("sexo");
            this.pacientes.add(paciente);
        }
    }

    private void parseSolicitacao(Element element) {
        RequisicaoJalisWS requisicao = new RequisicaoJalisWS();
        requisicao.codigoAlvaro = element.getAttribute("codigo");
        requisicao.codigoJalis = element.getAttribute("codigo_lis");
        requisicao.codigoAOL = element.getAttribute("codigo_aol");
        requisicao.paciente = this.locatePaciente(element.getAttribute("paciente"));
        if (!Funcoes.isNumeric(requisicao.codigoJalis) || !this.validaCodigoRequisicao(requisicao.codigoJalis)) {
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: C\u00f3digo incorreto da requisi\u00e7\u00e3o Jalis. " + requisicao.codigoJalis + " C\u00f3digo no \u00c1lvaro: " + requisicao.codigoAlvaro, false);
            return;
        }
        HashMap<String, String> examesJalis = this.localizaExameJalis(requisicao, element.getAttribute("paciente"));
        List<Element> list = XMLUtil.getElementosFilhos(element);
        requisicao.exames = new ArrayList();
        for (Element e : list) {
            if (e.getNodeName().equalsIgnoreCase("amostras")) {
                this.parseAmostras(XMLUtil.getElementosFilhos(e), requisicao);
                continue;
            }
            if (!e.getNodeName().equalsIgnoreCase("exame")) continue;
            this.parseExameResultado(e, requisicao, examesJalis);
        }
        this.requisicoes.add(requisicao);
    }

    private boolean validaCodigoRequisicao(String codigoRequisicao) {
        return !Funcoes.textoVazio(codigoRequisicao) && codigoRequisicao.matches("[0-9]+");
    }

    private void parseExameResultado(Element e, RequisicaoJalisWS requisicao, HashMap<String, String> examesJalis) {
        String codigoExame = e.getAttribute("codigo");
        if (!this.examesCadastro.containsKey(codigoExame)) {
            return;
        }
        ExameJalisWS exameCadastro = this.examesCadastro.get(codigoExame);
        ExameResultadoJalisWS exame = new ExameResultadoJalisWS();
        exame.codigo = codigoExame;
        exame.dataResultado = e.getAttribute("dataresultado");
        if (!Funcoes.textoVazio(e.getAttribute("metodo"))) {
            exame.metodo = this.removeCaracteresMetodo(e.getAttribute("metodo"));
        }
        exame.normal = e.getAttribute("normal");
        exame.dataAlteracao = exameCadastro.getDataAlteracao();
        exame.descricao = exameCadastro.getDescricao();
        StringBuilder observacao = new StringBuilder();
        if (!Funcoes.textoVazio(e.getAttribute("observacao"))) {
            observacao.append(this.trocaCaracteres(e.getAttribute("observacao") + "\n"));
        }
        List<Element> elements = XMLUtil.getElementosFilhos(e);
        StringBuilder resultadoAntibiogramas = new StringBuilder("");
        String grafico = null;
        String[] exameMaterialApoio = this.getExameMaterialApoio(codigoExame);
        for (Element ele : elements) {
            if (ele.getNodeName().equals("resultado")) {
                boolean resultadoImportado = !Funcoes.textoVazio(exame.resultadoLayout) || !Funcoes.textoVazio(exame.resultadoPdf);
                if (resultadoImportado) continue;
                LinhaResultadoJalisWS linhaResultadoJalisWS = this.montaLinhaResultadoJalisWs(exameCadastro, observacao, ele);
                exame.linhasResultado.add(linhaResultadoJalisWS);
                continue;
            }
            if (ele.getNodeName().equals("resultado_layout") || ele.getNodeName().equals("resultado_pdf")) {
                Integer tipo = ele.getNodeName().equals("resultado_layout") ? 1 : 2;
                try {
                    Map<String, String> map = this.montaResultadoPorExame(requisicao.codigoAlvaro, exameMaterialApoio[0], exameMaterialApoio[1], String.valueOf(tipo));
                    if (map.isEmpty() || !map.containsKey("id_lis") || !map.get("id_lis").equalsIgnoreCase(codigoExame) || !map.containsKey("codigo_lis") || !map.get("codigo_lis").equals(requisicao.codigoJalis)) continue;
                    if (map.containsKey("conteudolayout")) {
                        exame.resultadoLayout = map.get("conteudolayout");
                        continue;
                    }
                    if (!map.containsKey("conteudopdf")) continue;
                    exame.resultadoPdf = map.get("conteudopdf");
                }
                catch (Exception exception) {}
                continue;
            }
            if (ele.getNodeName().equals("camposcomplementares")) {
                for (Element element : XMLUtil.getElementosFilhos(ele)) {
                    CampoResultadoJalisWS campo = new CampoResultadoJalisWS();
                    campo.codigo = element.getAttribute("codigo");
                    campo.resultado = this.trocaCaracteres(element.getAttribute("resultado"));
                    if (!exame.linhasResultado.isEmpty()) continue;
                    exame.linhasResultado.get((int)(exame.linhasResultado.size() - 1)).camposCompl.add(campo);
                }
                continue;
            }
            if (ele.getNodeName().equals("antibiograma")) {
                String format = "%1$-35s%2$-15s%3$9s\n";
                for (Element element2 : XMLUtil.getElementosFilhos(ele)) {
                    CampoResultadoJalisWS campo = new CampoResultadoJalisWS();
                    resultadoAntibiogramas.append(String.format(format, element2.getAttribute("antibiotico"), campo.getResistencia(element2.getAttribute("resistencia")), element2.getAttribute("mic")));
                }
                continue;
            }
            if (!ele.getNodeName().equals("curvas")) continue;
            for (Element element : XMLUtil.getElementosFilhos(ele)) {
                grafico = element.getAttribute("pontos");
            }
        }
        exame.observacao = observacao.toString();
        exame.resultadoAntibiogramas = resultadoAntibiogramas.toString();
        exame.grafico = grafico;
        requisicao.exames.add(exame);
    }

    private String[] getExameMaterialApoio(String codigoExame) {
        String[] exameMaterialApoio = new String[2];
        if (!Funcoes.textoVazio(codigoExame)) {
            exameMaterialApoio = codigoExame.replace("|", "-").split("-");
        }
        return exameMaterialApoio;
    }

    private Map<String, String> montaResultadoPorExame(String codigoRequisicao, String exame, String material, String tipo) throws IOException {
        File arquivo = this.service.importarResultadoPorExameWS(codigoRequisicao, exame, material, tipo);
        Document doc = null;
        try {
            doc = XMLUtil.analisarXML(arquivo);
        }
        catch (Exception e1) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), "N\u00e3o foi poss\u00edvel analisar o XML.\n" + e1.getMessage(), e1.getStackTrace());
        }
        if (doc == null) {
            this.setTextoInformacoes("N\u00e3o foi poss\u00edvel analisar o arquivo: " + arquivo.getPath());
            return new HashMap<String, String>();
        }
        Element raiz = doc.getDocumentElement();
        return XMLUtil.getAtributosDoElemento(raiz);
    }

    private LinhaResultadoJalisWS montaLinhaResultadoJalisWs(ExameJalisWS exameCadastro, StringBuilder observacao, Element ele) {
        LinhaResultadoJalisWS linha = new LinhaResultadoJalisWS();
        linha.codigo = ele.getAttribute("linharesultado");
        linha.codigoAmostra = ele.getAttribute("amostra");
        linha.resultado = this.trocaCaracteres(ele.getAttribute("resultado"));
        for (LinhaResultado b : exameCadastro.getLinhasResultado()) {
            if (!linha.codigo.equalsIgnoreCase(b.getCodigo())) continue;
            linha.unidade = b.getUnidade();
            break;
        }
        if (!Funcoes.textoVazio(ele.getAttribute("observacao"))) {
            observacao.append(this.trocaCaracteres(ele.getAttribute("observacao") + "\n"));
        }
        return linha;
    }

    private HashMap<String, String> localizaExameJalis(RequisicaoJalisWS requisicao, String paciente) {
        String fil = Funcoes.getFilialRequisicao(requisicao.codigoJalis)[0];
        String req = Funcoes.getFilialRequisicao(requisicao.codigoJalis)[1];
        Statement st = Conexao.getStatement();
        HashMap<String, String> retorno = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder("select \n");
        sql.append("  f.ele_xmllabexterno , b.exa_codigo, b.mco_codigo \n");
        sql.append("from requisicao a \n");
        sql.append(" join examerequisicao b  on a.fil_codigo = b.fil_codigo and a.req_codigo = b.req_codigo \n");
        sql.append(" join loteexternoexamerequisicao c  on a.fil_codigo = c.fil_kodigo and a.req_codigo = c.req_codigo and b.exa_codigo = c.exa_codigo and b.mco_codigo = c.mco_codigo \n");
        sql.append("left join exames d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo \n");
        sql.append("left join examematcoleta e on b.fil_codigo = e.fil_codigo and b.exa_codigo = e.exa_codigo and b.mco_codigo = e.mco_codigo \n");
        sql.append("left join examematcoletalabexterno f on e.fil_codigo = f.fil_codigo and e.exa_codigo = f.exa_codigo and e.mco_codigo = f.mco_codigo and c.lae_codigo = f.lae_codigo ");
        sql.append("where \n");
        sql.append("  a.fil_codigo = ").append(fil).append(" and \n");
        sql.append("  a.req_codigo = ").append(req).append(" and \n");
        if (!Funcoes.textoVazio(paciente)) {
            sql.append("  a.pac_codigo = ").append(paciente).append(" and \n");
        } else {
            this.setTextoInformacoes("\nSem o c\u00f3digo do paciente na requisi\u00e7\u00e3o do Jalis. : " + requisicao.codigoJalis, false);
        }
        sql.append("  c.lae_codigo = ").append(this.codigoLabExterno).append(" and \n");
        sql.append("  a.req_excluida = false and b.exr_excluido = false and \n");
        sql.append("  f.ele_xmllabexterno is not null and f.ele_xmllabexterno <> '' ");
        try {
            ResultSet res = Conexao.executeQuery(st, sql.toString());
            StringBuilder buf = new StringBuilder();
            while (res.next()) {
                buf.setLength(0);
                String exameAlvaro = StringUtil.getValor(StringUtil.getValor(StringUtil.getValor(res.getString("ele_xmllabexterno"), "alvaro"), "exame"), "codigo");
                buf.append(res.getString("exa_codigo")).append("|").append(res.getString("mco_codigo"));
                if (Funcoes.textoVazio(exameAlvaro)) continue;
                retorno.put(exameAlvaro, buf.toString());
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    private String trocaCaracteres(String texto) {
        if (texto == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] caracteres = texto.split(";");
        boolean isFim = false;
        for (int i = 0; i < caracteres.length; ++i) {
            if (!isFim && caracteres[i].equals("&#xD") || caracteres[i].equals("&#xA")) {
                if (caracteres[i + 1].equals("&#xD") || caracteres[i + 1].equals("&#xA")) continue;
                isFim = true;
                continue;
            }
            buf.append(caracteres[i]);
        }
        texto = buf.toString();
        texto = texto.replace("&#xD", "\n");
        texto = texto.replace("&#xA", "\n");
        texto = texto.replace("&amp;#xA;", "\n");
        texto = texto.replace("&amp;#xD;", "\n");
        return texto;
    }

    private String removeCaracteresMetodo(String texto) {
        if (texto == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        String[] caracteres = texto.split(";");
        for (int i = 0; i < caracteres.length; ++i) {
            if (caracteres[i].equals("&#xD") || caracteres[i].equals("&#xA")) continue;
            buf.append(caracteres[i]);
        }
        texto = buf.toString();
        texto = texto.replace("&#xD", "");
        texto = texto.replace("&#xA", "");
        texto = texto.replace("&amp;#xA;", "");
        texto = texto.replace("&amp;#xD;", "");
        return texto;
    }

    private void parseAmostras(List<Element> elements, RequisicaoJalisWS requisicao) {
        for (Element e : elements) {
            String codigo;
            AmostraJalisWS amostra = new AmostraJalisWS();
            amostra.codigo = codigo = e.getAttribute("codigo");
            amostra.descricao = e.getAttribute("descricao");
            amostra.material = e.getAttribute("material");
            requisicao.amostras.put(codigo, amostra);
        }
    }

    private PacienteJalisWS locatePaciente(String paciente) {
        for (PacienteJalisWS p : this.pacientes) {
            if (!p.codigoAOL.equalsIgnoreCase(paciente)) continue;
            return p;
        }
        return null;
    }

    private Registro localizaExameRequisicao(RequisicaoJalisWS requisicao, ExameResultadoJalisWS exame) throws SQLException {
        String fil = "";
        String req = requisicao.codigoJalis;
        String exa = exame.exameJalis;
        String mco = exame.materialJalis;
        if (Funcoes.textoVazio(req) || req.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()) {
            this.adicionarAoModeloRelatorio(requisicao, exame, AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: Sem c\u00f3digo de requisi\u00e7\u00e3o no Jalis. " + this.protocolo.getDescricao() + " : " + requisicao.codigoAlvaro, false);
            return null;
        }
        if (Funcoes.textoVazio(exa) || Funcoes.textoVazio(mco)) {
            this.adicionarAoModeloRelatorio(requisicao, exame, AbstractImportadorResultadoLabExterno.Situacao.CONDICAO_INSATISFEITA);
            this.setTextoInformacoes("\nN\u00e3o foi poss\u00edvel importar: N\u00e3o existe o exame na requisi\u00e7\u00e3o do Jalis. " + this.protocolo.getDescricao() + " : " + requisicao.codigoAlvaro, false);
            return null;
        }
        fil = req.substring(0, ParametrosGerais.getDigitosTuboFilial());
        Registro reg = ImportacaoResultadoJalisWSDao.localizaExame(fil, req = req.substring(ParametrosGerais.getDigitosTuboFilial()), exa, mco);
        if (reg != null) {
            return reg;
        }
        return null;
    }

    private void adicionarAoModeloRelatorio(RequisicaoJalisWS requisicao, ExameResultadoJalisWS exame, AbstractImportadorResultadoLabExterno.Situacao situacao) {
        if (this.validaTamanhoTubo(requisicao)) {
            return;
        }
        String filCodigo = requisicao.codigoJalis.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String reqCodigo = requisicao.codigoJalis.substring(ParametrosGerais.getDigitosTuboFilial());
        boolean agruparMultiguia = false;
        Integer[] multiguias = new Integer[]{Integer.parseInt(reqCodigo)};
        try {
            boolean bl = agruparMultiguia = ParametrosGerais.isAgruparGuiasInterface() || DBUtil.requisicaoAgrupaMultiguiasLabExterno(Conexao.getStatement(), filCodigo, reqCodigo);
            if (agruparMultiguia) {
                multiguias = RecepcaoUtil.verificaMultiGuias(filCodigo, reqCodigo, true);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
        }
        Statement st = Conexao.getStatement();
        String exames = "";
        for (Integer multiguia : multiguias) {
            try {
                exames = BDUtil.getCodigoExames(filCodigo, multiguia.toString(), st);
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), null);
            }
            if (this.validaExame(exame) && !exames.contains(exame.exameJalis)) {
                ExameDesmembrado pai = this.dao.getExamesDesmembrados(filCodigo, multiguia.toString(), String.valueOf(this.codigoLabExterno), exame.exameJalis, exame.materialJalis);
                if (!this.existePai(pai)) continue;
                RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filCodigo, multiguia.toString(), pai.getCodigoExame(), pai.getCodigomaterial(), situacao.descricao, true);
                continue;
            }
            if (!this.validaExame(exame)) continue;
            RelatorioImportacaoResultadoUtil.adicionarAoModeloRelatorio(this, this.codigoLabExterno, this.modeloRelatorio, filCodigo, multiguia.toString(), exame.exameJalis, Integer.parseInt(exame.materialJalis), situacao.descricao, true);
        }
    }

    private boolean existePai(ExameDesmembrado pai) {
        return pai != null;
    }

    private boolean validaExame(ExameResultadoJalisWS exame) {
        return exame != null && !Funcoes.textoVazio(exame.exameJalis) && !Funcoes.textoVazio(exame.materialJalis);
    }

    private boolean validaTamanhoTubo(RequisicaoJalisWS requisicao) {
        return requisicao.codigoJalis.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboFilial();
    }

    private boolean exameLancado(Registro reg) {
        if (reg != null && !Funcoes.textoVazio(reg.getString("exr_situacao"))) {
            String sit = reg.getString("exr_situacao");
            return sit.equals("L") || sit.equals("C") || sit.equals("I") || sit.equals("E") || sit.equals("O");
        }
        return false;
    }

    private boolean exameColetado(Registro reg) {
        return reg != null && Funcoes.textoVazio(reg.getString("exr_situacao"));
    }

    public boolean exameRelacionado(Registro reg) throws SQLException {
        if (reg != null) {
            String fil = reg.getString("fil_codigo");
            String exa = reg.getString("exa_codigo");
            String mco = reg.getString("mco_codigo");
            StringBuilder sql = new StringBuilder("select lae_codigo, ele_xmllabexterno from examematcoletalabexterno ");
            sql.append(" where fil_codigo = ").append(fil);
            sql.append(" and exa_codigo = '").append(exa).append("' and mco_codigo = ").append(mco);
            sql.append(" and lae_codigo = ").append(this.codigoLabExterno);
            sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
            Statement st = Conexao.getStatement();
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                if (rs.getInt("lae_codigo") == this.codigoLabExterno) {
                    String xml = rs.getString("ele_xmllabexterno");
                    reg.setValor("ele_xmllabexterno", xml);
                    exa = StringUtil.getValor(xml, "codigo");
                    mco = StringUtil.getValor(xml, "material");
                    StringBuilder sqlBuilder = new StringBuilder();
                    sqlBuilder.append("select alv_xml from examesalvaro where fil_codigo = ").append(fil);
                    sqlBuilder.append(" and lae_codigo = ").append(this.codigoLabExterno);
                    sqlBuilder.append(" and alv_codexame = '").append(exa).append("' and alv_codmaterial = '").append(mco).append("' ");
                    rs = st.executeQuery(sqlBuilder.toString());
                    if (rs.next()) {
                        reg.setValor("alv_xml", rs.getString("alv_xml"));
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void atualizarSituacaoExameInterfaceamento(Statement st, Registro reg) throws SQLException {
        DBUtil.setExameSituacaoInterfaceamento(st, reg.getString("fil_codigo"), reg.getString("req_codigo"), reg.getString("exa_codigo"), reg.getString("mco_codigo"), 8);
    }

    private void editarRequisicaoExportaFiliais(Registro reg) {
        try {
            ExportaFiliais.gravaRequisicao(Integer.parseInt(reg.getString("fil_codigo")), reg.getInt("req_codigo"), reg.getString("exa_codigo"), reg.getInt("mco_codigo"), "U", "U");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoJalisWS");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, this.modeloRelatorio);
        } else if (e.getSource() == this.buttonImportarWS) {
            if (this.periodoImportacaoPreenchido()) {
                this.modeloRelatorio.clear();
                this.buttonImportarWS.setEnabled(false);
                super.actionPerformed(e);
            }
            this.isWebService = true;
            new Thread(this).start();
            this.habilitarBotoes(true);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean periodoImportacaoPreenchido() {
        this.periodoImportacao = InformaPeriodoImportacaoJalisWS.novaInstancia(this.getTopLevelAncestor(), this.codigoLabExterno);
        return this.periodoImportacao.isOk();
    }

    @Override
    protected void importarResultado() {
    }
}

