/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalisws;

import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.alvaro.ConfiguradorProtocoloAlvaro;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class ConfiguradorProtocoloJalisWS
extends ConfiguradorProtocoloAlvaro
implements ActionListener {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    public static final String TAG_ENDERECO_WS = "enderecoWebService";
    public static final String CODIGO = "codigo";
    public static final String CHAVE = "chave";
    public static final String LOTE = "lote";
    public static final String PROCESSAR_ENTER = "processarEnter";
    public static final String ENVIAR_TUBO_LIS = "enviarTuboLis";
    public static final String TAG_ENVIO_AUTOMATICO = "envioAutomatico";
    public static final String TAG_IMPORTAR_LAYOUT_LAUDO = "importarLayoutLaudo";
    public static final String TAG_IMPORTAR_RESULTADO_PDF = "importarResultadoPdf";
    public static final String CODIGO_TUBO_LIS = "codigoTuboLis";
    public static final String ENVIAR_MEDICO = "enviarMedico";
    public static final String TAG_ENVIAR_WS = "enviarLoteWebService";
    protected JTextField textCodTuboLis;
    protected JCheckBox checkEnviarTuboLis;
    protected JCheckBox checkImportarLaudo;
    protected JCheckBox checkImportarPdf;

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLaboratorio) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloJalisWS((Frame)pai, "Jalis WS", codigoLaboratorio);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloJalisWS((Dialog)pai, "Jalis WS", codigoLaboratorio);
        }
        return null;
    }

    public ConfiguradorProtocoloJalisWS(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
    }

    public ConfiguradorProtocoloJalisWS(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
    }

    @Override
    protected void iniciar() {
        this.textCodTuboLis = new TTextField(2, 1);
        this.checkEnviarTuboLis = new JCheckBox("Enviar c\u00f3digo do tubo LIS");
        this.checkImportarLaudo = new JCheckBox("Importar laudo original (XML)");
        this.checkImportarPdf = new JCheckBox("Importar resultado PDF");
        this.getPanelCentral().setLayout(new GridBagLayout());
        this.getPanelCentral().setBorder(BorderFactory.createTitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        GridBagConstraints cons = this.iniciaGridBag();
        this.montaCampos(cons);
        this.montaCheckbox(cons);
        this.montaCampoLis(cons);
        this.pack();
        this.setSize(new Dimension(350, 360));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textEndWebService);
        this.checkEnviarTuboLis.addActionListener(this);
        this.checkImportarLaudo.addActionListener(this);
        this.checkImportarPdf.addActionListener(this);
    }

    private GridBagConstraints iniciaGridBag() {
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.insets = new Insets(1, 1, 1, 1);
        cons.gridx = 0;
        cons.gridy = 0;
        cons.weightx = 0.5;
        cons.weighty = 0.5;
        cons.gridwidth = 1;
        cons.gridheight = 1;
        return cons;
    }

    private JLabel montaCampos(GridBagConstraints cons) {
        JLabel lblWebService = ComponenteFactory.novoJLabel("Web Service:", new Dimension(95, 25));
        lblWebService.setMinimumSize(new Dimension(95, 25));
        this.getPanelCentral().add((Component)lblWebService, cons);
        cons.gridx = 1;
        this.textEndWebService = new TTextField(100, 3);
        this.textEndWebService.setPreferredSize(new Dimension(150, 25));
        this.textEndWebService.setMinimumSize(new Dimension(150, 25));
        this.getPanelCentral().add((Component)this.textEndWebService, cons);
        cons.gridx = 0;
        ++cons.gridy;
        JLabel lblCodigo = ComponenteFactory.novoJLabel("C\u00f3digo:", new Dimension(95, 25));
        lblCodigo.setMinimumSize(new Dimension(95, 25));
        this.getPanelCentral().add((Component)lblCodigo, cons);
        cons.gridx = 1;
        this.textCodigo.setPreferredSize(new Dimension(200, 25));
        this.textCodigo.setMinimumSize(new Dimension(200, 25));
        this.getPanelCentral().add((Component)this.textCodigo, cons);
        cons.gridx = 0;
        ++cons.gridy;
        JLabel lblChave = ComponenteFactory.novoJLabel("Chave:", new Dimension(95, 25));
        lblChave.setMinimumSize(new Dimension(95, 25));
        this.getPanelCentral().add((Component)lblChave, cons);
        cons.gridx = 1;
        this.textChave = new TTextField(16, 3);
        this.textChave.setPreferredSize(new Dimension(150, 25));
        this.textChave.setMinimumSize(new Dimension(150, 25));
        this.getPanelCentral().add((Component)this.textChave, cons);
        cons.gridx = 0;
        ++cons.gridy;
        JLabel lblLote = ComponenteFactory.novoJLabel("Lote:", new Dimension(95, 25));
        lblLote.setMinimumSize(new Dimension(100, 25));
        this.getPanelCentral().add((Component)lblLote, cons);
        cons.gridx = 1;
        this.textLote.setPreferredSize(new Dimension(200, 25));
        this.textLote.setMinimumSize(new Dimension(200, 25));
        this.getPanelCentral().add((Component)this.textLote, cons);
        return lblLote;
    }

    private void montaCheckbox(GridBagConstraints cons) {
        cons.gridx = 0;
        ++cons.gridy;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkEnterNoResultado, cons);
        ++cons.gridy;
        cons.gridwidth = 2;
        this.getPanelCentral().add((Component)this.checkEnviarTuboLis, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkEnvioAutomatico, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkImportarLaudo, cons);
        ++cons.gridy;
        this.getPanelCentral().add((Component)this.checkImportarPdf, cons);
    }

    private void montaCampoLis(GridBagConstraints cons) {
        ++cons.gridy;
        cons.gridwidth = 1;
        JLabel lblCodLIS = ComponenteFactory.novoJLabel("C\u00f3digo LIS:", new Dimension(100, 25));
        this.getPanelCentral().add((Component)lblCodLIS, cons);
        cons.gridx = 1;
        this.textCodTuboLis.setPreferredSize(new Dimension(200, 25));
        this.textCodTuboLis.setMinimumSize(new Dimension(200, 25));
        this.getPanelCentral().add((Component)this.textCodTuboLis, cons);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.checkEnviarTuboLis) {
            this.textCodTuboLis.setEnabled(this.checkEnviarTuboLis.isSelected());
        } else if (o == this.checkImportarLaudo) {
            this.checkImportarPdf.setSelected(false);
        } else if (o == this.checkImportarPdf) {
            this.checkImportarLaudo.setSelected(false);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        if (xml != null) {
            xml = StringUtil.getValor(xml, "jalisWS");
            this.textLote.setText(StringUtil.getValor(xml, LOTE));
            this.textCodigo.setText(StringUtil.getValor(xml, CODIGO));
            this.textChave.setText(StringUtil.getValor(xml, CHAVE));
            this.textAgente.setText(StringUtil.getValor(xml, "agente"));
            this.textSenha.setText(StringUtil.getValor(xml, "senha"));
            this.textEndWebService.setText(StringUtil.getValor(xml, TAG_ENDERECO_WS));
            this.textEndResultado.setText(StringUtil.getValor(xml, "enderecoResultado"));
            this.checkEnviaLoteUsandoWebService.setSelected(StringUtil.getValor(xml, TAG_ENVIAR_WS).trim().length() > 0 && StringUtil.getBoolean(xml, TAG_ENVIAR_WS));
            this.checkEnterNoResultado.setSelected(StringUtil.getValor(xml, PROCESSAR_ENTER).trim().length() > 0 && StringUtil.getBoolean(xml, PROCESSAR_ENTER));
            this.checkEnvioAutomatico.setSelected(StringUtil.getValor(xml, TAG_ENVIO_AUTOMATICO).trim().length() > 0 && StringUtil.getBoolean(xml, TAG_ENVIO_AUTOMATICO));
            this.checkImportarXls.setSelected(StringUtil.getValor(xml, "importarListaXls").trim().length() > 0 && StringUtil.getBoolean(xml, "importarListaXls"));
            this.checkUrgente.setSelected(StringUtil.getValor(xml, "enviarUrgente").trim().length() > 0 && StringUtil.getBoolean(xml, "enviarUrgente"));
            this.checkEnviarTuboLis.setSelected(StringUtil.getValor(xml, ENVIAR_TUBO_LIS).trim().length() > 0 ? StringUtil.getBoolean(xml, ENVIAR_TUBO_LIS) : true);
            this.checkImportarLaudo.setSelected(StringUtil.getValor(xml, TAG_IMPORTAR_LAYOUT_LAUDO).trim().length() > 0 && StringUtil.getBoolean(xml, TAG_IMPORTAR_LAYOUT_LAUDO));
            this.checkImportarPdf.setSelected(StringUtil.getValor(xml, TAG_IMPORTAR_RESULTADO_PDF).trim().length() > 0 && StringUtil.getBoolean(xml, TAG_IMPORTAR_RESULTADO_PDF));
            this.textCodTuboLis.setText(StringUtil.getValor(xml, CODIGO_TUBO_LIS));
            this.textCodTuboLis.setEnabled(this.checkEnviarTuboLis.isSelected());
        }
    }

    @Override
    public boolean acaoOk() {
        if (this.checkEnviaLoteUsandoWebService.isSelected() && Funcoes.textoVazio(this.textEndWebService.getText())) {
            Funcoes.mensagem(this, "Informe o campo web services.", 2);
            ScreenUtil.requisitarFoco(this.textEndWebService);
            return false;
        }
        if (Funcoes.textoVazio(this.textChave.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado uma chave v\u00e1lida", 2);
            ScreenUtil.requisitarFoco(this.textChave);
        } else if (!this.textCodigo.getText().matches("\\d+")) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um c\u00f3digo v\u00e1lido", 2);
            ScreenUtil.requisitarFoco(this.textCodigo);
        } else {
            return true;
        }
        return false;
    }

    @Override
    public String getXML() {
        StringBuilder bui = new StringBuilder("<jalisWS>");
        bui.append(StringUtil.getTag(TAG_ENDERECO_WS, this.textEndWebService.getText()));
        bui.append(StringUtil.getTag(LOTE, this.textLote.getText()));
        bui.append(StringUtil.getTag(CODIGO, this.textCodigo.getText()));
        bui.append(StringUtil.getTag(CHAVE, this.textChave.getText()));
        bui.append(StringUtil.getTag(ENVIAR_MEDICO, TRUE));
        bui.append(this.pegaValorCheckbox(TAG_ENVIO_AUTOMATICO, this.checkEnvioAutomatico));
        bui.append(this.pegaValorCheckbox(PROCESSAR_ENTER, this.checkEnterNoResultado));
        bui.append(this.pegaValorCheckbox(ENVIAR_TUBO_LIS, this.checkEnviarTuboLis));
        bui.append(this.pegaValorCheckbox(TAG_IMPORTAR_LAYOUT_LAUDO, this.checkImportarLaudo));
        bui.append(this.pegaValorCheckbox(TAG_IMPORTAR_RESULTADO_PDF, this.checkImportarPdf));
        bui.append(StringUtil.getTag(TAG_ENVIAR_WS, TRUE));
        bui.append(StringUtil.getTag(CODIGO_TUBO_LIS, this.textCodTuboLis.getText()));
        return bui.append("</jalisWS>").toString();
    }

    private String pegaValorCheckbox(String tag, JCheckBox checkbox) {
        return StringUtil.getTag(tag, checkbox.isSelected() ? TRUE : FALSE);
    }
}

