/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalis.ws;

import jalis.apoio.servidorws.Apoiado;
import jalis.apoio.servidorws.WSCliente;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.digitacao.Resultado;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.relatorios.util.RelatorioUtil;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.laboratorio.util.parsers.jalis.ws.ExameRequisicao;
import jalis.laboratorio.util.parsers.jalis.ws.ExameRequisicaoId;
import jalis.laboratorio.util.parsers.jalis.ws.ImportacaoJalis;
import jalis.model.vo.cadastro.auxiliares.FilialVOAux;
import jalis.service.cadastro.FilialService;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ImportacaoResultadoJalis
extends AbstractImportadorResultadoLabExterno {
    private int codigoLabExterno;
    private boolean conferirAutomatico = false;
    private String codigoUsuarioConferenciaAutomatica = null;
    private static ModeloGridTable modelo = new ModeloGridTable(RelatorioSituacaoLote.campos);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);

    public ImportacaoResultadoJalis(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames utilizando o protocolo Jalis", codigoLabExterno, Protocolo.Jalis, new JPanel(new FlowLayout(2)));
        this.codigoLabExterno = codigoLabExterno;
        modelo.clear();
        this.getPanelAdicional().add(this.buttonImprimir);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    private Registro buscaDadosXML(int codigo) throws Exception {
        Registro retorno = null;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select lae_configuracao, lae_conferirautomatico, usr_codconferir from labexterno where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and lae_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = ConfiguradorProtocoloJalis.xmlToRegistro(rs.getString("lae_configuracao"));
            this.conferirAutomatico = rs.getBoolean("lae_conferirautomatico");
            this.codigoUsuarioConferenciaAutomatica = DBUtil.campoNull(rs.getString("usr_codconferir")) || Funcoes.textoVazio(rs.getString("usr_codconferir")) ? null : rs.getString("usr_codconferir");
        }
        return retorno;
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        modelo.clear();
        this.setTextoInformacoes("Aguarde... Conectando ao servidor do laborat\u00f3rio de apoio");
        ArrayList<Object> importados = new ArrayList();
        String requisicao = "";
        try {
            Registro registro = this.buscaDadosXML(this.codigoLabExterno);
            if (!Funcoes.testaConexaoWeb(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")))) {
                Funcoes.mensagem(this, "Conex\u00e3o  com a web n\u00e3o encontrada", 1);
                this.setTextoInformacoes("Conex\u00e3o com a web n\u00e3o encontrada");
                return;
            }
            WSCliente ws = new WSCliente(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")));
            if (!ws.isServidorOk()) {
                Funcoes.mensagem(this, "O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde", 1);
                this.setTextoInformacoes("O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde");
                return;
            }
            if (!ImportacaoJalis.validaCliente(ws, registro.getString("filialSelecionada"), registro.getString("codigoCliente"))) {
                Funcoes.mensagem(this, "O servidor remoto n\u00e3o autenticou sua conex\u00e3o.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
                this.setTextoInformacoes("O servidor remoto n\u00e3o autenticou sua conex\u00e3o. Entre em contato com o laborat\u00f3rio de apoio");
                return;
            }
            if (!ImportacaoJalis.validaConvenio(ws, registro.getString("filialSelecionada"), registro.getString("codigoConvenio"))) {
                Funcoes.mensagem(this, "O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
                this.setTextoInformacoes("O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio. Entre em contato com o laborat\u00f3rio de apoio.");
                return;
            }
            this.setTextoInformacoes("Recebendo resultados...");
            Apoiado apoiado = new Apoiado(Integer.parseInt(registro.getString("filialSelecionada")), Variaveis.tipoFilialPadrao, Integer.parseInt(registro.getString("codigoConvenio")));
            String string = apoiado.getChave();
            Statement st = Conexao.getStatement();
            importados = this.importarExameRequisicao(ws, string);
            Conexao.arquivaSQL();
            if (importados.size() > 0) {
                this.setTextoInformacoes("\n\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
                this.setTextoInformacoes("\n|" + Funcoes.preencheVazio("Resultados recebidos", 58, 2) + "|", false);
                this.setTextoInformacoes("\n|Filial|Requisi\u00e7\u00e3o|" + Funcoes.preencheVazio("Exame", 40, 2) + "|", false);
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
                for (String string2 : importados) {
                    this.setTextoInformacoes("\n" + string2, false);
                }
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
            }
            this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada", false);
            this.buttonImprimir.setEnabled(modelo.getRowCount() > 0);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception ws) {
                // empty catch block
            }
            String lista = "";
            if (importados != null) {
                for (String string : importados) {
                    lista = lista + string;
                }
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoJalis (139) \n" + lista + "\n" + requisicao);
        }
        System.gc();
    }

    private static void adicionaExameRetorno(Statement st, ArrayList<String> retorno, String requisicao, String exame, String material) throws Exception {
        String filial = ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0];
        String codigoRequisicao = ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[1];
        StringBuilder exameRequisicao = new StringBuilder("|");
        exameRequisicao.append(Funcoes.preencheVazio(filial, 6, 1)).append("|");
        exameRequisicao.append(Funcoes.preencheVazio(String.valueOf(Integer.parseInt(codigoRequisicao)), 10, 1)).append("|");
        exameRequisicao.append(Funcoes.preencheVazio(exame + " (" + material + ")", 40, 2)).append("|");
        if (!retorno.contains(exameRequisicao.toString())) {
            retorno.add(exameRequisicao.toString());
        }
        StringBuilder buf = new StringBuilder();
        if (filial.equals(Funcoes.preencheZero(0, ParametrosGerais.getDigitosTuboFilial()))) {
            filial = Variaveis.filialPadrao;
        }
        buf.append("select a.req_codigoapoiado as codigoRequisicaoApoio,  a.req_codigo as codigoRequisicao, '' as codigoFilialCodigoRequisicao, ");
        buf.append("paciente.pac_nome as nomePaciente, a.req_idade as idadePaciente, a.req_anomes as anoMesPaciente, ");
        buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame,  ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("a.med_conselho as conselhoMedico, a.med_crm as crmMedico, a.med_uf as ufMedico, medico.med_nome as nomeMedico, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_hora as horaRequisicao, ");
        buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
        buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, exr.exr_situacao as situacaoExame, ");
        buf.append("l.lex_codigo as codigoLote, l.lex_datahora as dataLote,  ");
        buf.append("d.lae_codigo as codigoLabExterno, labexterno.lae_descricao as descricaoLabExterno, labexterno.lae_protocolo as protocoloLabExterno, ");
        buf.append("ele.ele_xmllabexterno as codigoExameLaboratorioApoio, '' as descricaoExameLaboratorioApoio, ");
        buf.append("a.req_data as dataRequisicao, a.fil_codigo as codigoFilial, lote.fil_codigo as codigoFilialLote, fil.fil_descricao as descricaoFilial, ");
        buf.append("rle.rle_codigo as codigoCip, ");
        buf.append(" '' as posicaoOrdenacao, ");
        buf.append(" errecip.ere_codigoapoiado as etiquetaExternaExame ");
        buf.append("from loteexternorequisicao lote ");
        buf.append("left join loteexterno l on lote.fil_codigo = l.fil_codigo and lote.lex_codigo = l.lex_codigo and lote.lae_codigo = l.lae_codigo ");
        buf.append("left join requisicao a on lote.fil_kodigo = a.fil_codigo and lote.req_codigo = a.req_codigo ");
        buf.append("join loteexternoexamerequisicao b on lote.fil_kodigo = b.fil_kodigo and lote.req_codigo = b.req_codigo and lote.lex_codigo = b.lex_codigo and lote.lae_codigo = b.lae_codigo ");
        buf.append("left join  loteexternoexamerequisicaorecip  lerrecip ON b.fil_codigo = lerrecip.fil_codigo AND b.fil_kodigo = lerrecip.fil_kodigo AND b.req_codigo = lerrecip.req_codigo AND b.lex_codigo = lerrecip.lex_codigo AND b.lae_codigo = lerrecip.lae_codigo AND b.exa_codigo = lerrecip.exa_codigo AND b.mco_codigo = lerrecip.mco_codigo ");
        buf.append("left join  examerequisicaorecipiente errecip on lerrecip.fil_codigo = errecip.fil_codigo and lerrecip.req_codigo = errecip.req_codigo and lerrecip.exa_codigo = errecip.exa_codigo and lerrecip.mco_codigo = errecip.mco_codigo and lerrecip.rec_codigo = errecip.rec_kodigo ");
        buf.append("join examerequisicao exr on b.fil_kodigo = exr.fil_codigo and b.req_codigo = exr.req_codigo and b.exa_codigo = exr.exa_codigo and b.mco_codigo = exr.mco_codigo ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("left join labexterno on lote.fil_kodigo = labexterno.fil_codigo and lote.lae_codigo = labexterno.lae_codigo ");
        buf.append("left join filiais_postocoleta fil on lote.fil_kodigo = fil.fil_codigo ");
        buf.append("left join requisicaolabexterno rle on lote.fil_kodigo = rle.fil_codigo and lote.req_codigo = rle.req_codigo and lote.lae_codigo = rle.lae_codigo ");
        buf.append("left join examematcoletalabexterno ele on d.fil_codigo = ele.fil_codigo and d.exa_codigo = ele.exa_codigo and d.mco_codigo = ele.mco_codigo and b.lae_codigo = ele.lae_codigo ");
        buf.append("where lote.fil_kodigo = ");
        buf.append(filial);
        buf.append(" and lote.req_codigo = ").append(codigoRequisicao);
        buf.append(" and b.exa_codigo = '").append(exame).append("' ");
        buf.append(" and b.mco_codigo = ").append(material);
        buf.append(" and a.req_excluida = false and exr.exr_excluido = false ");
        buf.append(" and ele.ele_xmllabexterno is not null and ele.ele_xmllabexterno <> '' ");
        buf.append(" order by a.req_codigo ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            do {
                Object[] o = new Object[RelatorioSituacaoLote.campos.length];
                for (int i = 0; i < RelatorioSituacaoLote.campos.length; ++i) {
                    Protocolo p;
                    String xml;
                    if (RelatorioUtil.possuiColuna(rs, RelatorioSituacaoLote.campos[i]) < 0) continue;
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("codigoLoteLabApoio")) {
                        o[i] = Funcoes.preencheZero(rs.getString("codigoLote"), 6);
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("anoMesPaciente")) {
                        o[i] = Tipos.tipoIdade(rs.getString(RelatorioSituacaoLote.campos[i]));
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("sexoPaciente")) {
                        o[i] = Tipos.tipoSexo(rs.getString(RelatorioSituacaoLote.campos[i]));
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("situacaoExame")) {
                        o[i] = Tipos.tipoSituacaoExame(rs.getString(RelatorioSituacaoLote.campos[i]));
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("codigoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i] = FabricaConfigurador.getCodigoIdentExameLabExternoSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("descricaoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i] = FabricaConfigurador.getDescricaoExameSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    o[i] = RelatorioSituacaoLote.campos[i].equals("codigoFilialCodigoRequisicao") ? Funcoes.preencheZero(rs.getInt("codigoFilial"), ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(rs.getInt("codigoRequisicao"), ParametrosGerais.getDigitosTuboRequisicao()) : rs.getObject(RelatorioSituacaoLote.campos[i]);
                }
                modelo.addLine(o);
            } while (rs.next());
        }
    }

    private static void exportaExameRequisicaoWeb(Statement st, String requisicao, String exame, String material, String resultado, String situacao, String assinatura, String nomeAssinatura, String operacao) throws Exception {
        if (Variaveis.exportarWebFilial) {
            String codigoBase = null;
            FilialService filService = new FilialService();
            FilialVOAux filVO = filService.contemAgrupamento(st, ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0]);
            if (Funcoes.carregouVO(filVO)) {
                codigoBase = filVO.getTipoBase();
            } else {
                filVO = filService.getDadosExportaBaseWeb(st, ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0]);
                if (Funcoes.carregouVO(filVO)) {
                    codigoBase = filVO.getTipoBase();
                }
            }
            boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0]);
            String[] comandoExameRequisicao = new String[20];
            comandoExameRequisicao[0] = "codigoBase";
            comandoExameRequisicao[1] = codigoBase;
            comandoExameRequisicao[2] = "codigoRequisicao";
            comandoExameRequisicao[3] = ImportacaoResultadoJalis.formataCodigoRequisicao(ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0], ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[1], st);
            comandoExameRequisicao[4] = "codigoExameRequisicao";
            comandoExameRequisicao[5] = exame;
            comandoExameRequisicao[6] = "materialExameRequisicao";
            comandoExameRequisicao[7] = material;
            comandoExameRequisicao[8] = "situacaoExameRequisicao";
            comandoExameRequisicao[9] = situacao;
            comandoExameRequisicao[10] = "assinaturaExameRequisicao";
            comandoExameRequisicao[11] = assinatura;
            comandoExameRequisicao[12] = "nomeAssinaturaExameRequisicao";
            comandoExameRequisicao[13] = nomeAssinatura;
            comandoExameRequisicao[14] = "resultadoExameRequisicao";
            String rst = "";
            Map<String, Object> map = null;
            if (!resultadoPdf && !Funcoes.textoVazio(resultado)) {
                map = ResultadosUtil.geraResultadoParaWeb(st, ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0], ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[1], exame, material, resultado, false);
                rst = map != null && map.get("laudo") != null ? (String)map.get("laudo") : "";
            }
            comandoExameRequisicao[15] = resultadoPdf ? "" : rst;
            comandoExameRequisicao[16] = "dataEnvioExameRequisicao";
            comandoExameRequisicao[17] = "current_timestamp";
            String tipoOperacao = operacao;
            DBUtil.insereExportaWeb(st, ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0], "requisicaoexame", tipoOperacao, "", true, true, comandoExameRequisicao);
            Map imagens = null;
            String[] comandoExcluiImagens = new String[]{"codigoBase", codigoBase, "codigoRequisicao", ImportacaoResultadoJalis.formataCodigoRequisicao(ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0], ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[1], st), "codigoExameRequisicao", exame, "materialExameRequisicao", material};
            DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "D", comandoExcluiImagens);
            if (map != null && !(imagens = (Map)map.get("imagens")).isEmpty()) {
                String[] comandoInserirImagens = new String[12];
                comandoInserirImagens[0] = "codigoBase";
                comandoInserirImagens[2] = "codigoRequisicao";
                comandoInserirImagens[4] = "codigoExameRequisicao";
                comandoInserirImagens[6] = "materialExameRequisicao";
                comandoInserirImagens[8] = "codigoImagemExame";
                comandoInserirImagens[10] = "imagemExame";
                for (Integer i : imagens.keySet()) {
                    comandoInserirImagens[1] = codigoBase;
                    comandoInserirImagens[3] = ImportacaoResultadoJalis.formataCodigoRequisicao(ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0], ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[1], st);
                    comandoInserirImagens[5] = exame;
                    comandoInserirImagens[7] = material;
                    comandoInserirImagens[9] = i.toString();
                    comandoInserirImagens[11] = (String)imagens.get(i);
                    DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "I", comandoInserirImagens);
                }
            }
            if (ExportaWeb.isGerarPdfResultado(st, String.valueOf(ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0]))) {
                ExportaWeb.enviarResultadoPDF(st, ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0], ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[1], codigoBase);
            }
            ExportaWeb.atualizaPaginaOrdemExameWeb(st, String.valueOf(ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[0]), ImportacaoResultadoJalis.getFilialRequisicao(requisicao)[1], codigoBase);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, modelo);
        } else {
            super.actionPerformed(e);
        }
    }

    private boolean setResultadoImportado(WSCliente ws, String chave, String epa_codigo) throws RemoteException {
        ParametroSet param = new ParametroSet();
        Apoiado apoiado = new Apoiado(chave);
        param.setString("chave", apoiado.getChave());
        param.setString("epa_codigo", epa_codigo);
        ParametroSet paramRetorno = ws.executaAcao("setResultadoImportado", param);
        return paramRetorno.getBoolean("OK");
    }

    private void getExamesRequisicao(WSCliente ws, String chave, List<ExameRequisicao> examesReq, List<ExameRequisicaoId> examesReqExcluir) throws RemoteException {
        ParametroSet param = new ParametroSet();
        Apoiado apoiado = new Apoiado(chave);
        param.setString("chave", apoiado.getChave());
        param.setBoolean("resultado", true);
        ParametroSet paramRetorno = ws.executaAcao("getExamesRequisicao", param);
        if (examesReq != null && paramRetorno.getListParam("exames") != null) {
            for (ParametroSet exParam : paramRetorno.getListParam("exames")) {
                String requisicao = exParam.getString("requisicao");
                if (Funcoes.textoVazio(requisicao) && exParam.getLong("requisicao") > 0L) {
                    requisicao = String.valueOf(exParam.getLong("requisicao"));
                }
                ExameRequisicaoId id = new ExameRequisicaoId(requisicao, exParam.getString("exameOrigem"), exParam.getInt("materialOrigem"));
                ExameRequisicao ex = new ExameRequisicao(id);
                ex.setCodigoRequisicaoServidor(exParam.getLong("requisicaoServidor"));
                ex.setSituacao(exParam.getString("situacao"));
                ex.setDataMaterial(exParam.getDate("dataMaterial"));
                ex.setDataDigitacao(exParam.getDate("dataDigitacao"));
                ex.setDataAssinatura(exParam.getDate("dataAssinatura"));
                ex.setDataEntregaPrevista(exParam.getDate("dataEntregaPrevista"));
                ex.setResposta(exParam.getString("resposta"));
                ex.setMetodo(exParam.getInt("metodo"));
                ex.setUsuarioAssinatura(exParam.getString("usuarioAssinatura"));
                ex.setMaterialDescricao(exParam.getString("materialDescricao"));
                ex.setObservacao(exParam.getString("observacao"));
                ex.setDataCortesia(exParam.getDate("dataCortesia"));
                ex.setUsuarioCortesia(exParam.getString("usuarioCortesia"));
                ex.setData(exParam.getDate("data"));
                ex.setTempoJejum(exParam.getString("tempoJejum"));
                ex.setExameOrigem(exParam.getString("exame"));
                ex.setMaterialOrigem(exParam.getInt("material"));
                ex.setCodigoExportacao(exParam.getString("epa_codigo"));
                examesReq.add(ex);
            }
        }
    }

    private ParametroSet getResultadoExame(WSCliente ws, String chave, long codigoRequisicao, String codigoExame, int codigoMaterial) throws RemoteException {
        ParametroSet param = new ParametroSet();
        param.setString("chave", chave);
        param.setLong("requisicao", codigoRequisicao);
        param.setString("exame", codigoExame);
        param.setInt("material", codigoMaterial);
        param.setString("epa_codigo", codigoExame);
        ParametroSet paramRetorno = ws.executaAcao("getResultadoExame", param);
        return paramRetorno;
    }

    private ArrayList<String> importarExameRequisicao(WSCliente ws, String chave) throws Exception {
        ArrayList<ExameRequisicao> examesReq = new ArrayList<ExameRequisicao>();
        ArrayList<ExameRequisicaoId> examesReqExcluir = new ArrayList<ExameRequisicaoId>();
        this.getExamesRequisicao(ws, chave, examesReq, examesReqExcluir);
        ArrayList<String> retorno = new ArrayList<String>();
        ArrayList<Long> ignorar = new ArrayList<Long>();
        System.gc();
        this.setTextoInformacoes("Validando " + String.valueOf(examesReq.size()) + " requisi\u00e7\u00f5es recebidas...");
        if (examesReq.isEmpty() && examesReqExcluir.isEmpty()) {
            this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados");
            return retorno;
        }
        Statement st = Conexao.getStatement();
        Statement st2 = Conexao.getStatement();
        StringBuilder sqlSelect = new StringBuilder("");
        sqlSelect.append(" select exr.exr_situacao as exr_situacao ");
        sqlSelect.append("       ,req.pac_codigo as pac_codigo ");
        sqlSelect.append("       ,req.req_xmlagendamentoids as xmlAgendamentoIDS ");
        sqlSelect.append("       ,req.con_codigo as con_codigo ");
        sqlSelect.append("       ,req.req_integracaohospital as req_integracaohospital ");
        sqlSelect.append("       ,ele.met_codigo as met_codigo, req.req_guia as req_guia, exr.exr_solicitadotiss as exr_solicitadotiss, exr.exr_codautorizacao as exr_codautorizacao ");
        sqlSelect.append("   from examerequisicao exr ");
        sqlSelect.append("   join requisicao req on req.fil_codigo = exr.fil_codigo and req.req_codigo = exr.req_codigo ");
        sqlSelect.append("   left join examematcoletalabexterno ele on ele.fil_codigo = exr.fil_codigo and ele.exa_codigo = exr.exa_codigo and ele.mco_codigo = exr.mco_codigo ");
        sqlSelect.append("  where exr.fil_codigo = ? and exr.req_codigo = ? and exr.exa_codigo = ? and exr.mco_codigo = ? and not exr.exr_excluido and not req.req_excluida ");
        sqlSelect.append("  and ele.lae_codigo =").append(this.codigoLabExterno);
        PreparedStatement psSelect = Conexao.getPreparedStatement(sqlSelect.toString());
        for (ExameRequisicao exReq : examesReq) {
            if (Funcoes.textoVazio(exReq.getId().getCodigoRequisicao()) || exReq.getId().getCodigoRequisicao().equals("0")) {
                if (ignorar.contains(exReq.getCodigoRequisicaoServidor())) continue;
                this.setTextoInformacoes("\nRequisi\u00e7\u00e3o do servidor " + exReq.getCodigoRequisicaoServidor() + " cadastrada manualmente ou n\u00e3o possui c\u00f3digo apoiado para receber o resultado", false);
                ignorar.add(exReq.getCodigoRequisicaoServidor());
                continue;
            }
            String[] filialRequisicao = ImportacaoResultadoJalis.getFilialRequisicao(exReq.getId().getCodigoRequisicao());
            String filial = ImportacaoResultadoJalis.getFilialRequisicao(String.valueOf(exReq.getId().getCodigoRequisicao()))[0];
            String requisicao = ImportacaoResultadoJalis.getFilialRequisicao(String.valueOf(exReq.getId().getCodigoRequisicao()))[1];
            this.setTextoInformacoes("\nValidando requisi\u00e7\u00e3o " + requisicao + " da filial " + filial, false);
            if (exReq.getId() == null || Long.parseLong(requisicao) == 0L || Funcoes.textoVazio(exReq.getId().getCodigoExame()) || exReq.getId().getCodigoMaterial() == 0) {
                String txt = "Identificador da requisi\u00e7\u00e3o " + requisicao + " da filial " + filial + " n\u00e3o localizado ";
                if (exReq.getId() == null) {
                    txt = txt + " |id vazio|";
                }
                if (Long.parseLong(requisicao) == 0L) {
                    txt = txt + " |requisi\u00e7\u00e3o vazia|";
                }
                if (Funcoes.textoVazio(exReq.getId().getCodigoExame())) {
                    txt = txt + " |sem c\u00f3digo de exame|";
                }
                if (exReq.getId().getCodigoMaterial() == 0) {
                    txt = txt + " |sem c\u00f3digo de material|";
                }
                this.setTextoInformacoes("\n" + txt, false);
                continue;
            }
            psSelect.clearParameters();
            psSelect.setLong(1, Long.parseLong(filial));
            psSelect.setLong(2, Long.parseLong(requisicao));
            psSelect.setString(3, exReq.getId().getCodigoExame());
            psSelect.setInt(4, exReq.getId().getCodigoMaterial());
            this.setTextoInformacoes("\nBuscando informa\u00e7\u00f5es da requisi\u00e7\u00e3o " + requisicao + " da filial " + filial, false);
            ResultSet rs = psSelect.executeQuery();
            if (exReq.getCodigoRequisicaoServidor() != 0L) {
                ParametroSet res = this.getResultadoExame(ws, chave, exReq.getCodigoRequisicaoServidor(), exReq.getExameOrigem(), exReq.getMaterialOrigem());
                if (res == null || !res.getString("situacao").toUpperCase().equals("C")) {
                    this.setTextoInformacoes("\nO resultado n\u00e3o est\u00e1 pronto. Filial = " + filial + ", requisi\u00e7\u00e3o = " + requisicao + ", exame = " + exReq.getExameOrigem() + ", material = " + exReq.getMaterialOrigem() + ".", false);
                    this.setResultadoImportado(ws, chave, exReq.getCodigoExportacao());
                    continue;
                }
                String resultado = res.getString("resultado");
                boolean parcial = res.getBoolean("considerarparcial");
                String situacao = res.getString("situacao");
                String novaSituacao = "P";
                String situacaoAtual = "";
                String metodo = "";
                if (!rs.next()) {
                    this.setTextoInformacoes("\nO resultado n\u00e3o foi encontrado . Filial = " + filial + ", requisi\u00e7\u00e3o = " + requisicao + ", exame = " + exReq.getExameOrigem() + ", material = " + exReq.getMaterialOrigem() + ".", false);
                    this.setResultadoImportado(ws, chave, exReq.getCodigoExportacao());
                    continue;
                }
                situacaoAtual = rs.getString("exr_situacao");
                metodo = rs.getString("met_codigo");
                if (situacaoAtual == null) {
                    situacaoAtual = " ";
                }
                this.setTextoInformacoes("\nGravando exame " + exReq.getId().getCodigoExame() + " da requisi\u00e7\u00e3o " + requisicao + " da filial " + filial + " com a situa\u00e7\u00e3o " + situacaoAtual, false);
                if (!this.setResultadoImportado(ws, chave, exReq.getCodigoExportacao())) {
                    this.setTextoInformacoes(String.format("\nn\u00e3o foi poss\u00edvel marcar o resultado como importado, c\u00f3digo da importa\u00e7\u00e3o %s.", exReq.getCodigoExportacao()), false);
                }
                if (!Funcoes.textoVazio(situacaoAtual)) continue;
                novaSituacao = "L";
                if (parcial && exReq.getSituacao().equalsIgnoreCase("P")) {
                    novaSituacao = "P";
                }
                boolean marcarConferido = false;
                if (this.conferirAutomatico && !Funcoes.textoVazio(resultado)) {
                    Resultado resValida = new Resultado(resultado);
                    int verificacao = resValida.verificarValidacao();
                    marcarConferido = resValida.resultadoCompleto(false);
                    if (!marcarConferido && verificacao != 2) {
                        this.setTextoInformacoes("\nO resultado n\u00e3o ser\u00e1 conferido por n\u00e3o atender \u00e0 condi\u00e7\u00e3o de valida\u00e7\u00e3o do exame: " + requisicao + "|" + exReq.getId().getCodigoExame() + (!Funcoes.textoVazio(resValida.getMensagemValidacao()) ? " - " + resValida.getMensagemValidacao() : ""), false);
                    } else {
                        novaSituacao = "C";
                    }
                }
                Registro regRequisicao = Registro.novoRegistro(new Object[]{"fil_codigo", filial, "req_codigo", requisicao, "pac_codigo", rs.getInt("pac_codigo"), "xmlAgendamentoIDS", rs.getString("xmlAgendamentoIDS"), "con_codigo", rs.getInt("con_codigo"), "req_integracaohospital", rs.getString("req_integracaohospital"), "req_guia", rs.getString("req_guia")});
                Registro regExame = Registro.novoRegistro(new Object[]{"exa_codigo", exReq.getId().getCodigoExame(), "mco_codigo", exReq.getId().getCodigoMaterial(), "exr_codautorizacao", rs.getString("exr_codautorizacao"), "exr_solicitadotiss", rs.getString("exr_solicitadotiss")});
                boolean validacaoCompulsoria = new Resultado(resultado).verificarValidacaoCompulsoria() == 1;
                boolean validacaoResultadoCritico = new Resultado(resultado).verificarValidacaoResultadoCritico() == 1;
                this.salvarTabelaExameRequisicao(st, this, resultado, novaSituacao, metodo, regRequisicao, regExame, marcarConferido, this.codigoUsuarioConferenciaAutomatica, validacaoCompulsoria, validacaoResultadoCritico);
                if (exReq.getSituacao() != null && (exReq.getSituacao().equalsIgnoreCase("C") || exReq.getSituacao().equalsIgnoreCase("I") || exReq.getSituacao().equalsIgnoreCase("E") || parcial && exReq.getSituacao().equalsIgnoreCase("P"))) {
                    String codigo = exReq.getId().getCodigoRequisicao().toString();
                    String codigoExameOrigem = exReq.getId().getCodigoExame();
                    String codigoMaterialOrigem = String.valueOf(exReq.getId().getCodigoMaterial());
                    ImportacaoResultadoJalis.adicionaExameRetorno(st, retorno, codigo, codigoExameOrigem, codigoMaterialOrigem);
                    if (novaSituacao.equalsIgnoreCase("C")) {
                        Util.gravaAlteracaoExameRequisicao(st, ImportacaoResultadoJalis.getFilialRequisicao(codigo)[0], ImportacaoResultadoJalis.getFilialRequisicao(codigo)[1], codigoExameOrigem, codigoMaterialOrigem);
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.setLength(0);
                    buf.append("select pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.exr_dataassina, a.usr_codassina, a.exr_situacao, b.usr_nome ");
                    buf.append("from examerequisicao a ");
                    buf.append("left join usuario b on a.usr_codassina = b.usr_codigo ");
                    buf.append(" where a.fil_codigo = ");
                    buf.append(filial);
                    buf.append(" and a.req_codigo = ");
                    buf.append(requisicao);
                    buf.append(" and a.exa_codigo = '");
                    buf.append(codigoExameOrigem);
                    buf.append("' and a.mco_codigo = ");
                    buf.append(codigoMaterialOrigem);
                    rs = Conexao.executeQuery(st, buf.toString());
                    if (rs.next()) {
                        String rst = rs.getString("exr_resultado");
                        String sit = rs.getString("exr_situacao");
                        String usuario = rs.getString("usr_codassina");
                        String nomeUsuario = rs.getString("usr_nome");
                        ImportacaoResultadoJalis.exportaExameRequisicaoWeb(st, codigo, codigoExameOrigem, codigoMaterialOrigem, rst, sit, usuario, nomeUsuario, "A");
                    }
                    ExportaFiliais.gravaRequisicao(Integer.parseInt(filial), Long.parseLong(requisicao), codigoExameOrigem, Integer.parseInt(codigoMaterialOrigem), "U", "U");
                    if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !SMSUtil.isBloquearSMSExamePronto(String.valueOf(filial), String.valueOf(requisicao), st2)) {
                        SMSUtil.criaLogSmsComDadosRequisicao(String.valueOf(filial), String.valueOf(requisicao), ExportaSMS.TipoSMS.RESULTADO, st, st2);
                    }
                    if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !EmailUtil.isBloquearEmailExamePronto(String.valueOf(filial), String.valueOf(requisicao), st2)) {
                        EmailUtil.criaLogEmail(String.valueOf(filial), String.valueOf(requisicao), null, EmailUtil.TipoEmail.RESULTADO, true, st);
                    }
                    if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !PushUtil.isBloquearPushExamePronto(String.valueOf(filial), String.valueOf(requisicao), st2)) {
                        PushUtil.criaLogPushComDadosRequisicao(String.valueOf(filial), String.valueOf(requisicao), TipoPush.RESULTADO, st, st2);
                    }
                    if (this.conferirAutomatico && !Funcoes.textoVazio(this.codigoUsuarioConferenciaAutomatica) && !WhatsAppUtil.isBloquearWhatsappExamePronto(String.valueOf(filial), String.valueOf(requisicao), st2)) {
                        WhatsAppUtil.criaLogWhatsappComDadosRequisicao(String.valueOf(filial), String.valueOf(requisicao), TipoWhatsapp.RESULTADO, st, st2);
                    }
                    Conexao.arquivaSQL();
                }
                Conexao.arquivaSQL();
                continue;
            }
            this.setResultadoImportado(ws, chave, exReq.getCodigoExportacao());
            this.setTextoInformacoes("\nRequisi\u00e7\u00e3o " + requisicao + " n\u00e3o localizada.", false);
        }
        Conexao.fecharStatement(psSelect);
        Conexao.fecharStatement(st);
        Conexao.fecharStatement(st2);
        return retorno;
    }

    private static String[] getFilialRequisicao(String codigo) {
        String codigoComposto = Funcoes.preencheZero(codigo, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
        String filial = codigoComposto.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String requisicao = codigoComposto.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (filial.equals(Funcoes.preencheZero(0, ParametrosGerais.getDigitosTuboFilial()))) {
            filial = Variaveis.filialPadrao;
        }
        return new String[]{filial, requisicao};
    }

    private static Date dataSql(java.util.Date data) {
        return data != null ? new Date(data.getTime()) : null;
    }

    private static Date formataDataSQL(String data, String formato) {
        if (Funcoes.textoVazio(data)) {
            return null;
        }
        return new Date(Funcoes.stringToDate(formato, data).getTime());
    }

    protected static String formataCodigoRequisicao(String filial, String codigo, Statement st) {
        String retorno = codigo;
        try {
            if (ExportaWeb.isBaseWebAgrupada(st, filial) && Funcoes.isNumeric(filial) && Funcoes.isNumeric(codigo)) {
                retorno = Funcoes.preencheZero(filial, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(codigo, ParametrosGerais.getDigitosTuboRequisicao());
            }
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Importacao Resultados Jalis (271)");
        }
        return retorno;
    }

    @Override
    protected void importarResultadoWs() {
    }
}

