/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalis.ws;

import jalis.apoio.servidorws.Apoiado;
import jalis.apoio.servidorws.WSCliente;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractImportadorLabExterno;
import jalis.laboratorio.util.parsers.IntegracaoLabExternoUtil;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.laboratorio.util.parsers.jalis.ws.ExameJalis;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.sql.SalvaDados;
import jalis.util.sql.SalvaDadosException;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.rmi.RemoteException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class ImportacaoJalis
extends AbstractImportadorLabExterno {
    private int codigoLabExterno;
    private static JPanel panelCheck = null;
    private JCheckBox checkPrimeira;

    public ImportacaoJalis(int codigoLabExterno) {
        panelCheck = new JPanel(new FlowLayout(0));
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames utilizando o protocolo Jalis", codigoLabExterno, Protocolo.Jalis, panelCheck);
        this.checkPrimeira = ComponenteFactory.novoJCheckBox("Considerar como primeira conex\u00e3o", 'p', null);
        panelCheck.add(this.checkPrimeira);
        this.codigoLabExterno = codigoLabExterno;
    }

    public static long getModuloAcesso() {
        return 904000101L;
    }

    private Registro buscaDadosXML(int codigo) throws Exception {
        Registro retorno = null;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select lae_configuracao from labexterno where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and lae_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = ConfiguradorProtocoloJalis.xmlToRegistro(rs.getString("lae_configuracao"));
        }
        return retorno;
    }

    @Override
    protected boolean importarArquivo() {
        boolean retorno = false;
        ArrayList<String> examesAdicionados = new ArrayList<String>();
        this.setTextoInformacoes("Aguarde... Conectando ao servidor do laborat\u00f3rio de apoio");
        try {
            Registro registro = this.buscaDadosXML(this.codigoLabExterno);
            if (!Funcoes.testaConexaoWeb(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")))) {
                Funcoes.mensagem(this, "Conex\u00e3o com a web n\u00e3o encontrada", 1);
                this.setTextoInformacoes("Conex\u00e3o com a web n\u00e3o encontrada");
                return retorno;
            }
            WSCliente ws = new WSCliente(registro.getString("servidorRMI"), Integer.parseInt(registro.getString("portaServidor")));
            if (!ws.isServidorOk()) {
                Funcoes.mensagem(this, "O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde", 1);
                this.setTextoInformacoes("O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde");
                return retorno;
            }
            if (!ImportacaoJalis.validaCliente(ws, registro.getString("filialSelecionada"), registro.getString("codigoCliente"))) {
                Funcoes.mensagem(this, "O servidor remoto n\u00e3o autenticou sua conex\u00e3o.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
                this.setTextoInformacoes("O servidor remoto n\u00e3o autenticou sua conex\u00e3o. Entre em contato com o laborat\u00f3rio de apoio");
                return retorno;
            }
            if (!ImportacaoJalis.validaConvenio(ws, registro.getString("filialSelecionada"), registro.getString("codigoConvenio"))) {
                Funcoes.mensagem(this, "O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio.\nEntre em contato com o laborat\u00f3rio de apoio.", 1);
                this.setTextoInformacoes("O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio. Entre em contato com o laborat\u00f3rio de apoio.");
                return retorno;
            }
            this.setTextoInformacoes("Recebendo exames...");
            System.gc();
            String listagem = this.getListaExamesImportar(ws, registro.getString("filialSelecionada"), registro.getString("codigoConvenio"), this.checkPrimeira.isSelected() ? true : registro.getBoolean("primeiraConexao"), Variaveis.tipoFilialPadrao);
            if (Funcoes.textoVazio(listagem) || StringUtil.getValores(listagem, "exame").length == 0 && StringUtil.getValores(listagem, "examesexcluir").length == 0) {
                this.setTextoInformacoes("N\u00e3o h\u00e1 exames para serem importados");
                return retorno;
            }
            String[] importarExames = StringUtil.getValores(listagem, "exame");
            ArrayList<String> exameRecebido = new ArrayList<String>();
            for (int i = 0; i < importarExames.length; ++i) {
                String[] recebendo;
                String exames = this.getExamesJalis(ws, registro.getString("filialSelecionada"), registro.getString("codigoConvenio"), importarExames[i], this.checkPrimeira.isSelected() ? true : registro.getBoolean("primeiraConexao"));
                String[] stringArray = recebendo = StringUtil.getValores(exames, "exame");
                int n = stringArray.length;
                for (int j = 0; j < n; ++j) {
                    String r = stringArray[j];
                    exameRecebido.add(r);
                }
                System.gc();
            }
            this.setTextoInformacoes("Validando exames recebidos...");
            String[] temp = exameRecebido.toArray(new String[exameRecebido.size()]);
            Statement st = Conexao.getStatement();
            for (String exame : temp) {
                String[] materiais;
                String codigo = StringUtil.getValor(exame, "codigoexame");
                String descricao = StringUtil.xmlToTexto(StringUtil.getValor(exame, "descricao"));
                String sexo = StringUtil.getValor(exame, "sexo");
                String horaEntrada = StringUtil.getValor(exame, "horaentrada");
                String horaSaida = StringUtil.getValor(exame, "horasaida");
                String filtro = StringUtil.xmlToTexto(StringUtil.getValor(exame, "filtro"));
                String diagnostico = StringUtil.xmlToTexto(StringUtil.getValor(exame, "diagnostico"));
                String interferencia = StringUtil.xmlToTexto(StringUtil.getValor(exame, "interferencia"));
                String sinonimo = StringUtil.xmlToTexto(StringUtil.getValor(exame, "sinonimo"));
                String idadeMax = StringUtil.getValor(exame, "idademax");
                String idadeMin = StringUtil.getValor(exame, "idademin");
                String idadeMaxTipo = StringUtil.getValor(exame, "idademaxtipo");
                String idadeMinTipo = StringUtil.getValor(exame, "idademintipo");
                String qtdeAmostras = StringUtil.getValor(exame, "qtdeamostras");
                String proibido = StringUtil.getValor(exame, "proibido");
                String autorizacao = StringUtil.xmlToTexto(StringUtil.getValor(exame, "autorizacao"));
                this.setTextoInformacoes("\nValidando exame: " + codigo, false);
                SalvaDados salvaExame = new SalvaDados("examesjalis", 0);
                salvaExame.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvaExame.adicionaCampo("lae_codigo", 2, false, true, this.codigoLabExterno);
                salvaExame.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDB(codigo));
                salvaExame.adicionaCampo("exa_sexo", 0, true, false, sexo);
                salvaExame.adicionaCampo("exa_descricao", 0, true, false, StringUtil.textoDB(descricao));
                salvaExame.adicionaCampo("exa_horaentrada", 0, true, false, horaEntrada);
                salvaExame.adicionaCampo("exa_horasaida", 0, true, false, horaSaida);
                salvaExame.adicionaCampo("exa_filtro", 0, true, false, StringUtil.textoDB(filtro));
                salvaExame.adicionaCampo("exa_diagnostico", 0, true, false, StringUtil.textoDB(diagnostico));
                salvaExame.adicionaCampo("exa_interferencia", 0, true, false, StringUtil.textoDB(interferencia));
                salvaExame.adicionaCampo("exa_sinonimo", 0, true, false, StringUtil.textoDB(sinonimo));
                salvaExame.adicionaCampo("exa_idademax", 2, true, false, idadeMax);
                salvaExame.adicionaCampo("exa_idademin", 2, true, false, idadeMin);
                salvaExame.adicionaCampo("exa_idademaxtipo", 0, true, false, idadeMaxTipo);
                salvaExame.adicionaCampo("exa_idademintipo", 0, true, false, idadeMinTipo);
                salvaExame.adicionaCampo("exa_qtdeamostras", 2, true, false, qtdeAmostras);
                salvaExame.adicionaCampo("exa_proibido", 4, true, false, proibido);
                ResultSet rs = Conexao.executeQuery(st, salvaExame.getSelect());
                if (rs.next()) {
                    salvaExame.setOperacao(2);
                }
                DBUtil.gravaAutoCopia(st, salvaExame, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
                if (salvaExame.getOperacao() == 0 && !this.checkPrimeira.isSelected()) {
                    examesAdicionados.add("|" + Funcoes.preencheVazio(codigo, 7, 2) + "|" + Funcoes.preencheVazio(descricao, 50, 2) + "|");
                }
                for (String material : materiais = StringUtil.getValores(exame, "material")) {
                    String codigoMaterial = StringUtil.getValor(material, "codigomaterial");
                    String pergunta = StringUtil.xmlToTexto(StringUtil.getValor(material, "pergunta"));
                    String preparo = StringUtil.xmlToTexto(StringUtil.getValor(material, "preparo"));
                    String prepAmostra = StringUtil.xmlToTexto(StringUtil.getValor(material, "prepamostra"));
                    String instrColeta = StringUtil.xmlToTexto(StringUtil.getValor(material, "instrcoleta"));
                    String inadequada = StringUtil.xmlToTexto(StringUtil.getValor(material, "inadequada"));
                    String descricaoPrazo = StringUtil.getValor(material, "descricaoprazo");
                    String descricaoMetodo = StringUtil.getValor(material, "descricaometodo");
                    String descricaoMaterial = StringUtil.getValor(material, "descricaomaterial");
                    String conservacao = StringUtil.xmlToTexto(StringUtil.getValor(material, "conservacao"));
                    String diasConserva = StringUtil.getValor(material, "diasconserva");
                    String temperaturaInicial = StringUtil.getValor(material, "temperaturainicial");
                    String temperaturaFinal = StringUtil.getValor(material, "temperaturafinal");
                    String referencia = StringUtil.xmlToTexto(StringUtil.getValor(material, "referencia"));
                    boolean solicitarJejum = StringUtil.getValor(material, "solicitarjejum").equalsIgnoreCase("true");
                    boolean obrigaMedicamento = StringUtil.getValor(material, "obrigamedicamento").equalsIgnoreCase("true");
                    boolean obrigaDUM = StringUtil.getValor(material, "obrigadum").equalsIgnoreCase("true");
                    boolean obrigaPeso = StringUtil.getValor(material, "obrigapeso").equalsIgnoreCase("true");
                    boolean obrigaAltura = StringUtil.getValor(material, "obrigaaltura").equalsIgnoreCase("true");
                    boolean obrigaVolume = StringUtil.getValor(material, "obrigavolume").equalsIgnoreCase("true");
                    boolean obrigaTempoDiurese = StringUtil.getValor(material, "obrigatempodiurese").equalsIgnoreCase("true");
                    SalvaDados salvaExameMaterial = new SalvaDados("examematcoletajalis", 0);
                    salvaExameMaterial.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                    salvaExameMaterial.adicionaCampo("lae_codigo", 2, false, true, this.codigoLabExterno);
                    salvaExameMaterial.adicionaCampo("exa_codigo", 0, false, true, StringUtil.textoDB(codigo));
                    salvaExameMaterial.adicionaCampo("mco_codigo", 2, false, true, codigoMaterial);
                    salvaExameMaterial.adicionaCampo("emc_pergunta", 0, true, false, StringUtil.textoDB(pergunta));
                    salvaExameMaterial.adicionaCampo("emc_preparo", 0, true, false, StringUtil.textoDB(preparo));
                    salvaExameMaterial.adicionaCampo("emc_prepamostra", 0, true, false, StringUtil.textoDB(prepAmostra));
                    salvaExameMaterial.adicionaCampo("emc_inadequada", 0, true, false, StringUtil.textoDB(inadequada));
                    salvaExameMaterial.adicionaCampo("emc_referencia", 0, true, false, StringUtil.textoDB(referencia));
                    salvaExameMaterial.adicionaCampo("emc_descricaoprazo", 0, true, false, StringUtil.textoDB(descricaoPrazo));
                    salvaExameMaterial.adicionaCampo("emc_descricaometodo", 0, true, false, StringUtil.textoDB(descricaoMetodo));
                    salvaExameMaterial.adicionaCampo("emc_descricaomaterial", 0, true, false, StringUtil.textoDB(descricaoMaterial));
                    salvaExameMaterial.adicionaCampo("emc_conservacao", 0, true, false, StringUtil.textoDB(conservacao));
                    salvaExameMaterial.adicionaCampo("emc_diasconserva", 2, true, false, diasConserva);
                    salvaExameMaterial.adicionaCampo("emc_temperaturainicial", 0, true, false, temperaturaInicial);
                    salvaExameMaterial.adicionaCampo("emc_temperaturafinal", 0, true, false, temperaturaFinal);
                    salvaExameMaterial.adicionaCampo("emc_solicitarjejum", 4, true, false, solicitarJejum);
                    salvaExameMaterial.adicionaCampo("emc_obrigamedicamento", 4, true, false, obrigaMedicamento);
                    salvaExameMaterial.adicionaCampo("emc_obrigadum", 4, true, false, obrigaDUM);
                    salvaExameMaterial.adicionaCampo("emc_obrigapeso", 4, true, false, obrigaPeso);
                    salvaExameMaterial.adicionaCampo("emc_obrigaaltura", 4, true, false, obrigaAltura);
                    salvaExameMaterial.adicionaCampo("emc_obrigavolume", 4, true, false, obrigaVolume);
                    salvaExameMaterial.adicionaCampo("emc_obrigatempodiurese", 4, true, false, obrigaTempoDiurese);
                    rs = Conexao.executeQuery(st, salvaExameMaterial.getSelect());
                    if (rs.next()) {
                        salvaExameMaterial.setOperacao(2);
                    }
                    DBUtil.gravaAutoCopia(st, salvaExameMaterial, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
                }
            }
            ArrayList<ExameJalis> examesExcluidos = this.excluirExames(listagem, st, registro.getString("filialSelecionada"), Integer.toString(this.codigoLabExterno));
            if (this.checkPrimeira.isSelected()) {
                registro.setValor("primeiraConexao", "0");
                String xml = ConfiguradorProtocoloJalis.registroToXML(registro);
                SalvaDados salvaLabExterno = new SalvaDados("labexterno", 2);
                salvaLabExterno.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvaLabExterno.adicionaCampo("lae_codigo", 2, false, true, this.codigoLabExterno);
                salvaLabExterno.adicionaCampo("lae_configuracao", 0, false, false, xml);
                DBUtil.gravaAutoCopia(st, salvaLabExterno, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
            }
            Conexao.arquivaSQL();
            if (examesAdicionados.size() > 0) {
                this.setTextoInformacoes("+" + Funcoes.preencheVazio("", "-", 58, 1) + "+");
                this.setTextoInformacoes("\n|" + Funcoes.preencheVazio("Novos exames", 58, 2) + "|", false);
                this.setTextoInformacoes("\n|C\u00f3digo |" + Funcoes.preencheVazio("Descri\u00e7\u00e3o", 50, 2) + "|", false);
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
                for (String s : examesAdicionados) {
                    this.setTextoInformacoes("\n" + s, false);
                }
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
            }
            if (examesExcluidos.size() > 0) {
                this.setTextoInformacoes("+" + Funcoes.preencheVazio("", "-", 58, 1) + "+");
                this.setTextoInformacoes("\n|" + Funcoes.preencheVazio("Exames excluidos", 58, 2) + "|", false);
                this.setTextoInformacoes("\n|C\u00f3digo |" + Funcoes.preencheVazio("Descri\u00e7\u00e3o", 50, 2) + "|", false);
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
                for (ExameJalis e : examesExcluidos) {
                    this.setTextoInformacoes("\n|" + Funcoes.preencheVazio(e.getExame(), 7, 2) + "|" + Funcoes.preencheVazio(e.getDescricaoExame(), 50, 2) + "|", false);
                }
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
            }
            this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada", false);
            Funcoes.mensagem(this, "Importa\u00e7\u00e3o finalizada com sucesso!!!", 2);
            retorno = true;
        }
        catch (Exception e) {
            retorno = false;
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoJalis (241)");
        }
        System.gc();
        return retorno;
    }

    private ArrayList<ExameJalis> excluirExames(String xml, Statement st, String filial, String laeCodigo) throws SQLException, NumberFormatException, SalvaDadosException {
        String exames = StringUtil.getValor(xml, "examesexcluir");
        ArrayList<ExameJalis> examesExcluidos = new ArrayList<ExameJalis>();
        if (Funcoes.textoVazio(exames)) {
            return examesExcluidos;
        }
        ArrayList<ExameJalis> examesJalis = this.getExamesJalis(st, filial, laeCodigo);
        String[] examesExcluir = StringUtil.getValores(exames, "excluir");
        StringBuilder sql = new StringBuilder();
        for (String s : examesExcluir) {
            SalvaDados salvar;
            String codigo = StringUtil.getValor(s, "codigo");
            String material = StringUtil.getValor(s, "material");
            String descricao = "";
            sql.setLength(0);
            sql.append("select exa_descricao from exames where fil_codigo = ").append(Variaveis.filialPadrao);
            sql.append(" and exa_codigo = '").append(codigo).append("'");
            ResultSet rs = st.executeQuery(sql.toString());
            if (rs.next()) {
                descricao = rs.getString("exa_descricao");
            }
            rs.close();
            for (ExameJalis e : examesJalis) {
                if (!e.getExameLae().equalsIgnoreCase(codigo) || !e.getMaterialLae().equalsIgnoreCase(material)) continue;
                IntegracaoLabExternoUtil.salvaExameMatColetaLabExterno(st, filial, Integer.parseInt(laeCodigo), e.getExame(), Integer.parseInt(e.getMaterial()), null);
                examesExcluidos.add(new ExameJalis(e.getExame(), e.getMaterial(), descricao, laeCodigo, codigo, material));
            }
            if (!Funcoes.textoVazio(material)) {
                salvar = new SalvaDados("examematcoletajalis", 1);
                salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
                salvar.adicionaCampo("lae_codigo", 2, false, true, laeCodigo);
                salvar.adicionaCampo("exa_codigo", 0, false, true, codigo);
                salvar.adicionaCampo("mco_codigo", 2, false, true, material);
                DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
                examesExcluidos.add(new ExameJalis(codigo, material, descricao, laeCodigo, codigo, material));
                continue;
            }
            salvar = new SalvaDados("examematcoletajalis", 1);
            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
            salvar.adicionaCampo("lae_codigo", 2, false, true, laeCodigo);
            salvar.adicionaCampo("exa_codigo", 0, false, true, codigo);
            DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
            salvar = new SalvaDados("examesjalis", 1);
            salvar.adicionaCampo("fil_codigo", 2, false, true, Variaveis.filialPadrao);
            salvar.adicionaCampo("lae_codigo", 2, false, true, laeCodigo);
            salvar.adicionaCampo("exa_codigo", 0, false, true, codigo);
            DBUtil.gravaAutoCopia(st, salvar, "fil_codigo", ParametrosGerais.getCopiaLabExterno());
            examesExcluidos.add(new ExameJalis(codigo, material, descricao, laeCodigo, codigo, material));
        }
        return examesExcluidos;
    }

    private ArrayList<ExameJalis> getExamesJalis(Statement st, String filial, String laeCodigo) throws SQLException {
        ArrayList<ExameJalis> examesJalis = new ArrayList<ExameJalis>();
        StringBuilder sql = new StringBuilder();
        sql.append("select fil_codigo, exa_codigo, mco_codigo, ele_xmllabexterno ");
        sql.append("from examematcoletalabexterno ");
        sql.append(" where fil_codigo = ").append(Variaveis.filialPadrao);
        sql.append(" and lae_codigo = ").append(laeCodigo);
        sql.append(" and ele_xmllabexterno is not null and ele_xmllabexterno <> '' ");
        sql.append(" order by exa_codigo, mco_codigo ");
        ResultSet rs = st.executeQuery(sql.toString());
        while (rs.next()) {
            String xml = rs.getString("ele_xmllabexterno");
            if (Funcoes.textoVazio(xml)) continue;
            xml = StringUtil.getValor(rs.getString("ele_xmllabexterno"), "exame");
            String exameLae = StringUtil.getValor(xml, "codigoExame");
            String materialLae = StringUtil.getValor(xml, "codigoMaterial");
            examesJalis.add(new ExameJalis(rs.getString("exa_codigo"), rs.getString("mco_codigo"), "", laeCodigo, exameLae, materialLae));
        }
        return examesJalis;
    }

    public static boolean validaCliente(WSCliente ws, String codigoFilial, String codigoCliente) throws RemoteException {
        ParametroSet param = new ParametroSet();
        param.setString("codigoFilial", codigoFilial);
        param.setString("codigoCliente", codigoCliente);
        ParametroSet paramRetorno = ws.executaAcao("validaCliente", param);
        boolean retorno = paramRetorno.getBoolean("ok");
        return retorno;
    }

    public static boolean validaConvenio(WSCliente ws, String codigoFilial, String codigoConvenio) throws RemoteException {
        ParametroSet param = new ParametroSet();
        param.setString("codigoFilial", codigoFilial);
        param.setString("codigoConvenio", codigoConvenio);
        ParametroSet paramRetorno = ws.executaAcao("validaConvenio", param);
        boolean retorno = paramRetorno.getBoolean("ok");
        return retorno;
    }

    private String getListaExamesImportar(WSCliente ws, String codigoFilial, String codigoConvenio, boolean primeiraConexao, String tipoFilial) throws RemoteException {
        ParametroSet param = new ParametroSet();
        param.setString("codigoFilial", codigoFilial);
        param.setString("codigoConvenio", codigoConvenio);
        Apoiado apoiado = new Apoiado(Integer.parseInt(codigoFilial), tipoFilial, Integer.parseInt(codigoConvenio));
        param.setString("chave", apoiado.getChave());
        param.setBoolean("primeiraConexao", primeiraConexao);
        ParametroSet paramRetorno = ws.executaAcao("getListaExamesImportar", param);
        return paramRetorno.getString("listaExamesImportar");
    }

    private String getExamesJalis(WSCliente ws, String codigoFilial, String codigoConvenio, boolean primeiraConexao) throws RemoteException {
        ParametroSet param = new ParametroSet();
        param.setString("codigoFilial", codigoFilial);
        param.setString("codigoConvenio", codigoConvenio);
        param.setBoolean("primeiraConexao", primeiraConexao);
        ParametroSet paramRetorno = ws.executaAcao("getExamesJalis", param);
        return paramRetorno.getString("exames");
    }

    private String getExamesJalis(WSCliente ws, String codigoFilial, String codigoConvenio, String codigoExame, boolean primeiraConexao) throws RemoteException {
        ParametroSet param = new ParametroSet();
        param.setString("codigoFilial", codigoFilial);
        param.setString("codigoConvenio", codigoConvenio);
        param.setBoolean("primeiraConexao", primeiraConexao);
        param.setString("codigoExame", codigoExame);
        ParametroSet paramRetorno = ws.executaAcao("getExamesJalis", param);
        return paramRetorno.getString("exames");
    }
}

