/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalis;

import jalis.apoio.servidor.IServidor;
import jalis.apoio.util.Util;
import jalis.comum.Conexao;
import jalis.comum.ParametrosLocais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.exportacao.integracao.IntegracaoUtil;
import jalis.laboratorio.exportacao.thread.ExportaSMS;
import jalis.laboratorio.exportacao.thread.ExportaWeb;
import jalis.laboratorio.relatorios.apoio.RelatorioSituacaoLote;
import jalis.laboratorio.resultados.ResultadosUtil;
import jalis.laboratorio.util.EmailUtil;
import jalis.laboratorio.util.PushUtil;
import jalis.laboratorio.util.SMSUtil;
import jalis.laboratorio.util.TipoPush;
import jalis.laboratorio.util.TipoWhatsapp;
import jalis.laboratorio.util.WhatsAppUtil;
import jalis.laboratorio.util.autocopia.ExportaFiliais;
import jalis.laboratorio.util.parsers.AbstractImportadorResultadoLabExterno;
import jalis.laboratorio.util.parsers.FabricaConfigurador;
import jalis.laboratorio.util.parsers.Protocolo;
import jalis.laboratorio.util.parsers.RelatorioImportacaoResultadoUtil;
import jalis.laboratorio.util.parsers.jalis.ConexaoRMI;
import jalis.laboratorio.util.parsers.jalis.ConfiguradorProtocoloJalis;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ImportacaoResultadoJalis
extends AbstractImportadorResultadoLabExterno {
    private int codigoLabExterno;
    private static ModeloGridTable modelo = new ModeloGridTable(RelatorioSituacaoLote.campos);
    private JButton buttonImprimir = ComponenteFactory.novoJButton("Imprimir", 'I', this, null, null, false);

    public ImportacaoResultadoJalis(int codigoLabExterno) {
        super("Importa\u00e7\u00e3o de Exames", "Importa\u00e7\u00e3o de exames utilizando o protocolo Jalis", codigoLabExterno, Protocolo.Jalis, new JPanel(new FlowLayout(2)));
        this.codigoLabExterno = codigoLabExterno;
        this.getPanelAdicional().add(this.buttonImprimir);
    }

    public static long getModuloAcesso() {
        return 904000201L;
    }

    private Registro buscaDadosXML(int codigo) throws Exception {
        Registro retorno = null;
        Statement st = Conexao.getStatement();
        StringBuilder buf = new StringBuilder("select lae_configuracao from labexterno where fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and lae_codigo = ").append(codigo);
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            retorno = ConfiguradorProtocoloJalis.xmlToRegistro(rs.getString("lae_configuracao"));
        }
        return retorno;
    }

    @Override
    protected void importarResultado() {
        if (!Funcoes.permiteConferirGerarPdf(Variaveis.filialPadrao)) {
            return;
        }
        this.setTextoInformacoes("Aguarde... Conectando ao servidor do laborat\u00f3rio de apoio");
        ArrayList<Object> importados = new ArrayList();
        String requisicao = "";
        try {
            Registro registro = this.buscaDadosXML(this.codigoLabExterno);
            if (!Funcoes.testaConexaoWeb(registro.getString("servidorRMI"), 4445)) {
                Funcoes.mensagem(this, "Conex\u00e3o com a web n\u00e3o encontrada", 1);
                this.setTextoInformacoes("Conex\u00e3o com a web n\u00e3o encontrada");
                return;
            }
            IServidor servidor = ConexaoRMI.getServidor(registro.getString("servidorRMI"));
            int conectado = ConexaoRMI.testarServidor(servidor, registro.getString("filialSelecionada"), registro.getString("codigoCliente"), registro.getString("codigoConvenio"));
            String string = ConexaoRMI.getTextoMensagem(conectado);
            if (conectado != 0) {
                Funcoes.mensagem(this, string, 1);
                this.setTextoInformacoes(string);
                return;
            }
            this.setTextoInformacoes("Recebendo resultados...");
            requisicao = servidor.getExameRequisicao(registro.getString("filialSelecionada"), registro.getString("codigoConvenio"));
            this.setTextoInformacoes("Validando requisi\u00e7\u00f5es recebidas...");
            if (Funcoes.textoVazio(requisicao) || StringUtil.getValores(requisicao, "examerequisicao").length == 0) {
                this.setTextoInformacoes("N\u00e3o h\u00e1 resultados para serem importados");
                return;
            }
            Statement st = Conexao.getStatement();
            Statement st2 = Conexao.getStatement();
            System.gc();
            importados = this.importarExameRequisicao(st, st2, servidor, registro.getString("codigoConvenio"), requisicao, registro);
            Conexao.arquivaSQL();
            if (importados.size() > 0) {
                this.setTextoInformacoes("+" + Funcoes.preencheVazio("", "-", 58, 1) + "+");
                this.setTextoInformacoes("\n|" + Funcoes.preencheVazio("Resultados recebidos", 58, 2) + "|", false);
                this.setTextoInformacoes("\n|Requisi\u00e7\u00e3o|" + Funcoes.preencheVazio("Exame", 47, 2) + "|", false);
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
                for (String string2 : importados) {
                    this.setTextoInformacoes("\n" + string2, false);
                }
                this.setTextoInformacoes("\n+" + Funcoes.preencheVazio("", "-", 58, 1) + "+", false);
            }
            this.setTextoInformacoes("\nImporta\u00e7\u00e3o finalizada", false);
            this.buttonImprimir.setEnabled(modelo.getRowCount() > 0);
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception servidor) {
                // empty catch block
            }
            String lista = "";
            if (importados != null) {
                for (String string : importados) {
                    lista = lista + string;
                }
            }
            ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ImportacaoResultadoJalis (139) \n" + lista + "\n" + requisicao);
        }
        System.gc();
    }

    private static void adicionaExameRetorno(Statement st, ArrayList<String> retorno, String requisicao, String exame, String material) throws Exception {
        retorno.add("|" + Funcoes.preencheVazio(requisicao, 10, 1) + "|" + Funcoes.preencheVazio(exame + " (" + material + ")", 47, 2) + "|");
        StringBuilder buf = new StringBuilder();
        buf.append("select a.req_codigoapoiado as codigoRequisicaoApoio,  a.req_codigo as codigoRequisicao, ");
        buf.append("paciente.pac_nome as nomePaciente, a.req_idade as idadePaciente, a.req_anomes as anoMesPaciente, ");
        buf.append("c.exa_codigo as codigoExame, c.exa_descricao as descricaoExame,  ");
        buf.append("paciente.pac_datanasc as dataNascimentoPaciente, paciente.pac_sexo as sexoPaciente, ");
        buf.append("a.med_conselho as conselhoMedico, a.med_crm as crmMedico, a.med_uf as ufMedico, medico.med_nome as nomeMedico, ");
        buf.append("a.req_obs as observacaoRequisicao, a.req_hora as horaRequisicao, ");
        buf.append("coletado.mco_codigo as codigoMaterialColetado, coletado.mco_descricao as descricaoMaterialColetado, ");
        buf.append("coletado.mco_abreviatura as abreviaturaMaterialColetado, exr.exr_situacao as situacaoExame, ");
        buf.append("l.lex_codigo as codigoLote, l.lex_datahora as dataLote,  ");
        buf.append("d.lae_codigo as codigoLabExterno, labexterno.lae_protocolo as protocoloLabExterno, ");
        buf.append("ele.ele_xmllabexterno as codigoExameLaboratorioApoio, '' as descricaoExameLaboratorioApoio, ");
        buf.append("a.req_data as dataRequisicao, lote.fil_codigo as codigoFilial, fil.fil_descricao as descricaoFilial, ");
        buf.append("rle.rle_codigo as codigoCip ");
        buf.append("from loteexternorequisicao lote ");
        buf.append("left join loteexterno l on lote.fil_codigo = l.fil_codigo and lote.lex_codigo = l.lex_codigo and lote.lae_codigo = l.lae_codigo ");
        buf.append("left join requisicao a on lote.fil_codigo = a.fil_codigo and lote.req_codigo = a.req_codigo ");
        buf.append("join loteexternoexamerequisicao b on lote.fil_codigo = b.fil_codigo and lote.req_codigo = b.req_codigo and lote.lex_codigo = b.lex_codigo and lote.lae_codigo = b.lae_codigo ");
        buf.append("join examerequisicao exr on b.fil_codigo = exr.fil_codigo and b.req_codigo = exr.req_codigo and b.exa_codigo = exr.exa_codigo and b.mco_codigo = exr.mco_codigo ");
        buf.append("join paciente on a.fil_codigo = paciente.fil_codigo and a.pac_codigo = paciente.pac_codigo ");
        buf.append("left join exames c on b.fil_codigo = c.fil_codigo and b.exa_codigo = c.exa_codigo ");
        buf.append("left join examematcoleta d on b.fil_codigo = d.fil_codigo and b.exa_codigo = d.exa_codigo and b.mco_codigo = d.mco_codigo ");
        buf.append("left join materialcoleta coletado on d.fil_codigo = coletado.fil_codigo and d.mco_codigo = coletado.mco_codigo ");
        buf.append("left join medico on a.fil_codigo = medico.fil_codigo and a.med_conselho = medico.med_conselho and a.med_crm = medico.med_crm and a.med_uf = medico.med_uf ");
        buf.append("left join labexterno on lote.fil_codigo = labexterno.fil_codigo and lote.lae_codigo = labexterno.lae_codigo ");
        buf.append("left join filiais_postocoleta fil on lote.fil_codigo = fil.fil_codigo ");
        buf.append("left join requisicaolabexterno rle on lote.fil_codigo = rle.fil_codigo and lote.req_codigo = rle.req_codigo and lote.lae_codigo = rle.lae_codigo ");
        buf.append("left join examematcoletalabexterno ele on d.fil_codigo = ele.fil_codigo and d.exa_codigo = ele.exa_codigo and d.mco_codigo = ele.mco_codigo and b.lae_codigo = ele.lae_codigo ");
        buf.append("where a.fil_codigo = ");
        buf.append(Variaveis.filialPadrao);
        buf.append(" and lote.req_codigo = ").append(requisicao);
        buf.append(" and b.exa_codigo = '").append(exame).append("' ");
        buf.append(" and b.mco_codigo = ").append(material);
        buf.append(" and a.req_excluida = false and exr.exr_excluido = false ");
        buf.append(" and ele.ele_xmllabexterno is not null and ele.ele_xmllabexterno <> '' ");
        ResultSet rs = Conexao.executeQuery(st, buf);
        if (rs.next()) {
            do {
                Object[] o = new Object[RelatorioSituacaoLote.campos.length];
                for (int i = 0; i < RelatorioSituacaoLote.campos.length; ++i) {
                    Protocolo p;
                    String xml;
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("codigoLoteLabApoio")) {
                        o[i] = Funcoes.preencheZero(rs.getString("codigoLote"), 6);
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("anoMesPaciente")) {
                        o[i] = Tipos.tipoIdade(rs.getString(RelatorioSituacaoLote.campos[i]));
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("sexoPaciente")) {
                        o[i] = Tipos.tipoSexo(rs.getString(RelatorioSituacaoLote.campos[i]));
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("situacaoExame")) {
                        o[i] = Tipos.tipoSituacaoExame(rs.getString(RelatorioSituacaoLote.campos[i]));
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("codigoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i] = FabricaConfigurador.getCodigoIdentExameLabExternoSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    if (RelatorioSituacaoLote.campos[i].equalsIgnoreCase("descricaoExameLaboratorioApoio")) {
                        xml = rs.getString("codigoExameLaboratorioApoio");
                        o[i] = "";
                        p = Protocolo.getProtocolo(rs.getString("protocoloLabExterno"));
                        if (p == null) continue;
                        o[i] = FabricaConfigurador.getDescricaoExameSelecionado(p, rs.getString("codigoLabExterno"), xml);
                        continue;
                    }
                    o[i] = rs.getObject(RelatorioSituacaoLote.campos[i]);
                }
                modelo.addLine(o);
            } while (rs.next());
        }
    }

    private ArrayList<String> importarExameRequisicao(Statement st, Statement st2, IServidor servidor, String convenio, String requisicao, Registro registro) throws Exception {
        String[] requisicoes;
        ArrayList<String> retorno = new ArrayList<String>();
        if (Funcoes.textoVazio(requisicao)) {
            return retorno;
        }
        modelo.clear();
        for (String s : requisicoes = StringUtil.getValores(requisicao, "examerequisicao", true)) {
            String resultado;
            String material;
            String comando;
            if (s == null || (comando = StringUtil.getValor(s, "comando")) != null && !Funcoes.textoVazio(comando)) continue;
            String codigo = Util.getCodigoXML(s, "req_codigo");
            StringBuilder bui = new StringBuilder();
            boolean novoExame = false;
            String exame = Util.getCodigoXML(s, "exr_codexameorigem");
            if (Funcoes.textoVazio(exame)) {
                exame = Util.getCodigoXML(s, "exa_codigo");
            }
            if (Funcoes.textoVazio(material = Util.getCodigoXML(s, "exr_codmatorigem"))) {
                material = Util.getCodigoXML(s, "mco_codigo");
            }
            if (codigo == null || exame == null || material == null || exame.equalsIgnoreCase("null") || material.equalsIgnoreCase("null")) continue;
            if (!(Funcoes.textoVazio(codigo) || DBUtil.campoNull(codigo) || Funcoes.textoVazio(exame) || DBUtil.campoNull(exame) || Funcoes.textoVazio(material) || DBUtil.campoNull(material))) {
                bui.delete(0, bui.length());
                bui.append("select req_codigo from examerequisicao where fil_codigo = ");
                bui.append(Variaveis.filialPadrao);
                bui.append(" and req_codigo = ").append(codigo);
                bui.append(" and exa_codigo = '").append(StringUtil.textoDB(exame));
                bui.append("' and mco_codigo = ").append(material);
                bui.append(" and exr_excluido = false ");
                boolean bl = novoExame = !Conexao.executeQuery(st, bui.toString()).next();
            }
            if (novoExame) continue;
            String codigoApoio = "";
            String codigoExame = Util.getCodigoXML(s, "exa_codigo");
            String codigoMaterial = Util.getCodigoXML(s, "mco_codigo");
            String codigoExameOrigem = Util.getCodigoXML(s, "exr_codexameorigem");
            String codigoMaterialOrigem = Util.getCodigoXML(s, "exr_codmatorigem");
            if (codigoExame == null || codigoMaterial == null || codigoExameOrigem == null || codigoMaterialOrigem == null || codigoExameOrigem.equalsIgnoreCase("null") || codigoMaterialOrigem.equalsIgnoreCase("null")) continue;
            StringBuilder buf = new StringBuilder("select rle_codigo from requisicaolabexterno where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ").append(codigo).append(" and lae_codigo = ").append(this.codigoLabExterno);
            ResultSet rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                codigoApoio = rs.getString("rle_codigo");
            }
            if (Funcoes.textoVazio(codigoApoio) || Funcoes.textoVazio(StringUtil.getValor(resultado = servidor.getResultados(registro.getString("filialSelecionada"), codigoApoio, codigoExame, codigoMaterial), "resultados")) || Funcoes.textoVazio(StringUtil.getValor(resultado, "resultado"))) continue;
            String situacao = StringUtil.getValor(resultado, "situacao");
            boolean parcial = StringUtil.getBoolean(resultado, "considerarparcial");
            resultado = StringUtil.descompactar(IntegracaoUtil.VersaoXML.VERSAO_1_0_0, StringUtil.getValor(resultado, "resultado"), StringUtil.getCharsetIntegracao(ParametrosLocais.getParametro("codificacaoIntegracaoOffline")));
            String situacaoAtual = "";
            buf.delete(0, buf.length());
            buf.append("select exr_situacao from examerequisicao where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ");
            buf.append(codigo);
            buf.append(" and exa_codigo = '");
            buf.append(codigoExameOrigem);
            buf.append("' and mco_codigo = ");
            buf.append(codigoMaterialOrigem);
            buf.append(" and exr_excluido = false ");
            rs = Conexao.executeQuery(st, buf);
            if (rs.next()) {
                situacaoAtual = rs.getString("exr_situacao");
            }
            if (!Funcoes.textoVazio(situacaoAtual)) continue;
            String novaSituacao = "P";
            buf.delete(0, buf.length());
            buf.append("update examerequisicao set exr_resultado = '");
            buf.append(StringUtil.textoDB(resultado));
            buf.append("', exr_datadigita = current_timestamp, ");
            buf.append("usr_coddigitador = '").append(Variaveis.login).append("', ");
            buf.append("exr_situacao = '");
            if (parcial && situacao.equals("P")) {
                novaSituacao = "P";
                buf.append("P");
            } else {
                novaSituacao = "L";
                buf.append("L");
            }
            buf.append("' ");
            buf.append("where fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and req_codigo = ");
            buf.append(codigo);
            buf.append(" and exa_codigo = '");
            buf.append(codigoExameOrigem);
            buf.append("' and mco_codigo = ");
            buf.append(codigoMaterialOrigem);
            if (situacao == null || !situacao.equalsIgnoreCase("C") && !situacao.equalsIgnoreCase("I") && !situacao.equalsIgnoreCase("E") && (!parcial || !situacao.equalsIgnoreCase("P"))) continue;
            DBUtil.gravaLogSituacaoExameRequisicao(st, Variaveis.filialPadrao, codigo, codigoExameOrigem, codigoMaterialOrigem, novaSituacao, false);
            Conexao.execute(Variaveis.filialPadrao, st, buf.toString());
            ImportacaoResultadoJalis.adicionaExameRetorno(st, retorno, codigo, codigoExameOrigem, codigoMaterialOrigem);
            if (situacao.equalsIgnoreCase("C")) {
                Util.gravaAlteracaoExameRequisicao(st, codigo, codigoExameOrigem, codigoMaterialOrigem);
            }
            buf.delete(0, buf.length());
            buf.append("select pegaResultadoExame(a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo) as exr_resultado, a.exr_dataassina, a.usr_codassina, a.exr_situacao, b.usr_nome ");
            buf.append("from examerequisicao a ");
            buf.append("left join usuario b on a.usr_codassina = b.usr_codigo ");
            buf.append(" where a.fil_codigo = ");
            buf.append(Variaveis.filialPadrao);
            buf.append(" and a.req_codigo = ");
            buf.append(codigo);
            buf.append(" and a.exa_codigo = '");
            buf.append(codigoExameOrigem);
            buf.append("' and a.mco_codigo = ");
            buf.append(codigoMaterialOrigem);
            rs = Conexao.executeQuery(st, buf.toString());
            if (rs.next()) {
                String rst = rs.getString("exr_resultado");
                String sit = rs.getString("exr_situacao");
                String usuario = rs.getString("usr_codassina");
                String nomeUsuario = rs.getString("usr_nome");
                ImportacaoResultadoJalis.exportaExameRequisicaoWeb(st, codigo, codigoExameOrigem, codigoMaterialOrigem, rst, sit, usuario, nomeUsuario, "A");
            }
            ExportaFiliais.gravaRequisicao(Integer.parseInt(Variaveis.filialPadrao), Integer.parseInt(codigo), codigoExameOrigem, Integer.parseInt(codigoMaterialOrigem), "U", "U");
            if (!SMSUtil.isBloquearSMSExamePronto(Variaveis.filialPadrao, codigo, st2)) {
                SMSUtil.criaLogSmsComDadosRequisicao(Variaveis.filialPadrao, codigo, ExportaSMS.TipoSMS.RESULTADO, st, st2);
            }
            if (!EmailUtil.isBloquearEmailExamePronto(Variaveis.filialPadrao, codigo, st2)) {
                EmailUtil.criaLogEmail(Variaveis.filialPadrao, codigo, null, EmailUtil.TipoEmail.RESULTADO, true, st);
            }
            if (!PushUtil.isBloquearPushExamePronto(Variaveis.filialPadrao, codigo, st2)) {
                PushUtil.criaLogPushComDadosRequisicao(Variaveis.filialPadrao, codigo, TipoPush.RESULTADO, st, st2);
            }
            if (WhatsAppUtil.isBloquearWhatsappExamePronto(Variaveis.filialPadrao, codigo, st2)) continue;
            WhatsAppUtil.criaLogWhatsappComDadosRequisicao(Variaveis.filialPadrao, codigo, TipoWhatsapp.RESULTADO, st, st2);
        }
        return retorno;
    }

    private static void exportaExameRequisicaoWeb(Statement st, String requisicao, String exame, String material, String resultado, String situacao, String assinatura, String nomeAssinatura, String operacao) throws Exception {
        if (Variaveis.exportarWebFilial) {
            boolean resultadoPdf = ExportaWeb.isGerarPdfResultado(st, Variaveis.filialPadrao);
            String[] comandoExameRequisicao = new String[20];
            comandoExameRequisicao[0] = "codigoBase";
            comandoExameRequisicao[1] = Variaveis.codigoBaseWeb;
            comandoExameRequisicao[2] = "codigoRequisicao";
            comandoExameRequisicao[3] = IntegracaoUtil.formataCodigoRequisicao(Variaveis.filialPadrao, requisicao, st);
            comandoExameRequisicao[4] = "codigoExameRequisicao";
            comandoExameRequisicao[5] = exame;
            comandoExameRequisicao[6] = "materialExameRequisicao";
            comandoExameRequisicao[7] = material;
            comandoExameRequisicao[8] = "situacaoExameRequisicao";
            comandoExameRequisicao[9] = situacao;
            comandoExameRequisicao[10] = "assinaturaExameRequisicao";
            comandoExameRequisicao[11] = assinatura;
            comandoExameRequisicao[12] = "nomeAssinaturaExameRequisicao";
            comandoExameRequisicao[13] = nomeAssinatura;
            comandoExameRequisicao[14] = "resultadoExameRequisicao";
            String rst = "";
            Map<String, Object> map = null;
            if (!resultadoPdf && !Funcoes.textoVazio(resultado)) {
                map = ResultadosUtil.geraResultadoParaWeb(st, Variaveis.filialPadrao, requisicao, exame, material, resultado, false);
                rst = map != null && map.get("laudo") != null ? (String)map.get("laudo") : "";
            }
            comandoExameRequisicao[15] = resultadoPdf ? "" : rst;
            comandoExameRequisicao[16] = "dataEnvioExameRequisicao";
            comandoExameRequisicao[17] = "current_timestamp";
            String tipoOperacao = operacao;
            DBUtil.insereExportaWeb(st, "requisicaoexame", tipoOperacao, true, comandoExameRequisicao);
            Map imagens = null;
            String[] comandoExcluiImagens = new String[]{"codigoBase", Variaveis.codigoBaseWeb, "codigoRequisicao", IntegracaoUtil.formataCodigoRequisicao(Variaveis.filialPadrao, requisicao, st), "codigoExameRequisicao", exame, "materialExameRequisicao", material};
            DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "D", comandoExcluiImagens);
            if (map != null && !(imagens = (Map)map.get("imagens")).isEmpty()) {
                String[] comandoInserirImagens = new String[12];
                comandoInserirImagens[0] = "codigoBase";
                comandoInserirImagens[2] = "codigoRequisicao";
                comandoInserirImagens[4] = "codigoExameRequisicao";
                comandoInserirImagens[6] = "materialExameRequisicao";
                comandoInserirImagens[8] = "codigoImagemExame";
                comandoInserirImagens[10] = "imagemExame";
                for (Integer i : imagens.keySet()) {
                    comandoInserirImagens[1] = Variaveis.codigoBaseWeb;
                    comandoInserirImagens[3] = IntegracaoUtil.formataCodigoRequisicao(Variaveis.filialPadrao, requisicao, st);
                    comandoInserirImagens[5] = exame;
                    comandoInserirImagens[7] = material;
                    comandoInserirImagens[9] = i.toString();
                    comandoInserirImagens[11] = (String)imagens.get(i);
                    DBUtil.insereExportaWeb(st, "requisicaoexameimagem", "I", comandoInserirImagens);
                }
            }
            if (ExportaWeb.isGerarPdfResultado(st, String.valueOf(Variaveis.filialPadrao))) {
                ExportaWeb.enviarResultadoPDF(st, String.valueOf(Variaveis.filialPadrao), requisicao, Variaveis.codigoBaseWeb);
            }
            ExportaWeb.atualizaPaginaOrdemExameWeb(st, String.valueOf(Variaveis.filialPadrao), requisicao, Variaveis.codigoBaseWeb);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonImprimir) {
            RelatorioImportacaoResultadoUtil.imprimirRelatorio(this, modelo);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    protected void importarResultadoWs() {
    }
}

