/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalis;

import jalis.apoio.servidorws.Apoiado;
import jalis.apoio.servidorws.WSCliente;
import jalis.apoio.servidorws.parametroset.ParametroSet;
import jalis.laboratorio.util.parsers.AbstractConfiguradorProtocolo;
import jalis.laboratorio.util.parsers.jalis.ObjetoComboFiliais;
import jalis.util.Funcoes;
import jalis.util.ScreenUtil;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ConfiguradorProtocoloJalis
extends AbstractConfiguradorProtocolo {
    private TTextField textServidor = new TTextField(100);
    private TTextField textPortaServidor = new TTextField(4, 1);
    private JComboBox comboFiliais = new JComboBox();
    protected JTextField textCodTuboLis = new TTextField(2, 3);
    protected JCheckBox checkEnviarEtiqueta = ComponenteFactory.novoJCheckBox("Enviar etiqueta como c\u00f3digo de apoio", new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfiguradorProtocoloJalis.this.textCodTuboLis.setEnabled(ConfiguradorProtocoloJalis.this.checkEnviarEtiqueta.isSelected());
            if (!ConfiguradorProtocoloJalis.this.checkEnviarEtiqueta.isEnabled()) {
                ConfiguradorProtocoloJalis.this.textCodTuboLis.setText("");
            }
        }
    });
    private String codigoCliente = "";
    private boolean primeiraConexao = true;
    private static boolean servidorAtivo = false;
    public static final String CODIGO_CLIENTE_JALIS = "codigoCliente";
    public static final String SEQUENCIAL_LOTE = "sequencialLote";
    public static final String SERVIDOR_RMI = "servidorRMI";
    public static final String FILIAL_SELECIONADA = "filialSelecionada";
    public static final String CODIGO_CONVENIO = "codigoConvenio";
    public static final String PRIMEIRA_CONEXAO = "primeiraConexao";
    public static final String PORTA_SERVIDOR = "portaServidor";
    public static final String ENVIAR_ETIQUETA = "enviarEtiquetaApoio";
    public static final String CODIGO_ETIQUETA_APOIO = "codigoEtiquetaApoio";

    public static AbstractConfiguradorProtocolo novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Frame) {
            return new ConfiguradorProtocoloJalis((Frame)pai, "Configurador Jalis", codigoLabExterno);
        }
        if (pai instanceof Dialog) {
            return new ConfiguradorProtocoloJalis((Dialog)pai, "Configurador Jalis", codigoLabExterno);
        }
        return null;
    }

    public ConfiguradorProtocoloJalis(Dialog pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.montarTela();
    }

    public ConfiguradorProtocoloJalis(Frame pai, String titulo, String codigoLaboratorio) {
        super(pai, titulo, codigoLaboratorio);
        this.montarTela();
    }

    @Override
    public String getXML() {
        StringBuilder buf = new StringBuilder("<jalis>");
        buf.append(StringUtil.getTag(CODIGO_CLIENTE_JALIS, this.codigoCliente));
        buf.append(StringUtil.getTag(SERVIDOR_RMI, this.textServidor.getText()));
        buf.append(StringUtil.getTag(SEQUENCIAL_LOTE, this.textLote.getText()));
        buf.append(StringUtil.getTag(CODIGO_CONVENIO, this.textCodigo.getText()));
        buf.append(StringUtil.getTag(FILIAL_SELECIONADA, ((ObjetoComboFiliais)this.comboFiliais.getSelectedItem()).getCodigo()));
        buf.append(StringUtil.getTag(PRIMEIRA_CONEXAO, this.primeiraConexao ? "1" : "0"));
        buf.append(StringUtil.getTag(PORTA_SERVIDOR, this.textPortaServidor.getText()));
        buf.append(StringUtil.getTag(ENVIAR_ETIQUETA, this.checkEnviarEtiqueta.isSelected() ? "true" : "false"));
        buf.append(StringUtil.getTag(CODIGO_ETIQUETA_APOIO, this.textCodTuboLis.getText()));
        buf.append("</jalis>");
        return buf.toString();
    }

    @Override
    public void setXML(String xml, boolean verificarMaiorLote) {
        ObjetoComboFiliais o;
        boolean conf = this.isVisible();
        Registro r = ConfiguradorProtocoloJalis.xmlToRegistro(xml);
        this.codigoCliente = r.getString(CODIGO_CLIENTE_JALIS);
        this.textServidor.setText(r.getString(SERVIDOR_RMI));
        this.textCodigo.setText(r.getString(CODIGO_CONVENIO));
        String sequencia = r.getString(SEQUENCIAL_LOTE);
        String filial = r.getString(FILIAL_SELECIONADA);
        this.primeiraConexao = r.getString(PRIMEIRA_CONEXAO) == null || r.getString(PRIMEIRA_CONEXAO).equalsIgnoreCase("1");
        this.textPortaServidor.setText(r.getString(PORTA_SERVIDOR));
        this.checkEnviarEtiqueta.setSelected(r.getBoolean(ENVIAR_ETIQUETA));
        this.textCodTuboLis.setText(r.getString(CODIGO_ETIQUETA_APOIO));
        this.textCodTuboLis.setEnabled(this.checkEnviarEtiqueta.isSelected());
        this.verificaWs(this.textServidor.getText(), Funcoes.textoVazio(this.textPortaServidor) ? 0 : Integer.parseInt(this.textPortaServidor.getText()));
        if (servidorAtivo) {
            this.buscaFiliais(this.textServidor.getText(), Funcoes.textoVazio(this.textPortaServidor) ? 0 : Integer.parseInt(this.textPortaServidor.getText()));
        }
        for (int i = 0; i < this.comboFiliais.getItemCount(); ++i) {
            ObjetoComboFiliais o2 = (ObjetoComboFiliais)this.comboFiliais.getItemAt(i);
            if (!Funcoes.isNumeric(filial) || !Funcoes.isNumeric(o2.getCodigo()) || Integer.parseInt(o2.getCodigo()) != Integer.parseInt(filial)) continue;
            this.comboFiliais.setSelectedIndex(i);
            break;
        }
        if (this.comboFiliais.getItemCount() == 0 && !Funcoes.textoVazio(filial)) {
            this.comboFiliais.addItem(new ObjetoComboFiliais(filial, "", "0"));
            this.comboFiliais.setSelectedIndex(0);
        }
        if (this.comboFiliais.getSelectedItem() instanceof ObjetoComboFiliais && verificarMaiorLote && Funcoes.isNumeric((o = (ObjetoComboFiliais)this.comboFiliais.getSelectedItem()).getMaiorLote()) && Funcoes.isNumeric(sequencia)) {
            if (Integer.parseInt(o.getMaiorLote()) > Integer.parseInt(sequencia)) {
                if (conf) {
                    Funcoes.mensagem(this, "O c\u00f3digo sequencial do lote no laborat\u00f3rio de apoio \u00e9 maior que o\n sequencial local. O maior valor ser\u00e1 assumido", 2);
                }
            } else if (Integer.parseInt(o.getMaiorLote()) < Integer.parseInt(sequencia)) {
                if (conf) {
                    Funcoes.mensagem(this, "O c\u00f3digo sequencial do lote local \u00e9 maior que o sequencial no laborat\u00f3rio\n de apoio. O maior valor ser\u00e1 assumido", 2);
                }
                o.setMaiorLote(sequencia);
            }
            this.textLote.setText(o.getMaiorLote());
        }
    }

    private void verificaWs(String servidor, int porta) {
        if (Funcoes.testaConexaoWeb(servidor, porta)) {
            try {
                WSCliente ws = new WSCliente(servidor, porta);
                if (ws.isServidorOk()) {
                    servidorAtivo = true;
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConfiguradorProtocoloJalis");
            }
        }
    }

    @Override
    public boolean acaoOk() {
        if (Funcoes.textoVazio(this.textServidor.getText())) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado um servidor v\u00e1lido", 1);
        } else if (!Funcoes.textoVazio(this.textServidor.getText()) && this.comboFiliais.getSelectedItem() == null) {
            Funcoes.mensagem(this, "N\u00e3o foi especificado uma filial v\u00e1lida", 1);
        } else {
            return super.acaoOk();
        }
        this.textLote.grabFocus();
        return false;
    }

    private void montarTela() {
        this.getPanelCentral().setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.getPanelCentral().setBorder(new TitledBorder("Configura\u00e7\u00e3o de Protocolo"));
        this.textCodTuboLis.setEnabled(false);
        c.gridx = 0;
        c.gridy = 0;
        c.fill = 0;
        c.anchor = 17;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Servidor:", 'S', null, this.textServidor), c);
        ++c.gridy;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Porta Servidor:", null), c);
        ++c.gridy;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Filial:", null), c);
        ++c.gridy;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("C\u00f3digo:", null), c);
        ++c.gridy;
        this.getPanelCentral().add((Component)ComponenteFactory.novoJLabel("Sequ\u00eancia Lote:", null), c);
        c.gridx = 1;
        c.gridy = 0;
        c.fill = 2;
        c.weightx = 1.0;
        this.textServidor.setPreferredSize(new Dimension(100, 22));
        this.getPanelCentral().add((Component)this.textServidor, c);
        ++c.gridy;
        this.textPortaServidor.setPreferredSize(new Dimension(100, 22));
        this.getPanelCentral().add((Component)this.textPortaServidor, c);
        ++c.gridy;
        this.comboFiliais.setPreferredSize(new Dimension(100, 22));
        this.comboFiliais.setMinimumSize(new Dimension(100, 22));
        this.getPanelCentral().add((Component)this.comboFiliais, c);
        ++c.gridy;
        this.textCodigo.setPreferredSize(new Dimension(100, 22));
        this.getPanelCentral().add((Component)this.textCodigo, c);
        ++c.gridy;
        this.textLote.setPreferredSize(new Dimension(100, 22));
        this.getPanelCentral().add((Component)this.textLote, c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        this.getPanelCentral().add((Component)this.checkEnviarEtiqueta, c);
        ++c.gridy;
        c.gridwidth = 1;
        JLabel lblCodLIS = ComponenteFactory.novoJLabel("C\u00f3digo LIS:", new Dimension(100, 20));
        lblCodLIS.setMinimumSize(new Dimension(100, 20));
        this.getPanelCentral().add((Component)lblCodLIS, c);
        c.gridx = 1;
        this.textCodTuboLis.setPreferredSize(new Dimension(200, 20));
        this.textCodTuboLis.setMinimumSize(new Dimension(200, 20));
        this.getPanelCentral().add((Component)this.textCodTuboLis, c);
        this.pack();
        this.setSize(new Dimension(320, 270));
        ScreenUtil.centralizar(this);
        ScreenUtil.requisitarFoco(this.textServidor);
        this.textCodigo.setEnabled(false);
        this.textCodigo.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfiguradorProtocoloJalis.this.carregaApoiado();
            }
        });
        this.textPortaServidor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (!ConfiguradorProtocoloJalis.this.textCodigo.isEnabled()) {
                    ConfiguradorProtocoloJalis.this.carregaApoiado();
                }
            }
        });
        this.textPortaServidor.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                ConfiguradorProtocoloJalis.this.buscaFiliais(ConfiguradorProtocoloJalis.this.textServidor.getText(), Integer.parseInt(ConfiguradorProtocoloJalis.this.textPortaServidor.getText()));
                ConfiguradorProtocoloJalis.this.controlaCampos();
            }
        });
    }

    private void controlaCampos() {
        this.textCodigo.setEnabled(this.comboFiliais.getItemCount() > 0);
    }

    public static Registro xmlToRegistro(String xml) {
        if (xml == null) {
            return null;
        }
        Registro r = new Registro();
        r.setValor(CODIGO_CLIENTE_JALIS, StringUtil.getValor(xml, CODIGO_CLIENTE_JALIS));
        r.setValor(SERVIDOR_RMI, StringUtil.getValor(xml, SERVIDOR_RMI));
        r.setValor(CODIGO_CONVENIO, StringUtil.getValor(xml, CODIGO_CONVENIO));
        r.setValor(SEQUENCIAL_LOTE, StringUtil.getValor(xml, SEQUENCIAL_LOTE));
        r.setValor(FILIAL_SELECIONADA, StringUtil.getValor(xml, FILIAL_SELECIONADA));
        r.setValor(PRIMEIRA_CONEXAO, StringUtil.getValor(xml, PRIMEIRA_CONEXAO).equalsIgnoreCase("1"));
        r.setValor(ENVIAR_ETIQUETA, StringUtil.getBoolean(xml, ENVIAR_ETIQUETA));
        r.setValor(CODIGO_ETIQUETA_APOIO, StringUtil.getValor(xml, CODIGO_ETIQUETA_APOIO));
        if (StringUtil.getValor(xml, PORTA_SERVIDOR) == null || StringUtil.getValor(xml, PORTA_SERVIDOR).equals("")) {
            r.setValor(PORTA_SERVIDOR, "7070");
        } else {
            r.setValor(PORTA_SERVIDOR, StringUtil.getValor(xml, PORTA_SERVIDOR));
        }
        return r;
    }

    public static String registroToXML(Registro reg) {
        if (reg == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder("<jalis>");
        buf.append(StringUtil.getTag(CODIGO_CLIENTE_JALIS, reg.getString(CODIGO_CLIENTE_JALIS)));
        buf.append(StringUtil.getTag(SERVIDOR_RMI, reg.getString(SERVIDOR_RMI)));
        buf.append(StringUtil.getTag(SEQUENCIAL_LOTE, reg.getString(SEQUENCIAL_LOTE)));
        buf.append(StringUtil.getTag(CODIGO_CONVENIO, reg.getString(CODIGO_CONVENIO)));
        buf.append(StringUtil.getTag(FILIAL_SELECIONADA, reg.getString(FILIAL_SELECIONADA)));
        buf.append(StringUtil.getTag(PRIMEIRA_CONEXAO, reg.getString(PRIMEIRA_CONEXAO)));
        buf.append(StringUtil.getTag(PORTA_SERVIDOR, reg.getString(PORTA_SERVIDOR)));
        buf.append(StringUtil.getTag(ENVIAR_ETIQUETA, reg.getString(ENVIAR_ETIQUETA)));
        buf.append(StringUtil.getTag(CODIGO_ETIQUETA_APOIO, reg.getString(CODIGO_ETIQUETA_APOIO)));
        buf.append("</jalis>");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaFiliais(String servidor, int porta) {
        ObjetoComboFiliais tmp = (ObjetoComboFiliais)this.comboFiliais.getSelectedItem();
        this.comboFiliais.removeAllItems();
        if (!Funcoes.textoVazio(servidor)) {
            SplashMensagem splash = SplashMensagem.getInstancia(this);
            splash.mostrar("Aguarde... Conectando ao servidor do laborat\u00f3rio de apoio");
            if (!Funcoes.testaConexaoWeb(servidor, porta)) {
                servidorAtivo = false;
                splash.apagar();
                Funcoes.mensagem(this, "Conex\u00e3o com a web n\u00e3o encontrada", 1);
            } else {
                servidorAtivo = true;
                try {
                    WSCliente ws = new WSCliente(servidor, porta);
                    if (ws.isServidorOk()) {
                        this.codigoCliente = Funcoes.textoVazio(this.codigoCliente) ? ws.executaAcao("getCodigoCliente").getString(CODIGO_CLIENTE_JALIS) : StringUtil.encriptar(Long.parseLong(this.codigoCliente));
                        ParametroSet param = new ParametroSet();
                        param.setString(CODIGO_CLIENTE_JALIS, this.codigoCliente);
                        this.codigoCliente = String.valueOf(StringUtil.desencriptar(ws.executaAcao("getCodigoCliente").getString(CODIGO_CLIENTE_JALIS)));
                        List<ParametroSet> listMapFiliais = ws.executaAcao("getFiliais", param).getListParam("filiais");
                        if (listMapFiliais != null) {
                            for (ParametroSet paramFilial : listMapFiliais) {
                                Integer cod = paramFilial.getInt("codigo");
                                String desc = paramFilial.getString("descricao");
                                param = new ParametroSet();
                                param.setString("codigoFilial", cod.toString());
                                ObjetoComboFiliais o = new ObjetoComboFiliais(cod.toString(), desc, "-1");
                                this.comboFiliais.addItem(o);
                                if (tmp == null || !o.getCodigo().equalsIgnoreCase(tmp.getCodigo())) continue;
                                o.setMaiorLote(tmp.getMaiorLote());
                                this.comboFiliais.setSelectedIndex(this.comboFiliais.getItemCount() - 1);
                            }
                        }
                    } else {
                        splash.apagar();
                        servidorAtivo = false;
                        Funcoes.mensagem(this, "O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde", 1);
                    }
                    ws = null;
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConfiguradorProtocoloJalis (176)");
                }
                finally {
                    splash.apagar();
                }
            }
            splash.apagar();
        }
    }

    @Override
    public int getNumeroLote() {
        if (servidorAtivo) {
            return super.getNumeroLote();
        }
        return -1;
    }

    private void carregaApoiado() {
        if (Funcoes.textoVazio(this.textCodigo)) {
            return;
        }
        int codigoApoiado = Integer.parseInt(this.textCodigo.getText());
        ObjetoComboFiliais filial = (ObjetoComboFiliais)this.comboFiliais.getSelectedItem();
        try {
            WSCliente ws = new WSCliente(this.textServidor.getText(), Integer.parseInt(this.textPortaServidor.getText()));
            ParametroSet param = new ParametroSet();
            param.setInt("codigoFilial", Integer.parseInt(filial.getCodigo()));
            param.setString(CODIGO_CLIENTE_JALIS, StringUtil.encriptar(Long.parseLong(this.codigoCliente)));
            param.setInt("codigo", codigoApoiado);
            ParametroSet paramResposta = ws.executaAcao("getApoiado", param);
            Apoiado apoiado = null;
            if (paramResposta.getParametroSet("apoiado") != null) {
                ParametroSet paramApoiado = paramResposta.getParametroSet("apoiado");
                String tipoFilial = paramApoiado.getString("tipoFilial");
                apoiado = new Apoiado(Integer.parseInt(filial.getCodigo()), tipoFilial, codigoApoiado);
                apoiado.setDiasPrazo(paramApoiado.getInt("dias"));
                apoiado.setNome(paramApoiado.getString("nome"));
                apoiado.setUltimoLote(paramApoiado.getInt("ultimoLote"));
                apoiado.setValidado(paramApoiado.getBoolean("validado"));
                apoiado.setQtMaximaExames(paramApoiado.getInt("qtMaximaExames"));
                apoiado.setBloquearLaudo(paramApoiado.getBoolean("bloquearLaudo"));
                apoiado.setSolicitarCaixa(paramApoiado.getBoolean("solicitarCaixa"));
            }
            if (apoiado != null && apoiado.isValidado()) {
                this.textLote.setText(String.valueOf(apoiado.getUltimoLote()));
            } else {
                this.textLote.setText("");
                Funcoes.mensagem(this, "Apoiado n\u00e3o encontrado", 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace(), "ConfiguradorProtocoloJalis");
        }
    }
}

