/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalis;

import jalis.comum.Conexao;
import jalis.comum.Pesquisas;
import jalis.comum.Variaveis;
import jalis.laboratorio.util.parsers.AbstractConfigurador;
import jalis.util.Funcoes;
import jalis.util.ModeloGridTable;
import jalis.util.ScreenUtil;
import jalis.util.StringUtil;
import jalis.util.TTextField;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ConfiguradorJalis
extends AbstractConfigurador
implements ListSelectionListener {
    private ModeloGridTable modelo = new ModeloGridTable(new String[]{"C\u00f3digo", "Material", "Descri\u00e7\u00e3o"});
    private JTable tableExames = new JTable(this.modelo);
    private JScrollPane scrollExames = new JScrollPane(this.tableExames);
    private JTabbedPane tabbed = new JTabbedPane();
    private JPanel panelOpcoes = new JPanel(new GridBagLayout());
    private JButton buttonAvancado = ComponenteFactory.novoJButton("Avan\u00e7ado", 'v', this);
    private TTextField textLocalizar = new TTextField();
    private JLabel labelLocalizar = ComponenteFactory.novoJLabel("Localizar", 'L', null, null, this.textLocalizar);
    private JLabel labelJejum = new JLabel("Jejum");
    private JLabel labelMedicamento = new JLabel("Medicamento");
    private JLabel labelDUM = new JLabel("D.U.M.");
    private JLabel labelPeso = new JLabel("Peso");
    private JLabel labelAltura = new JLabel("Altura");
    private JLabel labelVolume = new JLabel("Volume diurese");
    private JLabel labelTempo = new JLabel("Tempo diurese");
    private JTextArea textInstrucaoColeta = new JTextArea();
    private JTextArea textPreparo = new JTextArea();
    private JTextArea textPrepAmostra = new JTextArea();
    private JTextArea textInadequada = new JTextArea();
    private JTextArea textConservacao = new JTextArea();
    private JTextArea textReferencia = new JTextArea();
    private JTextArea textDiagnostico = new JTextArea();
    private JTextArea textInterferencia = new JTextArea();
    private final int COLUNA_CODIGO = 0;
    private final int COLUNA_DESCRICAOMATERIAL = 1;
    private final int COLUNA_DESCRICAO = 2;
    private final int COLUNA_DADOSXML = 3;

    public static ConfiguradorJalis novaInstancia(Object pai, String codigoLabExterno) {
        if (pai instanceof Dialog) {
            return new ConfiguradorJalis((Dialog)pai, codigoLabExterno);
        }
        if (pai instanceof Frame) {
            return new ConfiguradorJalis((Frame)pai, codigoLabExterno);
        }
        return null;
    }

    public ConfiguradorJalis(Dialog pai, String codigoLabExterno) {
        super(pai, "Relacionamento de exames Jalis", codigoLabExterno);
        this.montaTela();
    }

    public ConfiguradorJalis(Frame pai, String codigoLabExterno) {
        super(pai, "Relacionamento de exames Jalis", codigoLabExterno);
        this.montaTela();
    }

    private void montaTela() {
        JPanel panelCentral = this.getPanelCentral();
        panelCentral.setLayout(new GridBagLayout());
        this.tableExames.getSelectionModel().addListSelectionListener(this);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        JPanel panelExames = new JPanel(new GridBagLayout());
        panelExames.setPreferredSize(new Dimension(100, 350));
        panelExames.setBorder(new TitledBorder("Exames"));
        panelCentral.add((Component)panelExames, c);
        panelExames.add((Component)this.scrollExames, c);
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 1;
        c2.gridy = 1;
        c2.fill = 2;
        c2.weightx = 1.0;
        panelExames.add((Component)this.textLocalizar, c2);
        c2.gridx = 0;
        c2.fill = 0;
        c2.insets = new Insets(1, 1, 1, 3);
        c2.weightx = 0.0;
        panelExames.add((Component)this.labelLocalizar, c2);
        c2.gridx = 2;
        this.buttonAvancado.setPreferredSize(new Dimension(70, 20));
        this.buttonAvancado.setMinimumSize(new Dimension(100, 20));
        panelExames.add((Component)this.buttonAvancado, c2);
        c.gridy = 1;
        c.gridwidth = 1;
        c.weighty = 0.0;
        this.tabbed.setBorder(new TitledBorder("Informa\u00e7\u00f5es"));
        panelCentral.add((Component)this.tabbed, c);
        c.gridx = 1;
        c.weightx = 0.0;
        c.fill = 3;
        this.panelOpcoes.setBorder(new TitledBorder("Op\u00e7\u00f5es"));
        panelCentral.add((Component)this.panelOpcoes, c);
        c2.gridx = 0;
        c2.gridy = 0;
        c2.anchor = 17;
        c2.fill = 2;
        this.panelOpcoes.add((Component)this.labelJejum, c2);
        c2.gridy = 1;
        this.panelOpcoes.add((Component)this.labelMedicamento, c2);
        c2.gridy = 2;
        this.panelOpcoes.add((Component)this.labelDUM, c2);
        c2.gridy = 3;
        this.panelOpcoes.add((Component)this.labelPeso, c2);
        c2.gridy = 4;
        this.panelOpcoes.add((Component)this.labelAltura, c2);
        c2.gridy = 5;
        this.panelOpcoes.add((Component)this.labelVolume, c2);
        c2.gridy = 6;
        this.panelOpcoes.add((Component)this.labelTempo, c2);
        c2.gridy = 7;
        c2.weighty = 1.0;
        c2.weightx = 1.0;
        c2.fill = 1;
        this.panelOpcoes.add((Component)new JPanel(), c2);
        this.labelJejum.setEnabled(false);
        this.labelMedicamento.setEnabled(false);
        this.labelDUM.setEnabled(false);
        this.labelPeso.setEnabled(false);
        this.labelAltura.setEnabled(false);
        this.labelVolume.setEnabled(false);
        this.labelTempo.setEnabled(false);
        this.modelo.setColumnSize(new int[]{70, 100, 0}, this.tableExames);
        this.tabbed.add((Component)new JScrollPane(this.textPrepAmostra), "Preparo da amostra");
        this.tabbed.add((Component)new JScrollPane(this.textPreparo), "Preparo");
        this.tabbed.add((Component)new JScrollPane(this.textInstrucaoColeta), "Instru\u00e7\u00f5es de coleta");
        this.tabbed.add((Component)new JScrollPane(this.textInadequada), "Inadequada");
        this.tabbed.add((Component)new JScrollPane(this.textConservacao), "Conserva\u00e7\u00e3o");
        this.tabbed.add((Component)new JScrollPane(this.textReferencia), "Refer\u00eancia");
        this.tabbed.add((Component)new JScrollPane(this.textDiagnostico), "Diagn\u00f3stico");
        this.tabbed.add((Component)new JScrollPane(this.textInterferencia), "Interfer\u00eancia");
        this.setSize(new Dimension(650, 550));
        ScreenUtil.requisitarFoco(this.textLocalizar);
        ScreenUtil.centralizar(this);
        this.buscaDados();
        this.textLocalizar.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                for (int i = 0; i < ConfiguradorJalis.this.tableExames.getRowCount() - 1; ++i) {
                    String descricao = ConfiguradorJalis.this.tableExames.getValueAt(i, 2).toString();
                    if (!descricao.toUpperCase().startsWith(ConfiguradorJalis.this.textLocalizar.getText().toUpperCase())) continue;
                    ConfiguradorJalis.this.tableExames.setRowSelectionInterval(i, i);
                    ConfiguradorJalis.this.tableExames.scrollRectToVisible(ConfiguradorJalis.this.tableExames.getCellRect(i, i, false));
                    break;
                }
            }
        });
    }

    private String criaDadosXML(ResultSet rs) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append(StringUtil.getTag("codigoMaterial", rs.getString("mco_codigo")));
        buf.append(StringUtil.getTag("descricaoPrazo", rs.getString("emc_descricaoprazo")));
        buf.append(StringUtil.getTag("descricaoMetodo", rs.getString("emc_descricaometodo")));
        buf.append(StringUtil.getTag("instrucaoColeta", rs.getString("emc_instrcoleta")));
        buf.append(StringUtil.getTag("preparo", rs.getString("emc_preparo")));
        buf.append(StringUtil.getTag("preparoAmostra", rs.getString("emc_prepamostra")));
        buf.append(StringUtil.getTag("inadequada", rs.getString("emc_inadequada")));
        buf.append(StringUtil.getTag("conservacao", rs.getString("emc_conservacao")));
        buf.append(StringUtil.getTag("referencia", rs.getString("emc_referencia")));
        buf.append(StringUtil.getTag("diagnostico", rs.getString("exa_diagnostico")));
        buf.append(StringUtil.getTag("interferencia", rs.getString("exa_interferencia")));
        buf.append(StringUtil.getTag("solicitarJejum", rs.getBoolean("emc_solicitarjejum") ? "1" : "0"));
        buf.append(StringUtil.getTag("obrigaMedicamento", rs.getBoolean("emc_obrigamedicamento") ? "1" : "0"));
        buf.append(StringUtil.getTag("obrigaDUM", rs.getBoolean("emc_obrigadum") ? "1" : "0"));
        buf.append(StringUtil.getTag("obrigaPeso", rs.getBoolean("emc_obrigapeso") ? "1" : "0"));
        buf.append(StringUtil.getTag("obrigaAltura", rs.getBoolean("emc_obrigaaltura") ? "1" : "0"));
        buf.append(StringUtil.getTag("obrigaVolume", rs.getBoolean("emc_obrigavolume") ? "1" : "0"));
        buf.append(StringUtil.getTag("obrigaTempoDiurese", rs.getBoolean("emc_obrigatempodiurese") ? "1" : "0"));
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buscaDados() {
        Statement st = Conexao.getStatement();
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("select a.exa_codigo, a.exa_descricao, b.emc_descricaomaterial, b.mco_codigo, ");
            buf.append("b.emc_descricaoprazo, b.emc_descricaometodo, b.emc_instrcoleta, b.emc_preparo, ");
            buf.append("b.emc_prepamostra, b.emc_inadequada, b.emc_conservacao, b.emc_referencia, ");
            buf.append("b.emc_solicitarjejum, b.emc_obrigamedicamento, b.emc_obrigadum, b.emc_obrigapeso, ");
            buf.append("b.emc_obrigaaltura, b.emc_obrigavolume, b.emc_obrigatempodiurese, a.exa_diagnostico,  ");
            buf.append("a.exa_interferencia ");
            buf.append("from examesjalis a ");
            buf.append("left join examematcoletajalis b on a.fil_codigo = b.fil_codigo and a.lae_codigo = b.lae_codigo and a.exa_codigo = b.exa_codigo ");
            buf.append("where a.fil_codigo = ").append(Variaveis.filialPadrao);
            buf.append(" and a.lae_codigo = ").append(this.getCodigoLabExterno());
            buf.append(" order by a.exa_descricao, b.emc_descricaomaterial");
            ResultSet rs = Conexao.executeQuery(st, buf);
            while (rs.next()) {
                this.modelo.addLine(new String[]{rs.getString("exa_codigo"), rs.getString("emc_descricaomaterial"), rs.getString("exa_descricao"), this.criaDadosXML(rs)});
            }
        }
        catch (Exception e) {
            try {
                ErrorLogger.mostraMensagem(this, e.getMessage(), e.getStackTrace(), "ConfiguradorJalis (231)");
            }
            catch (Throwable throwable) {
                Conexao.fecharStatement(st);
                throw throwable;
            }
            Conexao.fecharStatement(st);
        }
        Conexao.fecharStatement(st);
    }

    private String pegaDadosXML() {
        if (this.tableExames.getSelectedRow() <= -1) {
            return "";
        }
        return this.modelo.getValueAt(this.tableExames.getSelectedRow(), 3).toString();
    }

    @Override
    public String getXML() {
        if (this.tableExames.getSelectedRow() <= -1) {
            return "";
        }
        String codigo = this.modelo.getValueAt(this.tableExames.getSelectedRow(), 0).toString();
        String xml = this.pegaDadosXML();
        StringBuilder buf = new StringBuilder();
        buf.append("<exame>");
        buf.append(StringUtil.getTag("codigoExame", codigo));
        buf.append(StringUtil.getTag("codigoMaterial", StringUtil.getValor(xml, "codigoMaterial")));
        buf.append("</exame>");
        return buf.toString();
    }

    @Override
    public void setXML(String xml) {
        String codigo = "";
        String codigoMaterial = "";
        if (!(Funcoes.textoVazio(xml) || Funcoes.textoVazio(codigo = StringUtil.getValor(xml, "codigoExame")) || Funcoes.textoVazio(codigoMaterial = StringUtil.getValor(xml, "codigoMaterial")))) {
            for (int i = 0; i < this.modelo.getRowCount() - 1; ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(codigo) || !StringUtil.getValor(this.modelo.getValueAt(i, 3).toString(), "codigoMaterial").equalsIgnoreCase(codigoMaterial)) continue;
                this.tableExames.setRowSelectionInterval(i, i);
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(i, 0, false));
                this.tableExames.grabFocus();
                break;
            }
        }
    }

    @Override
    public boolean exigeTempoDiurese() {
        return StringUtil.getValor(this.pegaDadosXML(), "obrigaTempoDiurese").equalsIgnoreCase("1");
    }

    @Override
    public boolean exigeVolumeDiurese() {
        return StringUtil.getValor(this.pegaDadosXML(), "obrigaVolume").equalsIgnoreCase("1");
    }

    @Override
    public boolean exigePeso() {
        return StringUtil.getValor(this.pegaDadosXML(), "obrigaPeso").equalsIgnoreCase("1");
    }

    @Override
    public boolean exigeAltura() {
        return StringUtil.getValor(this.pegaDadosXML(), "obrigaAltura").equalsIgnoreCase("1");
    }

    @Override
    public boolean exigeJejum() {
        return StringUtil.getValor(this.pegaDadosXML(), "solicitarJejum").equalsIgnoreCase("1");
    }

    @Override
    public boolean exigeMedicamento() {
        return StringUtil.getValor(this.pegaDadosXML(), "obrigaMedicamento").equalsIgnoreCase("1");
    }

    @Override
    public boolean exigeDUM() {
        return StringUtil.getValor(this.pegaDadosXML(), "obrigaDUM").equalsIgnoreCase("1");
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.tableExames.getSelectedRow() <= -1) {
            return;
        }
        String xml = this.modelo.getValueAt(this.tableExames.getSelectedRow(), 3).toString();
        this.labelJejum.setEnabled(StringUtil.getValor(xml, "solicitarJejum").equalsIgnoreCase("1"));
        this.labelMedicamento.setEnabled(StringUtil.getValor(xml, "obrigaMedicamento").equalsIgnoreCase("1"));
        this.labelDUM.setEnabled(StringUtil.getValor(xml, "obrigaDUM").equalsIgnoreCase("1"));
        this.labelPeso.setEnabled(StringUtil.getValor(xml, "obrigaPeso").equalsIgnoreCase("1"));
        this.labelAltura.setEnabled(StringUtil.getValor(xml, "obrigaAltura").equalsIgnoreCase("1"));
        this.labelVolume.setEnabled(StringUtil.getValor(xml, "obrigaVolume").equalsIgnoreCase("1"));
        this.labelTempo.setEnabled(StringUtil.getValor(xml, "obrigaTempoDiurese").equalsIgnoreCase("1"));
        this.textInterferencia.setText(StringUtil.getValor(xml, "interferencia"));
        this.textInstrucaoColeta.setText(StringUtil.getValor(xml, "instrucaoColeta"));
        this.textPreparo.setText(StringUtil.getValor(xml, "preparo"));
        this.textPrepAmostra.setText(StringUtil.getValor(xml, "preparoAmostra"));
        this.textInadequada.setText(StringUtil.getValor(xml, "inadequada"));
        this.textConservacao.setText(StringUtil.getValor(xml, "conservacao"));
        this.textReferencia.setText(StringUtil.getValor(xml, "referencia"));
        this.textDiagnostico.setText(StringUtil.getValor(xml, "diagnostico"));
        ScreenUtil.posicionaTextoTopo(this.textInterferencia);
        ScreenUtil.posicionaTextoTopo(this.textInstrucaoColeta);
        ScreenUtil.posicionaTextoTopo(this.textPreparo);
        ScreenUtil.posicionaTextoTopo(this.textPrepAmostra);
        ScreenUtil.posicionaTextoTopo(this.textInadequada);
        ScreenUtil.posicionaTextoTopo(this.textConservacao);
        ScreenUtil.posicionaTextoTopo(this.textReferencia);
        ScreenUtil.posicionaTextoTopo(this.textDiagnostico);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDescricaoExameSelecionado(String codigoLabExterno, String xml) {
        String retorno = "";
        if (xml != null) {
            Statement st;
            block5: {
                String codigoExame = StringUtil.getValor(xml, "codigoExame");
                st = Conexao.getStatement();
                StringBuilder buf = new StringBuilder("select exa_descricao from examesjalis ");
                buf.append("where fil_codigo = ").append(Variaveis.filialPadrao);
                buf.append(" and lae_codigo = ").append(codigoLabExterno);
                buf.append(" and exa_codigo = '").append(StringUtil.textoDB(codigoExame)).append("' ");
                try {
                    ResultSet rs;
                    if (Funcoes.textoVazio(codigoExame) || !(rs = Conexao.executeQuery(st, buf)).next()) break block5;
                    retorno = rs.getString("exa_descricao");
                }
                catch (Exception ex) {
                    try {
                        ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "ConfiguradorJalis (405)");
                    }
                    catch (Throwable throwable) {
                        Conexao.fecharStatement(st);
                        throw throwable;
                    }
                    Conexao.fecharStatement(st);
                }
            }
            Conexao.fecharStatement(st);
        }
        return retorno;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonAvancado) {
            this.buscaAvancada();
        } else {
            super.actionPerformed(e);
        }
    }

    private void buscaAvancada() {
        Hashtable resultado = Pesquisas.exameExternoJalis(this, this.getCodigoLabExterno());
        if (resultado != null) {
            String codigo = resultado.get("exa_codigo").toString();
            String material = resultado.get("emc_descricaomaterial").toString();
            for (int i = 0; i < this.modelo.getRowCount(); ++i) {
                if (!this.modelo.getValueAt(i, 0).toString().equalsIgnoreCase(codigo) || !this.modelo.getValueAt(i, 1).toString().equalsIgnoreCase(material)) continue;
                this.tableExames.setRowSelectionInterval(i, i);
                this.tableExames.scrollRectToVisible(this.tableExames.getCellRect(i, 0, false));
            }
        }
        this.tableExames.requestFocus();
    }
}

