/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.jalis;

import jalis.apoio.servidor.IServidor;
import jalis.laboratorio.ControlaTempoInativo;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.sql.SQLException;

public class ConexaoRMI {
    private IServidor servidor = null;
    public static final int SERVIDOR_AGUARDANDO_COMANDO = 0;
    public static final int SERVIDOR_NAO_ATIVADO = 1;
    public static final int SERVIDOR_NAO_AUTENTICOU = 2;
    public static final int SERVIDOR_CONVENIO_NAO_AUTORIZADO = 3;

    public static IServidor getServidor(String servidor) throws Exception {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        boolean contando = false;
        contando = ControlaTempoInativo.contando();
        if (contando) {
            ControlaTempoInativo.parar();
        }
        Registry registro = LocateRegistry.getRegistry(servidor, 4445);
        IServidor comp = (IServidor)registro.lookup("servidorApoio");
        if (contando) {
            ControlaTempoInativo.iniciar();
        }
        return comp;
    }

    public static int testarServidor(IServidor servidor, String filialSelecionada, String codigoCliente, String codigoConvenio) throws SQLException, RemoteException {
        if (servidor == null) {
            return 1;
        }
        if (!servidor.validaCliente(filialSelecionada, codigoCliente)) {
            return 2;
        }
        if (!servidor.validaConvenio(filialSelecionada, codigoConvenio)) {
            return 3;
        }
        return 0;
    }

    public static String getTextoMensagem(int erro) {
        if (erro == 1) {
            return "O servidor remoto n\u00e3o est\u00e1 ativado, tente novamente mais tarde";
        }
        if (erro == 2) {
            return "O servidor remoto n\u00e3o autenticou sua conex\u00e3o. Entre em contato com o laborat\u00f3rio de apoio";
        }
        if (erro == 3) {
            return "O conv\u00eanio informado n\u00e3o est\u00e1 autorizado a receber dados do servidor de apoio. Entre em contato com o laborat\u00f3rio de apoio.";
        }
        return "";
    }
}

