/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.laboratorio.util.parsers.indlab.resultado.dto.PacienteExameIndLabDto;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.PacienteIndLabDto;
import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class SolicitacaoIndLabDto {
    public static final String TAG_SOLICITACAO = "solicitacao";
    private final PacienteIndLabDto paciente;
    private final PacienteExameIndLabDto examePaciente;

    private SolicitacaoIndLabDto(Builder builder) {
        this.paciente = builder.paciente;
        this.examePaciente = builder.examePaciente;
    }

    public PacienteIndLabDto getPaciente() {
        return this.paciente;
    }

    public PacienteExameIndLabDto getExamePaciente() {
        return this.examePaciente;
    }

    public static SolicitacaoIndLabDto fromXml(String xml) {
        SolicitacaoIndLabDto solicitacaoDto = null;
        if (!Funcoes.textoVazio(xml)) {
            String xmlPaciente = StringUtil.getValor(xml, "paciente");
            String xmlPacienteExame = StringUtil.getValor(xml, "pacienteExame");
            solicitacaoDto = new Builder().paciente(PacienteIndLabDto.fromXml(xmlPaciente)).examePaciente(PacienteExameIndLabDto.fromXml(xmlPacienteExame)).build();
        }
        return solicitacaoDto;
    }

    public static class Builder {
        private PacienteIndLabDto paciente;
        private PacienteExameIndLabDto examePaciente;

        public Builder paciente(PacienteIndLabDto paciente) {
            this.paciente = paciente;
            return this;
        }

        public Builder examePaciente(PacienteExameIndLabDto examePaciente) {
            this.examePaciente = examePaciente;
            return this;
        }

        public SolicitacaoIndLabDto build() {
            return new SolicitacaoIndLabDto(this);
        }
    }
}

