/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.laboratorio.util.parsers.indlab.resultado.dto.CabecalhoIndLabDto;
import jalis.laboratorio.util.parsers.indlab.resultado.dto.SolicitacaoIndLabDto;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ResultadoIndLabDto {
    private final CabecalhoIndLabDto cabecalho;
    private final List<SolicitacaoIndLabDto> solicitacoes;

    private ResultadoIndLabDto(Builder builder) {
        this.cabecalho = builder.cabecalho;
        this.solicitacoes = builder.solicitacoes;
    }

    public CabecalhoIndLabDto getCabecalho() {
        return this.cabecalho;
    }

    public List<SolicitacaoIndLabDto> getSolicitacoes() {
        return this.solicitacoes;
    }

    public static ResultadoIndLabDto fromXml(String xml) {
        ResultadoIndLabDto resultadoDto = null;
        if (!Funcoes.textoVazio(xml)) {
            String xmlCabecalho = StringUtil.getValor(xml, "cabecalho");
            List<String> tagsSolicitacao = StringUtil.getListValores(xml, "solicitacao");
            ArrayList<SolicitacaoIndLabDto> solicitacoes = new ArrayList<SolicitacaoIndLabDto>();
            tagsSolicitacao.forEach(tag -> solicitacoes.add(SolicitacaoIndLabDto.fromXml(tag)));
            resultadoDto = new Builder().cabecalho(CabecalhoIndLabDto.fromXml(xmlCabecalho)).solicitacoes(solicitacoes).build();
        }
        return resultadoDto;
    }

    public static class Builder {
        private CabecalhoIndLabDto cabecalho;
        private List<SolicitacaoIndLabDto> solicitacoes;

        public Builder cabecalho(CabecalhoIndLabDto cabecalho) {
            this.cabecalho = cabecalho;
            return this;
        }

        public Builder solicitacoes(List<SolicitacaoIndLabDto> solicitacoes) {
            this.solicitacoes = solicitacoes;
            return this;
        }

        public ResultadoIndLabDto build() {
            return new ResultadoIndLabDto(this);
        }
    }
}

