/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class PacienteIndLabDto {
    public static final String TAG_PACIENTE = "paciente";
    public static final String TAG_NOME_PACIENTE = "nomePaciente";
    public static final String TAG_CODIGO_EXTERNO_PACIENTE = "codigoExternoPaciente";
    public static final String TAG_CODIGO_EXTERNO_CONTA_MEDICA = "codigoExternoContaMedica";
    public static final String TAG_CODIGO_APOIO = "codigoApoio";
    private final String nomePaciente;
    private final String codigoExternoPaciente;
    private final String codigoExternoContaMedica;
    private final String codigoApoio;

    private PacienteIndLabDto(Builder builder) {
        this.nomePaciente = builder.nomePaciente;
        this.codigoExternoPaciente = builder.codigoExternoPaciente;
        this.codigoExternoContaMedica = builder.codigoExternoContaMedica;
        this.codigoApoio = builder.codigoApoio;
    }

    public String getNomePaciente() {
        return this.nomePaciente;
    }

    public String getCodigoExternoPaciente() {
        return this.codigoExternoPaciente;
    }

    public String getCodigoExternoContaMedica() {
        return this.codigoExternoContaMedica;
    }

    public String getCodigoApoio() {
        return this.codigoApoio;
    }

    public static PacienteIndLabDto fromXml(String xml) {
        PacienteIndLabDto pacienteDto = null;
        if (!Funcoes.textoVazio(xml)) {
            String nomePaciente = StringUtil.getValor(xml, TAG_NOME_PACIENTE);
            String codigoExternoPaciente = StringUtil.getValor(xml, TAG_CODIGO_EXTERNO_PACIENTE);
            String codigoExternoContaMedica = StringUtil.getValor(xml, TAG_CODIGO_EXTERNO_CONTA_MEDICA);
            String codigoApoio = StringUtil.getValor(xml, TAG_CODIGO_APOIO);
            pacienteDto = new Builder().codigoExternoContaMedica(PacienteIndLabDto.padronizarString(codigoExternoContaMedica)).codigoExternoPaciente(PacienteIndLabDto.padronizarString(codigoExternoPaciente)).nomePaciente(PacienteIndLabDto.padronizarString(nomePaciente)).codigoApoio(PacienteIndLabDto.padronizarString(codigoApoio)).build();
        }
        return pacienteDto;
    }

    private static String padronizarString(String str) {
        return StringUtil.xmlToTexto(str.trim());
    }

    public static class Builder {
        private String nomePaciente;
        private String codigoExternoPaciente;
        private String codigoExternoContaMedica;
        private String codigoApoio;

        public Builder nomePaciente(String nomePaciente) {
            this.nomePaciente = nomePaciente;
            return this;
        }

        public Builder codigoExternoPaciente(String codigoExternoPaciente) {
            this.codigoExternoPaciente = codigoExternoPaciente;
            return this;
        }

        public Builder codigoExternoContaMedica(String codigoExternoContaMedica) {
            this.codigoExternoContaMedica = codigoExternoContaMedica;
            return this;
        }

        public Builder codigoApoio(String codigoApoio) {
            this.codigoApoio = codigoApoio;
            return this;
        }

        public PacienteIndLabDto build() {
            return new PacienteIndLabDto(this);
        }
    }
}

