/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.laboratorio.util.parsers.indlab.resultado.dto.ExameResultadoIndLabDto;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class PacienteExameIndLabDto {
    public static final String TAG_PACIENTE_EXAME = "pacienteExame";
    private final List<ExameResultadoIndLabDto> exames;

    private PacienteExameIndLabDto(Builder builder) {
        this.exames = builder.exames;
    }

    public List<ExameResultadoIndLabDto> getExames() {
        return this.exames;
    }

    public static PacienteExameIndLabDto fromXml(String xml) {
        PacienteExameIndLabDto pacienteDto = null;
        if (!Funcoes.textoVazio(xml)) {
            ArrayList<ExameResultadoIndLabDto> exames = new ArrayList<ExameResultadoIndLabDto>();
            List<String> tagsExameResultado = StringUtil.getListValores(xml, "exame");
            tagsExameResultado.forEach(tag -> exames.add(ExameResultadoIndLabDto.fromXml(tag)));
            pacienteDto = new Builder().exames(exames).build();
        }
        return pacienteDto;
    }

    public static class Builder {
        private List<ExameResultadoIndLabDto> exames;

        public Builder exames(List<ExameResultadoIndLabDto> exames) {
            this.exames = exames;
            return this;
        }

        public PacienteExameIndLabDto build() {
            return new PacienteExameIndLabDto(this);
        }
    }
}

