/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.util.Funcoes;
import jalis.util.StringUtil;

public class ItemExameIndLabDto {
    public static final String TAG_ITEM_EXAME = "itemExame";
    public static final String TAG_ITEM_NUMERO = "itemNumero";
    public static final String TAG_ITEM_NOME = "itemNome";
    public static final String TAG_RESULTADO = "resultado";
    public static final String TAG_UNIDADE_MEDIDA = "unidadeMedida";
    public static final String TAG_VALOR_REFERENCIA = "valorReferencia";
    public static final String TAG_METODOLOGIA = "metodologia";
    public static final String TAG_OBSERVACOES_FIXAS = "observacoesFixas";
    public static final String TAG_OBSERVACOES_VARIAVEIS = "observacoesVariaveis";
    private final Integer itemNumero;
    private final String itemNome;
    private final String resultado;
    private final String unidadeMedida;
    private final String valorReferencia;
    private final String metodologia;
    private final String observacoesFixas;
    private final String observacoesVariaveis;

    private ItemExameIndLabDto(Builder builder) {
        this.itemNome = builder.itemNome;
        this.itemNumero = builder.itemNumero;
        this.metodologia = builder.metodologia;
        this.observacoesFixas = builder.observacoesFixas;
        this.observacoesVariaveis = builder.observacoesVariaveis;
        this.resultado = builder.resultado;
        this.unidadeMedida = builder.unidadeMedida;
        this.valorReferencia = builder.valorReferencia;
    }

    public Integer getItemNumero() {
        return this.itemNumero;
    }

    public String getItemNome() {
        return this.itemNome;
    }

    public String getResultado() {
        return this.resultado;
    }

    public String getUnidadeMedida() {
        return this.unidadeMedida;
    }

    public String getValorReferencia() {
        return this.valorReferencia;
    }

    public String getMetodologia() {
        return this.metodologia;
    }

    public String getObservacoesFixas() {
        return this.observacoesFixas;
    }

    public String getObservacoesVariaveis() {
        return this.observacoesVariaveis;
    }

    public static ItemExameIndLabDto fromXml(String xml) {
        ItemExameIndLabDto itemExameDto = null;
        if (!Funcoes.textoVazio(xml)) {
            Integer itemNumero = Integer.valueOf(StringUtil.getValor(xml, TAG_ITEM_NUMERO));
            String itemNome = StringUtil.getValor(xml, TAG_ITEM_NOME);
            String resultado = StringUtil.getValor(xml, TAG_RESULTADO);
            String unidadeMedida = StringUtil.getValor(xml, TAG_UNIDADE_MEDIDA);
            String valorReferencia = StringUtil.getValor(xml, TAG_VALOR_REFERENCIA);
            String metodologia = StringUtil.getValor(xml, TAG_METODOLOGIA);
            String observacoesFixas = StringUtil.getValor(xml, TAG_OBSERVACOES_FIXAS);
            String observacoesVariaveis = StringUtil.getValor(xml, TAG_OBSERVACOES_VARIAVEIS);
            itemExameDto = new Builder().itemNome(ItemExameIndLabDto.padronizarString(itemNome)).itemNumero(itemNumero).metodologia(ItemExameIndLabDto.padronizarString(metodologia)).resultado(ItemExameIndLabDto.padronizarString(resultado)).unidadeMedida(ItemExameIndLabDto.padronizarString(unidadeMedida)).valorReferencia(ItemExameIndLabDto.padronizarString(valorReferencia)).observacoesFixas(ItemExameIndLabDto.padronizarStringObservacoesFixas(observacoesFixas)).observacoesVariaveis(ItemExameIndLabDto.padronizarString(observacoesVariaveis)).build();
        }
        return itemExameDto;
    }

    private static String padronizarString(String str) {
        return StringUtil.xmlToTexto(str.trim());
    }

    private static String padronizarStringObservacoesFixas(String str) {
        if (!Funcoes.textoVazio(str) && str.contains("|")) {
            str = str.replace("|", "\n");
        }
        return StringUtil.xmlToTexto(str.trim());
    }

    public static class Builder {
        private Integer itemNumero;
        private String itemNome;
        private String resultado;
        private String unidadeMedida;
        private String valorReferencia;
        private String metodologia;
        private String observacoesFixas;
        private String observacoesVariaveis;

        public Builder itemNumero(Integer itemNumero) {
            this.itemNumero = itemNumero;
            return this;
        }

        public Builder itemNome(String itemNome) {
            this.itemNome = itemNome;
            return this;
        }

        public Builder resultado(String resultado) {
            this.resultado = resultado;
            return this;
        }

        public Builder unidadeMedida(String unidadeMedida) {
            this.unidadeMedida = unidadeMedida;
            return this;
        }

        public Builder valorReferencia(String valorReferencia) {
            this.valorReferencia = valorReferencia;
            return this;
        }

        public Builder metodologia(String metodologia) {
            this.metodologia = metodologia;
            return this;
        }

        public Builder observacoesFixas(String observacoesFixas) {
            this.observacoesFixas = observacoesFixas;
            return this;
        }

        public Builder observacoesVariaveis(String observacoesVariaveis) {
            this.observacoesVariaveis = observacoesVariaveis;
            return this;
        }

        public ItemExameIndLabDto build() {
            return new ItemExameIndLabDto(this);
        }
    }
}

