/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.laboratorio.util.parsers.indlab.resultado.dto.CampoExameIndLabDto;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class FormatoExameIndLabDto {
    private final Integer codigo;
    private final List<CampoExameIndLabDto> campos;

    private FormatoExameIndLabDto(Builder builder) {
        this.codigo = builder.codigo;
        this.campos = builder.campos;
    }

    public Integer getCodigo() {
        return this.codigo;
    }

    public List<CampoExameIndLabDto> getCampos() {
        return this.campos;
    }

    public static FormatoExameIndLabDto fromXml(String xml) {
        FormatoExameIndLabDto formatoDto = null;
        if (!Funcoes.textoVazio(xml)) {
            Integer codigo = Integer.valueOf(StringUtil.getValor(xml, "formato"));
            ArrayList<CampoExameIndLabDto> campos = new ArrayList<CampoExameIndLabDto>();
            List<String> tagsCampo = StringUtil.getListValores(xml, "campo");
            tagsCampo.forEach(tag -> campos.add(CampoExameIndLabDto.fromXml(tag)));
            formatoDto = new Builder().codigo(codigo).campos(campos).build();
        }
        return formatoDto;
    }

    public static class Builder {
        private Integer codigo;
        private List<CampoExameIndLabDto> campos;

        public Builder codigo(Integer codigo) {
            this.codigo = codigo;
            return this;
        }

        public Builder campos(List<CampoExameIndLabDto> campos) {
            this.campos = campos;
            return this;
        }

        public FormatoExameIndLabDto build() {
            return new FormatoExameIndLabDto(this);
        }
    }
}

