/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.util.parsers.indlab.resultado.dto;

import jalis.laboratorio.util.parsers.indlab.resultado.dto.ItemExameIndLabDto;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public class ExameResultadoIndLabDto {
    public static final String TAG_EXAME = "exame";
    public static final String TAG_NOME_EXAME = "nomeExame";
    public static final String TAG_MNEMONICO_EXAME = "mnemonicoExame";
    public static final String TAG_FORMATACAO_EXAME = "formatacaoExame";
    public static final String TAG_MNEMONICO_ORIGEM = "mnemonicoOrigem";
    private final String nomeExame;
    private final String mnemonicoExame;
    private final Integer formatacaoExame;
    private final String mnemonicoOrigem;
    private final List<ItemExameIndLabDto> itensExame;

    private ExameResultadoIndLabDto(Builder builder) {
        this.nomeExame = builder.nomeExame;
        this.mnemonicoExame = builder.mnemonicoExame;
        this.formatacaoExame = builder.formatacaoExame;
        this.mnemonicoOrigem = builder.mnemonicoOrigem;
        this.itensExame = builder.itensExame;
    }

    public String getNomeExame() {
        return this.nomeExame;
    }

    public String getMnemonicoExame() {
        return this.mnemonicoExame;
    }

    public Integer getFormatacaoExame() {
        return this.formatacaoExame;
    }

    public String getMnemonicoOrigem() {
        return this.mnemonicoOrigem;
    }

    public List<ItemExameIndLabDto> getItensExame() {
        return this.itensExame;
    }

    public static ExameResultadoIndLabDto fromXml(String xml) {
        ExameResultadoIndLabDto exameResultadoDto = null;
        if (!Funcoes.textoVazio(xml)) {
            String nomeExame = StringUtil.getValor(xml, TAG_NOME_EXAME);
            String mnemonicoExame = StringUtil.getValor(xml, TAG_MNEMONICO_EXAME);
            Integer formatacaoExame = Integer.valueOf(StringUtil.getValor(xml, TAG_FORMATACAO_EXAME));
            String mnemonicoOrigem = StringUtil.getValor(xml, TAG_MNEMONICO_ORIGEM);
            ArrayList<ItemExameIndLabDto> exames = new ArrayList<ItemExameIndLabDto>();
            List<String> tagsItemExame = StringUtil.getListValores(xml, "itemExame");
            tagsItemExame.forEach(tag -> exames.add(ItemExameIndLabDto.fromXml(tag)));
            exameResultadoDto = new Builder().formatacaoExame(formatacaoExame).itensExame(exames).mnemonicoExame(ExameResultadoIndLabDto.padronizarString(mnemonicoExame)).mnemonicoOrigem(ExameResultadoIndLabDto.padronizarString(mnemonicoOrigem)).nomeExame(ExameResultadoIndLabDto.padronizarString(nomeExame)).build();
        }
        return exameResultadoDto;
    }

    private static String padronizarString(String str) {
        return StringUtil.xmlToTexto(str.trim());
    }

    public static class Builder {
        private String nomeExame;
        private String mnemonicoExame;
        private Integer formatacaoExame;
        private String mnemonicoOrigem;
        private List<ItemExameIndLabDto> itensExame;

        public Builder nomeExame(String nomeExame) {
            this.nomeExame = nomeExame;
            return this;
        }

        public Builder mnemonicoExame(String mnemonicoExame) {
            this.mnemonicoExame = mnemonicoExame;
            return this;
        }

        public Builder formatacaoExame(Integer formatacaoExame) {
            this.formatacaoExame = formatacaoExame;
            return this;
        }

        public Builder mnemonicoOrigem(String mnemonicoOrigem) {
            this.mnemonicoOrigem = mnemonicoOrigem;
            return this;
        }

        public Builder itensExame(List<ItemExameIndLabDto> itensExame) {
            this.itensExame = itensExame;
            return this;
        }

        public ExameResultadoIndLabDto build() {
            return new ExameResultadoIndLabDto(this);
        }
    }
}

